#!/usr/bin/perl -w

use strict;
use Test;
#use warnings;

# First check that the module loads OK.
use vars qw($loaded);
BEGIN {  $| = 1;  plan tests => 8; }
END {print "not ok 1\n" unless $loaded;}

use ConfigFile;
print "! Testing module load ...\n";
ok(++$loaded);

print "! Testing constructor ...\n";
my $config = ConfigFile::read_config_file("t/config");
ok($config);

print "! Testing simple values ...\n";
ok($config->{foo}, 'bar');

print "! Testing embeded values ...\n";
ok($config->{bar}, 'bar/bar');

print "! Testing embeded values with comment...\n";
ok($config->{foobar}, 'bar/bar # variable #');

print "! Testing clustered values...\n";
ok($config->{dummy}->{1}, 'data 1');
ok($config->{dummy}->{2}, 'data 2');
ok($config->{dummy}->{3}, 'data 3');
