/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.Unmodifiable;

public final class UnmodifiableMapIterator
implements MapIterator,
Unmodifiable {
    private MapIterator iterator;

    public static final MapIterator decorate(MapIterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("MapIterator must not be null");
        }
        if (iterator instanceof Unmodifiable) {
            return iterator;
        }
        return new UnmodifiableMapIterator(iterator);
    }

    public final boolean hasNext() {
        return this.iterator.hasNext();
    }

    public final Object next() {
        return this.iterator.next();
    }

    public final Object getKey() {
        return this.iterator.getKey();
    }

    public final Object getValue() {
        return this.iterator.getValue();
    }

    public final Object setValue(Object value) {
        throw new UnsupportedOperationException("setValue() is not supported");
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    private UnmodifiableMapIterator(MapIterator iterator) {
        this.iterator = iterator;
    }
}

