/**
 * Copyright 2011-2015
 *
 * Modified from https://github.com/BoostGSoC13/boost.trie
 *
 * Distributed under the Boost Software License, Version 1.0.
 *
 * Boost Software License - Version 1.0 - August 17th, 2003
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef LIBBITCOIN_TRIE_REVERSE_ITERATOR_IPP
#define LIBBITCOIN_TRIE_REVERSE_ITERATOR_IPP

namespace libbitcoin {

// trie_reverse_iterator implementation
template <typename TrieIterator>
trie_reverse_iterator<TrieIterator>::trie_reverse_iterator()
    : base_iterator_()
{
}

template <typename TrieIterator>
trie_reverse_iterator<TrieIterator>::trie_reverse_iterator(base_iter_type it)
    : base_iterator_(it)
{
}

template <typename TrieIterator>
trie_reverse_iterator<TrieIterator>::trie_reverse_iterator(
    const iter_type& other)
    : base_iterator_(other.base())
{
}

template <typename TrieIterator>
template<typename Iter>
trie_reverse_iterator<TrieIterator>::trie_reverse_iterator(
    const trie_reverse_iterator<Iter>& other)
    : base_iterator_(other.base())
{
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::reference
    trie_reverse_iterator<TrieIterator>::operator*() const
{
    auto it = base_iterator_;
    return *--it;
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::pointer
    trie_reverse_iterator<TrieIterator>::operator->() const
{
    return &(operator*());
}

template <typename TrieIterator>
bool trie_reverse_iterator<TrieIterator>::operator==(
    const iter_type& other) const
{
    return base() == other.base();
}

template <typename TrieIterator>
bool trie_reverse_iterator<TrieIterator>::operator!=(
    const iter_type& other) const
{
    return !(*this == other);
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::iter_type&
    trie_reverse_iterator<TrieIterator>::operator++()
{
    --base_iterator_;
    return *this;
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::iter_type
    trie_reverse_iterator<TrieIterator>::operator++(int)
{
    auto it = *this;
    --base_iterator_;
    return it;
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::iter_type&
    trie_reverse_iterator<TrieIterator>::operator--()
{
    ++base_iterator_;
    return *this;
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::iter_type
    trie_reverse_iterator<TrieIterator>::operator--(int)
{
    auto it = *this;
    ++base_iterator_;
    return it;
}

template <typename TrieIterator>
typename trie_reverse_iterator<TrieIterator>::base_iter_type
    trie_reverse_iterator<TrieIterator>::base() const
{
    return base_iterator_;
}

template<typename TrieIterator>
binary_type trie_reverse_iterator<TrieIterator>::get_key()
{
    auto it = base_iterator_;
    return (--it).get_key();
}

} // namespace libbitcoin

#endif
