#ifndef BER_H
#define BER_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdint.h>

/* Tag Class Encodings */
#define BER_Universal		0x00
#define BER_Application		0x40
#define BER_ContextSpecific	0x80
#define BER_Private			0xc0

/* Tag Format Encodings */
#define BER_Primitive		0x00
#define BER_Constructed		0x20

/* Primitive ASN.1 Types */
#define BER_INTEGER			( BER_Universal | BER_Primitive | 0x02 )	/* -2^31 <= x < 2^31 */
#define BER_OCTET_STRING	( BER_Universal | BER_Primitive | 0x04 )
#define BER_NULL			( BER_Universal | BER_Primitive | 0x05 )
#define BER_OID				( BER_Universal | BER_Primitive | 0x06 )

/* Constructed ASN.1 Types */
#define BER_SEQUENCE		( BER_Universal | BER_Constructed | 0x10 )

/* Primitive SNMP application types */
#define BER_IpAddress		( BER_Application | BER_Primitive | 0x00 )
#define BER_Counter32		( BER_Application | BER_Primitive | 0x01 )	/* 0 <= x < 2^32 */
#define BER_Gauge32			( BER_Application | BER_Primitive | 0x02 )	/* 0 <= x < 2^32 */
#define BER_TimeTicks		( BER_Application | BER_Primitive | 0x03 )	/* 0 <= x < 2^32  --  time measured in hundreds of a second (10ms) */
#define BER_Opaque			( BER_Application | BER_Primitive | 0x04 )
#define BER_Counter64		( BER_Application | BER_Primitive | 0x06 )	/* 0 <= x < 2^64 */

/* Context-specific types within an SNMP Message */
#define BER_GetRequest		( BER_ContextSpecific | BER_Constructed | 0x00 )
#define BER_GetNextRequest	( BER_ContextSpecific | BER_Constructed | 0x01 )
#define BER_GetResponse		( BER_ContextSpecific | BER_Constructed | 0x02 )
#define BER_SetRequest		( BER_ContextSpecific | BER_Constructed | 0x03 )
#define BER_Trap			( BER_ContextSpecific | BER_Constructed | 0x04 )
#define BER_GetBulkRequest	( BER_ContextSpecific | BER_Constructed | 0x05 )
#define BER_InformRequest	( BER_ContextSpecific | BER_Constructed | 0x06 )
#define BER_SNMPv2_Trap		( BER_ContextSpecific | BER_Constructed | 0x07 )

typedef struct
{
   uint32_t len;
   uint8_t *buf;
} octet_string_t;

typedef struct
{
   uint8_t *buf;		/* buffer where data is stored */
   uint32_t size;		/* size of buffer */
   uint32_t offset;		/* current offset in buffer (from the end) */
} ber_t;

#include <ber/ber_encode.h>
#include <ber/ber_decode.h>
#include <ber/ber_utils.h>

#endif	/* #ifndef BER_H */
