//
//  libavg - Media Playback Engine. 
//  Copyright (C) 2003-2008 Ulrich von Zadow
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  Current versions can be found at www.libavg.de
//

#ifndef _ProfilingZone_H_ 
#define _ProfilingZone_H_

#include "../api.h"
#include "ProfilingZoneID.h"
#include "TimeSource.h"

#include <boost/shared_ptr.hpp>

namespace avg {

class AVG_API ProfilingZone
{
public:
    ProfilingZone(const ProfilingZoneID& zoneID);
    virtual ~ProfilingZone();
    
    void start() 
    {
        m_StartTime = TimeSource::get()->getCurrentMicrosecs();
    };
    void stop()
    {
        m_TimeSum += TimeSource::get()->getCurrentMicrosecs()-m_StartTime;
    };
    void reset();
    long long getUSecs() const;
    long long getAvgUSecs() const;
    void setIndentLevel(int indent);
    int getIndentLevel() const;
    std::string getIndentString() const;
    const std::string& getName() const;

private:
    const ProfilingZoneID& m_ZoneID;
    long long m_TimeSum;
    long long m_AvgTime;
    long long m_StartTime;
    int m_NumFrames;
    int m_Indent;
    bool m_bIsRegistered;
};

typedef boost::shared_ptr<ProfilingZone> ProfilingZonePtr;

}

#endif
