// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: LogServer.h,v 1.5 2005/10/08 02:42:01 vlg Exp $
//------------------------------------------------------------------------------
//                            LogServer.h
//------------------------------------------------------------------------------
//  Copyright (c) 2003 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Thu Apr 17 17:31:20 2003
//
//------------------------------------------------------------------------------

#ifndef LogServer_H
#define LogServer_H

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif
#include <string>
using std::string;

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>
#include <assa/Acceptor.h>
#include <assa/IPv4Socket.h>
#include <assa/Repository.h>

//#include <Conn.h>
class Conn;
class MonitorConn;

class LogServer :
    public ASSA::GenServer,
    public ASSA::Singleton<LogServer>
{
public:
	typedef ASSA::Repository<Conn> repo_type;
	typedef ASSA::Acceptor<Conn, ASSA::IPv4Socket> conn_accpt_type;
	typedef ASSA::Acceptor<MonitorConn, ASSA::IPv4Socket> mon_accpt_type;

public:
    LogServer ();

    virtual void init_service ();
    virtual void process_events ();

	repo_type* get_repository () { return &m_repo; }

	std::string get_log_dir () const { return m_log_dir; }
	bool recycle () const { return m_recycle; }

private:
	repo_type                    m_repo;
	conn_accpt_type*         m_acceptor;
	mon_accpt_type*  m_monitor_acceptor;
	std::string               m_log_dir;
	bool                      m_recycle;
};

/* Useful definitions */

#define LOGSERVER  LogServer::get_instance()
#define REACTOR    LOGSERVER->get_reactor()
#define REPO       LOGSERVER->get_repository()

#endif // LogServer_H

