// -*- c++ -*-
//------------------------------------------------------------------------------
//                               MaskSet.h
//------------------------------------------------------------------------------
//  Copyright (c) 1999 by Vladislav Grinchenko
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
#ifndef MASK_SET_H
#define MASK_SET_H

#include "assa/FdSet.h"

namespace ASSA {

/** @file MaskSet.h

Bundles file descriptor mask sets to be used with ::select().
*/

class MaskSet
{
public:
	/// Read fds set
	FdSet m_rset;
		
	/// Write fds set
	FdSet m_wset;

	/// Exception fds set
	FdSet m_eset;

public:
	/// Clear all bits in all sets.
	void reset (void);

	/// Write current state of MaskSet object to log file. 
	void dump (void);
};

inline void 
MaskSet::
reset (void) 
{
	m_rset.reset ();
	m_wset.reset ();
	m_eset.reset ();
}

inline void 
MaskSet::
dump (void) 
{
	DL((REACTTRACE,"--------------------\n"));
	DL((REACTTRACE,"Read FDs set:\n"));
	m_rset.dump ();

	DL((REACTTRACE,"Write FDs set:\n"));
	m_wset.dump ();

	DL((REACTTRACE,"Except FDs set:\n"));
	m_eset.dump ();
	DL((REACTTRACE,"--------------------\n"));
}

} // end namespace ASSA

#endif /* MASK_SET_H */  
