/* 
 * $Id: acs_default.c,v 1.5 2000/08/25 19:42:31 terpstra Exp $
 *
 * libarr - a screen management toolkit
 *
 * Copyright (C) 2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Author: Chris Bond
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <sys/types.h>
#include "arr.h"

const acs_map_t acs_default[] = {
	/* TC_RARROW */		{ '>', 0 },
	/* TC_LARROW */		{ '<', 0 },
	/* TC_UARROW */		{ '^', 0 },
	/* TC_DARROW */		{ 'v', 0 },
				{ 0, 0 },
	/* TC_BLOCK */		{ '#', 0 },
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, 
				{ 0, 0 }, { 0, 0 }, { 0, 0 },
	/* TC_DIAMOND */	{ '+', 0 },
	/* TC_CHKBOARD */	{ ':', 0 },
				{ 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },
	/* TC_DEGREE */		{ '\'', 0 },
	/* TC_PLUSMINUS */	{ '#', 0 },
	/* TC_SQBOARD */	{ '#', 0 },
	/* TC_LANTERN */	{ '#', 0 },
	/* TC_LRCORNER */	{ '/', 0 },
	/* TC_URCORNER */	{ '\\', 0 },
	/* TC_ULCORNER */	{ '/', 0 },
	/* TC_LLCORNER */	{ '\\', 0 },
	/* TC_PLUS */		{ '+', 0 },
	/* TC_SCANL1 */		{ '~', 0 },
	/* TC_SCANL3 */		{ '-', 0 },
	/* TC_HORZLINE */	{ '-', 0 },
	/* TC_SCANL7 */		{ '-', 0 },
	/* TC_SCANL9 */		{ '_', 0 },
	/* TC_RTEE */		{ '+', 0 },
	/* TC_LTEE */		{ '+', 0 },
	/* TC_UTEE */		{ '+', 0 },
	/* TC_DTEE */		{ '+', 0 },
	/* TC_VERTLINE */	{ '|', 0 },
	/* TC_LESSEQUAL */	{ '<', 0 },
	/* TC_MOREEQUAL */	{ '>', 0 },
	/* TC_PI */		{ '*', 0 },
	/* TC_NOTEQUAL */	{ '!', 0 },
	/* TC_STERLING */	{ 'f', 0 },
	/* TC_BULLET */		{ 'o', 0 }
};

const int sizeof_acs_default = sizeof(acs_default)  / sizeof(acs_default[0]);
