#ifndef NLSERVERCOMMANDS_H
#define NLSERVERCOMMANDS_H

/**
   The commands from the server to the client
**/

class ArServerCommands
{
public:
  enum ServerCommands {
    SHUTDOWN = 1, ///< Closes the connection
    INTRODUCTION = 2, ///< Introduces the server to the client
    UDP_INTRODUCTION = 3, ///< Udp introduction of the server to the client
    UDP_CONFIRMATION = 4, ///< Confirmation Udp was received from client
    CONNECTED = 5, ///< Server accepts clients connection
    REJECTED = 6, ///< Server rejects clients connection, has a byte2, then a string.... these reasons (1 = bad username password, string then is empty, 2 = rejecting connection because using central server, string then is central server IP)
    TCP_ONLY = 7, ///< Server tells client to only send TCP
    LIST = 129, ///< Map of the string names for a type to a number along with a long description of the data type
    LISTSINGLE = 130, ///< Map of a single type to a number (for late additions to server) along with its description
    LISTARGRET = 131, ///< Map of the number to their arguments and returns descriptions
    LISTARGRETSINGLE = 132, ///< Map of a single type to a number (for late additions to server) along with its argument and return descriptions
    LISTGROUPANDFLAGS = 133, ///< Map of the number to their command groups and data flags
    LISTGROUPANDFLAGSSINGLE = 134 ///< Map of a single type to a number (for late additions to server) along with its command group and data flags
  };
};

#endif // NLSERVERCOMMANDS_H
