/***************************************************************************
 $RCSfile: rdhkeyfile.h,v $
                             -------------------
    cvs         : $Id: rdhkeyfile.h,v 1.2 2004/04/22 22:56:36 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef AH_MEDIUMRDHKEYFILE_H
#define AH_MEDIUMRDHKEYFILE_H

#include <aqhbci/mediumrdh.h>
#include <gwenhywfar/buffer.h>
#include <gwenhywfar/crypt.h>
#include <gwenhywfar/keyspec.h>

/** @defgroup AQHBCI_MOD_HBCI_MEDIUM_KEYFILE HBCI RDH Medium Using Keyfiles
 * @ingroup AQHBCI_MOD_HBCI_MEDIUMRDH
 * @short Security Medium For HBCI in RDH Mode Using Keyfiles
 * @author Martin Preuss<martin@libchipcard.de>
 *
 */
/*@{*/

/** @name Constructor And Destructor
 *
 */
/*@{*/
AH_MEDIUM *AH_MediumRDHKeyFile_new(AH_HBCI *hbci, const char *mediumName);
/*@}*/


/** @name Special Functions
 *
 */
/*@{*/
int AH_MediumRDHKeyFile_ChangePin(AH_MEDIUM *m);
/*@}*/


/*@}*/ /* defgroup */



AH_MEDIUMPROVIDER *AH_MediumRDHKeyFileProvider_new();



#endif /* AH_MEDIUMRDHKEYFILE_H */


