/***************************************************************************
 $RCSfile: mediumrdh.c,v $
                             -------------------
    cvs         : $Id: mediumrdh.c,v 1.9 2005/03/28 02:04:33 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "mediumrdh_p.h"
#include "aqhbci_l.h"
#include <gwenhywfar/debug.h>
#include <gwenhywfar/misc.h>

#include <stdlib.h>
#include <assert.h>
#include <string.h>


GWEN_INHERIT(AH_MEDIUM, AH_MEDIUMRDH);



AH_MEDIUMRDH *AH_MediumRDH_Data_new(){
  AH_MEDIUMRDH *mrdh;

  GWEN_NEW_OBJECT(AH_MEDIUMRDH, mrdh);

  return mrdh;
}



void AH_MediumRDH_Data_free(AH_MEDIUMRDH *mrdh){
  if (mrdh) {
    DBG_DEBUG(AQHBCI_LOGDOMAIN, "Destroying AH_MEDIUMRDH");
    free(mrdh);
  }
}




AH_MEDIUM *AH_MediumRDH_new(AH_HBCI *hbci,
                            const char *mtn,
                            const char *mediumName) {
  AH_MEDIUM *m;
  AH_MEDIUMRDH *mrdh;

  m=AH_Medium_new(hbci,
                  AH_MediumTypeRDH,
                  mtn,
                  mediumName);
  mrdh=AH_MediumRDH_Data_new();
  GWEN_INHERIT_SETDATA(AH_MEDIUM, AH_MEDIUMRDH,
                       m, mrdh,
                       AH_MediumRDH_FreeData);

  return m;
}



void AH_MediumRDH_FreeData(void *bp, void *p){
  AH_MEDIUM *m;
  AH_MEDIUMRDH *mrdh;

  assert(p);
  assert(bp);
  m=(AH_MEDIUM*)bp;
  mrdh=(AH_MEDIUMRDH*)p;

  AH_MediumRDH_Data_free(mrdh);
}



GWEN_CRYPTKEY *AH_MediumRDH_GetLocalPubSignKey(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return 0;
  }
  if (mrdh->getLocalPubSignKeyFn)
    return mrdh->getLocalPubSignKeyFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No getLocalPubSignKey function set");
    return 0;
  }
}



GWEN_CRYPTKEY *AH_MediumRDH_GetLocalPubCryptKey(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return 0;
  }
  if (mrdh->getLocalPubCryptKeyFn)
    return mrdh->getLocalPubCryptKeyFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No getLocalPubCryptKey function set");
    return 0;
  }
}



GWEN_CRYPTKEY *AH_MediumRDH_GetLocalTmpSignKey(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return 0;
  }
  if (mrdh->getLocalTmpSignKeyFn)
    return mrdh->getLocalTmpSignKeyFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No getLocalTmpSignKey function set");
    return 0;
  }
}



GWEN_CRYPTKEY *AH_MediumRDH_GetLocalTmpCryptKey(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return 0;
  }
  if (mrdh->getLocalTmpCryptKeyFn)
    return mrdh->getLocalTmpCryptKeyFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No getLocalTmpCryptKey function set");
    return 0;
  }
}



GWEN_CRYPTKEY *AH_MediumRDH_GetPubSignKey(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return 0;
  }
  if (mrdh->getPubSignKeyFn)
    return mrdh->getPubSignKeyFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No getPubSignKey function set");
    return 0;
  }
}



int AH_MediumRDH_SetPubSignKey(AH_MEDIUM *m,
                               const GWEN_CRYPTKEY *key){
  AH_MEDIUMRDH *mrdh;
  int rv;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return AB_ERROR_GENERIC;
  }
  if (mrdh->setPubSignKeyFn) {
    AH_Medium_SetRemoteSignKeySpec(m, GWEN_CryptKey_GetKeySpec(key));
    rv=mrdh->setPubSignKeyFn(m, key);
  }
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No setPubSignKey function set");
    return AB_ERROR_NOT_SUPPORTED;
  }
  return rv;
}




GWEN_CRYPTKEY *AH_MediumRDH_GetPubCryptKey(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return 0;
  }
  if (mrdh->getPubCryptKeyFn)
    return mrdh->getPubCryptKeyFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No getPubCryptKey function set");
    return 0;
  }
}



int AH_MediumRDH_SetPubCryptKey(AH_MEDIUM *m,
                                const GWEN_CRYPTKEY *key){
  AH_MEDIUMRDH *mrdh;
  int rv;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return AB_ERROR_GENERIC;
  }
  if (mrdh->setPubCryptKeyFn) {
    AH_Medium_SetRemoteCryptKeySpec(m, GWEN_CryptKey_GetKeySpec(key));
    rv=mrdh->setPubCryptKeyFn(m, key);
  }
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No setPubCryptKey function set");
    return AB_ERROR_NOT_SUPPORTED;
  }
  return rv;
}



int AH_MediumRDH_CreateKeys(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return -1;
  }
  if (mrdh->createKeysFn)
    return mrdh->createKeysFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No createKeys function set");
    return -1;
  }
}



int AH_MediumRDH_ActivateKeys(AH_MEDIUM *m){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  if (!AH_Medium_IsMounted(m)) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "Medium is not mounted");
    return -1;
  }
  if (mrdh->activateKeysFn)
    return mrdh->activateKeysFn(m);
  else {
    DBG_WARN(AQHBCI_LOGDOMAIN, "No activateKeys function set");
    return -1;
  }
}



void AH_MediumRDH_SetGetLocalPubSignKeyFn(AH_MEDIUM *m,
                                          AH_MEDIUMRDH_GETLOCALPUBSIGNKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->getLocalPubSignKeyFn=f;
}



void AH_MediumRDH_SetGetLocalPubCryptKeyFn(AH_MEDIUM *m,
                                           AH_MEDIUMRDH_GETLOCALPUBCRYPTKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->getLocalPubCryptKeyFn=f;
}



void AH_MediumRDH_SetGetLocalTmpSignKeyFn(AH_MEDIUM *m,
                                          AH_MEDIUMRDH_GETLOCALTMPSIGNKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->getLocalTmpSignKeyFn=f;
}



void AH_MediumRDH_SetGetLocalTmpCryptKeyFn(AH_MEDIUM *m,
                                           AH_MEDIUMRDH_GETLOCALTMPCRYPTKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->getLocalTmpCryptKeyFn=f;
}



void AH_MediumRDH_SetSetPubSignKeyFn(AH_MEDIUM *m,
                                     AH_MEDIUMRDH_SETPUBSIGNKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->setPubSignKeyFn=f;
}



void AH_MediumRDH_SetGetPubSignKeyFn(AH_MEDIUM *m,
                                     AH_MEDIUMRDH_GETPUBSIGNKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->getPubSignKeyFn=f;
}



void
AH_MediumRDH_SetSetPubCryptKeyFn(AH_MEDIUM *m,
                                     AH_MEDIUMRDH_SETPUBCRYPTKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->setPubCryptKeyFn=f;
}



void
AH_MediumRDH_SetGetPubCryptKeyFn(AH_MEDIUM *m,
                                 AH_MEDIUMRDH_GETPUBCRYPTKEYFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->getPubCryptKeyFn=f;
}



void AH_MediumRDH_SetCreateKeysFn(AH_MEDIUM *m,
                                  AH_MEDIUMRDH_CREATEKEYSFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->createKeysFn=f;
}



void AH_MediumRDH_SetActivateKeysFn(AH_MEDIUM *m,
                                    AH_MEDIUMRDH_ACTIVATEKEYSFN f){
  AH_MEDIUMRDH *mrdh;

  assert(m);
  mrdh=GWEN_INHERIT_GETDATA(AH_MEDIUM, AH_MEDIUMRDH, m);
  assert(mrdh);
  mrdh->activateKeysFn=f;
}



AH_MEDIUM_RESULT AH_MediumRDH_EncryptKey(AH_MEDIUM *m,
                                         GWEN_CRYPTKEY *remoteCryptKey,
                                         GWEN_BUFFER *srckey,
                                         GWEN_BUFFER *encKey){
  GWEN_ERRORCODE err;
  GWEN_BUFFER *kbuf;
  int i;

  assert(m);

  /* encrypt session key */
  GWEN_Buffer_Rewind(srckey);
  i=GWEN_CryptKey_GetChunkSize(remoteCryptKey)-16;
  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Padding with %d bytes", i);
  kbuf=GWEN_Buffer_new(0, 96, 0, 1);

  while(i-->0)
    GWEN_Buffer_AppendByte(kbuf, (char)0);
  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Padding done");
  GWEN_Buffer_AppendBuffer(kbuf, srckey);

  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Encrypting key");
  err=GWEN_CryptKey_Encrypt(remoteCryptKey,
                            kbuf,
                            encKey);
  GWEN_Buffer_free(kbuf);
  if (!GWEN_Error_IsOk(err)) {
    DBG_INFO_ERR(AQHBCI_LOGDOMAIN, err);
    return AH_MediumResultGenericError;
  }
  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Encrypting key done");

  return AH_MediumResultOk;
}



AH_MEDIUM_RESULT AH_MediumRDH_DecryptKey(AH_MEDIUM *m,
                                         GWEN_CRYPTKEY *localCryptKey,
                                         GWEN_BUFFER *srckey,
                                         GWEN_BUFFER *deckey){
  GWEN_ERRORCODE err;

  if (localCryptKey==0) {
    DBG_ERROR(AQHBCI_LOGDOMAIN, "No local crypt key");
    return AH_MediumResultNoKey;
  }

  /* create session key */
  GWEN_Buffer_Rewind(srckey);

  /* decrypt session key */
  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Decrypting key");
  err=GWEN_CryptKey_Decrypt(localCryptKey,
                            srckey,
                            deckey);
  if (!GWEN_Error_IsOk(err)) {
    DBG_INFO_ERR(AQHBCI_LOGDOMAIN, err);
    return AH_MediumResultBadKey;
  }

  if (GWEN_Buffer_GetUsedBytes(deckey)<16) {
    DBG_ERROR(AQHBCI_LOGDOMAIN,
              "Bad size of session key (%d bytes)",
              GWEN_Buffer_GetUsedBytes(deckey));
    return AH_MediumResultBadKey;
  }
  GWEN_Buffer_Crop(deckey, GWEN_Buffer_GetUsedBytes(deckey)-16, 16);
  DBG_DEBUG(AQHBCI_LOGDOMAIN, "Decrypting key done");

  return AH_MediumResultOk;
}
























