/***************************************************************************
 $RCSfile: kbanking.h,v $
                             -------------------
    cvs         : $Id: kbanking.h,v 1.3 2005/02/20 23:18:54 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQHBCI_KDE_BANKING_H
#define AQHBCI_KDE_BANKING_H


#include <aqbanking/banking.h>
#include <aqbanking++/banking.h>
#include <gwenhywfar/nettransportssl.h>

#include <qobject.h>
#include <list>


class KBProgress;
class KBSimpleBox;


class KBanking: public QObject, public AB::Banking {
  friend class KBanking_Linker;
  Q_OBJECT
private:
  QWidget *_parentWidget;
  GWEN_TYPE_UINT32 _lastWidgetId;
  AB_BANKING_LOGLEVEL _logLevel;
  std::list<KBProgress*> _progressWidgets;
  std::list<KBSimpleBox*> _simpleBoxWidgets;

  KBProgress *_findProgressWidget(GWEN_TYPE_UINT32 id);
  void _cleanupProgressWidgets();
  int _extractHTML(const char *text, GWEN_BUFFER *buf);

protected:
  virtual int messageBox(GWEN_TYPE_UINT32 flags,
			 const char *title,
			 const char *text,
			 const char *b1,
			 const char *b2,
			 const char *b3);

  virtual int inputBox(GWEN_TYPE_UINT32 flags,
		       const char *title,
                       const char *text,
                       char *buffer,
                       int minLen,
                       int maxLen);

  virtual GWEN_TYPE_UINT32 showBox(GWEN_TYPE_UINT32 flags,
                                   const char *title,
                                   const char *text);
  virtual void hideBox(GWEN_TYPE_UINT32 id);

  virtual GWEN_TYPE_UINT32 progressStart(const char *title,
                                         const char *text,
                                         GWEN_TYPE_UINT32 total);

  /**
   * Advances the progress bar an application might present to the user.
   * @param id id assigned by @ref AB_Banking_Progress_Start
   * @param progress new value for progress. A special value is
   *  AB_BANKING_PROGRESS_NONE which means that the progress is unchanged.
   * This might be used as a keepalive call to a GUI.
   */
  virtual int progressAdvance(GWEN_TYPE_UINT32 id,
                              GWEN_TYPE_UINT32 progress);
  virtual int progressLog(GWEN_TYPE_UINT32 id,
                          AB_BANKING_LOGLEVEL level,
                          const char *text);
  virtual int progressEnd(GWEN_TYPE_UINT32 id);


public:
  KBanking(const char *appname,
           const char *fname=0,
           QObject *parent=0,
           const char *name=0);
  virtual ~KBanking();


  void setParentWidget(QWidget *w);

  int enqueueJob(AB_JOB *j);
  int dequeueJob(AB_JOB *j);
  int executeQueue();

  void accountsUpdated();

  static std::string QStringToUtf8String(const QString &qs);

signals:
  void signalQueueUpdated();
  void signalAccountsUpdated();
};




#endif /* AQHBCI_KDE_BANKING_H */


