#!/usr/bin/perl -w
#
#  Test that DropPath works as expected
#
# $Id: drop-path.t,v 1.3 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

my $conf = <<EOF;
DropAction status=403
DropPath path.cgi
DropPath formmail.(cgi|pl)

DropPath skx.cgi status=500

EOF

writeConf( $conf );
restart();


#
#  Get a random path, so we can be sure we'll get a 404 code.
#
my $path = join ( '', map {('a'..'z')[rand 26]} 0..7 );

#
#  Now we make some requests.
#
is( makeGETRequest( "/path.cgi" ),
    403, "/path.cgi blocked as expected" );
is( makeGETRequest( "/path.cgi?foo=bar" ),
    403, "/path.cgi?foo=bar blocked as expected" );
is( makeGETRequest( "/$path/path.cgi" ),
    403, "/$path/path.cgi blocked as expected" );
is( makeGETRequest( "/$path/test.txt" ),
    404, "/$path/test.txt allowed as expected" );

is( makeGETRequest( "/formmail.cgi" ),
    403, "/formmail.cgi blocked as expected" );
is( makeGETRequest( "/formmail.cgi?foo=bar" ),
    403, "/formmail.cgi?foo=bar blocked as expected" );
is( makeGETRequest( "/$path/formmail.cgi" ),
    403, "/$path/formmail.cgi blocked as expected" );
is( makeGETRequest( "/$path/formmail.txt" ),
    404, "/$path/formmail.txt allowed as expected" );

is( makeGETRequest( "/formmail.pl" ),
    403, "/formmail.pl blocked as expected" );
is( makeGETRequest( "/formmail.pl?foo=bar" ),
    403, "/formmail.pl blocked as expected" );
is( makeGETRequest( "/$path/formmail.pl" ),
    403, "/$path/formmail.pl blocked as expected" );

is( makeGETRequest( "/skx.cgi" ),
    500, "Per-rule action works as expected: GET" );
is( makeHEADRequest( "/skx.cgi" ),
    500, "Per-rule action works as expected: HEAD" );


#
#  Cleanup
#
cleanConf();
restart();
