/*
 *  mod_musicindex.h
 *  mod_musicindex
 *  
 *  $Id: mod_musicindex.h,v 1.55 2004/05/29 11:26:54 varenet Exp $
 *
 *  Created by Thibaut VARENE on Thu Mar 20 2003.
 *  Copyright (c) 2003-2004 Regis BOUDIN
 *  Copyright (c) 2003-2004 Thibaut VARENE
 *   
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1, or (at your option)
 *  any later version.
 *
 */

#ifndef MOD_MUSICINDEX_H
#define MOD_MUSICINDEX_H

#undef ENABLE_GETTEXT

/* i18n stuff */
#ifdef ENABLE_GETTEXT
 #include <libintl.h>
 #define _(String)	gettext(String)
#else
 #define _(String)	String
#endif	/* ENABLE_GETTEXT */

#include <httpd.h>
#include <http_config.h>
#include <http_core.h>
#include <http_request.h>
#include <http_protocol.h>
#include <http_log.h>
#include <http_main.h>
#include <ap_compat.h>

#ifdef AP_SERVER_MAJORVERSION /* detects if we use apache 2 */
 #define __BUILD_FOR_APACHE2
 
 #include <apr_strings.h>
 #include <apr_base64.h>

 #ifdef APLOG_ERR
  #undef APLOG_ERR
  #define APLOG_ERR LOG_ERR, 0	/**< dirty trick because ap_log_rerror takes one more arg in apache2 */
 #endif

 #define ap_hard_timeout(pool, dir)	/**< disapeared in apache2 */
 #define ap_kill_timeout(r)		/**< disapeared in apache2 */
 
 #define ap_pclosedir(pool, dir) apr_dir_close(dir) /**< function is different in apache2 */

#endif	/* AP_SERVER_MAJORVERSION */

#ifndef __BUILD_FOR_APACHE2

/* some things have to be redefined for apache 1.3 to use the same declaration
   in both apache 1&2 versions of the program */
 #define apr_pool_t	pool	/**< type name is different in apache 1.3 and 2 */
 #define apr_dir_t	DIR	/**< apache 2 uses a special directory type */
 
 #define AP_INIT_NO_ARGS(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, NO_ARGS, help }
 #define AP_INIT_RAW_ARGS(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, RAW_ARGS, help }
 #define AP_INIT_TAKE1(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, TAKE1, help }
 #define AP_INIT_FLAG(directive, func, mconfig, where, help) \
    { directive, func, mconfig, where, FLAG, help }


 #define ap_is_directory(pool, name) ap_is_directory(name) /**< function changed in apache2 */

 #define apr_dir_open(dir, filename, pool) ((*(dir)) = ap_popendir(pool, filename))

 #define ap_set_content_type(r, string) (r->content_type = string)

 #define apr_pool_create(child, parent) ((*(child)) = ap_make_sub_pool(parent))

 #define ap_sub_req_lookup_uri(p, r, ptr) ap_sub_req_lookup_uri(p, r)

 #define REQUEST_USER(rec) (rec->connection->user)
#else
 #define REQUEST_USER(rec) (rec->user)
#endif	/* ! __BUILD_FOR_APACHE2 */

module MODULE_VAR_EXPORT musicindex_module;

/*
 * Compile time configuration option
 */
#undef NO_TITLE_STRIP	/**< Disable pretty printing for untagged files */

/*
 * Current version number & authors
 */
#define MUSIC_VERSION_STRING	"0.99.0"		/**< Version string */
#define MUSIC_AUTHORS_STRING	"R. Boudin & T. Varene"	/**< Authors */

/*
 * Various constants used almost everywhere
 */
#define SB_ALBUM	'A'		/**< Sort by album */
#define SB_ARTIST	'B'		/**< Sort by artist */
#define SB_DATE		'D'		/**< Sort by date */
#define SB_GENRE	'G'		/**< Sort by genre */
#define SB_FILETYPE	'F'		/**< Sort by filetype */
#define SB_LENGTH	'L'		/**< Sort by length */
#define SB_FILENAME	'M'		/**< Sort by filename */
#define SB_TRACK	'N'		/**< Sort by track */
#define SB_POSN		'P'		/**< Sort by Part Of Set nb */
#define SB_BITRATE	'R'		/**< Sort by bitrate */
#define SB_SIZE		'S'		/**< Sort by filesize */
#define SB_TITLE	'T'		/**< Sort by title */
#define SB_URI		'U'		/**< Sort by URI */
#define SB_DIR		'V'		/**< Sort by directory */
#define SB_DEFAULT	'U'		/**< Default sort order (used in search results) */
#define SB_RANDOM	'Z'		/**< Sort randomly */

#define FT_OGG		'O'		/**< File is Ogg */
#define FT_MP3		'M'		/**< File is MP3 */
#define FT_DIR		'Z'		/**< File is a directory, must be high */

#define D_ASCENDING	1		/**< Sort ascending */
#define D_DESCENDING	-1		/**< Sort descending */

#define ARG_NUMBER	16		/**< Number of args to sort lists */

#define MI_ACTIVE	0x0001		/**< Music indexing is enabled */
#define MI_PLAYLIST	0x0002		/**< Generation of a playlist (not webpage) */
#define MI_ALLOWSTREAM	0x0004		/**< Stream is permitted */
#define MI_ALLOWDWNLD	0x0008		/**< Download is permitted */
#define MI_PLAYALL	0x0010		/**< Play all songs */
#define MI_RECURSIVE	0x0020		/**< Recursive action */
#define MI_QUICKPL	0x0040		/**< "Quick Play" (disable bitrate/length) */
#define MI_ALLOWSEARCH	0x0080		/**< Search is permitted */
#define MI_LISTCUSTOM	0x0100		/**< mu_ent lists is a custom playlist */

#define MI_COOKIE	0x0400		/**< Should be removed later */
#define MI_COOKIEADD	0x0800		/**< Add an entry to X-dir list */
#define MI_COOKIEALL	0x1000		/**< Add all files from dir */
#define MI_COOKIEDEL	0x2000		/**< Remove entry from X-dir list */
#define MI_COOKIESTREAM	0x4000		/**< Stream X-dir list */
#define MI_COOKIEPURGE	0x8000		/**< Empty X-dir list */

#define MI_COOKIEANY	(MI_COOKIEADD	|	\
			MI_COOKIEALL	|	\
			MI_COOKIEDEL	|	\
			MI_COOKIEPURGE	|	\
			MI_COOKIESTREAM)

#define MAX_STRING	1024		/**< Common reference for maximum string size. */

/** first struct to handle yet unparsed files */
typedef struct mu_ent_names {
	char filename[MAX_STRING];	/**< file path */
	char uri[MAX_STRING];		/**< file URI */
	short create_cache_file;	/**< used by cache subsystem */
} mu_ent_names;

/** Music entry. It contains various data about an associated file. */
typedef struct mu_ent {
	char *file;		/**< file path */
	char *uri;		/**< file URI (unique) */
	char *album;		/**< album (if any) */
	char *artist;		/**< artist (if any) */
	char *title;		/**< title (as shown on the webpages) */
	char *genre;		/**< genre (type of music - if any) */
	unsigned short date;	/**< date (year actually) */
	unsigned short track;	/**< track number */
	unsigned short posn;	/**< "part of a set" number, that is, disc number */
	unsigned long length;	/**< length in seconds */
	unsigned long bitrate;	/**< bitrate in bits per second */
	unsigned long size;	/**< size in bytes */
	char filetype;		/**< file type */
	struct mu_ent *next;
} mu_ent;

/** sort function pointer type (see inf.c) */
typedef int (*inf_ptr)(mu_ent *, mu_ent *);

/** Configuration handling structure. We use it to share configuration
 * throughout the whole module */
typedef struct mu_config {
	char order[ARG_NUMBER];		/**< Sort order */
	char fields[ARG_NUMBER];	/**< Fields to display */
	inf_ptr order_functions[ARG_NUMBER];	/**< Functions array for sort */
	
	char *title;			/**< title of the page */

	char *directory;		/**< directory where files will be stored */

	char *favicon;			/**< favicon used by modern browsers in url bar */
	char *cd_icon;			/**< path to the cd icon */
	char *small_cd_icon;		/**< path to the small cd icon */
	char *sound_icon;		/**< path to the stream icon */
	char *fetch_icon;		/**< path to the fetch icon */
	char *arrow;			/**< path to the arrow icon */
	char *css;			/**< path to the css */

	char *search;			/**< string to search */

	char *cache_path;		/**< path to the cache root folder */
	char *iceserver;		/**< adress of an icecast server */

	unsigned short cookie_life;	/**< cookie lifetime in seconds */

	unsigned short play_recursive;	/**< should we go recursively ? */

	unsigned short options;		/**< diverse options */
	unsigned short options_not;	/**< used to disable options */
} mu_config;

#endif	/* MOD_MUSICINDEX_H */
