/* ======================================================================
 * Copyright (c) 1998-1999 The Johns Hopkins University.
 * All rights reserved.
 * The following code was written by Theo Schlossnagle for use in the
 * Backhand project at The Center for Networking and Distributed Systems
 * at The Johns Hopkins University.
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

#ifndef _MOD_BACKHAND_H
#define _MOD_BACKHAND_H

/* mod_backhand header file */

/* All statistic information is kept in the serverstat.h file.  This
   is done as all the information is filled by a separate process or a
   separate thread. */
#include "httpd.h"
#include "http_config.h"
#include "serverstat.h"

#define MOD_BACKHAND_STRING_VERSION "mod_backhand/1.2.2"

#define MAXSERVERS HARD_SERVER_LIMIT
#define MAXSESSIONSPERSERVER 100
#define SERVERSTATS_SIZE (sizeof(serverstat)*MAXSERVERS)
#define SERVER_TIMEOUT 5
#define RBUFLEN 65536

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN 8192
#endif

#ifdef SOLARIS2
static int inet_aton(const char *a, struct in_addr *b) {
  return (*(unsigned long int *)b = inet_addr(a));
}
#endif

typedef struct {
  unsigned int redirect:1;
#define MB_HTTP_PROXY    0
#define MB_HTTP_REDIRECT 1
  unsigned int hosttype:1;
#define MB_HOSTTYPE_NAME 0
#define MB_HOSTTYPE_IP   1
  int id;
} ServerSlot;

typedef int (*DecisionFunc)(request_rec *,  ServerSlot *, int *, char *);
/* This takes the request, an array of candidated server indeices.
   a reference to the number of candidates and the argument.
   The array is guaranteed to be MAXSERVERS in size and is NOT const,
   fill this with what you want,  Change the cardinality when you are done */

typedef struct _ACL {
  struct in_addr ip;
  struct in_addr mask;
  struct _ACL *next;
} ACL;

typedef struct _StatsSI {
  struct in_addr from;    /* who we are: IP */
  unsigned short webport; /* who we are: port */
  struct sockaddr_in sin; /* where we are going */
} StatsSI;

typedef struct mbcfg {
  int cmode;
#define CONFIG_MODE_SERVER 1
#define CONFIG_MODE_DIRECTORY 2
#define CONFIG_MODE_COMBO 3     /* Shouldn't ever happen. */
  int local;
  int congenital;
  int connectionpools;
#define MBCP_INHERIT 0
#define MBCP_ON      1
#define MBCP_OFF     2
  int selfredirect;
#define MBSR_INHERIT 0
#define MBSR_ON      1
#define MBSR_OFF     2
  int loglevel;
#define MBLL_NONE    0
#define MBLL_NET1    (1)
#define MBLL_NET2    (1<<1)
#define MBLL_NET3    (1<<2)
#define MBLL_NET4    (1<<3)
#define MBLL_NETALL  (MBLL_NET1|MBLL_NET2|MBLL_NET3|MBLL_NET4)
#define MBLL_MBCS1   (1<<4)
#define MBLL_MBCS2   (1<<5)
#define MBLL_MBCS3   (1<<6)
#define MBLL_MBCS4   (1<<7)
#define MBLL_MBCSALL  (MBLL_MBCS1|MBLL_MBCS2|MBLL_MBCS3|MBLL_MBCS4)
#define MBLL_DCSN1   (1<<8)
#define MBLL_DCSN2   (1<<9)
#define MBLL_DCSN3   (1<<10)
#define MBLL_DCSN4   (1<<11)
#define MBLL_DCSNALL  (MBLL_DCSN1|MBLL_DCSN2|MBLL_DCSN3|MBLL_DCSN4)
  char *loc;
  struct cpd *dfunc;
} mbcfg;

struct lognames {
  char *aString;
  int bits;
};

#define our_dconfig(a) ((mbcfg *) ap_get_module_config((a)->per_dir_config, &backhand_module))
#define our_sconfig(a) ((mbcfg *) ap_get_module_config((a)->module_config, &backhand_module))

#ifndef IN_MODULE
extern int serverstats_shmid;
extern int serverstats_shmkey;
extern serverstat *serverstats;
extern int mod_backhand_personal_arriba;
extern module backhand_module;
extern struct lognames *LogLevels;
#else
struct lognames LogLevels[] = {
  {"none", MBLL_NONE},
  {"net1", MBLL_NET1},
  {"net2", MBLL_NET2},
  {"net3", MBLL_NET3},
  {"net4", MBLL_NET4},
  {"netall", MBLL_NETALL},
  {"mbcs1", MBLL_MBCS1},
  {"mbcs2", MBLL_MBCS2},
  {"mbcs3", MBLL_MBCS3},
  {"mbcs4", MBLL_MBCS4},
  {"mbcsall", MBLL_MBCSALL},
  {"dcsn1", MBLL_DCSN1},
  {"dcsn2", MBLL_DCSN2},
  {"dcsn3", MBLL_DCSN3},
  {"dcsn4", MBLL_DCSN4},
  {"dcsnall", MBLL_DCSNALL},
  {NULL, 0}
};
#endif

#define MAX3(a,b,c) (((a)>(b))?(((a)>(c))?(a):(c)):((b)>(c))?(b):(c))
#ifndef MAX
#define MAX(a,b) ((a>b)?(a):(b))
#endif
#ifndef MIN
#define MIN(a,b) ((a<b)?(a):(b))
#endif

#endif
