/* $Id: mysql.c,v 1.5 2002/01/05 11:50:50 tellini Exp $ */

/*
	Copyright (c) 2001-2002 Simone Tellini

	Permission is hereby granted, free of charge, to any person obtaining 
	a copy of this software and associated documentation files (the "Software"), 
	to deal in the Software without restriction, including without limitation 
	the rights to use, copy, modify, merge, publish, distribute, sublicense, 
	and/or sell copies of the Software, and to permit persons to whom the 
	Software is furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included 
	in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
	THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
	FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
	DEALINGS IN THE SOFTWARE.
*/

#ifdef NEED_MYSQL

#include <mysql/mysql.h>

#include "mod_accounting.h"

#define MYSQL_ERROR( mysql ) (( mysql ) ? ( mysql_error(( MYSQL * )mysql )) : "MySQL server has gone away" )

int MySetup( accounting_state *cfg )
{
	if( !cfg->DBHandle && cfg->DBName ) {
		unsigned int	port = 0;

		if( cfg->DBPort )
			port = atoi( cfg->DBPort );

		cfg->DBHandle = malloc( sizeof( MYSQL ));

		mysql_init(( MYSQL * )cfg->DBHandle );

		if( !mysql_real_connect(( MYSQL * )cfg->DBHandle, cfg->DBHost, cfg->DBUser, cfg->DBPwd, cfg->DBName, port, NULL, 0 )) {

			free( cfg->DBHandle );

			cfg->DBHandle = NULL;
		}
	}

	return( cfg->DBHandle != NULL );
}

int MyQuery( accounting_state *cfg, server_rec *server, pool *p, char *query )
{
	int		retval = 1;
	void	( *handler )( int );

	/* A failed mysql_query() may send a SIGPIPE, so we ignore that signal momentarily. */
	handler = signal( SIGPIPE, SIG_IGN );

	// is the DB link still alive?
	if( !cfg->DBHandle || mysql_ping(( MYSQL * )cfg->DBHandle )) {

		MyClose( cfg );

	    ap_log_error( APLOG_MARK,ERRLEVEL, server, "MySQL: connection lost, attempting reconnect" );

   		if( MySetup( cfg ))
	   		ap_log_error( APLOG_MARK,ERRLEVEL, server, "MySQL: reconnect successful" );
		else
  			ap_log_error( APLOG_MARK,ERRLEVEL, server, "MySQL: reconnect failed" );
	}

	if( cfg->DBHandle ) {

		retval = mysql_query(( MYSQL * )cfg->DBHandle, query );

		if( retval ) {

			ap_log_error( APLOG_MARK,ERRLEVEL, server, 
						  ap_pstrcat( p, "MySQL insert failed:  ", query, NULL ));

			ap_log_error( APLOG_MARK, ERRLEVEL, server, 
						  ap_pstrcat( p, "MySQL failure reason:  ", MYSQL_ERROR( cfg->DBHandle ), NULL ));
		}
	}

	signal( SIGPIPE, handler );

	return( retval == 0 );
}

void MyClose( accounting_state *cfg )
{
	if( cfg->DBHandle ) {

		mysql_close(( MYSQL * )cfg->DBHandle );

		free( cfg->DBHandle );

		cfg->DBHandle = NULL;
	}
}

#endif /* NEED_MYSQL */
