-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          July 8, 1998  HFVogt: adapted to new naming of Button
--
-------------------------------------------------------------------------------

with Ada.Text_Io,
     Interfaces.C,
     String_List,
     X_Lib.Tasking,
     X_Toolkit;
use  Ada.Text_Io,
     X_Toolkit;
package body Actions_Global is


   procedure Show_Event_Data (Event : in X_Lib.X_Event_Pointer) is
   begin
      Put_Line ("Event: " & X_Lib.Event_Type'Image (Event.Ev_Type));
      Put_Line ("   Root: " & X_Lib.Window_ID'Image (Event.X_Button.Root) &
                ", SubWindow: " &
                X_Lib.Window_ID'Image (Event.X_Button.SubWindow));
      Put_Line ("   Time: " & X_Lib.Server_Time'Image (Event.X_Button.Time));
      Put_Line ("   X, Y: " &
                X_Lib.Position'Image (Event.X_Button.X) & ", " &
                X_Lib.Position'Image (Event.X_Button.Y));
      Put_Line ("   X, Y rel. Root: " &
                X_Lib.Position'Image (Event.X_Button.X_Root) & ", " &
                X_Lib.Position'Image (Event.X_Button.Y_Root));
      Put_Line ("   Button: " &
                X_Lib.Button_Type'Image (Event.X_Button.Button));
      if Event.X_Button.Same_Screen then
         Ada.Text_Io.Put_Line ("       Same Screen");
      else
         Ada.Text_Io.Put_Line ("       NOT Same Screen");
      end if;
   end Show_Event_Data;


   procedure Action_One (W          : in Widget;
                         Event      : in X_Lib.X_Event_Pointer;
                         Params     : in String_List_Conversion.Chars_Ptr_List_Type;
                         Num_Params : access String_List_Conversion.Index_Type) is
      Parameters : String_List.Element_Access_List := String_List_Conversion.To_String_Access_List (Params, Num_Params.all);
   begin
      X_Lib.Tasking.Resource.Release;

      Ada.Text_Io.Put_Line ("Action One called");
      Show_Event_Data (Event);
      Ada.Text_Io.Put_Line ("Parameters:");
      for I in 1 .. String_List.Length (Parameters) loop
         Ada.Text_Io.Put_Line (Integer'Image (I) & ": " & String_List.Element (Parameters, I));
      end loop;
      
      X_Lib.Tasking.Resource.Seize;
   end Action_One;
 

   procedure Action_Two (W          : in Widget;
                         Event      : in X_Lib.X_Event_Pointer;
                         Params     : in String_List_Conversion.Chars_Ptr_List_Type;
                         Num_Params : access String_List_Conversion.Index_Type) is
      Parameters : String_List.Element_Access_List := String_List_Conversion.To_String_Access_List (Params, Num_Params.all);
   begin
      X_Lib.Tasking.Resource.Release;

      Ada.Text_Io.Put_Line ("Action Two called");
      Show_Event_Data (Event);
      Ada.Text_Io.Put_Line ("Parameters:");
      for I in 1 .. String_List.Length (Parameters) loop
         Ada.Text_Io.Put_Line (Integer'Image (I) & ": " & String_List.Element (Parameters, I));
      end loop;

      X_Lib.Tasking.Resource.Seize;
   end Action_Two;
 
end Actions_Global;
