/**
 * \file insetlabel.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Lars Gullik Bjnnes
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#include "insetlabel.h"
#include "support/LOstream.h"
#include "frontends/Alert.h"
#include "support/lstrings.h" //frontStrip, strip
#include "lyxtext.h"
#include "buffer.h"
#include "gettext.h"
#include "BufferView.h"
#include "support/lstrings.h"

using std::ostream;
using std::vector;
using std::pair;

/* Label. Used to insert a label automatically */


InsetLabel::InsetLabel(InsetCommandParams const & p, bool)
	: InsetCommand(p)
{}


vector<string> const InsetLabel::getLabelList() const
{
	return vector<string>(1, getContents());
}


void InsetLabel::edit(BufferView * bv, int, int, mouse_button::state)
{
	pair<bool, string> result = Alert::askForText(_("Enter label:"), getContents());
	if (result.first) {
		string new_contents = trim(result.second);
		if (!new_contents.empty() &&
		    getContents() != new_contents) {
			bv->buffer()->markDirty();
			bool flag = bv->ChangeRefsIfUnique(getContents(),
							   new_contents);
			setContents(new_contents);
#if 0
			bv->text->redoParagraph(bv);
			if (flag) {
				bv->redraw();
				bv->fitCursor();
			} else
				bv->update(bv->text, BufferView::SELECT|BufferView::FITCUR|BufferView::CHANGE);
#else
			bv->updateInset(this, !flag);
#endif
		}
	}
}


void InsetLabel::edit(BufferView * bv, bool)
{
	edit(bv, 0, 0, mouse_button::none);
}


int InsetLabel::latex(Buffer const *, ostream & os,
		      bool /*fragile*/, bool /*fs*/) const
{
	os << escape(getCommand());
	return 0;
}

int InsetLabel::ascii(Buffer const *, ostream & os, int) const
{
	os << '<' << getContents()  << '>';
	return 0;
}


int InsetLabel::linuxdoc(Buffer const *, ostream & os) const
{
	os << "<label id=\"" << getContents() << "\" >";
	return 0;
}


int InsetLabel::docbook(Buffer const *, ostream & os, bool) const
{
	os << "<anchor id=\"" << getContents() << "\">";
	return 0;
}
