// -*- C++ -*-
/**
 * \file GFloat.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GFLOAT_H
#define GFLOAT_H

#include "ControlFloat.h"
#include "GnomeBase.h"

namespace Gtk {
	class Buttton;
	class CheckButton;
	class RadioButton;
	class HBox;
}

/**
 * This class implements the dialog to modify the LaTeX preamble
 */
class GFloat : public GnomeCB<ControlFloat> {
public:
	///
	GFloat(ControlFloat & c);
	///
	~GFloat();

	void apply();
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	///
	void connect_signals();
	///
	void disconnect_signals();

	/// generated by accessors.py
	Gtk::HBox * other_options() const;
	/// generated by accessors.py
	Gtk::CheckButton * page_of_floats() const;
	/// generated by accessors.py
	Gtk::CheckButton * top_of_page() const;
	/// generated by accessors.py
	Gtk::CheckButton * bottom_of_page() const;
	/// generated by accessors.py
	Gtk::CheckButton * here_if_possible() const;
	/// generated by accessors.py
	Gtk::RadioButton * here_definitely() const;
	/// generated by accessors.py
	Gtk::Button * close_btn() const;
	/// Disable all the uncheckable buttons
	void update_sensitive();

	SigC::Connection conn_top_;
	SigC::Connection conn_bottom_;
	SigC::Connection conn_page_;
	SigC::Connection conn_ifposs_;
	SigC::Connection conn_definitely_;
	SigC::Connection conn_disable_;
};

#endif
