// -*- C++ -*-
/**
 * \file GAbout.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GABOUT_H
#define GABOUT_H

#include "ControlAboutlyx.h"
#include "GnomeBase.h"

namespace Gtk {
	class Button;
	class Label;
	class TextView;
}

/**
 * This class implements the dialog to display the information About LyX
 */
class GAbout : public GnomeCB<ControlAboutlyx> {
public:
	///
	GAbout(ControlAboutlyx & c);
	///
	~GAbout();

	void apply();
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	/// generated by accessors.py
	Gtk::Button * close_btn() const;
	/// generated by accessors.py
	Gtk::Label * version() const;
	/// generated by accessors.py
	Gtk::TextView * credits() const;
	/// generated by accessors.py
	Gtk::TextView * copyright() const;


};

#endif
