/*
 *  xoutput.h
 *	
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 */



#ifndef  XOUTPUT_H_INCLUDED__
#define  XOUTPUT_H_INCLUDED__

#ifdef HAVE_TERMIOS
#define HAVE_TCATTR
#endif

#include <stdarg.h>
#include <stdio.h>
#ifdef HAVE_TERMIO
#ifdef __DGUX
#include <sys/ioctl.h>
#endif
#ifndef NO_TERMIO
#include <termio.h>
#endif
#include <fcntl.h>
#else
#ifdef HAVE_TERMIOS
#include <termios.h>

#include <fcntl.h>
#else /* HAVE_TERMIOS */
#include <sgtty.h>
#endif /* HAVE_TERMIOS */
#endif

#include <s-string.h>


/* On TERMIOS systems, the tcmumbleattr calls take care of these
   parameters, and it's a bad idea to use them (on AIX, it makes the
   tty hang for a long time).  */
#if defined (TIOCGLTC) && !defined (HAVE_TERMIOS)
#define HAVE_LTCHARS
#endif

#if defined (TIOCGETC) && !defined (HAVE_TERMIOS)
#define HAVE_TCHARS
#endif


typedef	enum  {  XO_terminal, XO_file, XO_edited_text  }	XO_type;

/*
 *  STREAM_TYPE tells if the stream is connected to the controlling
 *  terminal (XO_terminal), to a file (XO_file) or to a text the user
 *  is writing (XO_edited_text).  If the stream is connected to the
 *  controlling terminal (i e stdin), the xoutput routines stop when a
 *  screenful of text is written, and wait for the user to read it.
 *  If the stream is connected to a file, then that file is specified
 *  in F_STREAM, and everything is just written on that file.  If the
 *  stream is connected to a text, the 'edit number' of that text is
 *  in TEXT_NO, and everything is appended to the end of that text.
 */

#define XO_EDIT_BUFSIZE		512

typedef	struct {
	XO_type		  stream_type;
	FILE		* f_stream;	/* Normal file */
	int		  text_no;	/* Text you are editing */
	int		  used_buf;	/* Used chars in buffer */
	char		  buffer[XO_EDIT_BUFSIZE]; /* Buffer for text */
} XO_stream;



/* The default stream for output. */
extern  XO_stream	* kom_outstream;

/* Printed lines and current column */
extern	int		  printed_lines;
extern	int		  current_column;
extern  int               charset;

#if defined (HAVE_TERMIO) || defined (HAVE_TERMIOS)
extern  unsigned char	  original_eof_char;
#endif

/* For each tty parameter structure that Emacs might want to save and restore,
   - include an element for it in this structure, and
   - extend the emacs_{get,set}_tty functions in sysdep.c to deal with the
     new members.  */

struct emacs_tty {

/* There is always one of the following elements, so there is no need
   for dummy get and set definitions.  */
#ifdef HAVE_TCATTR
  struct termios main;
#else
#ifdef HAVE_TERMIO
  struct termio main;
#else
#ifdef VMS
  struct sensemode main;
#else
  struct sgttyb main;
#endif
#endif
#endif

/* If we have TERMIOS, we don't need to do this - they're taken care of
   by the tc*attr calls.  */
#ifndef HAVE_TERMIOS
#ifdef HAVE_LTCHARS
  struct ltchars ltchars;
#endif

#ifdef HAVE_TCHARS
  struct tchars tchars;
  int lmode;
#endif
#endif
};

int emacs_set_tty(int fd, struct emacs_tty * settings, int waitp);
int emacs_get_tty(int fd, struct emacs_tty * settings);


/*
 *  Do some initializations for the terminal and XO-output functions.
 */
extern  Success
init_terminal (FILE	* infile,
	       FILE	* outfile);


/*
 *  Restore the terminal settings.
 */
extern  Success
restore_terminal (FILE		* infile,
		  FILE		* outfile);



/*
 * Function to explicitly set the page lenght.
 */
extern Success
set_window_height(int		  n);


/* Print a single character to an XO_stream. */
extern  int
xputc (char	      char_to_print,
       XO_stream    * outstream);


#define xputchar(ch)	xputc (ch, kom_outstream)


/* Print to OUTSTREAM the String STR */
extern  int
s_xfputs (String	  str,
	  XO_stream	* outstream);


#define xfputs(str, outstream)	s_xfputs (s_fcrea_str (str), outstream)
#define xputs(str)		s_xfputs (s_fcrea_str (str), kom_outstream)
#define s_xputs(Str)		s_xfputs (Str, kom_outstream)


/*
 *  Print the argument list ARGS to OUTSTREAM according to the format string
 *  FORMAT.
 */
extern  int
vxfprintf (XO_stream		* outstream,
	   const unsigned char	* format,
	   va_list	  	args	    );

extern  int
xfprintf (XO_stream		* outstream,
	  const unsigned char	* format,
	  ...				 );


extern  int
xprintf (const unsigned char	* format,
	 ...				 );


/*
 *  Flush all pending output to the XO_stream OUTSTREAM.
 */
extern  int
xflush (XO_stream	* outstream);


/*
 *  Move cursor to a specific column.  Moves to that column on the next
 *  line if cursor has passed that column already.  Wraps if specified
 *  column is outside screen.
 */
extern  int
xo_goto_column (int		  column,
		XO_stream	* outstream);


#define goto_column(column)	xo_goto_column ((column), kom_outstream)

extern String *theprompt;
#endif  /*  XOUTPUT_H_INCLUDED__  */
