/*
 *  copy.c
 *	Functions to copy and free the data structures used by LysKOM.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#include <config.h>

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include <kom-types.h>
#ifdef __vax__
#define __SIZE_T included from string.h
#endif
#include <zmalloc.h>
#include <s-string.h>

#include "copy.h"

#define Export



/* Person */
Export  Person *
mark_person (Person	* pers)
{
    (void) s_mark (&pers->username);
    return  pers;
}

Export  Person *
release_person (Person	* pers)
{
    if (pers == NULL)
	return  pers;
    (void) s_release (&(pers->username));
    return  pers;
}


/* Conference */
Export  Conference *
mark_conf (Conference	* conf)
{
    (void) s_mark (&conf->name);
    return  conf;
}

Export  Conference *
release_conf (Conference	* conf)
{
    if (conf == NULL)
	return  conf;
    (void) s_release (&(conf->name));
    return  conf;
}



/* Misc_info */
Export  Misc_info *
mark_misc_list (Misc_info	* list,
		int		  length)
{
    while (--length >= 0)
	/* Do nothing on list[length] */    ;
    return  list;
}

Export  Misc_info *
release_misc_list (Misc_info	* list,
		   int		  length)
{
    if (list == NULL)
	return  list;
    while (--length >= 0)
	;
    return  list;
}


/* Text_stat */
Export  Text_stat *
mark_text_stat (Text_stat	* text)
{
    mark_misc_list (text->misc_items, text->no_of_misc);
    return  text;
}

Export  Text_stat *
release_text_stat (Text_stat	* text)
{
    if (text == NULL)
	return  text;
    zfree (release_misc_list (text->misc_items, text->no_of_misc));
    return  text;
}


/* Membership */
Export  Membership *
mark_membership (Membership	* memb)
{
    zuse (memb->read_texts);
    return  memb;
}

Export  Membership *
release_membership (Membership	* memb)
{
    if (memb == NULL)
	return  memb;
    if (memb->read_texts != NULL)
    {
        zfree (memb->read_texts);
	memb->read_texts = NULL;
    }
    return  memb;
}


/* Mark_list */
Export  Mark_list *
mark_mark_list (Mark_list	* marks)
{
    unsigned short	  i;

    for (i = 0 ;  i < marks->no_of_marks ;  i++)
	/* Do nothing */    ;
    zuse (marks->marks);
    return  marks;
}

Export  Mark_list *
release_mark_list (Mark_list	* marks)
{
    unsigned short	  i;

    if (marks == NULL)
	return  marks;
    for (i = 0 ;  i < marks->no_of_marks ;  i++)
	;
    zfree (marks->marks);
    return  marks;
}


/* Conf_no_list */
Export  Conf_no_list *
release_conf_no_list (Conf_no_list * list)
{
    if (list == NULL)
	return  list;
    zfree (list->conf_nos);
    return list;
}
  

/* Member_list */
Export  Member_list *
mark_member_list (Member_list	* membs)
{
    zuse (membs->members);
    return  membs;
}

Export  Member_list *
release_member_list (Member_list	* membs)
{
    if (membs == NULL)
	return  membs;
    zfree (membs->members);
    return  membs;
}


/* Text_list */
Export  Text_list *
mark_text_list (Text_list	* texts)
{
    zuse (texts->texts);
    return  texts;
}

Export  Text_list *
release_text_list (Text_list	* texts)
{
    if (texts == NULL || texts->texts == NULL)
	return  texts;
    zfree (texts->texts);
    return  texts;
}


/* Membership_list */
Export  Membership_list *
mark_membership_list (Membership_list	* membships)
{
    unsigned short	  i;

    for (i = 0 ;  i < membships->no_of_confs ;  i++)
	zuse (membships->confs[i].read_texts);
    zuse (membships->confs);
    return  membships;
}

Export  Membership_list *
release_membership_list (Membership_list	* membships)
{
    unsigned short	  i;

    if (membships == NULL)
	return  membships;
    for (i = 0; i < membships->no_of_confs;  i++)
    {
	release_membership (&membships->confs[i]);
    }
    zfree (membships->confs);
    return  membships;
}


/* Info */
Export  Info *
mark_info (Info	    * info)
{
    return  info;
}

Export  Info *
release_info (Info	* info)
{
    return  info;
}


/* Who_info */
Export  Who_info *
release_who_info (Who_info	* info)
{
    if (info == NULL)
	return info;
    (void) s_release (& (info->what_am_i_doing));
    (void) s_release (& (info->username));
    return  info;
}


/* Conf_z_info */
Export  Conf_z_info *
mark_conf_z_info(Conf_z_info * info)
{
    if (info == NULL)
	return info;
    (void) s_mark(&(info->name));
    return info;
}

Export  Conf_z_info *
release_conf_z_info(Conf_z_info * info)
{
    if (info == NULL)
	return info;
    (void) s_release(&(info->name));
    return info;
}

Export  void
copy_conf_z_info(Conf_z_info * target, Conf_z_info * source)
{
    *target = *source;
    mark_conf_z_info(target);
}



/* Conf_z_info_list */
Export  Conf_z_info_list *
mark_conf_z_info_list(Conf_z_info_list * list)
{
    int i;

    if (list == NULL || list->confs == NULL)
	return list;
    for (i = 0; i < list->no_of_confs; i++)
    {
	mark_conf_z_info(&(list->confs[i]));
    }
    zuse(list->confs);
    return list;
}

Export  Conf_z_info_list *
release_conf_z_info_list(Conf_z_info_list * list)
{
    int i;

    if (list == NULL || list->confs == NULL)
	return list;
    for (i = 0; i < list->no_of_confs; i++)
    {
	release_conf_z_info(&(list->confs[i]));
    }
    zfree(list->confs);
    return list;
}




/* Dynamic_session_info */
Export Dynamic_session_info *
mark_dynamic_session_info(Dynamic_session_info * info)
{
    if (info == NULL)
	return info;
    (void) s_mark(&(info->what_am_i_doing));
    return info;
}

Export Dynamic_session_info *
release_dynamic_session_info(Dynamic_session_info * info)
{
    if (info == NULL)
	return info;
    (void) s_release(&(info->what_am_i_doing));
    return info;
}



/* Dynamic_session_info_list */
Export Dynamic_session_info_list *
mark_dynamic_session_info_list(Dynamic_session_info_list * list)
{
    int i;

    if (list == NULL || list->sessions == NULL)
	return list;

    for (i = 0; i < list->no_of_sessions; i++)
    {
	mark_dynamic_session_info(&(list->sessions[i]));
    }
    zuse(list->sessions);
    return list;
}

Export Dynamic_session_info_list *
release_dynamic_session_info_list(Dynamic_session_info_list * list)
{
    int i;

    if (list == NULL || list->sessions == NULL)
	return list;

    for (i = 0; i < list->no_of_sessions; i++)
    {
	release_dynamic_session_info(&(list->sessions[i]));
    }
    zfree(list->sessions);
    return list;
}


/* Static_session_info */
Export Static_session_info *
mark_static_session_info(Static_session_info * info)
{
    if (info == NULL)
	return info;
    (void) s_mark(&(info->username));
    (void) s_mark(&(info->hostname));
    (void) s_mark(&(info->ident_user));
    return info;
}

Export Static_session_info *
release_static_session_info(Static_session_info * info)
{
    if (info == NULL)
	return info;
    (void) s_release(&(info->username));
    (void) s_release(&(info->hostname));
    (void) s_release(&(info->ident_user));
    return info;
}
