CREATE DATABASE lyricDb;

USE lyricDb;

--
-- Table structure for table `associations`
--

CREATE TABLE associations (
  id INTEGER auto_increment,
  playlist INTEGER NOT NULL default '0',
  imagename varchar(255) NOT NULL default '',
  absoluteparent INTEGER NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Table structure for table `audit`
--

CREATE TABLE audit (
  id INTEGER auto_increment,
  songid INTEGER NOT NULL default '0',
  playdate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Table structure for table `lyricMain`
--

CREATE TABLE lyricMain (
  id INTEGER auto_increment,
  title varchar(100) NOT NULL default '',
  songnum INTEGER default '0',
  book varchar(100) default '',
  artist varchar(100) default '',
  written timestamp(14) NOT NULL default '00000000000000',
  keywords text,
  entered timestamp(14) NOT NULL default '00000000000000',
  copyright varchar(100) default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `lyricMain`
--

INSERT INTO lyricMain VALUES (385,'Joy to the world',105,'The Hymnal','Isaac Watts and George F. Handel',20031220153506,'',00000000000000,'');
INSERT INTO lyricMain VALUES (373,'Praise to the Lord, the Almighty',8,'The Hymnal','Lobe Den Herren',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (3,'Amazing Grace',0,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (9,'Joyful, Joyful we adore thee',1,'The Hymnal','Henry Van Dyke',20040307192037,'joyful adore the god glory lord love we thee',00000000000000,'');
INSERT INTO lyricMain VALUES (8,'Rejoice! Rejoice!',614,'','',20011111183604,'rejoice christ in you',00000000000000,'');
INSERT INTO lyricMain VALUES (10,'The Solid Rock',0,'','',20011118103223,'',00000000000000,'');
INSERT INTO lyricMain VALUES (11,'He has made me glad (I will enter His gates)',0,'','Leona Von Brethorst',20031116180147,'',00000000000000,'1976 Maranatha Praise');
INSERT INTO lyricMain VALUES (13,'Beautiful',5,'Elevate','Lucas Parry',20011118191716,'',00000000000000,'');
INSERT INTO lyricMain VALUES (14,'Adore',6,'Elevate','Sebastian Buffa',20011118191732,'',00000000000000,'');
INSERT INTO lyricMain VALUES (18,'God is in the house',0,'Hillsongs','Russel Fragar and Darlene Zschech',20011118191603,'',00000000000000,'');
INSERT INTO lyricMain VALUES (20,'This is my desire (Lord I give You my heart)',0,'Hillsongs','Reuben Morgan',20030510224259,'give you my heart',00000000000000,'1995 Reuben Morgan');
INSERT INTO lyricMain VALUES (78,'Glory',14,'Hillsongs: the music','Geoff Bullock',20030510223456,'',00000000000000,'1990 Geoff Bullock');
INSERT INTO lyricMain VALUES (23,'The stone\'s been rolled away',0,'','Geoff Bullock',20030510231249,'',00000000000000,'1992 Word Inc');
INSERT INTO lyricMain VALUES (22,'My Redeemer Lives',0,'','Reuben Morgan',20030510225323,'',00000000000000,'1998 Hillsong Music Australia');
INSERT INTO lyricMain VALUES (25,'You give me Shelter',0,'','Geoff Bullock',20030510232503,'',00000000000000,'1992 Word Inc');
INSERT INTO lyricMain VALUES (27,'I Believe',0,'','Geoff Bullock',20030510224002,'',00000000000000,'1993 Word Inc');
INSERT INTO lyricMain VALUES (28,'Put on the garment of praise',0,'','',20011125093751,'',00000000000000,'');
INSERT INTO lyricMain VALUES (32,'Because He Lives',0,'','',20011125100113,'',00000000000000,'');
INSERT INTO lyricMain VALUES (31,'Give Thanks',509,'','Henry Smith',20031109194848,'',00000000000000,'1978 Integrity\'s Hosanna! Music');
INSERT INTO lyricMain VALUES (33,'The Servant King',0,'','',20011125101127,'',00000000000000,'');
INSERT INTO lyricMain VALUES (34,'Hallelujah! Our God reigns',102,'S in S','Dale Garratt',20011202173436,'',00000000000000,'');
INSERT INTO lyricMain VALUES (35,'He is exalted',518,'S in S','Twila Paris',20011202174211,'',00000000000000,'');
INSERT INTO lyricMain VALUES (36,'Ascribe greatness',461,'S in S','',20011202174456,'',00000000000000,'');
INSERT INTO lyricMain VALUES (37,'The Lord reigns',342,'S in S','',20011202175646,'',00000000000000,'');
INSERT INTO lyricMain VALUES (38,'Blessed be the Lord God almighty',472,'S in S','',20030810091343,'',00000000000000,'');
INSERT INTO lyricMain VALUES (39,'Doxology',343,'S in S','',20020113103411,'',00000000000000,'');
INSERT INTO lyricMain VALUES (41,'Great are your works',0,'','Andy Park',20011202181554,'',00000000000000,'');
INSERT INTO lyricMain VALUES (54,'Silent Night',0,'','',20011223165720,'',00000000000000,'');
INSERT INTO lyricMain VALUES (43,'Make Me Your Servant',0,'Hillsongs','Russell Fragar',20011209174759,'servant',00000000000000,'');
INSERT INTO lyricMain VALUES (44,'Jesus Lover of my Soul',0,'Hillsongs','Daniel Grul & John Ezzy',20011209175018,'',00000000000000,'');
INSERT INTO lyricMain VALUES (226,'Today\'s Announcements',0,'','',20020421185546,'',00000000000000,'');
INSERT INTO lyricMain VALUES (47,'Angels we have heard on high (In excelsis deo)',111,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (49,'Come and join the celebration',0,'','',20011216185327,'',00000000000000,'');
INSERT INTO lyricMain VALUES (48,'Hark! the herald angels sing',0,'','',20011216183648,'',00000000000000,'');
INSERT INTO lyricMain VALUES (50,'O Come all ye faithful',0,'','',20011216191028,'',00000000000000,'');
INSERT INTO lyricMain VALUES (51,'He is the king of kings',0,'','',20011216191145,'',00000000000000,'');
INSERT INTO lyricMain VALUES (52,'The heavens shall declare',0,'','Geoff Bullock',20031116184151,'',00000000000000,'1990 Word Music Inc');
INSERT INTO lyricMain VALUES (53,'The First Noel',124,'The Hymnal','',20040307192037,'noel',00000000000000,'');
INSERT INTO lyricMain VALUES (56,'Merry Christmas',0,'','',20011223182107,'',00000000000000,'');
INSERT INTO lyricMain VALUES (55,'It came upon the midnight clear',0,'','',20011223174450,'',00000000000000,'');
INSERT INTO lyricMain VALUES (2147483647,'Away in a manger',0,'','',20011223175802,'',00000000000000,'');
INSERT INTO lyricMain VALUES (57,'While Shepherds Watched',0,'','',20011223183109,'',00000000000000,'');
INSERT INTO lyricMain VALUES (58,'As with Gladness Men of Old',0,'','',20011223183137,'',00000000000000,'');
INSERT INTO lyricMain VALUES (59,'Jesus stand Among us',0,'','',20011230093046,'',00000000000000,'');
INSERT INTO lyricMain VALUES (114,'Everybody ought to know',0,'','R. J. Hughes',20020127093034,'',00000000000000,'');
INSERT INTO lyricMain VALUES (60,'I will sing of the mercies of the lord',0,'','',20011230093325,'',00000000000000,'');
INSERT INTO lyricMain VALUES (61,'Behold what manner of love',316,'S in S','',20020113103355,'behold manner love sons god',00000000000000,'');
INSERT INTO lyricMain VALUES (62,'Now unto him',0,'','',20011230101843,'',00000000000000,'');
INSERT INTO lyricMain VALUES (63,'He is Lord',49,'S in S','Artist Unknown',20030511000406,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (64,'Blessing, Honour',0,'','Geoff Bullock and David Reidy',20020721175653,'',00000000000000,'');
INSERT INTO lyricMain VALUES (65,'The Lord thy God in the midst',103,'S in S','Tapu Moala',20011230174534,'',00000000000000,'');
INSERT INTO lyricMain VALUES (67,'The Lord Liveth',635,'S in S','Michael O\'Shields',20011230175725,'',00000000000000,'');
INSERT INTO lyricMain VALUES (66,'Make Way',587,'S in S','Graham Kendrick',20011230174918,'',00000000000000,'');
INSERT INTO lyricMain VALUES (68,'For I\'m Building a People of Power',262,'S in S','Dave Richards',20011230175955,'',00000000000000,'');
INSERT INTO lyricMain VALUES (69,'I will rejoice',556,'S in S','Brent Chambers',20011230180403,'',00000000000000,'');
INSERT INTO lyricMain VALUES (70,'Lord, for the years',0,'','Timothy Dudley-Smith',20011230183809,'',00000000000000,'');
INSERT INTO lyricMain VALUES (71,'Blessed Assurance',687,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (72,'All for Jesus',0,'','',20020106092327,'',00000000000000,'');
INSERT INTO lyricMain VALUES (105,'My Lord knows the way',10,'','Sidney E. Cox',20020120101759,'',00000000000000,'');
INSERT INTO lyricMain VALUES (75,'Love the Lord your God',0,'S in S','',20020113103336,'',00000000000000,'');
INSERT INTO lyricMain VALUES (74,'Ancient of days',0,'S in S','Gary Sadler and Jamie Harvill',20020113103347,'every ancient',00000000000000,'');
INSERT INTO lyricMain VALUES (76,'Lord I lift your name on high',0,'','Rick Founds',20030510225140,'',00000000000000,'1989 Maranatha Music');
INSERT INTO lyricMain VALUES (113,'The Price is paid',640,'','Graham Kendrick',20020127092637,'',00000000000000,'');
INSERT INTO lyricMain VALUES (77,'Lord of the Heavens',13,'God Is In The house','Lucy Fisher',20030510225222,'',00000000000000,'1996 Hillsongs Australia');
INSERT INTO lyricMain VALUES (79,'Thou are the everlasting word',242,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (80,'To God be the glory',741,'The Hymnal','William H. Doane, Fanny J. Crosby',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (82,'I will sing, I will sing',254,'S in S','Max Dyer',20020113092728,'',00000000000000,'');
INSERT INTO lyricMain VALUES (83,'Glory to the king',0,'S in S','Darlene Zschech',20020113093240,'',00000000000000,'');
INSERT INTO lyricMain VALUES (84,'Thank You, Lord',378,'S in S','Diane Davis Andrew',20020113094242,'',00000000000000,'');
INSERT INTO lyricMain VALUES (85,'Turn your eyes upon Jesus',34,'S in S','Helen Lemmel',20031116184830,'',00000000000000,'1922 Singspiration Music');
INSERT INTO lyricMain VALUES (86,'I know a fount',15,'','O. Cooke Lewisham',20020113100411,'',00000000000000,'');
INSERT INTO lyricMain VALUES (87,'Oh, how I love Him',16,'','Carl Blackmore',20020113101215,'',00000000000000,'');
INSERT INTO lyricMain VALUES (91,'I will run to You',15,'God Is In The House','Darlene Zschech',20030510224717,'',00000000000000,'1996 Hillsongs Australia');
INSERT INTO lyricMain VALUES (88,'I will sing, I will sing',254,'S in S','Max Dyer',20020113174204,'',00000000000000,'');
INSERT INTO lyricMain VALUES (89,'Glory Jesus Glory',251,'S in S','Susie Wilson',20020113174329,'',00000000000000,'');
INSERT INTO lyricMain VALUES (90,'Your hand O God has Guided',0,'','',20020113174428,'',00000000000000,'');
INSERT INTO lyricMain VALUES (92,'Your People Sing Praises',10,'God Is In The House','Russell Fragar',20030510233011,'',00000000000000,'1995 Hillsongs Australia');
INSERT INTO lyricMain VALUES (93,'Let the peace of God reign',7,'God Is In The House','Dalene Zschech\n',20020113175234,'',00000000000000,'');
INSERT INTO lyricMain VALUES (94,'Jesus, What a beautiful name',6,'God Is In The House','Tanya Riches',20030510224905,'',00000000000000,'1995 Hillsongs Australia');
INSERT INTO lyricMain VALUES (95,'And that my soul knows very well',5,'God Is In The House','Darlene Zschech and Russel Fragar',20020113175435,'',00000000000000,'');
INSERT INTO lyricMain VALUES (96,'My heart Sings Praises',4,'God Is In The House','Russell Fragar',20020113175547,'',00000000000000,'');
INSERT INTO lyricMain VALUES (97,'Steppin\' out',3,'God Is In The House','Steve McPherson',20020113175634,'',00000000000000,'');
INSERT INTO lyricMain VALUES (98,'Joy in the Holy Ghost',2,'God Is In The House','Russell Fragar',20030510224938,'',00000000000000,'1996 Hillsongs Australia');
INSERT INTO lyricMain VALUES (99,'Amazing Love (My Lord, what love is this)',370,'The Source','Graham Kendrick',20030504091856,'',00000000000000,'1989 Make Way Music');
INSERT INTO lyricMain VALUES (100,'Beauty for Ashes',144,'','',20020120090905,'',00000000000000,'');
INSERT INTO lyricMain VALUES (101,'Praise my soul',17,'The Hymnal','John Goss and Henry F. Lyte',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (102,'Take my life, And let it be',510,'The Hymnal','Frances Ridley Havergal',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (103,'Guide me, O thou great Jehovah,',540,'The Hymnal','Wiliam Wiliams, John Hughes',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (104,'The Son of God goes forth to war,',525,'The Hymnal','Reginald Heber, Henry S. Cutler',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (106,'I\'n in the Lord\'s Army',31,'','Anonymous. Copyright held by Zondervan Music Publishers',20020120102247,'',00000000000000,'');
INSERT INTO lyricMain VALUES (107,'Every day with Jesus',71,'','Wendell P. Loveless',20020120102623,'',00000000000000,'');
INSERT INTO lyricMain VALUES (108,'I shall not be moved',6,'Singing Joy','John T. Benson and Mrs. Jas. A. Pate',20020120103238,'',00000000000000,'');
INSERT INTO lyricMain VALUES (109,'Have faith in God',0,'','Geoff Bullock',20020728104248,'',00000000000000,'');
INSERT INTO lyricMain VALUES (110,'Blessed be the rock',473,'S in S','Dan Gardner',20020120174515,'blessed rock',00000000000000,'');
INSERT INTO lyricMain VALUES (111,'Don\'t you know that I formed you',496,'S in S','David Garratt and Wayne Drain',20020120174804,'',00000000000000,'');
INSERT INTO lyricMain VALUES (112,'Question',0,'','',20031012185905,'',00000000000000,'');
INSERT INTO lyricMain VALUES (118,'One Day',1,'For This Cause','Reuben Morgan',20020331185428,'blessed enough',00000000000000,'');
INSERT INTO lyricMain VALUES (116,'All the Earth shall Worship',457,'S in S','Carl Tuttle',20020127180611,'worship',00000000000000,'');
INSERT INTO lyricMain VALUES (115,'Jesus put this song into our hearts',569,'S in S','',20020127102303,'',00000000000000,'');
INSERT INTO lyricMain VALUES (117,'I will lift my voice',0,'Geoff Bullock 2','Geoff Bullock',20030510224626,'lift voice king lord worship',00000000000000,'1989 Nightlight Music');
INSERT INTO lyricMain VALUES (123,'Surrender',0,'','Marc James',20020202170248,'',00000000000000,'');
INSERT INTO lyricMain VALUES (119,'Faith',2,'For This Cause','Reuben Morgan',20020417115600,'Faith standing greater world',00000000000000,'');
INSERT INTO lyricMain VALUES (121,'It makes me wanna sing',0,'','Jay VanDer Noord',20020202165057,'',00000000000000,'');
INSERT INTO lyricMain VALUES (133,'Here is bread',0,'','Graham Kendrick',20030510223649,'',00000000000000,'1992 Make Way Music');
INSERT INTO lyricMain VALUES (122,'Stronger than',0,'','',20020202165635,'',00000000000000,'');
INSERT INTO lyricMain VALUES (124,'Your love oh Lord',0,'','',20020202170556,'',00000000000000,'');
INSERT INTO lyricMain VALUES (125,'You are my world',0,'','',20020202171200,'',00000000000000,'');
INSERT INTO lyricMain VALUES (135,'Shout to the Lord',0,'People Just Like Us','Darlene Zschesh',20030510230505,'',00000000000000,'1993 Hillsongs Australia');
INSERT INTO lyricMain VALUES (156,'Your grace and your mercy',103,'Geoff Bullock 2','Geoff Bullock',20040725094903,'',00000000000000,'1997 Watershed Productions');
INSERT INTO lyricMain VALUES (134,'Father of Lights',0,'People Just Like Us','Russell Fragar',20020203175557,'',00000000000000,'');
INSERT INTO lyricMain VALUES (129,'Awesome in this place',3,'For This Cause','Ned Davies',20031109194037,'',00000000000000,'1999 Ned Davies (Hillsong)');
INSERT INTO lyricMain VALUES (130,'Dwell in Your House',4,'For This Cause','Paul Ewing',20020331183951,'',00000000000000,'');
INSERT INTO lyricMain VALUES (131,'As the Deer',0,'The Hymnal','Martin J. Nystrom',20040307192037,'',00000000000000,'1984 Maranatha Praise, Inc');
INSERT INTO lyricMain VALUES (132,'At the Name of Jesus',191,'The Hymnal','Jimbo Stevens',20040307192037,'',00000000000000,'1989 New Spring Publishing');
INSERT INTO lyricMain VALUES (136,'Your love keeps following me',0,'People Just Like Us','Russell Fragar',20030510232936,'',00000000000000,'1993 Hillsongs Australia');
INSERT INTO lyricMain VALUES (137,'Just let me say',0,'People Just Like Us','Geoff Bullock',20020203182118,'',00000000000000,'');
INSERT INTO lyricMain VALUES (138,'Power and the Glory',0,'People Just Like Us','Geoff Bullock',20030510231042,'',00000000000000,'1993 Word Music');
INSERT INTO lyricMain VALUES (142,'God is great',0,'','Marty Sampson',20020209170817,'',00000000000000,'');
INSERT INTO lyricMain VALUES (141,'Holy Moment',0,'','Mat Redmond',20020209165408,'',00000000000000,'');
INSERT INTO lyricMain VALUES (143,'For This Cause',0,'For This Cause','',20020209172410,'',00000000000000,'');
INSERT INTO lyricMain VALUES (448,'The King of love',85,'The Hymnal','Sir Henry W. Baker & John B. Dykes',20030302091313,'',00000000000000,'');
INSERT INTO lyricMain VALUES (145,'Deeply In love',0,'','',20020209173153,'',00000000000000,'');
INSERT INTO lyricMain VALUES (184,'I will praise you',0,'Access all Areas','Jamin and Ryan Day',20020616181425,'',00000000000000,'');
INSERT INTO lyricMain VALUES (147,'The Celebration Song',361,'S in S','Brent Chambers',20020210091555,'',00000000000000,'');
INSERT INTO lyricMain VALUES (148,'Jesus is Lord',360,'S in S','David J. Mansell',20020210091914,'',00000000000000,'');
INSERT INTO lyricMain VALUES (155,'We are a people of power',652,'S in S','Trevor King',20020217173716,'',00000000000000,'');
INSERT INTO lyricMain VALUES (149,'Holy, Holy, Holy, Holy',94,'S in S','',20020331184029,'',00000000000000,'');
INSERT INTO lyricMain VALUES (150,'Holy, Holy, Holy',60,'The Hymnal','John B. Dykes',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (190,'Teach me to dance',0,'','',20020317093254,'',00000000000000,'');
INSERT INTO lyricMain VALUES (153,'Master speak, thy servant heareth',441,'The Hymnal','Lowell Mason',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (154,'This kingdom',0,'','Geoff Bullock',20030510231203,'',00000000000000,'1995 Word Music');
INSERT INTO lyricMain VALUES (191,'Power of your love',0,'','Geoff Bullock',20030510231120,'',00000000000000,'1990 Hillsongs Australia');
INSERT INTO lyricMain VALUES (158,'What a Friend I\'ve found',0,'','',20020216183547,'',00000000000000,'');
INSERT INTO lyricMain VALUES (157,'Steve\'s quotes of the day',0,'','',20020210192313,'',00000000000000,'');
INSERT INTO lyricMain VALUES (159,'Forever',0,'','',20020216183702,'',00000000000000,'');
INSERT INTO lyricMain VALUES (162,'Father, I thank you',269,'S in S','Steve Stewart',20020331184003,'',00000000000000,'');
INSERT INTO lyricMain VALUES (160,'All of creation',0,'','',20020216184718,'',00000000000000,'');
INSERT INTO lyricMain VALUES (161,'All I need is You',0,'','',20020216185639,'',00000000000000,'');
INSERT INTO lyricMain VALUES (163,'Love divine, all loves excelling',496,'The Hymnal','Charles Wesley and John Zundel',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (164,'Standing on the promises',690,'The Hymnal','R. Kelso Carter',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (165,'There is a redeemer',644,'S in S','Melody Green',20020330181901,'',00000000000000,'');
INSERT INTO lyricMain VALUES (166,'Will your anchor hold?',714,'The Hymnal','Priscilla J. Owens and William J. Kirkpatrick',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (167,'Trust and Obey',711,'The Hymnal','John H. Sammis and Daniel B. Towner',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (168,'The Lords Prayer',0,'','',20020217104243,'',00000000000000,'');
INSERT INTO lyricMain VALUES (169,'Hosanna',538,'S in S','Carl Tuttle',20020217180104,'',00000000000000,'');
INSERT INTO lyricMain VALUES (171,'I Found Love',0,'','',20020302183322,'',00000000000000,'');
INSERT INTO lyricMain VALUES (170,'We believe',654,'S in S','Graham Kendrick',20020217180455,'',00000000000000,'');
INSERT INTO lyricMain VALUES (172,'Heart of worship',0,'','',20020607200356,'all about you',00000000000000,'');
INSERT INTO lyricMain VALUES (173,'I Cannot Tell',185,'The Hymnal','William Young Fullerton and Arr. Frederic C. Silvester\n',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (174,'Count Your blessings',723,'The Hymnal','Johnson Oatman Jr and Edwin O. Excell',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (183,'King of majesty',0,'United Live','Marty Sampson',20020316173520,'',00000000000000,'');
INSERT INTO lyricMain VALUES (175,'Alleluia, Alleluia, give thanks to the risen Lord.',0,'','',20020331183919,'',00000000000000,'');
INSERT INTO lyricMain VALUES (176,'I, the Lord of Sea and Sky',0,'','',20020331184017,'',00000000000000,'');
INSERT INTO lyricMain VALUES (177,'This is the day that the Lord has made',40,'S in S','Les Garrett',20030504170805,'',00000000000000,'1967, 1980 Scripture in Song');
INSERT INTO lyricMain VALUES (185,'Let Your presence fall',0,'','David Willersdorf',20020316174428,'',00000000000000,'');
INSERT INTO lyricMain VALUES (182,'This is how we overcome',0,'By Your Side','Reuben Morgan',20020316173235,'',00000000000000,'');
INSERT INTO lyricMain VALUES (181,'Hallelujah!',0,'','',20020310102804,'',00000000000000,'');
INSERT INTO lyricMain VALUES (186,'Open the Eyes of My Heart',0,'','Paul Baloche',20020316174805,'',00000000000000,'');
INSERT INTO lyricMain VALUES (187,'You are near',0,'','Reuben Morgan',20020316175116,'',00000000000000,'');
INSERT INTO lyricMain VALUES (189,'Come let us join',206,'The Hymnal','Henry Lahee',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (192,'King of My Life',666,'The Hymnal','Jennie Evelyn Hussey',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (193,'Holy Ground',528,'S in S','Chris Beatty',20031116180543,'',00000000000000,'1982 Birdwing Music');
INSERT INTO lyricMain VALUES (194,'come and see',0,'','',20020329085920,'',00000000000000,'');
INSERT INTO lyricMain VALUES (195,'When I survey the wondrous cross',154,'The Hymnal','Isaac Watts',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (197,'One80 Announcements',0,'','',20030126175250,'',00000000000000,'');
INSERT INTO lyricMain VALUES (198,'Worthy is the Lamb',0,'','Darlene Zchech',20020330172034,'',00000000000000,'');
INSERT INTO lyricMain VALUES (199,'Everyday',0,'God is in the house','',20020519193031,'',00000000000000,'');
INSERT INTO lyricMain VALUES (200,'Hallelujah (Your Love is Amazing)',0,'','',20020330173547,'',00000000000000,'');
INSERT INTO lyricMain VALUES (260,'Victory Song',320,'S in S','Dale Garratt',20020526180710,'victory praise',00000000000000,'');
INSERT INTO lyricMain VALUES (204,'Christ is risen hallelujah',164,'The Hymnal','John S. B. Monsell',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (205,'Thine is the glory',169,'The Hymnal','',20030330090906,'',00000000000000,'');
INSERT INTO lyricMain VALUES (208,'I Just want to love',0,'','',20020406203659,'',00000000000000,'');
INSERT INTO lyricMain VALUES (206,'Christ is Risen',0,'','',20020331105009,'',00000000000000,'');
INSERT INTO lyricMain VALUES (207,'Because He Lives',0,'','William J Gaither',20020331105845,'',00000000000000,'');
INSERT INTO lyricMain VALUES (209,'Let everything that has breath',0,'','',20020406183024,'',00000000000000,'');
INSERT INTO lyricMain VALUES (210,'Lord You have my heart',0,'','',20020406183726,'',00000000000000,'');
INSERT INTO lyricMain VALUES (212,'I\'ve found Jesus',0,'','',20020406184807,'',00000000000000,'');
INSERT INTO lyricMain VALUES (213,'I will sing',0,'','',20020406190958,'',00000000000000,'');
INSERT INTO lyricMain VALUES (214,'God is our Strength and Refuge',0,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (215,'Praise the name of Jesus',11,'S in S','',20040725094929,'',00000000000000,'');
INSERT INTO lyricMain VALUES (216,'We\'re not looking back',0,'','Geoff Bullock',20030510231612,'',00000000000000,'1988');
INSERT INTO lyricMain VALUES (217,'The Great South Land',0,'','Geoff Bullock',20031116184133,'',00000000000000,'1993 Maranatha! Music Australia');
INSERT INTO lyricMain VALUES (218,'They that wait',0,'','',20020413163405,'',00000000000000,'');
INSERT INTO lyricMain VALUES (219,'I want to know you',0,'','',20020413165157,'',00000000000000,'');
INSERT INTO lyricMain VALUES (220,'U R Y',0,'','',20020413170943,'',00000000000000,'');
INSERT INTO lyricMain VALUES (466,'My tribute (To God be the glory)',76,'S in S','Andrae Crouch',20031116181823,'',00000000000000,'1971 Bud John Songs Inc');
INSERT INTO lyricMain VALUES (259,'Come let us sing for joy',488,'S in S','Brent Chambers',20020526180359,'joy lord thanksgiving',00000000000000,'');
INSERT INTO lyricMain VALUES (224,'O Happy Day!',387,'','Words: Phillip Doddridge (altered) Music: Ron Jones',20020421093349,'',00000000000000,'');
INSERT INTO lyricMain VALUES (223,'Be still for the Presence',252,'','David Evans',20020421092430,'',00000000000000,'');
INSERT INTO lyricMain VALUES (228,'All to Jesus I surrender',378,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (225,'Sermon - Parables about the Kingdom',0,'sermons','',20040307192527,'',00000000000000,'');
INSERT INTO lyricMain VALUES (227,'Crown Him with many crowns',180,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (229,'Who is on the Lord\'s side?',750,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (230,'My Jesus, I love Thee',443,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (231,'Give me a sight, O Saviour',415,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (232,'It\'s You',0,'','',20020504165554,'',00000000000000,'');
INSERT INTO lyricMain VALUES (233,'Let my words be few',0,'','',20020504170422,'',00000000000000,'');
INSERT INTO lyricMain VALUES (234,'Hallelujah',0,'','',20020504170902,'',00000000000000,'');
INSERT INTO lyricMain VALUES (235,'I wanna sing',0,'','',20020504171215,'',00000000000000,'');
INSERT INTO lyricMain VALUES (236,'Give back to You',0,'','',20020504182357,'',00000000000000,'');
INSERT INTO lyricMain VALUES (237,'Come and fill me up',0,'','',20020504182930,'',00000000000000,'');
INSERT INTO lyricMain VALUES (238,'Eagles wings',0,'','',20020504183218,'',00000000000000,'');
INSERT INTO lyricMain VALUES (239,'More Love, More Power',0,'','',20020504183437,'',00000000000000,'');
INSERT INTO lyricMain VALUES (240,'Exalt the Lord Our God',497,'S in S','',20020505183557,'',00000000000000,'');
INSERT INTO lyricMain VALUES (241,'Majesty',206,'S in S','',20020505184122,'',00000000000000,'');
INSERT INTO lyricMain VALUES (242,'Trading my sorrows',0,'','',20020511185719,'',00000000000000,'');
INSERT INTO lyricMain VALUES (243,'I love you lord',0,'','',20020511190605,'',00000000000000,'');
INSERT INTO lyricMain VALUES (245,'Shine Jesus Shine',580,'S in S','Graham Kendrick',20031116182730,'',00000000000000,'1987 Make Way Music');
INSERT INTO lyricMain VALUES (244,'Here I am to worship',0,'','Tim Hughes',20020511192415,'',00000000000000,'');
INSERT INTO lyricMain VALUES (246,'Father of all things',275,'S in S','Lyn & Neil Riley',20031109194553,'',00000000000000,'1979,1980 Scripture in Song');
INSERT INTO lyricMain VALUES (247,'O worship the king',31,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (257,'My life is in You,Lord',120,'','Daniel Gards',20020519092959,'',00000000000000,'');
INSERT INTO lyricMain VALUES (248,'You Placed Your Love',0,'Hillsongs','Geoff Bullock',20030510232432,'',00000000000000,'1990 Hillsongs Australia');
INSERT INTO lyricMain VALUES (250,'Once again',0,'','Matt Redmond',20020518201506,'',00000000000000,'');
INSERT INTO lyricMain VALUES (251,'History Maker',0,'Curious Music','Martin Smith',20020518201130,'',00000000000000,'');
INSERT INTO lyricMain VALUES (252,'All day',1,'Elevate','Marty Sampson',20021103002039,'don\'t care dont',00000000000000,'');
INSERT INTO lyricMain VALUES (261,'Malawi National Anthem',0,'','',20020526191956,'',00000000000000,'');
INSERT INTO lyricMain VALUES (266,'Brother, sister, let me serve you',0,'','Richard Gillard',20020602095308,'',00000000000000,'');
INSERT INTO lyricMain VALUES (256,'Thy loving kindness',71,'S in S','Hugh Mitchell',20031130160445,'',00000000000000,'');
INSERT INTO lyricMain VALUES (267,'How sweet the Name of Jesus sounds',210,'The Hymnal','John Newton',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (258,'Let your glory fall',0,'','',20020525180541,'',00000000000000,'');
INSERT INTO lyricMain VALUES (262,'Awesome God',0,'','',20020601172438,'',00000000000000,'');
INSERT INTO lyricMain VALUES (263,'Undignified',0,'','',20020601173103,'',00000000000000,'');
INSERT INTO lyricMain VALUES (264,'Finally found what I\'m looking for',0,'','',20020601173829,'u2',00000000000000,'');
INSERT INTO lyricMain VALUES (265,'Let us break bread together',0,'','',20020602093933,'',00000000000000,'');
INSERT INTO lyricMain VALUES (268,'In need of prayer:',0,'','',20020602104157,'',00000000000000,'');
INSERT INTO lyricMain VALUES (269,'The teachings of Matthew',0,'','Stephen Fyson',20020602182254,'',00000000000000,'');
INSERT INTO lyricMain VALUES (271,'Fear Not',505,'S in S','Phil Pringle',20020609182528,'',00000000000000,'');
INSERT INTO lyricMain VALUES (270,'You Are',0,'Sea of Gold','Kristian Anderson',20020607173927,'',00000000000000,'');
INSERT INTO lyricMain VALUES (273,'The Church\'s One Foundation',289,'The Hymnal','Wesley and Samuel J. Stone',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (272,'Sermon - Instructions as the Disciples are Sent Out',0,'sermons','',20040307192541,'',00000000000000,'');
INSERT INTO lyricMain VALUES (278,'Jesus Loves Me',116,'The Hymnal','',20040111094832,'',00000000000000,'');
INSERT INTO lyricMain VALUES (274,'You are my Rock',0,'','Geoff Bullock',20031116185019,'',00000000000000,'1992 Hillsongs Australia');
INSERT INTO lyricMain VALUES (275,'I will never be',0,'','Geoff Bullock',20020616181409,'',00000000000000,'');
INSERT INTO lyricMain VALUES (276,'Lay Hold',330,'S in S','Mark Pendergrass',20020616194146,'',00000000000000,'');
INSERT INTO lyricMain VALUES (277,'The Battle Belongs to the Lord',630,'S in S','Jamie Owens-Collins',20020616194504,'',00000000000000,'');
INSERT INTO lyricMain VALUES (282,'All Heaven Declares',46,'Songs of Awakening 2000','Noel & Tricia Richards',20031109193839,'',00000000000000,'1987,1997 Kingsway\'s Thankyou Music');
INSERT INTO lyricMain VALUES (283,'Breathe on me Breath of God',266,'The Hymnal','Lucy Fisher',20040307192037,'',00000000000000,'1998 Lucy Fisher (Hillsong)');
INSERT INTO lyricMain VALUES (279,'Sermon - Behaviour within the Kingdom on Earth',0,'sermons','',20040307192550,'',00000000000000,'');
INSERT INTO lyricMain VALUES (280,'Sermon - The Coming of the Final Kingdom',0,'sermons','',20040307192558,'',00000000000000,'');
INSERT INTO lyricMain VALUES (281,'Sermon - The Case Study of Peter',0,'sermons','',20040307192604,'',00000000000000,'');
INSERT INTO lyricMain VALUES (287,'Worthy of my Days',669,'S in S','Ted Sanquist',20021026203646,'you alone',00000000000000,'');
INSERT INTO lyricMain VALUES (284,'Father we love you',451,'S in S','',20021026203755,'glorify',00000000000000,'');
INSERT INTO lyricMain VALUES (285,'Holy Spirit Come',446,'S in S','Ron Fordyce',20031116180621,'',00000000000000,'1976 Birdwing music');
INSERT INTO lyricMain VALUES (286,'O Thou who Camest from Above',0,'The Hymnal','Charles Wesley and S Stanley',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (289,'Hail to the Lamb',516,'S in S','Mike and Claire McIntosh',20020630180240,'',00000000000000,'');
INSERT INTO lyricMain VALUES (292,'Set Me On Fire',0,'Big Bright Sky','Ryan Delmar',20020706182424,'',00000000000000,'');
INSERT INTO lyricMain VALUES (310,'I Have Been Justified',2,'Our God Reigns','Rob Smith',20030510224328,'',00000000000000,'1997 Rob Smith');
INSERT INTO lyricMain VALUES (306,'God will make a way',0,'','',20020721090520,'',00000000000000,'');
INSERT INTO lyricMain VALUES (295,'Set me on fire',0,'','',20020706183858,'',00000000000000,'');
INSERT INTO lyricMain VALUES (296,'Mal stuff',0,'','',20020706185039,'',00000000000000,'');
INSERT INTO lyricMain VALUES (293,'You Are In Control',0,'Mercy/Vineyard Publishing','Scott Underwood',20020706182857,'',00000000000000,'');
INSERT INTO lyricMain VALUES (297,'We have come into His house',240,'S in S','',20020707093735,'',00000000000000,'');
INSERT INTO lyricMain VALUES (298,'Spirit of the living God',0,'','',20020707093159,'',00000000000000,'');
INSERT INTO lyricMain VALUES (299,'Spirit of God',0,'','',20020707093454,'',00000000000000,'');
INSERT INTO lyricMain VALUES (300,'Sing my tongue the Saviours glory',0,'','',20020707094353,'',00000000000000,'');
INSERT INTO lyricMain VALUES (302,'We bring the sacrifice of praise',655,'','',20020714093017,'',00000000000000,'');
INSERT INTO lyricMain VALUES (307,'So you would come',0,'','Russell Fragar',20031116183119,'',00000000000000,'1996 Russell Fragar (Hillsong)');
INSERT INTO lyricMain VALUES (301,'O worship the King',0,'','',20020707101227,'',00000000000000,'');
INSERT INTO lyricMain VALUES (308,'Jesus name above all names',0,'','',20020721091011,'',00000000000000,'');
INSERT INTO lyricMain VALUES (303,'I exalt thee',255,'S in S','Pete Sanchez Jr.',20020714102007,'',00000000000000,'');
INSERT INTO lyricMain VALUES (304,'Electronic Devices',0,'','',20020714182400,'',00000000000000,'');
INSERT INTO lyricMain VALUES (305,'Come into His presence',0,'','',20020721090412,'',00000000000000,'');
INSERT INTO lyricMain VALUES (318,'Lord, Reign in me',0,'','Benton Brown',20020803161502,'',00000000000000,'');
INSERT INTO lyricMain VALUES (309,'I know Whom I have believed',651,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (314,'Standing on the rock',0,'','',20020727184847,'',00000000000000,'');
INSERT INTO lyricMain VALUES (319,'Worthy of my praise',0,'','',20020803164226,'',00000000000000,'');
INSERT INTO lyricMain VALUES (317,'I could sing of your love',0,'','Martin Smith',20020803160752,'',00000000000000,'');
INSERT INTO lyricMain VALUES (315,'Times',0,'','',20020730203135,'',00000000000000,'');
INSERT INTO lyricMain VALUES (311,'Sermon - The Kingdom - Gods\' or Mans?',0,'sermons','Frank',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (316,'Hey lord',0,'','',20020803160159,'',00000000000000,'');
INSERT INTO lyricMain VALUES (312,'Immortal Invisible, God only wise',81,'The Hymnal','Walter Chalmers Smith',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (249,'Refresh My Heart Lord',0,'Hillsongs','Geoff Bullock',20030510230359,'refresh heart ignite',00000000000000,'1990 Geoff Bullock');
INSERT INTO lyricMain VALUES (313,'Oh, the Splendour',13,'Bethlehem','Beth Hutt',20031116181916,'',00000000000000,'1987 Beth Hutt');
INSERT INTO lyricMain VALUES (320,'Find me in the river',0,'','Delerious',20020803181023,'',00000000000000,'');
INSERT INTO lyricMain VALUES (321,'Colours of Day',0,'','',20020803183203,'',00000000000000,'');
INSERT INTO lyricMain VALUES (322,'Be Thou my vision',429,'The Hymnal','Mary Byrne, Eleanor Hull & David Byrne',20040111102307,'',00000000000000,'');
INSERT INTO lyricMain VALUES (325,'Here O my Lord',315,'The Hymnal','TOULON',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (323,'Sing Hallelujah',0,'Goodman Collection','Bonnie Goodman',20021026204003,'',00000000000000,'');
INSERT INTO lyricMain VALUES (324,'I am Yours',0,'','Clhare Rochford',20020803000000,'',00000000000000,'');
INSERT INTO lyricMain VALUES (326,'Meekness & Majesty',0,'','',20020803215031,'',00000000000000,'');
INSERT INTO lyricMain VALUES (327,'Thy Word',0,'','Amy Grant & Michael W. Smith',20020804181837,'',00000000000000,'');
INSERT INTO lyricMain VALUES (328,'What the Lord has done in me',0,'','Reuben Morgan',20030510231652,'',00000000000000,'1998 Hillsong Music Australia');
INSERT INTO lyricMain VALUES (329,'King of Glory',0,'','',20020810181740,'',00000000000000,'');
INSERT INTO lyricMain VALUES (330,'How Deep the Fathers\' Love for Us',185,'','Stuart Townsend',20031116180727,'',00000000000000,'1995 Kingsway\'s Thankyou music');
INSERT INTO lyricMain VALUES (332,'I love you, Lord and I lift my voice',419,'S in S','Laurie Klein',20030727151300,'',00000000000000,'1980 House of Mercy Music. Admin by Maranatha! Music');
INSERT INTO lyricMain VALUES (331,'More precious than silver',590,'S in S','Lynn DeShazo',20020818091044,'',00000000000000,'');
INSERT INTO lyricMain VALUES (333,'Sermon - The Spirit is in the Wind',0,'sermons','Frank Willis',20020818094601,'',00000000000000,'');
INSERT INTO lyricMain VALUES (335,'Holy One of God',0,'Stones been rolled away','Geoff Bullock',20020825174506,'',00000000000000,'');
INSERT INTO lyricMain VALUES (334,'I\'m Saved',0,'Songs of Geoff Bullock','Geoff Bullock',20020818175257,'',00000000000000,'');
INSERT INTO lyricMain VALUES (336,'By Your side',0,'hillsongs','marty sampson',20020831152713,'favour dwell',00000000000000,'');
INSERT INTO lyricMain VALUES (349,'You are Holy Lord',771,'Resource','Michael Battersby 1994',20020915094428,'',00000000000000,'');
INSERT INTO lyricMain VALUES (348,'They that wait upon the Lord',645,'S in S','Dale Jackson',20020915094232,'',00000000000000,'');
INSERT INTO lyricMain VALUES (347,'Salvation belongs to our God',0,'Spec','Adrian Howard/Pat Turner/Restoration Music 1985',20020915093244,'',00000000000000,'');
INSERT INTO lyricMain VALUES (344,'Day after day',0,'','Tim Huges',20020914162121,'',00000000000000,'');
INSERT INTO lyricMain VALUES (345,'Walk on water',0,'','Nikki Fletcher',20020914162746,'',00000000000000,'');
INSERT INTO lyricMain VALUES (338,'Now thank we all our God',0,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (339,'Jesus shall reign',184,'The Hymnal','Lyrics: Isaac Watts Music: John Hatton',20030504091529,'',00000000000000,'');
INSERT INTO lyricMain VALUES (340,'All ye that pass by',155,'The Hymnal','Charles Wesley & William Knapp',20040229102926,'',00000000000000,'');
INSERT INTO lyricMain VALUES (342,'I Believe in Jesus',0,'','Marc Nelson',20030510224120,'',00000000000000,'1987 Mercy Publishing');
INSERT INTO lyricMain VALUES (351,'Be Bold',465,'S in S','Morris Chapman',20020915174833,'',00000000000000,'');
INSERT INTO lyricMain VALUES (343,'Adore You',0,'','Jay Vander Noord',20020914160527,'Adore',00000000000000,'');
INSERT INTO lyricMain VALUES (341,'Now is the time',0,'','',20020908095410,'',00000000000000,'');
INSERT INTO lyricMain VALUES (346,'All Hail the Power of Jesus Name',5,'MP','Edward Perronet/John Rippon/Public Domain',20020915093022,'',00000000000000,'');
INSERT INTO lyricMain VALUES (354,'This is my Fathers world',615,'The Hymnal','Maltbie D. Babcock',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (350,'The King is Among Us',29,'Kendrick1','Graham Kendrick/Thank You Music 1981',20020915095447,'',00000000000000,'');
INSERT INTO lyricMain VALUES (353,'Sermon - Hebrews 3 and 4',0,'sermons','Stephen Fyson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (356,'Born to win',475,'S in S','Phil Pringle',20031109194341,'',00000000000000,'1986 Seam of Gold International');
INSERT INTO lyricMain VALUES (355,'How great thou art (revised)',120,'The Hymnal','',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (359,'Good News - I Sing the Mighty Power of God',0,'','',20021013072249,'',00000000000000,'');
INSERT INTO lyricMain VALUES (360,'Good News - How majestic is Your name',0,'','Michael W. Smith 1981 Meadowgreen Music Co. CCLI 63352',20021013072541,'',00000000000000,'');
INSERT INTO lyricMain VALUES (358,'Sermon - Is Jesus adequate enough?',0,'sermons','Stephen Fyson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (361,'Good News - The heavens shall declare',0,'','Geoff Bullock 1990 Nightlight Music Pty Ltd CCLI 63352',20021013072738,'',00000000000000,'');
INSERT INTO lyricMain VALUES (362,'Good News - Wonderful Grace - Medley',0,'','',20021013073603,'',00000000000000,'');
INSERT INTO lyricMain VALUES (363,'Good News - Were you there? with Crown Him with many crowns',0,'','',20021013073826,'',00000000000000,'');
INSERT INTO lyricMain VALUES (364,'Good News - When I survey the wondrous cross',0,'','',20021013073944,'',00000000000000,'');
INSERT INTO lyricMain VALUES (365,'Just as I am',0,'','',20021013090833,'',00000000000000,'');
INSERT INTO lyricMain VALUES (366,'Sing hallelujah',0,'Jay collection :)','Jay vandernoord',20021019190708,'',00000000000000,'');
INSERT INTO lyricMain VALUES (369,'I walk by Faith',0,'','Chris Falson',20030510224532,'',00000000000000,'Seam of gold');
INSERT INTO lyricMain VALUES (368,'King of Kings',409,'S in S','Sophie Conty & Naomi Batya',20031116181432,'',00000000000000,'1980 Maranatha Praise Inc');
INSERT INTO lyricMain VALUES (367,'You gave me love',0,'You gave me love','Archie P. Jordan and Claire Cloninger',20021020093124,'',00000000000000,'');
INSERT INTO lyricMain VALUES (374,'Blessed',1,'Blessed','Darlene Zschech ad Reuben Morgan',20021103001955,'bless our land',00000000000000,'');
INSERT INTO lyricMain VALUES (372,'All for Jesus',0,'','',20030727151606,'',00000000000000,'');
INSERT INTO lyricMain VALUES (376,'Shout of the king',3,'Blessed','Ned Davies',20021103001937,'Praise Him',00000000000000,'');
INSERT INTO lyricMain VALUES (375,'Now that You\'re near',2,'Blessed','Marty Sampson',20021103001142,'',00000000000000,'');
INSERT INTO lyricMain VALUES (379,'Lord, We lift your name on high',0,'','',20021110083228,'',00000000000000,'');
INSERT INTO lyricMain VALUES (377,'All by the love of the father',0,'','Scott Brenner and Scott Ezzy',20030727151408,'',00000000000000,'');
INSERT INTO lyricMain VALUES (380,'Lord of the church',16,'Renewal','Timothy Dudly-Smith',20021117075216,'',00000000000000,'');
INSERT INTO lyricMain VALUES (381,'Behold The Lamb of God',12,'Our God Reigns','Nicky Chiswell & Rob Smith',20040725094847,'',00000000000000,'1989 Nicky Chiswell, Rob Smith');
INSERT INTO lyricMain VALUES (378,'You are the King of Glory',74,'','Mavis Ford',20021103195954,'',00000000000000,'');
INSERT INTO lyricMain VALUES (383,'And can it be',377,'The Hymnal','Charles Wesley',20021201192734,'',00000000000000,'');
INSERT INTO lyricMain VALUES (-7,'Leviticus:17:1-17:12',0,'','',20021201193126,NULL,00000000000000,'');
INSERT INTO lyricMain VALUES (613,'in the Garden',0,'','C. Austin Miles',20031026093119,'',00000000000000,'');
INSERT INTO lyricMain VALUES (-5,'logosundaymorninggcbc.jpg',0,'','',20021201191320,NULL,00000000000000,'');
INSERT INTO lyricMain VALUES (382,'Advance Australia Fair',0,'','',20021201191016,'',00000000000000,'');
INSERT INTO lyricMain VALUES (384,'Great in Power',0,'','Russell Fragar',20031116175914,'',00000000000000,'1998 Russell Fragar');
INSERT INTO lyricMain VALUES (393,'Tell out, my soul',102,'The Hymnal','Timothy Dudley-Smith',20031116184024,'',00000000000000,'1962 Hope Publishing Company');
INSERT INTO lyricMain VALUES (431,'Sermon - Help when it hurts',0,'sermons','',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (392,'Play',0,'','',20021215105348,'',00000000000000,'');
INSERT INTO lyricMain VALUES (406,'O Come all ye faithful - Christmas Day 2002',0,'','',20021225085107,'',00000000000000,'');
INSERT INTO lyricMain VALUES (388,'Let earth and heaven combine',227,'Hymn Book','Charles Wesley',20021214125827,'earth and heaven combine',00000000000000,'');
INSERT INTO lyricMain VALUES (389,'For me to live is Christ',0,'Elevate','Kate Spence',20030829213748,'',00000000000000,'');
INSERT INTO lyricMain VALUES (390,'Jesus I long',0,'','Marty Sampson',20031116181202,'',00000000000000,'1999 Marty Sampson (Hillsong)');
INSERT INTO lyricMain VALUES (391,'Bless the Lord',0,'','Kate Spence',20031109194234,'',00000000000000,'1999 Kate Spence (SHOUT!)');
INSERT INTO lyricMain VALUES (394,'Wonderful Counsellor',665,'S in S','John Michael Talbot',20021215180348,'',00000000000000,'');
INSERT INTO lyricMain VALUES (395,'Sermon - Marys\' big decision',0,'sermons','Syliva Collinson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (396,'Mary\'s boy child',0,'','Jester Hairston',20021222002124,'',00000000000000,'');
INSERT INTO lyricMain VALUES (397,'Once in royal David\'s city',0,'','Henry J. Gauntlett',20021222002730,'',00000000000000,'');
INSERT INTO lyricMain VALUES (398,'Thou didst leave Thy throne',0,'','',20021222003039,'',00000000000000,'');
INSERT INTO lyricMain VALUES (399,'Christians awake',127,'The Hymnal','John Byrom',20021222085242,'',00000000000000,'');
INSERT INTO lyricMain VALUES (400,'Angels from the realms of glory',130,'The Hymnal','James Montgomery',20021222090651,'',00000000000000,'');
INSERT INTO lyricMain VALUES (401,'Gloria',0,'','',20021222173133,'',00000000000000,'');
INSERT INTO lyricMain VALUES (402,'O\' little town of Bethlehem',0,'','',20021222173833,'',00000000000000,'');
INSERT INTO lyricMain VALUES (403,'We three Kings',0,'','',20021222174241,'',00000000000000,'');
INSERT INTO lyricMain VALUES (404,'Jingle Bells',0,'','',20021222174628,'',00000000000000,'');
INSERT INTO lyricMain VALUES (405,'O Holy Night',0,'','',20021222174928,'',00000000000000,'');
INSERT INTO lyricMain VALUES (407,'For Unto Us a Child is Born',42,'S in S','David J. Hadden',20031109194819,'',00000000000000,'1984 Restoration Music, Ltd');
INSERT INTO lyricMain VALUES (408,'C\'mon, Ring those Bells',0,'','',20021225085559,'',00000000000000,'');
INSERT INTO lyricMain VALUES (410,'A new commandment',12,'S in S','Elizabeth L. Benson',20031109193721,'',00000000000000,'1957, Renewed 1985 Nazarene Publishing House');
INSERT INTO lyricMain VALUES (411,'For the might of Thine arm',288,'The Hymnal','',20030105091150,'',00000000000000,'');
INSERT INTO lyricMain VALUES (412,'Lord Jesus Christ',0,'','Patrick Robert Appleford',20031116181649,'',00000000000000,'1960 Josef Weinberger Ltd');
INSERT INTO lyricMain VALUES (413,'Jesus Thou joy of loving hearts',229,'The Hymnal','',20030105091259,'',00000000000000,'');
INSERT INTO lyricMain VALUES (414,'May the mind of Christ my Saviour',491,'The Hymnal','Kate Barclay Wilkinson',20031116181740,'',00000000000000,'1994 Mark Peterson');
INSERT INTO lyricMain VALUES (417,'Sermon - Psalm 139',0,'sermons','',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (415,'I Worship You',561,'S in S','Sondra Corbett',20030105174729,'',00000000000000,'1983 Integrity\'s Hosanna Music');
INSERT INTO lyricMain VALUES (416,'I Worship You',562,'S in S','Carl Tuttle',20030105174707,'',00000000000000,'1982 Mercy Publishing');
INSERT INTO lyricMain VALUES (418,'Beautiful Lord, Wonderful Saviour',0,'','Darlene Zschech',20030112091121,'',00000000000000,'');
INSERT INTO lyricMain VALUES (419,'O let the Son of God enfold you',0,'','John Wimber',20030112091526,'',00000000000000,'');
INSERT INTO lyricMain VALUES (420,'Come Let us Sing of a Wonderful Love',0,'','Robert Walmsley & F L Wiseman',20030112091733,'',00000000000000,'');
INSERT INTO lyricMain VALUES (423,'Nothing But the Blood',705,'The Hymnal','Robert Lowry',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (421,'Father, Father, I rest in your love',502,'S in S','Rob Packer',20030112174520,'',00000000000000,'1984 Scripture in Song');
INSERT INTO lyricMain VALUES (422,'Be Exalted, O God',396,'S in S','Brent Chambers',20030112174919,'',00000000000000,'1977 Scripture in Song');
INSERT INTO lyricMain VALUES (424,'Sermon - Will God Forgive?',0,'sermons','',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (425,'It is He',0,'','sjf',20030119182617,'',00000000000000,'');
INSERT INTO lyricMain VALUES (426,'Our God reigns',219,'Maranatha! Chorus Book','Leonard E. Smith, Jr.',20030126004414,'',00000000000000,'1974, 1978 New Jerusalem Music');
INSERT INTO lyricMain VALUES (427,'Psalm 22 - From Anguish to Praise',0,'','',20030126174748,'',00000000000000,'');
INSERT INTO lyricMain VALUES (438,'What a friend we have in Jesus',442,'The Hymnal','Joseph M Sciven and William P. Rowlands',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (428,'When I look into Your hoIiness',662,'S in S','Wayne & Cathy Perrin',20030202090702,'',00000000000000,'');
INSERT INTO lyricMain VALUES (429,'It\'s Your blood',566,'S in S','Michael Christ V1&V2/Lynne Blair V3',20040801103531,'',00000000000000,'1985 Mercy/Vineyard publishing');
INSERT INTO lyricMain VALUES (432,'rain down',0,'','Jay Vandernoord',20030207192313,'',00000000000000,'');
INSERT INTO lyricMain VALUES (430,'I Know that my Redeemer Lives',174,'The Hymnal','Samuel Medley/John Hatton',20030202091144,'',00000000000000,'Public Domain');
INSERT INTO lyricMain VALUES (439,'The Lord\'s my Shepherd',78,'The Hymnal','Sir George Smart',20040307192037,'',00000000000000,'');
INSERT INTO lyricMain VALUES (433,'Forever God is faithful',0,'','Chris Tomlin',20040516172028,'',00000000000000,'');
INSERT INTO lyricMain VALUES (434,'O, for a thousand tongues to sing',238,'The Hymnal','Charles Wesley',20030209080334,'',00000000000000,'');
INSERT INTO lyricMain VALUES (435,'God forgave my sin (Freely, freely)',123,'','Carol Owens',20030209082840,'',00000000000000,'1972 Bud John Songs/Universal Songs');
INSERT INTO lyricMain VALUES (436,'Jesus the Light of the World',0,'','Ross Young',20030209174703,'',00000000000000,'Ross Young - Feb 2003');
INSERT INTO lyricMain VALUES (437,'With Your Love',0,'','Geoff Bullock',20030209180429,'',00000000000000,'');
INSERT INTO lyricMain VALUES (454,'Holy, Holy',35,'','Nathan Fellingham',20030308184822,'',00000000000000,'1995 Kingsway Thankyou Music');
INSERT INTO lyricMain VALUES (440,'Sermon - The Greatest Gift Giver of All!',0,'sermons','Kristie',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (441,'For This Purpose',0,'','Graham Kendrick',20031109194655,'',00000000000000,'1985 Kingsway\'s Thankyou music');
INSERT INTO lyricMain VALUES (442,'All Hail King Jesus',219,'','Dave Moody',20031109193753,'',00000000000000,'1981 Dayspring Music Inc');
INSERT INTO lyricMain VALUES (443,'Jesus, We Enthrone You',431,'','Paul Kyle/ Lynne Blair',20030216091241,'',00000000000000,'');
INSERT INTO lyricMain VALUES (444,'To Keep Your Lovely Face',0,'','Graham Kendrick',20030216091341,'',00000000000000,'');
INSERT INTO lyricMain VALUES (445,'Blessed are the people',470,'S in S','Shirley Pavy',20030216175611,'',00000000000000,'');
INSERT INTO lyricMain VALUES (446,'Born to Win ending',0,'','',20030216181526,'',00000000000000,'');
INSERT INTO lyricMain VALUES (447,'Practice being Godly',0,'','Colin Buchanan',20031116182045,'',00000000000000,'1997 Rondor Music');
INSERT INTO lyricMain VALUES (449,'Praise God from whom all blessings flow',0,'','Andy Piercy & David Clifton',20031116182225,'',00000000000000,'1993 IQ Music Ltd');
INSERT INTO lyricMain VALUES (450,'There must be more (Consuming fire)',72,'The survivor songbook','Tim Hughes',20030419193700,'',00000000000000,'2002 Thankyou Music');
INSERT INTO lyricMain VALUES (451,'How lovely is Your dwelling place',36,'Soul Survivor','Matt Redmond',20030308184147,'',00000000000000,'Copyright 1995 Kingsway\'s Thankyou Music');
INSERT INTO lyricMain VALUES (452,'Beautiful One',0,'Soul Survivor','Tim Hughes',20030411171101,'',00000000000000,'Copyright (c) 2002 Thankyou Music');
INSERT INTO lyricMain VALUES (453,'Blessed be Your name',12,'The survivor songbook','Matt & Beth Redman',20030308184214,'',00000000000000,'2002 Thankyou Music');
INSERT INTO lyricMain VALUES (456,'Holy and anointed one',943,'','John Barnett',20031116180519,'',00000000000000,'1988 Mercy/Vineyard publishing');
INSERT INTO lyricMain VALUES (455,'He is the Lord',28,'Soul Survivor','Kevin Prosch',20030308185412,'',00000000000000,'Copyright (c) 1991 Mercy/Vineyard Publishing');
INSERT INTO lyricMain VALUES (457,'Playlist part 2',0,'','',20030308185614,'',00000000000000,'');
INSERT INTO lyricMain VALUES (458,'O sacred King',54,'','Matt Redman',20030308185657,'',00000000000000,'1999 Kingsway Thankyou Music');
INSERT INTO lyricMain VALUES (459,'Befriended',0,'Soul Survivor','Matt Redman',20030411171233,'',00000000000000,'2002 Matt Redman, Kingsway Thankyou Music');
INSERT INTO lyricMain VALUES (462,'Over and Over again',0,'','Terry Butler',20030309092045,'',00000000000000,'1992 Mercy/Vineyard publishing');
INSERT INTO lyricMain VALUES (461,'The love of God can do',0,'','Christine and Russell Fragar',20030510231318,'',00000000000000,'1996 Hillsongs Australia');
INSERT INTO lyricMain VALUES (464,'Making Melody',0,'','Matt Redman',20030314194239,'',00000000000000,'2001 Kingsway\'s thankyou music');
INSERT INTO lyricMain VALUES (463,'Sermon - John 4:43-54',0,'sermons','',20040307192642,'',00000000000000,'');
INSERT INTO lyricMain VALUES (467,'Son of God',0,'Blessed','2002 Integritys Praise! Music',20030316174554,'',00000000000000,'');
INSERT INTO lyricMain VALUES (468,'I am the bread of life',544,'S in S','Sr. Suzanne Toolan',20030316175222,'',00000000000000,'1971 GIA Publications Inc');
INSERT INTO lyricMain VALUES (469,'God of Grace and God of Glory',0,'','',20030323092708,'',00000000000000,'');
INSERT INTO lyricMain VALUES (470,'Rejoice in the Lord always',81,'S in S','Evelyn Tarner',20031116182438,'',00000000000000,'1967 Word Music Inc');
INSERT INTO lyricMain VALUES (471,'It\'s no longer I that liveth',8,'S in S','Sally Ellis',20030330091719,'',00000000000000,'1980 Thank You Music');
INSERT INTO lyricMain VALUES (472,'Best Friend',0,'','',20030404191125,'',00000000000000,'');
INSERT INTO lyricMain VALUES (473,'Sermon - The Ultimate Victory: The coming again of Jesus the lord',0,'sermons','Rev. Norris Brook',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (474,'walking on sunshine',0,'','',20030411185311,'',00000000000000,'');
INSERT INTO lyricMain VALUES (644,'My faith looks up to Thee',532,'The Hymnal','Ray Palmer and Lowell Mason',20040222091324,'',00000000000000,'');
INSERT INTO lyricMain VALUES (645,'Sermon - A challenge to faithful service',0,'sermons','Norris Brook',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (646,'Bind us together Lord',0,'','',20040229091142,'',00000000000000,'');
INSERT INTO lyricMain VALUES (497,'Man of Sorrows',350,'The Source 1','Philiip Bliss',20030418091347,'',00000000000000,'Public Domain');
INSERT INTO lyricMain VALUES (498,'This is my rest forever',1,'S in S','Artist Unknown',20030419200848,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (503,'For thou art great',6,'S in S','Artist Unknown',20030419220335,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (499,'He\'s all I need',2,'S in S','Artist Unknown',20030419201114,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (505,'I get so thrilled with Jesus',9,'S in S','Artist Unknown',20030419224242,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (500,'Sweep over my soul',3,'S in S','Harry D Clarke',20030419215747,'',00000000000000,'1927. Renewal 1995 by Hope Publishing Co.');
INSERT INTO lyricMain VALUES (501,'To get a touch from the Lord',4,'S in S','Artist Unknown',20030419220003,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (502,'He brought my soul out of prison',5,'S in S','Gillian Bough',20030419220155,'',00000000000000,'1976 Gillian Bough');
INSERT INTO lyricMain VALUES (509,'Not my will be thine be done',14,'S in S','Artist Unknown',20030419225120,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (507,'There with joy shall ye draw water',11,'S in S','Artist Unknown',20030419224549,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (504,'Anointed, anointed of the Father',7,'S in S','R Edward Miller',20030419220559,'',00000000000000,'1976 R Edward Miller. Admin by S.I.S.');
INSERT INTO lyricMain VALUES (506,'God is moving by his Spirit',10,'S in S','L C Hall',20030419224416,'',00000000000000,'1966 Gospel Publishing House');
INSERT INTO lyricMain VALUES (519,'Behold, God is my salvation',24,'S in S','Artist Unknown',20030419233331,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (508,'Jesus himself took my weakness',13,'S in S','Dale Garratt',20030419224807,'',00000000000000,'1972 Scripture in Song');
INSERT INTO lyricMain VALUES (526,'Therefor, being justified by faith',29,'S in S','Artist Unknown',20030420160230,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (510,'For from him, and through him',15,'S in S','Ena Thompson',20030419225238,'',00000000000000,'1972, 1977 Scripture in Song');
INSERT INTO lyricMain VALUES (511,'We are gathering together unto him',16,'S in S','Artist Unknown',20030419225709,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (512,'It\'s a new and living way',17,'S in S','Artist Unknown',20030419231056,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (513,'Blessed be the Lord God',18,'S in S','Shirley Powell',20030419231657,'',00000000000000,'1972 Scripture in Song');
INSERT INTO lyricMain VALUES (514,'It\'s a new hour',19,'S in S','Mildred Crawford',20030419231856,'',00000000000000,'1978 Scripture in Song');
INSERT INTO lyricMain VALUES (515,'By my Spirit',20,'S in S','Almeda Herrick',20030419232313,'',00000000000000,'1957 Gospel Publishing House');
INSERT INTO lyricMain VALUES (516,'We see the Lord',21,'S in S','Artist Unknown',20030419232505,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (517,'He is my everything',22,'S in S','Sally Ellis',20030419232806,'',00000000000000,'1980 Thank You Music');
INSERT INTO lyricMain VALUES (518,'Whoso offereth praise glorifieth me',23,'S in S','Artist Unknown',20030419232942,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (520,'He lives',725,'The Hymnal','A. H. Ackley',20031116180247,'',00000000000000,'1933 Homer A. Rodeheaver et al.');
INSERT INTO lyricMain VALUES (521,'Lift up your heads',218,'S in S','Steven Fry',20030420084533,'',00000000000000,'1974 Steven L. Fry');
INSERT INTO lyricMain VALUES (522,'Take our bread',25,'S in S','Joe Wise',20030420153318,'',00000000000000,'1983 G.I.A. Publications Inc.');
INSERT INTO lyricMain VALUES (523,'There is a river of the water of life',26,'S in S','Graham Kelly',20030420153525,'',00000000000000,'1976 Scripture in Song');
INSERT INTO lyricMain VALUES (524,'Be still and know that I am God',27,'S in S','Artist Unknown',20030420153728,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (525,'Cause me to come to thy river',28,'S in S','R Edward Miller',20030420153927,'',00000000000000,'1974 Maranatha! Music');
INSERT INTO lyricMain VALUES (529,'I will be the Lord at all times',32,'S in S','Vep Ellis',20030420161349,'',00000000000000,'1967 Vep Ellis');
INSERT INTO lyricMain VALUES (527,'O cloud of great glory',30,'S in S','R Edward Miller',20030420160511,'',00000000000000,'1976 R Edward Miller. Admin by S.I.S');
INSERT INTO lyricMain VALUES (528,'Praise ye the Lord',31,'S in S','Reta Kelligan',20030420161010,'',00000000000000,'1951, 1980 Reta Kelligan');
INSERT INTO lyricMain VALUES (538,'Set my spirit free',43,'S in S','Artist Unknown',20030504171244,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (533,'I Surrender',0,'Stone\'s been rolled away','Geoff Bullock',20030427092519,'',00000000000000,'1993 Word Inc');
INSERT INTO lyricMain VALUES (530,'Jesus, you are so precious and lovely',33,'S in S','Helen Lemmel',20030420161527,'',00000000000000,'1981 Singspiration Music');
INSERT INTO lyricMain VALUES (531,'Sing praises to God',35,'S in S','Artist Unknown',20030420161745,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (532,'Abide with me',544,'The Hymnal','Lyrics: Henry F. Lyte Music: William H. Monk',20030427091731,'',00000000000000,'');
INSERT INTO lyricMain VALUES (1,'Sermon: Kristie',0,'sermons','Kristie Wauchope',20040307192756,NULL,00000000000000,'');
INSERT INTO lyricMain VALUES (534,'Alleluia',36,'S in S','Jerry Sinclair',20030504165813,'',00000000000000,'1972, 1978 Manna Music Inc.');
INSERT INTO lyricMain VALUES (535,'His name is wonderful',37,'S in S','Audrey Mieir',20031116180447,'',00000000000000,'1959 Audrey Mieir Inc');
INSERT INTO lyricMain VALUES (536,'Sweet Jesus',38,'S in S','Paul Goodwin',20030504170327,'',00000000000000,'1962 Gospel Publishing House');
INSERT INTO lyricMain VALUES (537,'Heavenly Father, I appreciate you',39,'S in S','Artist Unknown',20030504170633,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (539,'And you shall seek me',44,'S in S','Robert Rhodes',20030504171602,'',00000000000000,'1978 Robert Rhodes');
INSERT INTO lyricMain VALUES (540,'Thank You, Lord',0,'God is in the House','Dennis Jernigan',20031116184110,'',00000000000000,'1991 Shepherd\'s Heart Music');
INSERT INTO lyricMain VALUES (541,'create in me a clean heart',0,'','',20030509194750,'',00000000000000,'');
INSERT INTO lyricMain VALUES (542,'Oh the mercy of God',0,'','Geoff Bullock',20030510230009,'',00000000000000,'1997 Watershed Productions');
INSERT INTO lyricMain VALUES (543,'You are my God',0,'','Geoff Bullock/Gail Dunshea',20031116184953,'',00000000000000,'1992 Word Music Inc');
INSERT INTO lyricMain VALUES (544,'Your love',0,'','Geoff Bullock',20031116185107,'',00000000000000,'1995 Word Music Inc');
INSERT INTO lyricMain VALUES (545,'You rescued me',0,'','Geoff Bullock',20031116185039,'',00000000000000,'1993 Word Music');
INSERT INTO lyricMain VALUES (546,'Let God arise',45,'S in S','Elisabeth Bacon',20030510235933,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (547,'Surely goodness and mercy shall follow',46,'S in S','John W Peterson',20031116183526,'',00000000000000,'1954 Singspiration Music');
INSERT INTO lyricMain VALUES (548,'For the beauty of the earth',0,'NON-HYMNAL','',20030511085033,'',00000000000000,'');
INSERT INTO lyricMain VALUES (549,'There is none like You',637,'Resource','Lenny Le Blanc',20030511085428,'',00000000000000,'1991 Integrity\'s Hosanna Music');
INSERT INTO lyricMain VALUES (550,'Mother\'s Day Bible Verses',0,'','New International Version',20030511092259,'',00000000000000,'');
INSERT INTO lyricMain VALUES (552,'I come to the garden alone',0,'','',20030523125213,'',00000000000000,'');
INSERT INTO lyricMain VALUES (551,'MY MUM',0,'','',20030511094706,'',00000000000000,'');
INSERT INTO lyricMain VALUES (553,'How great thou art - Bill Fyson',0,'','',20030523125449,'',00000000000000,'');
INSERT INTO lyricMain VALUES (554,'up from the grave',0,'','',20030525091924,'',00000000000000,'');
INSERT INTO lyricMain VALUES (555,'Exalt the Lord our God',234,'S in S','Rick Ridings',20030601092309,'',00000000000000,'1977, 1980 Scripture in Song');
INSERT INTO lyricMain VALUES (556,'In Love for me (this is my body)',284,'S in S','Jimmy Owens',20040307192230,'',00000000000000,'1978 Bud John Songs Inc.');
INSERT INTO lyricMain VALUES (557,'Bless the Lord',0,'Draw Near','Darin Sasser, Jay Hall, Chad Jamagin',20030606185831,'',00000000000000,'');
INSERT INTO lyricMain VALUES (558,'Sermon - The Holy Spirit in the Gospel of John',0,'sermons','Rev Norris Brook',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (560,'Psalm 89',307,'S in S','Karen Barrie',20030608180523,'',00000000000000,'1973 Karen Barrie');
INSERT INTO lyricMain VALUES (614,'The resolution',0,'','',20031101094617,'',00000000000000,'');
INSERT INTO lyricMain VALUES (562,'Praise the Lord, you heavens adore Him,',0,'The Hymnal','',20030615084508,'',00000000000000,'');
INSERT INTO lyricMain VALUES (563,'Praise Him!',225,'The Hymnal','Fanny J. Crosby',20030622092732,'',00000000000000,'');
INSERT INTO lyricMain VALUES (564,'YOU ARE MY HIDING PLACE',673,'Scripture in Song','Michael Ledner',20031116185009,'',00000000000000,'1981 Maranatha Music');
INSERT INTO lyricMain VALUES (565,'Sermon - Temptation',0,'sermons','Stephen Fyson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (567,'Tremble',0,'','Audio Adrenaline',20030703191450,'',00000000000000,'');
INSERT INTO lyricMain VALUES (568,'Australia',0,'','',20030703194912,'',00000000000000,'');
INSERT INTO lyricMain VALUES (569,'Healer',0,'','Ten Shekel Shirt',20030703195855,'',00000000000000,'');
INSERT INTO lyricMain VALUES (570,'Meet with me',0,'','Ten Shekel Shirt',20030703200351,'',00000000000000,'');
INSERT INTO lyricMain VALUES (571,'You still Amaze me',0,'','',20030703201150,'',00000000000000,'');
INSERT INTO lyricMain VALUES (572,'You Said',0,'By Your side','Rita Springer',20030703202009,'',00000000000000,'');
INSERT INTO lyricMain VALUES (573,'Sweet Embrace',0,'','Ten Shekel Shirt',20030703202518,'',00000000000000,'');
INSERT INTO lyricMain VALUES (574,'In my life Lord',0,'Hymn','',20030705232558,'',00000000000000,'');
INSERT INTO lyricMain VALUES (575,'Change my heart O God',482,'S in S','Eddie Espinosa',20030706175206,'',00000000000000,'1982 Mercy Publishing');
INSERT INTO lyricMain VALUES (576,'Sermon - Relationship',0,'sermons','Bob Copleston',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (577,'Therefore the Redeemed',79,'S in S','Ruth Lake',20030720091836,'',00000000000000,'1972 Scripture in Song');
INSERT INTO lyricMain VALUES (579,'Prayer',0,'','',20030720183323,'',00000000000000,'');
INSERT INTO lyricMain VALUES (580,'Sermon - The Importance of Attitude',0,'sermons','',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (586,'Your Beloved',0,'','Brent Helming',20030801200108,'',00000000000000,'');
INSERT INTO lyricMain VALUES (583,'To the depths',0,'','',20030725194740,'',00000000000000,'');
INSERT INTO lyricMain VALUES (584,'The steadfast love of the Lord',306,'','Edith McNeill',20031116184811,'',00000000000000,'1974, 1975 Celebration');
INSERT INTO lyricMain VALUES (585,'O the deep, deep love of Jesus!',216,'The Hymnal','Samuel Trever Francis & Thomas John Williams',20030727101427,'',00000000000000,'');
INSERT INTO lyricMain VALUES (587,'We are family',165,'S in S','Jimmy and Carol Owens',20031116184924,'',00000000000000,'1975 Bud John Songs Inc.');
INSERT INTO lyricMain VALUES (588,'Abba Father',305,'S in S','Dave Bilbrough',20030803091517,'',00000000000000,'1977 Thank You Music.');
INSERT INTO lyricMain VALUES (589,'The Battle Hymn of the Republic',0,'','Julia Ward Howe',20030803095242,'',00000000000000,'');
INSERT INTO lyricMain VALUES (593,'I am a new creation',542,'S in S','Dave Bilbrough',20030817105628,'',00000000000000,'1983 Thank You');
INSERT INTO lyricMain VALUES (591,'Arms of Love',0,'','Craig Musseau',20030815185240,'',00000000000000,'1991 Mercy Publishing');
INSERT INTO lyricMain VALUES (592,'God of wonders',0,'','Third Day',20030815185638,'',00000000000000,'');
INSERT INTO lyricMain VALUES (597,'Great is Your faithfulness',73,'The Hymnal','Thomas Chrisholm',20031116180100,'',00000000000000,'1923, 1951 Hope Publishing Co.');
INSERT INTO lyricMain VALUES (595,'Higher and Higher',0,'','',20030829200855,'',00000000000000,'');
INSERT INTO lyricMain VALUES (596,'To God be the glory (LB)',76,'S in S','Andrae Crouch',20030831091951,'',00000000000000,'');
INSERT INTO lyricMain VALUES (598,'Holy',0,'','',20030912184343,'',00000000000000,'');
INSERT INTO lyricMain VALUES (599,'Jehovah Jireh',184,'S in S','Merla Watson',20030914092438,'',00000000000000,'1974 Gordon V. Thompson');
INSERT INTO lyricMain VALUES (600,'Sermon - Ethics of Reconciliation vs. Ministry of Reconciliation',0,'sermons','Stephen Fyson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (601,'Celebrate',554,'S in S','Patricia Morgan/Dave Bankhead',20031109194459,'',00000000000000,'1984 Kingsway\'s Thankyou Music');
INSERT INTO lyricMain VALUES (602,'Jesus, take me as I am',318,'S in S','Dave Bryant',20031116181312,'',00000000000000,'1978 Kingsway\'s Thankyou music');
INSERT INTO lyricMain VALUES (603,'Sermon - Baptism',0,'sermons','Sylvia Collinson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (604,'Find me at the cross',0,'','Chris o\'brien',20031109194607,'',00000000000000,'2000 Seam of gold');
INSERT INTO lyricMain VALUES (605,'Days of Elijah',912,'','Robin Mark',20031109194535,'',00000000000000,'1996 Daybreak Music, Ltd');
INSERT INTO lyricMain VALUES (606,'Shout to the North',354,'The Source','Martin Smith',20031116182859,'',00000000000000,'1995 Curious? Music U.K.');
INSERT INTO lyricMain VALUES (607,'Beautiful',8,'','Dennis Cleveland',20030928092255,'',00000000000000,'');
INSERT INTO lyricMain VALUES (608,'Lift High the Cross',0,'','George William Kitchin',20031116181548,'',00000000000000,'1974 Hope Publishing Company');
INSERT INTO lyricMain VALUES (609,'This is the church',942,'','Michael Battersby',20031012180659,'',00000000000000,'');
INSERT INTO lyricMain VALUES (610,'I will sing unto the Lord',168,'S in S','Artist Unknown',20031012181447,'',00000000000000,'Copyright Unknown');
INSERT INTO lyricMain VALUES (611,'Sermon - Father Abraham',0,'sermons','Norris Brook',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (612,'All the heavens',0,'Blessed','Reuben Morgan',20031019175959,'',00000000000000,'2002 Reuben Morgan/Hillsong Publishing');
INSERT INTO lyricMain VALUES (615,'Sing we the King',206,'Mission Praise','C H Gabriel/Sylvester Horne',20031116090828,'',00000000000000,'');
INSERT INTO lyricMain VALUES (616,'If I can help somebody',0,'','Alma Androzzo',20031123091732,'',00000000000000,'1945 Alma Androzzo, Assigned to Boosey & Hawkes');
INSERT INTO lyricMain VALUES (617,'Thou are worthy',50,'S in S','Pauline Michael Mills',20031130160730,'',00000000000000,'1963, 1975 Fred Bock Music');
INSERT INTO lyricMain VALUES (618,'All over the world',51,'S in S','Cameron Brothers',20031130161033,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (619,'I will bless Thee O Lord',52,'S in S','Teresa Muller',20031130161209,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (620,'Into thy presence we come',54,'S in S','Unknown',20031130161508,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (621,'There\'s a river of life flowing out from me',55,'S in S','L Casebolt',20031130161657,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (622,'We worhsip and adore Thee',56,'S in S','Unknown',20031130161912,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (623,'Jesus breaks every fetter',57,'S in S','',20031130162114,'',00000000000000,'');
INSERT INTO lyricMain VALUES (624,'It\'s a lovely, lovely name',58,'S in S','Joe Parks',20031130162342,'',00000000000000,'1955 Tennessee Music and Printing Company');
INSERT INTO lyricMain VALUES (625,'He has shown thee O man what is good',59,'S in S','Unknown',20031130162523,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (626,'Come bless the Lord',140,'S in S','Unknown',20031207175210,'',00000000000000,'Unknown');
INSERT INTO lyricMain VALUES (627,'Sermon - Aussie alternatives to Jesus',0,'sermons','Stephen Fyson',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (628,'Christ Triumphant',10,'','John Barnard',20031214091001,'',00000000000000,'Michael Saward');
INSERT INTO lyricMain VALUES (629,'Good Christian men rejoice',115,'The Hymnal','John M. Neale',20031214091741,'',00000000000000,'');
INSERT INTO lyricMain VALUES (630,'Worship the King',0,'MW','Mendelssohn, Smiley & Hatton',20031214092749,'',00000000000000,'');
INSERT INTO lyricMain VALUES (631,'The North Wind',769,'The Hymnal','John Wheeler & William G. James',20031214095510,'',00000000000000,'');
INSERT INTO lyricMain VALUES (632,'Sermon - Unto you... city of David',0,'sermons','Norris Brook',20040307192756,'',00000000000000,'');
INSERT INTO lyricMain VALUES (638,'O Come, O Come, Emmanuel',104,'The Hymnal','',20031225084659,'',00000000000000,'Public Domain');
INSERT INTO lyricMain VALUES (639,'Emmanuel',234,'S in S','',20031225084852,'',00000000000000,'');
INSERT INTO lyricMain VALUES (640,'It\'s Christmas',0,'','Dean Watson',20031225085303,'',00000000000000,'');
INSERT INTO lyricMain VALUES (641,'Mission statement',0,'','',20040118102045,'',00000000000000,'');
INSERT INTO lyricMain VALUES (642,'Seek Ye First',0,'','',20040125090915,'',00000000000000,'');
INSERT INTO lyricMain VALUES (643,'Glory for me',0,'','',20040208085820,'',00000000000000,'');
INSERT INTO lyricMain VALUES (647,'In the NIV',0,'','',20040321100629,'',00000000000000,'');
INSERT INTO lyricMain VALUES (648,'Your love',737,'Resource','Michael Adeney',20040328091626,'',00000000000000,'1994 Michael Adeney');
INSERT INTO lyricMain VALUES (649,'O sacred head, once wounded',928,'The Source','Paulus Gerhardt',20040409091515,'',00000000000000,'');
INSERT INTO lyricMain VALUES (650,'These Thousand Hills',2,'Offerings','Third Day',20040411180533,'',00000000000000,'');
INSERT INTO lyricMain VALUES (651,'The Ode to the Fallen',0,'','Binyon (1869 -1943)',20040425085751,'',00000000000000,'');
INSERT INTO lyricMain VALUES (652,'No Greater Love',0,'','Sally Pinsak',20040509175906,'music@ccec.com.au',00000000000000,'2003 Sing Jesus Praise');
INSERT INTO lyricMain VALUES (653,'Christ for the world',0,'','',20040516093008,'',00000000000000,'');
INSERT INTO lyricMain VALUES (654,'Christ for the Yao',0,'','',20040516101843,'',00000000000000,'');
INSERT INTO lyricMain VALUES (655,'I can only imagine',0,'','',20040516172304,'',00000000000000,'');
INSERT INTO lyricMain VALUES (656,'You chose the cross',0,'','',20040516172519,'',00000000000000,'');
INSERT INTO lyricMain VALUES (657,'Thine be the glory',13,'Billy Graham Songbook','Edmond L. Budry & George F. Handel',20040523091222,'',00000000000000,'');
INSERT INTO lyricMain VALUES (658,'He keeps me singing',20,'Billy Graham Songbook','',20040523092216,'',00000000000000,'');
INSERT INTO lyricMain VALUES (659,'Let the Lord have His way',0,'','',20040530090423,'',00000000000000,'');
INSERT INTO lyricMain VALUES (660,'I\'ve got a wonderful saviour',0,'','',20040530090546,'',00000000000000,'');
INSERT INTO lyricMain VALUES (661,'Stop & Go',0,'','',20040530091301,'',00000000000000,'');
INSERT INTO lyricMain VALUES (662,'I\'m Your child',0,'','Geoff Bullock',20040606091236,'',00000000000000,'1990');
INSERT INTO lyricMain VALUES (663,'working bee',0,'','',20040606104811,'',00000000000000,'');
INSERT INTO lyricMain VALUES (664,'Come Holy Spirit',0,'','John W. Peterson',20040627194841,'',00000000000000,'1971 Singspiration Inc');
INSERT INTO lyricMain VALUES (666,'Stand up, stand up for Jesus',0,'','',20040704095854,'',00000000000000,'');
INSERT INTO lyricMain VALUES (667,'One way',0,'','',20040711090902,'',00000000000000,'');
INSERT INTO lyricMain VALUES (668,'the list',0,'','',20040711192233,'',00000000000000,'');
INSERT INTO lyricMain VALUES (669,'How great are you Lord',749,'The Source','Lynn De Shazo & Chris Mitchell',20040718092144,'',00000000000000,'');
INSERT INTO lyricMain VALUES (670,'Worthy is the lamb',666,'The Hymnal','Jim Enchenbacher',20040718171415,'',00000000000000,'1987 Scripture in song');
INSERT INTO lyricMain VALUES (671,'Consider Christ',0,'','',20040718172049,'',00000000000000,'');
INSERT INTO lyricMain VALUES (672,'O Worship the Lord in the beauty of Holiness',23,'The Hymnal','',20040801091149,'',00000000000000,'');
INSERT INTO lyricMain VALUES (673,'For God so loved the world',62,'Bill Graham Crusade Songs','Frances Townsend and Alfred B. Smith',20040808090804,'',00000000000000,'');

--
-- Table structure for table `page`
--

CREATE TABLE page (
  pageid INTEGER auto_increment,
  songid INTEGER NOT NULL default '0',
  pagenum INTEGER NOT NULL default '0',
  lyrics text,
  PRIMARY KEY  (pageid)
) TYPE=MyISAM;

--
-- Dumping data for table `page`
--

INSERT INTO page VALUES (5271,9,7,'Mortals join the mighty chorus,\nwhich the morning stars began;\nFather love is reigning o\'er us,\nBrother love binds man to man.\n');
INSERT INTO page VALUES (696,41,2,'Great are Your works Lord,\nGreat are Your deeds,\nAwesome in power,\nSo awesome to me.');
INSERT INTO page VALUES (697,41,3,'You will reign, You will reign\nForever, forever\nIn power, in power\nYou will reign.\n(repeat)');
INSERT INTO page VALUES (698,41,4,'Great are Your works Lord,\nGreat are Your deeds,\nAwesome in power,\nSo awesome to me.');
INSERT INTO page VALUES (699,41,5,'Because of, because of,\nYour greatness, your greatness,\nAll the earth, all the earth,\nWill sing.\n(repeat)');
INSERT INTO page VALUES (10294,113,5,'The price is paid and by that\nscourging cruel\nHe took our sicknesses\nas if his own\nAnd by his wounds his\nbody broken there\nHis healing touch may\nnow by faith be known.');
INSERT INTO page VALUES (1639,115,3,'Jesus taught us how to be a family\nJesus taught us how to be a family\nLoving one another with the love that\nHe gives\nJesus taught us how to be a family.');
INSERT INTO page VALUES (1638,115,2,'Jesus taught us how to live in harmony\nJesus taught us how to live in harmony\nDifferent faces, different races,\nHe made us one\nJesus taught us how to live in harmony.');
INSERT INTO page VALUES (10293,113,2,'The price is paid, Alleluia\nAmazing grace so strong and sure\nAnd so with all my heart\nMy life in every part\nI live to thank you for the price you paid.');
INSERT INTO page VALUES (10292,113,7,'The price is paid \nworthy the Lamb we cry\nEternity shall never \ncease his praise\nThe church of Christ \nshall rule upon the Earth\nIn Jesus name we have authority.');
INSERT INTO page VALUES (10291,113,3,'The Price is paid see \nSatan flee away\nFor Jesus crucified \ndestroys his power\nNo more to pay let \naccusation cease\nIn Christ there is no \ncondemnation now.');
INSERT INTO page VALUES (10290,113,1,'The price is paid come let us enter in\nTo all that Jesus died to make our own\nFor every sin.\nMore than enough he gave\nAnd bought our freedom from \neach guilty stain.');
INSERT INTO page VALUES (10289,113,4,'The price is paid, Alleluia\nAmazing grace so strong and sure\nAnd so with all my heart\nMy life in every part\nI live to thank you for the price you paid.');
INSERT INTO page VALUES (10288,113,6,'The price is paid, Alleluia\nAmazing grace so strong and sure\nAnd so with all my heart\nMy life in every part\nI live to thank you for the price you paid.');
INSERT INTO page VALUES (10287,113,8,'The price is paid, Alleluia\nAmazing grace so strong and sure\nAnd so with all my heart\nMy life in every part\nI live to thank you for the price you paid.\nI live to thank you for the price you paid.');
INSERT INTO page VALUES (1637,115,1,'Jesus put this song into our hearts,\nJesus put this song into our hearts,\nIt\'s a song of joy no one can take away,\nJesus put this song into our hearts.');
INSERT INTO page VALUES (5270,9,6,'Thou our Father, Christ our brother,\nAll who live in love are thine;\nTeach us how to love each other,\nLift us to the joy divine.');
INSERT INTO page VALUES (5269,9,5,'Thou art giving and forgiving,\never blessing, ever blest,\nWell-spring of the joy of living,\nOcean depth of happy rest!\n');
INSERT INTO page VALUES (5268,9,4,'Field and forest, vale and mountain\nFlowery meadow, flashing stream;\nChanting bird and flowing fountain,\nCall us to rejoice in thee');
INSERT INTO page VALUES (5267,9,3,'All thy works with joy surround thee\nEarth and heav\'n reflect thy rays\nStars and angels sing around thee\ncentre of unbroken praise\n');
INSERT INTO page VALUES (5266,9,2,'Melt the clouds of Sin and sadness\nDrive the dark of doubt away\nGiver of immortal gladness\nFill us with the light of day');
INSERT INTO page VALUES (5265,9,1,'Joyful, Joyful we adore thee\nGod of glory, Lord of love;\nHearts unfold like flowers before thee\nOpening to the sun above.');
INSERT INTO page VALUES (160,10,1,'My hope is built on nothing less \nthan Jesus\' blood and righteousness.\nI dare not trust the sweetest frame \nbut wholly lean on Jesus\' name.\n\nOn Christ, the solid Rock, I stand; \nall other ground is sinking sand.\nAll other ground is sinking sand.');
INSERT INTO page VALUES (7120,39,2,'Praise Him above ye \nheavenly host\nPraise Father, Son \nand Holy Ghost!');
INSERT INTO page VALUES (7119,39,1,'Praise God from whom \nall blessings flow\nPraise Him all\ncreatures here below\n');
INSERT INTO page VALUES (6266,38,3,'Father in heaven how we praise You,\nWe worship you with\nall our hearts.\nMay our voices be a \nwitness to your greatness\nAs your people declare \nthat you are Lord.');
INSERT INTO page VALUES (6267,38,4,'Blessed be the Lord God Almighty\nWho was and is and is to come\nBlessed be the Lord God Almighty\nWho reigns for evermore\nWho reigns for evermore');
INSERT INTO page VALUES (5785,37,3,'The Lord reigns, The Lord reigns,\nThe Lord reigns, let the earth rejoice\nLet the earth rejoice, \nLet the earth rejoice,\nLet the people be glad\nThat our God reigns!');
INSERT INTO page VALUES (5784,37,2,'A fire goes before him\nAnd burns up all his enemies\nThe hills melt like wax\nAt the presence of the Lord\nAt the presence of the Lord\nof the whole earth');
INSERT INTO page VALUES (5783,37,1,'The Lord reigns, The Lord reigns,\nThe Lord reigns, let the earth rejoice\nLet the earth rejoice, \nLet the earth rejoice,\nLet the people be glad\nThat our God reigns!');
INSERT INTO page VALUES (1464,35,2,'He is the Lord\nFor ever His truth shall reign:\nHeaven and earth\nRejoice in His holy name\nHe is exalted\nThe King is exalted on high.');
INSERT INTO page VALUES (8452,36,2,'A God of faithfulness\nand without injustice\nGood and upright is He\n(repeat)');
INSERT INTO page VALUES (8451,36,1,'Ascribe greatness to our God,\nthe rock.\nHis work is perfect,\nand all his ways are just.\n(repeat)');
INSERT INTO page VALUES (3318,23,6,'Restored and Sanctified\nThe stone\'s been rolled away\nRestored and Sanctified\nThe stone\'s been rolled away');
INSERT INTO page VALUES (3317,23,5,'Singing Glory\nSinging Glory\nSinging Glory\nRestored and Sanctified\nThe stone\'s been rolled away');
INSERT INTO page VALUES (441,13,3,'Let us see on earth\nThe glory of your Son\nMay I be the one\nThat you\'d use in your plan');
INSERT INTO page VALUES (442,13,4,'Bring the nations to your side\nLet the kingdoms join\nIn shouts of praise\nLet me be the one who brings\nThe one who brings your love');
INSERT INTO page VALUES (9547,20,5,'I give you my heart\nI give you my soul');
INSERT INTO page VALUES (9546,20,4,'Lord I give You my heart\nI give You my soul\nI live for You alone\nEvery breath that I take\nEvery moment I\'m awake\nLord have Your way in me');
INSERT INTO page VALUES (12534,78,2,'Holy one, all creation\ncrowns you King of Kings\nHoly one, King of Kings,\nLord of Lords, Holy one.');
INSERT INTO page VALUES (440,13,2,'I stand before you\nMy heart adores you\nIn your hands I place my life\nI pray, let your will be done');
INSERT INTO page VALUES (439,13,1,'All I am I give to you\nWith every breath I worship you\nI pray, let your will be done');
INSERT INTO page VALUES (700,41,6,'Great are Your works Lord,\nGreat are Your deeds,\nAwesome in power,\nSo awesome to me.');
INSERT INTO page VALUES (836,50,4,'O come, let us adore Him,\nO come, let us adore Him,\nO come, let us adore Him,\nChrist the Lord.');
INSERT INTO page VALUES (827,51,1,'He is the King of Kings\nHe is the Lord of Lord\nHis name is Jesus, \nJesus, Jesus, Jesus\nO, He is King');
INSERT INTO page VALUES (7378,43,1,'I want to be your hands\nAnd be your feet\nLord make me your servant\nI want to tell your love\nTo everyone I meet\nLord make me your servant\n(repeat)');
INSERT INTO page VALUES (11235,3,2,'\'Twas grace that taught \nmy heart to fear,\nand grace my fears relieved;\nHow precious did that grace \nappear the hour I first believed!\n');
INSERT INTO page VALUES (11234,3,3,'Through many dangers, \ntoils and snares I have \nalready come;\n\'Tis grace hath brought \nme safe thus far, \nand grace will lead me home.\n');
INSERT INTO page VALUES (11233,3,1,'Amazing grace! \nHow sweet the sound\nthat saved a wretch like me!\nI once was lost but now am found, \nWas blind but now I see');
INSERT INTO page VALUES (11232,3,4,'When we\'ve been there\nten thousand years,\nbright shining as the sun,\nWe\'ve no less days to \nsing God\'s praise \nthen when we first began.');
INSERT INTO page VALUES (1640,115,4,'Jesus turned our sorrow into dancing\nJesus turned our sorrow into dancing\nChanged our tears of sadness into rivers\nof joy\nJesus turned our sorrow into a dance.');
INSERT INTO page VALUES (1705,117,3,'I will lift my hands\nto the Lord of lords\nAs an offering to Him\nI will lift my life\nto the Lord of lords\nAs an offering to Him');
INSERT INTO page VALUES (1625,114,1,'Everybody ought to know\nEverybody ought to know\nEverybody ought to know\nwho Jesus is. (repeat)\n');
INSERT INTO page VALUES (13717,114,4,'On the cross He died for sinners\nAnd His blood makes white as snow\nLoving living coming Saviour\nHe\'s the one you ought to know');
INSERT INTO page VALUES (12270,8,2,'Now is the time for us to \nmarch upon the land \nInto our hands he will \ngive the ground we claim \nHe rides in majesty \nto lead us into victory \nThe world shall see \nthat Christ is Lord.\n');
INSERT INTO page VALUES (12269,8,7,'Rejoice Rejoice! Christ is in you\nThe hope of glory in our hearts\nHe lives! He lives! His breath is in you\nArise a mighty army, we arise!');
INSERT INTO page VALUES (12268,8,3,'Rejoice Rejoice! Christ is in you\nThe hope of glory in our hearts\nHe lives! He lives! His breath is in you\nArise a mighty army, we arise!');
INSERT INTO page VALUES (12267,8,1,'Rejoice Rejoice! Christ is in you\nThe hope of glory in our hearts\nHe lives! He lives! His breath is in you\nArise a mighty army, we arise!');
INSERT INTO page VALUES (12266,8,4,'God is at work in us\n  his purpose to perform\nBuilding a kingdom of\n  power not of words\nWhere things impossible, \nby faith shall be made possible\nLet\'s give the glory to him now.');
INSERT INTO page VALUES (12265,8,6,'Though we are weak, \nhis grace is everything we need\nWe\'re made of clay. \nBut this treasure is within. \nHe turns our weaknesses \ninto his opportunities\nSo that the glory goes to him.');
INSERT INTO page VALUES (13621,643,5,'Friends will be there I have loved long ago,\nJoy like a river around me will flow,\nYet just a smile from my Saviour I know,\nWill through the ages be glory for me.');
INSERT INTO page VALUES (176,10,2,'When darkness seems to hide His face, \nI rest on His unchanging grace.\nIn every high and stormy gale, \nmy anchor holds within the vale.\n\nOn Christ, the solid Rock, I stand; \nall other ground is sinking sand.\nAll other ground is sinking sand.');
INSERT INTO page VALUES (13620,643,1,'When all my labours and trials are o\'er,\nAnd I am safe on that beautiful shore,\nJust to be near the dear Lord I adore,\nWill through the ages be glory for me.');
INSERT INTO page VALUES (13619,643,3,'When by the gift of His infinite grace,\nI am accorded in heaven a place,\nJust to be there and to look on His face,\nWill through the ages be glory for me.');
INSERT INTO page VALUES (179,10,3,'His oath, His covenant, \nHis blood support me in the whelming flood.\nWhen all around my soul gives way, \nHe then is all my Hope and Stay.\n\nOn Christ, the solid Rock, I stand; \nall other ground is sinking sand.\nAll other ground is sinking sand.');
INSERT INTO page VALUES (13618,643,2,'O that will be glory for me,\nGlory for me, glory for me,\nWhen by His grace\n I shall look on His face,\nThat will be glory, be glory for me.');
INSERT INTO page VALUES (181,10,4,'When He shall come with trumpet sound, \noh, may I then in Him be found;\nDressed in His righteousness alone, \nfaultless to stand before the throne.\n\nOn Christ, the solid Rock, I stand; \nall other ground is sinking sand.\nAll other ground is sinking sand.');
INSERT INTO page VALUES (13617,643,6,'O that will be glory for me,\nGlory for me, glory for me,\nWhen by His grace\n I shall look on His face,\nThat will be glory, be glory for me.');
INSERT INTO page VALUES (13616,643,4,'O that will be glory for me,\nGlory for me, glory for me,\nWhen by His grace\n I shall look on His face,\nThat will be glory, be glory for me.');
INSERT INTO page VALUES (13663,651,1,'With proud thanksgiving,\n a mother for her children,\nAustralia mourns for her\n dead across the sea.\nFlesh of her flesh they were,\n spirit of her spirit,\nFallen in the cause of the free.');
INSERT INTO page VALUES (695,41,1,'Your works Lord, Your works Lord\nAre awesome, are awesome\nYour power, your power\nIs great \n(repeat)');
INSERT INTO page VALUES (1463,35,1,'He is exalted, \nthe King is exalted on high:\nI will praise Him.\nHe is exalted, forever exalted\nAnd I will praise His name');
INSERT INTO page VALUES (670,34,2,'Let us rejoice and be glad\nAnd give the glory unto Him\nHallelujah! for the Lord our God \nthe Almighty reigns.');
INSERT INTO page VALUES (669,34,1,'Hallelujah! For the Lord our God\nthe almighty reigns\nHallelujah! For the Lord our God\nthe almighty reigns');
INSERT INTO page VALUES (11241,31,2,'And now,\nlet the weak say I am strong,\nlet the poor say I am rich,\nBecause of what the Lord\nhas done for us\n(repeat)');
INSERT INTO page VALUES (11240,31,1,'Give thanks with a grateful heart\nGive thanks to the Holy One\nGive thanks because He\'s given\nJesus Christ His Son\n(repeat)');
INSERT INTO page VALUES (659,32,1,'Because He Lives\nI can face tomorrow\nBecause He Lives\nAll fear is gone');
INSERT INTO page VALUES (660,32,2,'Because I know\nHe holds the future\nAnd life is worth the living,\nJust because He lives');
INSERT INTO page VALUES (661,32,3,'Because He Lives\nI can face tomorrow\nBecause He Lives\nAll fear is gone');
INSERT INTO page VALUES (662,32,4,'Because I know\nHe holds the future\nAnd life is worth the living,\nJust because He lives.');
INSERT INTO page VALUES (12519,33,5,'Come and see His hands and His feet,\nThe scars that speak of sacrifice,\nHands that flung stars into space\nTo cruel nails surrendered.');
INSERT INTO page VALUES (12405,28,2,'All you that mourn in Zion\nI have authority\nTo appoint unto you in Zion\nOil of joy that will set you free...');
INSERT INTO page VALUES (12404,28,7,'Put on the garment of praise\nfor the spirit of heaviness\nLift up your voice to God!\n\nPraise with the spirit\nAnd with understanding\nO, magnify the Lord.');
INSERT INTO page VALUES (12403,28,3,'Put on the garment of praise\nfor the spirit of heaviness\nLift up your voice to God!\n\nPraise with the spirit\nAnd with understanding\nO, magnify the Lord.');
INSERT INTO page VALUES (12402,28,1,'Put on the garment of praise\nfor the spirit of heaviness\nLift up your voice to God!\n\nPraise with the spirit\nAnd with understanding\nO, magnify the Lord.');
INSERT INTO page VALUES (12401,28,4,'Lift up the hands that hang down\nLift up the voice now still\nGive unto God continuous praise\nSing forth from Zion\'s hill...\n ');
INSERT INTO page VALUES (12400,28,6,'Sing to Yahweh, alleluia\nWorship and praise our God\nPraise and adore Him,\nbow down before Him\nO, magnify the Lord...');
INSERT INTO page VALUES (11936,11,2,'He has made me glad,\nHe has made me glad\nI will rejoice for He has made me glad\nHe has made me glad,\nHe has made me glad\nI will rejoice for He has made me glad');
INSERT INTO page VALUES (11935,11,1,'I will enter His gates with\nthanksgiving in my heart\nI will enter His courts with praise\nI will say this is the day \nthat the Lord has made\nI will rejoice for He has made me glad');
INSERT INTO page VALUES (818,49,5,'Come and join the celebration,\nIt\'s a very special day;\nCome and share our jubilation,\nThere\'s a new King born today!');
INSERT INTO page VALUES (835,50,3,'Sing, choirs of angels,\nsing in exaltation,\nSing, all ye citizens of\nheaven above;\nGlory to God,\nglory in the highest!');
INSERT INTO page VALUES (791,48,9,'Hark! the herald angels sing,\nGlory to the newborn King!');
INSERT INTO page VALUES (790,48,8,'Risen with healing in his wings.\nLight and life to all he brings,\nHail the Son the Righteousness!\nHail the heaven\n born Prince of Peace!');
INSERT INTO page VALUES (789,48,7,'Mild, He lays His glory by,\nBorn that man no more may die;\nBorn to raise the sons of earth,\nBorn to give them second birth!');
INSERT INTO page VALUES (787,48,5,'Veiled in flesh the Godhead see,\nHail, the incarnate Deity!\nPleased as man with men to dwell,\nJesus our Immanuel!');
INSERT INTO page VALUES (788,48,6,'Hark! the herald angels sing,\nGlory to the newborn King!');
INSERT INTO page VALUES (785,48,3,'Hark! the herald angels sing,\nGlory to the newborn King!');
INSERT INTO page VALUES (786,48,4,'Christ, by highest heaven adored,\nChrist, the everlasting Lord;\nLate in time behold him come,\nOffspring of a virgin\'s womb.');
INSERT INTO page VALUES (783,48,1,'Hark the herald angels sing,\nGlory to the newborn King;\nPeace on earth and mercy mild,\nGod and sinners reconciled.');
INSERT INTO page VALUES (998,55,4,'For lo! the days are hastening on,\nBy prophet-bards foretold,\nWhen with the ever-circling years\nComes round the age of gold;\nWhen peace shall over all the Earth\nIts ancient splendors fling,\nAnd the whole world give back the song\nWhich now the angels sing.');
INSERT INTO page VALUES (5793,261,1,'O God bless our land of Malawi,\nKeep it a land of peace.\nPut down each and every enemy, \nHunger, disease, envy.\nJoin together all our hearts as one,\nThat we be free from fear.\nBless our leader, each and every one,\nAnd Mother Malawi.');
INSERT INTO page VALUES (5905,265,3,'Let us praise God together in the Lord\nLet us praise God together in the Lord\nWhen I fall on my knees,\nWith my face to the rising sun,\nO Lord have mercy on me.');
INSERT INTO page VALUES (4912,44,2,'I love you, I need you\nThough my world may fall\nI\'ll never let you go\nMy saviour, my closest friend\nI will worship you until the very end');
INSERT INTO page VALUES (7379,43,2,'And when you call me servant\nYou really call me friend\nYour love has made me love you\nAnd want to serve you\nMake me the one you send');
INSERT INTO page VALUES (3663,192,2,'Show me the tomb where Thou wast laid,\nTenderly mourned and wept;\nAngels in robes of light arrayed,\nGuarded Thee whilst Thou slept.\n\nLest I forget Gethsemane;\nLest I forget Thine agony;\nLest I forget Thy love for me,\nLead me to Calvary.');
INSERT INTO page VALUES (6345,184,7,'And I see You high and lifted up\nSeated on the throne\nLet Your glory shine upon me now\nI adore You alone');
INSERT INTO page VALUES (3616,189,1,'Come let us join our cheerful songs\nWith angels round the throne;\nTen thousand. thousand are their tongues\nBut all their joys are one.');
INSERT INTO page VALUES (3364,27,7,'I believe, I\'m sanctified, restored\nI believe\nI believe, forgiven and transformed\nI believe');
INSERT INTO page VALUES (3365,27,8,'I believe, I\'m righteous and reformed\nI believe\nI believe, oh yes my God\nI believe');
INSERT INTO page VALUES (3363,27,6,'I\'m singing out\n\'Cause I\'ve heard all the angels say\nI can\'t hold back\n\'Cause I know You will come one day\nI\'m holding on\nHolding on to you');
INSERT INTO page VALUES (3360,27,3,'I believe, I\'m sanctified, restored\nI believe\nI believe, forgiven and transformed\nI believe');
INSERT INTO page VALUES (3362,27,5,'I\'m reaching out\n\'Cause I know there\'s\na better way\nI walk by faith\nI believe in a better day\nI\'m holding on, \nholding on to you');
INSERT INTO page VALUES (3361,27,4,'I believe, I\'m righteous and reformed\nI believe\nI believe, oh yes my God\nI believe');
INSERT INTO page VALUES (3358,27,1,'I\'m reaching out\n\'Cause I know there\'s\na better way\nI walk by faith\nI believe in a better day\nI\'m holding on, \nholding on to you');
INSERT INTO page VALUES (3359,27,2,'I\'m singing out\n\'Cause I\'ve heard all the angels say\nI can\'t hold back\n\'Cause I know You will come one day\nI\'m holding on\nHolding on to you');
INSERT INTO page VALUES (1695,116,6,'All the earth shall worship\nAt the throne of the king\nOf His great and awesome\npower we shall sing.\n(repeat)');
INSERT INTO page VALUES (4646,186,3,'Holy, Holy, Holy\nHoly, Holy, Holy\nHoly, Holy, Holy\nI want to see You\n(repeat)');
INSERT INTO page VALUES (1703,117,1,'I will lift my voice\nto the King of kings\nAs an offering to Him\nI will lift my heart\nto the King of kings\nAs an offering to Him');
INSERT INTO page VALUES (1706,117,4,'Jesus how I love you,\nI will worship, You alone\nJesus precious Jesus,\nI will serve You, You alone');
INSERT INTO page VALUES (9656,25,4,'You\'re my God, Saviour Lord\nYou\'re my God, King of Kings\nYou\'re my God, Prince of peace\n\nAnd all the Earth \nis going to see the \nglory of my God');
INSERT INTO page VALUES (9655,25,3,'And no matter what \nlife can bring\nThis peace in my heart \njust makes me sing');
INSERT INTO page VALUES (9654,25,2,'You healed my body\nReleased my mind\nYou set me free\nto leave the past behind\n\nThe peace and comfort\nof the knowledge of\nGod in my heart');
INSERT INTO page VALUES (1704,117,2,'Jesus how I love you,\nI will worship, You alone\nJesus precious Jesus,\nI will serve You, You alone');
INSERT INTO page VALUES (9653,25,1,'You give me shelter\nYou give me peace\nYou give me comfort\nhealing, release\n\nThe peace and comfort\nof the knowledge of\nGod in my heart');
INSERT INTO page VALUES (3316,23,4,'I\'ve been released\nThe stone\'s been rolled away\nI\'ve been released\nThe stone\'s been rolled away');
INSERT INTO page VALUES (3315,23,3,'I\'ve been delivered\nI\'ve been released\nBeen washed and purified\nMy God has set me free');
INSERT INTO page VALUES (3314,23,2,'And I am free\nThe stone\'s been rolled away\nAnd I am free\nThe stone\'s been rolled away');
INSERT INTO page VALUES (12535,78,5,'Glory to the King of Kings.\nMajesty, power and strength\nto the Lord of Lords.\n(repeat)\n\nPower and strength\nto the Lord of Lords.\n(repeat)');
INSERT INTO page VALUES (12533,78,3,'Glory to the King of Kings\nMajesty, power and strength,\nTo the Lord of Lords.\n(repeat)');
INSERT INTO page VALUES (5575,47,2,'Come to Bethlehem and see,\nHim whose birth the angels sing;\nCome, adore on bended knee,\nChrist the Lord,\n the newborn King;\n\nGloria in excelsis Deo,\nGloria in excelsis Deo!');
INSERT INTO page VALUES (12409,14,1,'Before the heavens we stand\nIn awe of the one we love\nBefore the nations we stand\nTo sing of the Son of God');
INSERT INTO page VALUES (12408,14,6,'How I adore you\nHow I adore, I adore you\nHow I adore you\nHow I adore, I adore you');
INSERT INTO page VALUES (12407,14,3,'Before the heavens we stand\nIn awe of the one we love\nBefore the nations we stand\nTo sing of the Son of God');
INSERT INTO page VALUES (784,48,2,'Joyful, all ye nations, rise,\nJoin the triumph of the skies;\nWith angelic hosts proclaim,\nChrist is born in Bethlehem!');
INSERT INTO page VALUES (3313,23,1,'I\'ve been forgiven\nI\'ve been set free\nRestored and sanctified\nIn Christ I\'ve been set free');
INSERT INTO page VALUES (9417,22,8,'My redeemer lives!');
INSERT INTO page VALUES (9416,22,7,'You lift my burdens\nI\'ll rise with you\nI\'m dancing on this mountain top\nto see your kingdom come!');
INSERT INTO page VALUES (9415,22,6,'My redeemer lives!\nMy redeemer lives!\nMy redeemer lives!\nMy redeemer lives!\n');
INSERT INTO page VALUES (9412,22,3,'My redeemer lives!\nMy redeemer lives!\nMy redeemer lives!\nMy redeemer lives!');
INSERT INTO page VALUES (9413,22,4,'I know He rescued my soul\nHis blood has covered my sins\nI Believe, I Believe.\n\nMy shame He\'s taken away,\nMy pain is healed in His name.\nI Believe, I Believe.\n\n');
INSERT INTO page VALUES (9414,22,5,'I\'ll raise a banner\n\'cause my Lord has \nconquered the grave\n\n');
INSERT INTO page VALUES (9411,22,2,'I\'ll raise a banner\n\'cause my Lord has \nconquered the grave\n');
INSERT INTO page VALUES (9936,18,3,'God is in the house\nThere is no doubt\nGod is in the house\nCan\'t keep Him out\nAs for you (As for you)\nAs for me (As for me)\nWe\'re gonna serve the Lord');
INSERT INTO page VALUES (9934,18,1,'As for me, God came and found me\nAs for me, He took me home\nAs for me, He gave me a family\nAnd I\'ll never walk alone\nIn my life I\'m soaked in blessing\nAnd in heaven there\'s a great reward\nAs for me and my house\nWe\'re gonna serve the Lord');
INSERT INTO page VALUES (5574,47,1,'Angels we have heard on high,\nSweetly singing o\'er the plains,\nAnd the mountains in reply,\nEcho back their joyous strains,\n\nGloria in excelsis Deo,\nGloria in excelsis Deo!');
INSERT INTO page VALUES (817,49,4,'Wise men journey,\nled to worship by a star,\n\nKneel in homage,\nbringing precious gifts from \nlands afar, So...');
INSERT INTO page VALUES (816,49,3,'Come and join the celebration,\nIt\'s a very special day;\nCome and share our jubilation,\nThere\'s a new King born today!');
INSERT INTO page VALUES (814,49,1,'Come and join the celebration,\nIt\'s a very special day;\nCome and share our jubilation,\nThere\'s a new King born today!');
INSERT INTO page VALUES (815,49,2,'See the shepherds hurry \ndown to Bethlehem\n\nGaze in wonder at the Son\nof God who lay before them');
INSERT INTO page VALUES (813,49,7,'Come and join the celebration,\nIt\'s a very special day;\nCome and share our jubilation,\nThere\'s a new King born today!');
INSERT INTO page VALUES (819,49,6,'God is with us,\nround the world the message bring,\nHe is with us,\nWelcome,\nall the bells on earth are peeling');
INSERT INTO page VALUES (7213,52,5,'Every eye shall see,\nEvery heart will know,\nEvery knee shall bow,\nEvery tongue confess;');
INSERT INTO page VALUES (834,50,2,'O come, let us adore Him,\nO come, let us adore Him,\nO come, let us adore Him,\nChrist the Lord.');
INSERT INTO page VALUES (833,50,1,'O come, all ye faithful, \njoyful and triumphant,\nO come, O come ye,\nto Bethlehem,\nCome and behold him,\nBorn the king of angels;');
INSERT INTO page VALUES (837,50,5,'Yea, Lord, we greet thee,\nborn this happy morning,\nJesus to Thee be glory given!\nWord of the father \nnow in flesh appearing;');
INSERT INTO page VALUES (838,50,6,'O come, let us adore Him,\nO come, let us adore Him,\nO come, let us adore Him,\nChrist the Lord.');
INSERT INTO page VALUES (7212,52,4,'The heavens shall declare\nthe glory of His name,\nAll creation bow\nat the coming of the King');
INSERT INTO page VALUES (7211,52,3,'Holy, Holy, Holy is the Lord,\nSee the coming of the King,\nHoly is the Lord.');
INSERT INTO page VALUES (7210,52,2,'Every eye shall see,\nEvery heart will know,\nEvery knee shall bow,\nEvery tongue confess;');
INSERT INTO page VALUES (7209,52,1,'The heavens shall declare\nthe glory of His name,\nAll creation bow\nat the coming of the King');
INSERT INTO page VALUES (1350,53,7,'Then let us all with one accord,\nSing praises to our heavenly lord;\nWho hath made heaven,\nand Earth of nought\nAnd with His blood,\nmankind hath bought');
INSERT INTO page VALUES (1351,53,8,'Noel, Noel, Noel, Noel\nBorn is the King of Israel,');
INSERT INTO page VALUES (1348,53,5,'And by the light of\n that same star,\nThree wise men\n came from country far;\nTo seek for a King\n that was their intent,\nAnd to follow the\n star wherever it went,');
INSERT INTO page VALUES (1349,53,6,'Noel, Noel, Noel, Noel\nBorn is the King of Israel,');
INSERT INTO page VALUES (1346,53,3,'They looked up and saw a star,\nShining in the east,\nBeyond them far;\nAnd to the earth it\n gave great light,\nAnd so it continued\n both day and night');
INSERT INTO page VALUES (1344,53,1,'The First Noel the angel did say,\nWas to certain poor shepherds,\nin fields as they lay;\nIn fields where they lay,\nkeeping their sheep,\nOn a cold winter\'s\n night that was so deep');
INSERT INTO page VALUES (1345,53,2,'Noel, Noel, Noel, Noel\nBorn is the King of Israel,');
INSERT INTO page VALUES (1005,59,1,'Jesus, Stand among us\nAt the meeting of our lives.\nBe our sweet agreement,\nAt the meeting of our eyes.');
INSERT INTO page VALUES (994,54,3,'Silent night, holy night\nSon of God, love\'s pure light \nRadiant beams from Thy holy face \nWith the dawn of redeeming grace\nJesus, Lord at Thy birth.\nJesus, Lord at Thy birth.');
INSERT INTO page VALUES (1347,53,4,'Noel, Noel, Noel, Noel\nBorn is the King of Israel,');
INSERT INTO page VALUES (993,54,2,'Silent night, holy night \nShepherds quake at the sight \nGlories stream from Heaven afar \nHeavenly hosts sing Hallelujah \nChrist the Saviour is born \nChrist the Saviour is born.');
INSERT INTO page VALUES (992,54,1,'Silent night, holy night\nAll is calm, all is bright\nRound yon Virgin\nMother and Child\nHoly infant, so tender and mild\nSleep in heavenly peace\nSleep in heavenly peace.');
INSERT INTO page VALUES (997,55,3,'And ye, beneath life\'s crushing load,\nWhose forms are bending low,\nWho toil along the climbing way\nWith painful steps and slow,\nLook now! for glad and golden hours\nCome swiftly on the wing:\nO rest beside the weary road,\nAnd hear the angels sing!');
INSERT INTO page VALUES (996,55,2,'Still thro\' the cloven skies they come,\nWith peaceful wings unfurled,\nAnd still their heavenly music floats\nO\'er all the weary world:\nAbove its sad and lowly plains\nThey bend on hovering wing,\nAnd ever o\'er its Babel sounds\nThe blessed angels sing.');
INSERT INTO page VALUES (995,55,1,'It came upon the midnight clear,\nThat glorious song of old,\nFrom angels bending near the Earth,\nTo touch their harps of gold:\nPeace on Earth, good will to men,\nFrom heaven\'s all gracious King.\nThe world in solemn stillness lay,\nTo hear the angels sing.');
INSERT INTO page VALUES (12506,2147483647,2,'The cattle are lowing, \nthe baby awakes,\nBut little Lord Jesus \nno crying he makes.\nI love Thee, Lord Jesus! \nlook down from the sky,\nAnd stay by my side\nuntil morning is nigh.');
INSERT INTO page VALUES (12505,2147483647,3,'Be near me, Lord Jesus;\nI ask thee to stay\nClose by me for ever, \nand love me, I pray, \nBless all the dear children\nin thy tender care,\nAnd fit us for heaven \nto live with Thee there.');
INSERT INTO page VALUES (12504,2147483647,1,'Away in a manger, \nNo crib for a bed\nthe little Lord Jesus lay \ndown His sweet head.\nThe stars in the bright sky \nlooked down where He lay.\nThe little Lord Jesus,\nasleep on the hay.');
INSERT INTO page VALUES (1007,59,3,'So to you we\'re gathering\nOut of each and every land\nChrist the love between us\nAt the joining of our hands');
INSERT INTO page VALUES (978,56,3,'Golden day, When we say,\nMerry, merry christmas.\nIn the street, Where we meet,\nMerry, merry, merry christmas.\nAnd with pride, far and wide,\nAll our homes adorning,\nEarth and sky, Sound the cry,');
INSERT INTO page VALUES (977,56,2,'So with joy, Man and boy,\nSing with us together; On this morn,\nChrist was born,\nMerry, Merry, Merry Christmas.\nRaise the song, Loud and strong,\nIn the shining weather, Joy bells ring,\nChrist is King, Merry, merry, merry Christmas.');
INSERT INTO page VALUES (976,56,1,'Sun gleams bright, Hearts are light,\nMerry, merry Christmas.\nBells ring out, Children shout,\nMerry, Merry, Merry Christmas.\nSheep in fold, Shine like gold, As the day is\ndawning, Riding by Stocking men cry,\nWelcome Christmas morning\n');
INSERT INTO page VALUES (12547,57,5,'Thus spake the seraph; \nand forth-with\nAppeared a shining throng\nOf angels praising God on high\nWho thus addressed their song:');
INSERT INTO page VALUES (12546,57,2,'Fear Not, said he for mighty dread\nHad seized their troubled mind\nGlad tidings of great joy I bring\nTo you and all mankind');
INSERT INTO page VALUES (12544,57,1,'While shepherds watched\ntheir flocks by night\nAll seated on the ground\nThe angel of the \nLord came down\nAnd glory shone around');
INSERT INTO page VALUES (12545,57,3,'To you, in Davids \ntown this day\nIs born of Davids line,\nThe Saviour who is \nChrist the Lord\nAnd this shall be the sign:');
INSERT INTO page VALUES (12543,57,4,'The heavenly Babe \nyou there shall find\nTo human view displayed\nAll meanly wrapped \nin swathing bands\nAnd in a manger laid');
INSERT INTO page VALUES (12542,57,6,'All glory be to God on high\nAnd to the earth be peace\nGood will henceforth from\nheaven to men\nBegin and never cease!');
INSERT INTO page VALUES (1001,58,3,'As they offered gifts most rare\nAt the manger rude and bare\nSo may we with holy joy,\nPure and free from sin\'s alloy\nAll our costliest treasures bring\nChrist, to Thee, our heavenly King.');
INSERT INTO page VALUES (1006,59,2,'O Jesus, we love you\nSo we gather here\nJoin our hearts in unity\nand take away our fear.');
INSERT INTO page VALUES (1002,58,4,'Holy Jesus, every day\nKeep us in the narrow way;\nAnd when earthly things are past,\nBring our ransomed souls at last\nWhere they need no star to guide,\nWhere no clouds Thy glory hide.');
INSERT INTO page VALUES (1000,58,2,'As with joyous steps they sped\nTo that lowly manger bed,\nThere to bend the knee before\nHim whom heaven and earth adore\nSo may we with willing feet\nEver seek Thy mercy seat');
INSERT INTO page VALUES (999,58,1,'As with gladness men of old\nDid the guiding star behold\nAs with joy they hailed its light\nLeading onward, beaming bright\nSo, most gracious Lord,\nmay we Evermore be led to thee');
INSERT INTO page VALUES (1008,59,4,'O Jesus, we love you\nSo we gather here\nJoin our hearts in unity\nAnd take away our fear');
INSERT INTO page VALUES (5330,60,2,'With my mouth will I make known\nThy faithfulness, thy faithfulness\nWith my mouth will I make known\nThy faithfulness to all generations.');
INSERT INTO page VALUES (1361,61,1,'Behold what manner of love\nthe Father has given unto us\nBehold what manner of love\nthe Father has given unto us\n\nThat we should be called the\nSons of God\nThat we should be called the\nSons of God');
INSERT INTO page VALUES (1026,65,1,'The Lord thy God in the midst of thee\nIs mighty, is mighty\nHe will save, he will rejoice over thee\nWith joy, with joy\nHe will rest in his love\nHe will joy over thee with singing\nThe Lord thy God in the midst of thee\nIs mighty, is mighty, is mighty');
INSERT INTO page VALUES (1019,62,1,'Now unto him who is able to keep,\nable to keep you from falling.\nAnd present you faultless,\nbefore the presence of his glory,\nwith exceeding joy!');
INSERT INTO page VALUES (1020,62,2,'To the only wise God, \nour Saviour,\nBe glory and Majesty!\nDominion and Power, \nboth now and forever, \nAmen.');
INSERT INTO page VALUES (1075,63,1,'He is Lord, He is Lord,\nHe is risen from the dead\nand He is Lord!\nevery knee shall bow,\nevery tongue confess,\nthat Jesus Christ is Lord.');
INSERT INTO page VALUES (7624,64,2,'Death could not hold Him down,\nfor He is risen!\nSeated upon the throne,\nHe is the Lamb of God!');
INSERT INTO page VALUES (1507,66,7,'We call you now to worship him\nAs Lord of all\nTo have no gods before him\nTheir thrones must fall');
INSERT INTO page VALUES (1508,66,8,'Make way (echo)\nMake way (echo)\nFor the King of kings (echo)\nMake way (echo)\nMake way (echo)\nAnd let his Kingdom in');
INSERT INTO page VALUES (12418,77,5,'Holy, holy, You are worthy,\nPraises to the Son of God,\nJesus You alone are worthy,\nCrowned in righteousness and peace.');
INSERT INTO page VALUES (1506,66,6,'Make way (echo)\nMake way (echo)\nFor the King of kings (echo)\nMake way (echo)\nMake way (echo)\nAnd let his Kingdom in');
INSERT INTO page VALUES (1505,66,5,'And those who mourn with heavy hearts\nWho weep and sigh\nWith laughter joy and royal crown\nHe\'ll beautify');
INSERT INTO page VALUES (1503,66,3,'He comes the broken hearts to heal\nThe prisoners to free\nThe deaf shall hear, the lame shall dance\nThe blind shall see');
INSERT INTO page VALUES (1504,66,4,'Make way (echo)\nMake way (echo)\nFor the King of kings (echo)\nMake way (echo)\nMake way (echo)\nAnd let his Kingdom in');
INSERT INTO page VALUES (1502,66,2,'Make way (echo)\nMake way (echo)\nFor the King of kings (echo)\nMake way (echo)\nMake way (echo)\nAnd let his Kingdom in');
INSERT INTO page VALUES (1501,66,1,'Make way, make way for Christ the King\nIn splendour arrives\nFling wide the gates and welcome him\nInto your lives');
INSERT INTO page VALUES (12195,67,2,'The Lord liveth\nAnd blessed be my rock\nAnd let the God of my \nsalvation be exalted\nThe Lord liveth\nAnd blessed be my rock\nAnd let the God of my \nsalvation be exalted');
INSERT INTO page VALUES (9430,68,2,'Build your Church, Lord\nMake us strong, Lord\nJoin our hearts, Lord\nThrough your Son\nMake us one, Lord\nIn your Body\nIn the kingdom of your Son');
INSERT INTO page VALUES (9429,68,1,'For I\'m building a people of power\nAnd I\'m making a people of praise\nThat will move through this land\n     by my Spirit\nAnd will glorify my precious name');
INSERT INTO page VALUES (3473,182,5,'This is how we overcome');
INSERT INTO page VALUES (3156,69,4,'It doesn\'t depend on the circumstance,\nThe strength of my arm or my voice.\nIt doesn\'t depend on the way I feel.\nI\'ve made up my mind\nAnd I\'m gonna rejoice!');
INSERT INTO page VALUES (3157,69,5,'I will rejoice,\nI will rejoice,\nI will rejoice,\nfor I\'ve made my choice\nTo rejoice in the Lord\n(Repeat)');
INSERT INTO page VALUES (3155,69,3,'I will rejoice,\nI will rejoice,\nI will rejoice,\nfor I\'ve made my choice\nTo rejoice in the Lord\n(Repeat)');
INSERT INTO page VALUES (9023,336,6,'And I will climb this mountain\nAnd I step off the shore\nAnd I have chosen to follow\nAnd be by Your side forever more');
INSERT INTO page VALUES (9022,336,5,'Do Your will, have Your way\nBe Lord God in this place\nOh I want Your will to be done');
INSERT INTO page VALUES (8690,70,1,'Lord, for the years your \nlove has kept and guided\nurged and inspired us, \ncheered us on our way,\nsought us and saved us, \npardoned and provided:\nLord of the years, \nwe bring our thanks today.');
INSERT INTO page VALUES (8691,70,2,'Lord, for that word, \nthe word of life which fires us,\nspeaks to our hearts\nand sets our souls ablaze,\nteaches and trains, \nrebukes us and inspires us:\nLord of the word, \nreceive your people\'s praise.');
INSERT INTO page VALUES (8692,70,3,'Lord, for our land, \nin this our generation,\nspirits oppressed by pleasure, \nwealth and care:\nfor young and old, \nfor commonwealth and nation,\nLord of our land, \nbe pleased to hear our prayer.');
INSERT INTO page VALUES (1105,71,5,'Perfect submission,\nall is at rest,\nI in my Saviour\nam happy and blest:\nWatching and waiting,\nlooking above,\nFill\'d with His goodness,\nlost in His love');
INSERT INTO page VALUES (1106,71,6,'This is my story,\nthis is my song\nPraising my Saviour\nall the day long\n(repeat)');
INSERT INTO page VALUES (1104,71,4,'This is my story,\nthis is my song\nPraising my Saviour\nall the day long\n(repeat)');
INSERT INTO page VALUES (1102,71,2,'This is my story,\nthis is my song\nPraising my Saviour\nall the day long\n(repeat)');
INSERT INTO page VALUES (1103,71,3,'Perfect Submission,\nperfect delight,\nVisions of rapture\nnow burst on my sight:\nAngels descending\nbring from above\nEchoes of mercy,\nwhispers of love.');
INSERT INTO page VALUES (1082,72,1,'All for Jesus, all for Jesus!\nThis our song shall ever be:\nYou our only hope, our Saviour,\nYour\'s the love that sets us free!');
INSERT INTO page VALUES (1083,72,2,'All for Jesus: you will give us\nStrength to serve you hour by hour:\nNone can move us from your presence\nWhile we trust your grace and power.');
INSERT INTO page VALUES (1084,72,3,'All for Jesus you have loved us,\nAll for Jesus you have died,\nAll for Jesus you are with us;\nAll for Jesus crucified.\n');
INSERT INTO page VALUES (1085,72,4,'All for Jesus, all for Jesus,\nAll our talents and our powers,\nAll our thoughts and words and actions,\nAll our passing days and hours.');
INSERT INTO page VALUES (1086,72,5,'All for Jesus, all for Jesus!\nThis our Church\'s song shall be\nTill at last her children gather,\nOne in Him eternally.');
INSERT INTO page VALUES (1514,107,1,'Ev\'ry day with Jesus\nIs sweeter than the day before,\nEv\'ry day with Jesus\nI love Him more and more;\nJesus saves and keeps me,\nAnd He\'s the One I\'m waiting for;\nEv\'ry day with Jesus\nIs sweeter than the day before,');
INSERT INTO page VALUES (1626,105,1,'My Lord knows the way thro\' the wilderness,\nall I have to do is follow.\nMy Lord knows the way thro\' the wilderness,\nall I have to do is follow.\n\nStrength for today is mine all the way,\nand all I need for tomorrow.\nMy Lord knows the way thro\' the wilderness,\nall I have to do is follow.');
INSERT INTO page VALUES (1513,106,1,'I may never march in the infantry,\nRide in the Calvary,\nShoot the artillery;\nI may never fly o\'er the enemy,\nBut I\'m in the Lord\'s army.\nI\'m in the Lord\'s army,\nI\'m in the Lord\'s army!');
INSERT INTO page VALUES (7920,124,2,'Your Righteousness\nIs like the mighty mountains\nYour Justice flows\nLike the ocean\'s tide');
INSERT INTO page VALUES (1101,71,1,'Blessed assurance,\nJesus is mine!\nOh What a foretaste\nof glory divine!\nHeir of salvation,\npurchase of God,\nBorn of His spirit,\nwash\'d in His Blood.');
INSERT INTO page VALUES (4191,118,2,'So blessed I can\'t contain it\nSo much I\'ve got to give it away\nYour love has tought\nme to live now\nYou are more than enough for me\n');
INSERT INTO page VALUES (10656,74,2,'Every tongue in heaven and \nEarth shall declare your glory,\nEvery knee shall bow at your \nthrone in worship\nYou will be exalted oh God,\nand your kingdom shall not \npass away,\nO Ancient of Days');
INSERT INTO page VALUES (10654,74,1,'Blessing and honour, glory and power,\nBe unto the Ancient of Days\nFrom every nation, all of creation,\nBow before the Ancient of Days\n(repeat)');
INSERT INTO page VALUES (10655,74,3,'Blessing and honour, glory and power,\nBe unto the Ancient of Days\nFrom every nation, all of creation,\nBow before the Ancient of Days');
INSERT INTO page VALUES (1540,111,1,'Don\'t you know that I formed you?\nBefore you were born I knew you.\nCan\'t you see that my\n plans for you are good?\n(Repeat)');
INSERT INTO page VALUES (1352,75,1,'Love the Lord your God,\nwith all your heart and \nall your soul and all your mind,\nand love for all mankind as you would\nlove yourself and..');
INSERT INTO page VALUES (1353,75,2,'Love the Lord your God\nwith all your heart and \nall your soul and mind\nand love for mankind.');
INSERT INTO page VALUES (1354,75,3,'We\'ve got Christian lives to live\nWe\'ve got Jesus\' love to give\nWe\'ve got nothing to hide\nbecause in him we abide Love.');
INSERT INTO page VALUES (2476,76,3,'Lord, I lift your name on high;\nLord, I love to sing your praises.\nI\'m so glad You\'re in my life;\nI\'m so glad You came to save us.');
INSERT INTO page VALUES (2475,76,2,'You came from heaven to Earth\nTo show the way;\nFrom the Earth to the cross,\nMy debt to pay.\nFrom the cross to the grave,\nFrom the grave to the sky;\nLord, I lift your name on high\n');
INSERT INTO page VALUES (2474,76,1,'Lord, I lift your name on high;\nLord, I love to sing your praises.\nI\'m so glad You\'re in my life;\nI\'m so glad You came to save us.');
INSERT INTO page VALUES (10653,74,4,'Every tongue in heaven and \nEarth shall declare your glory,\nEvery knee shall bow at your \nthrone in worship\nYou will be exalted oh God,\nand your kingdom shall not \npass away,\nO Ancient of Days');
INSERT INTO page VALUES (10652,74,6,'Every tongue in heaven and \nEarth shall declare your glory,\nEvery knee shall bow at your \nthrone in worship\nYou will be exalted oh God,\nand your kingdom shall not \npass away,\n\nO Ancient of Days! (x3)');
INSERT INTO page VALUES (2477,76,4,'You came from heaven to Earth\nTo show the way;\nFrom the Earth to the cross,\nMy debt to pay.\nFrom the cross to the grave,\nFrom the grave to the sky;\nLord, I lift your name on high\n(repeat)');
INSERT INTO page VALUES (12417,77,2,'Holy, holy, You are worthy,\nPraises to the Son of God,\nJesus You alone are worthy,\nCrowned in righteousness and peace.');
INSERT INTO page VALUES (12416,77,3,'Glory, glory, hallelujah,\nPraises to the Great I Am.\nHosanna, join with angels singing,\nworthy is the Lamb of God.');
INSERT INTO page VALUES (4190,118,1,'More than I could\nHope or Dream of\nYou have poured\nYour favour on me\nOne day in the\nHouse of God is\nBetter than a thousand\nDays in the world\n');
INSERT INTO page VALUES (12531,78,4,'Jesus, Lord with eyes unveiled\nwe will see Your throne.\nJesus, Prince of Peace,\nSon of God, Emmanuel.');
INSERT INTO page VALUES (12532,78,1,'Glory to the King of Kings\nMajesty, power and strength,\nTo the Lord of Lords.\n(repeat)');
INSERT INTO page VALUES (1333,79,5,'True image of the Infinite,\nwhose essence is concealed;\nBrightness of uncreated light;\nThe heart of God revealed:\n');
INSERT INTO page VALUES (1336,79,8,'Worthy, O Lamb of God, art Thou \nThat ev\'ry knee to Thee should bow');
INSERT INTO page VALUES (1337,79,9,'Throughout the universe of bliss,\nThe centre Thou and sun;\nTh\'eternal theme of praise in this,\nTo heav\'n\'s beloved One:\n');
INSERT INTO page VALUES (1335,79,7,'But the high myst\'ries of thy name\nAn angel\'s grasp trancent;\nThe Father only, glorious, claim.\nThe Son can comprehend:');
INSERT INTO page VALUES (1334,79,6,'Worthy, O Lamb of God, art Thou \nThat ev\'ry knee to Thee should bow');
INSERT INTO page VALUES (1332,79,4,'Worthy, O Lamb of God, art Thou \nThat ev\'ry knee to Thee should bow');
INSERT INTO page VALUES (1331,79,10,'Worthy, O Lamb of God, art Thou \nThat ev\'ry knee to Thee should bow');
INSERT INTO page VALUES (1330,79,3,'In The most perfectly expressed\nThe Father\'s glories shine;\nOf the full Deity possessed,\nEternally Divine:');
INSERT INTO page VALUES (1329,79,2,'Worthy, O Lamb of God, art Thou \nThat ev\'ry knee to Thee should bow');
INSERT INTO page VALUES (8901,80,6,'Praise the Lord, Praise the Lord,\nLet the Earth hear His voice!\nPraise the Lord, Praise the Lord,\nLet the people rejoice!\nO come to the Father,\nthro\' Jesus the Son,\nAnd give Him the Glory,\nGreat things He has done.');
INSERT INTO page VALUES (8900,80,5,'Great things He has taught us, \ngreat things He has done, \nAnd great our rejoicing \nthro\' Jesus the Son; \nBut purer, and higher, \nand greater will be\nOur wonder, our transport, \nwhen Jesus we see.');
INSERT INTO page VALUES (8899,80,4,'Praise the Lord, Praise the Lord,\nLet the Earth hear His voice!\nPraise the Lord, Praise the Lord,\nLet the people rejoice!\nO come to the Father,\nthro\' Jesus the Son,\nAnd give Him the Glory,\nGreat things He has done.');
INSERT INTO page VALUES (8898,80,3,'O perfect redemption,\nthe purchase of blood,\nTo ev\'ry believer the \npromise of God;\nThe vilest offender \nwho truly believes,\nThat moment from Jesus\na pardon receives.');
INSERT INTO page VALUES (8897,80,2,'Praise the Lord, Praise the Lord,\nLet the Earth hear His voice!\nPraise the Lord, Praise the Lord,\nLet the people rejoice!\nO come to the Father,\nthro\' Jesus the Son,\nAnd give Him the Glory,\nGreat things He has done.');
INSERT INTO page VALUES (8896,80,1,'To God be the glory, \ngreat things He has done;\nSo loved He the world \nthat He gave us His Son;\nWho yielded his life an\natonement for sin,\nAnd opened the life gate \nthat all may go in.');
INSERT INTO page VALUES (1263,82,2,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1262,82,1,'I will sing, I will sing a song unto the Lord. \nI will sing, I will sing a song unto the Lord.\nI will sing, I will sing a song unto the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1264,82,3,'We will come, we will come as one before the Lord.\nWe will come, we will come as one before the Lord.\nWe will come, we will come as one before the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1265,82,10,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1266,82,4,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1267,82,11,'In his name, In his name we have the victory.\nIn his name, In his name we have the victory.\nIn his name, In his name we have the victory.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1268,82,5,'If the Son, if the Son shall make you free\nIf the Son, if the Son shall make you free\nIf the Son, if the Son shall make you free\nYou shall be free indeed.');
INSERT INTO page VALUES (1269,82,12,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1270,82,6,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1271,82,7,'They that sow in tears shall reap in joy.\nThey that sow in tears shall reap in joy.\nThey that sow in tears shall reap in joy.\nAleluia, Glory to the Lord.\n');
INSERT INTO page VALUES (1272,82,8,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1273,82,9,'Every knee shall bow and ev\'ry tounge confess,\nEvery knee shall bow and ev\'ry tounge confess,\nEvery knee shall bow and ev\'ry tounge confess,\nThat Jesus Christ is Lord.');
INSERT INTO page VALUES (1289,83,6,'You\'re a father to the fatherless\nThe answer to my dreams\nI see you crowned in righteousness\nWe cry glory to the King\nComforter to the lonely\nThe lifter of my head\nI see you veiled in majesty\nWe cry glory, glory\nWe cry glory to the king');
INSERT INTO page VALUES (1288,83,5,'Open my ears\nLet me hear your voice\nTo know that sweet sound\nOh my soul rejoice\nGlory, glory\nI hear the angels sing');
INSERT INTO page VALUES (1287,83,4,'Lord my heart cries out\nGlory to the King\nMy greatest love in life\nI hand you everything\nGlory, glory\nI hear the angels sing');
INSERT INTO page VALUES (1286,83,3,'You\'re a father to the fatherless\nThe answer to my dreams\nI see you crowned in righteousness\nWe cry glory to the King\nComforter to the lonely\nThe lifter of my head\nI see you veiled in majesty\nWe cry glory, glory\nWe cry glory to the king\n(repeat)');
INSERT INTO page VALUES (1284,83,1,'Lord my heart cries out\nGlory to the King\nMy greatest love in life\nI hand you everything\nGlory, glory\nI hear the angels sing');
INSERT INTO page VALUES (1285,83,2,'Open my ears\nLet me hear your voice\nTo know that sweet sound\nOh my soul rejoice\nGlory, glory\nI hear the angels sing');
INSERT INTO page VALUES (1306,84,3,'Thank you Lord for loving us.\nThank you Lord for loving us.\nThank you Lord for loving us,\nright where we are.');
INSERT INTO page VALUES (1305,84,2,'Alleluia, praise the Lord.\nAlleluia, praise the Lord.\nAlleluia, praise the Lord,\nright where we are.');
INSERT INTO page VALUES (1304,84,1,'Thank you, Lord, for this fine day.\nThank you, Lord, for this fine day.\nThank you, Lord, for this fine day.\nright where we are.');
INSERT INTO page VALUES (1291,85,1,'Turn your eyes upon Jesus\nLook full in His wonderful face;\nAnd the things of Earth will grow\nstrangely dim,\nIn the light of His glory and grace.');
INSERT INTO page VALUES (1292,86,1,'I know a fount where sins are washed away,\nI know a place where night is turned to day;\nBurdens are lifted, blind eyes made to see;\nTheres a wonder working power in the\nblood of Calvary.');
INSERT INTO page VALUES (1328,79,1,'Thou art the Everlasting word,\nThe Father\'s only Son;\nGod manifestly seen and heard,\nAnd Heaven\'s beloved One:');
INSERT INTO page VALUES (1303,87,1,'Oh, how I love Him, this man of Gallilee;\nOh, how I love Him, He died on Calvary;\nOh, how I love Him, He\'s done so much for me;\nOh, how I love Him, and He loves me.\n');
INSERT INTO page VALUES (1307,84,4,'Thank you Lord for giving us peace,\nThank you Lord for giving us peace,\nThank you Lord for giving us peace,\nright where we are.');
INSERT INTO page VALUES (1367,88,1,' will sing, I will sing a song unto the Lord. \nI will sing, I will sing a song unto the Lord.\nI will sing, I will sing a song unto the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1368,88,2,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1369,88,3,'We will come, we will come as one before the Lord.\nWe will come, we will come as one before the Lord.\nWe will come, we will come as one before the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1370,88,10,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1371,88,4,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1372,88,11,'In his name, In his name we have the victory.\nIn his name, In his name we have the victory.\nIn his name, In his name we have the victory.\nAleluia, Glory to the Lord.\n');
INSERT INTO page VALUES (1373,88,5,'If the Son, if the Son shall make you free\nIf the Son, if the Son shall make you free\nIf the Son, if the Son shall make you free\nYou shall be free indeed.');
INSERT INTO page VALUES (1374,88,12,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1375,88,6,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1376,88,7,'They that sow in tears shall reap in joy.\nThey that sow in tears shall reap in joy.\nThey that sow in tears shall reap in joy.\nAleluia, Glory to the Lord.\n');
INSERT INTO page VALUES (1377,88,8,'Alelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAlelu, aleluia, Glory to the Lord.\nAleluia, Glory to the Lord.');
INSERT INTO page VALUES (1378,88,9,'Every knee shall bow and ev\'ry tounge confess,\nEvery knee shall bow and ev\'ry tounge confess,\nEvery knee shall bow and ev\'ry tounge confess,\nThat Jesus Christ is Lord.\n');
INSERT INTO page VALUES (1379,89,1,'Glory, Jesus, glory,\nYou do the fighting for me.\nPraise you Jesus, praise you,\nWith you there\'s always victory.\nYou are of God, little children,\nand have over come them,\nFor greater is He that is in you,\nthan he that is in the world.');
INSERT INTO page VALUES (1380,90,1,'Your hand O god has guided\nYour flock from age to age;\nThe wondrous tale is written,\nFull clear on every page.\nOur fathers owned your goodness,\nAnd we their deeds record,\nAnd both of these bear witness,\nOne Church, one Faith, one Lord.');
INSERT INTO page VALUES (1381,90,2,'Through many a day of darkness,\nThrough many a scene of strife,\nThe faithful few fought bravely\nTo guard the nation\'s life.\nTheir Gospel of redemption,\nSin pardoned, man restored.\nWas all in this enfolded,\nOne Church, one Faith, one Lord.\n');
INSERT INTO page VALUES (1382,90,3,'Your mercy will not fail us,\nNor leave your work undone;\nWith your right hand to help us,\nYour victory will be won.\nAnd then, by men and angels,\nYour name shall be adored,\nAnd this shall be their anthem,\nOne Church, one Faith, one Lord.');
INSERT INTO page VALUES (1431,91,3,'And I will run to You\nTo Your words of truth\nNot by might, not by power\nBut by the Spirit of God\nYes I will run the race\n\'Til I see Your face\nOh let me live in the \nglory of Your grace.');
INSERT INTO page VALUES (1430,91,2,'You call me to Your purpose\nAs angels understand\nFor Your glory\nMay You draw all men\nAs Your love and grace demands');
INSERT INTO page VALUES (1429,91,1,'Your Eye is on the sparrow\nAnd Your Hand, It comforts me\nFrom the ends of the earth\nTo the depths of my heart\nLet Your mercy and strength be seen');
INSERT INTO page VALUES (6593,92,6,'We Praise the Lord with our voices\nWe Praise the Lord with our hearts\nWe Praise the Lord with all our strength\nAnd everything else that we\'ve got\nWe praise His name with dancing\nWe praise His name with the drums\nCome on and lift up Jesus\' name\n\'Til the day He comes!');
INSERT INTO page VALUES (6592,92,5,'Your People sing praises,\nLet laughter fill the world.\nYour People sing praises,\nLet love and faith be heard.\nJesus came to the Rescue,\nAnd we\'re the reason He came.\nSo come on lift up a mighty voice,\n\'Til Jesus comes again.');
INSERT INTO page VALUES (6591,92,4,'Your People sing praises,\nLet laughter fill the world.\nYour People sing praises,\nLet love and faith be heard.\nThe power of death has been shattered,\nAnd Jesus ever will reign.\nSo come on lift up a mighty voice,\n\'Til Jesus comes again.');
INSERT INTO page VALUES (6590,92,3,'We Praise the Lord with our voices\nWe Praise the Lord with our hearts\nWe Praise the Lord with all our strength\nAnd everything else that we\'ve got\nWe praise his name with dancing\nWe praise His name with the drums\nCome on and lift up Jesus\' name\n\'Til the day He comes!');
INSERT INTO page VALUES (6589,92,2,'Your People sing praises,\nLet laughter fill the world.\nYour People sing praises,\nLet love and faith be heard.\nJesus came to the Rescue,\nAnd we\'re the reason He came.\nSo come on lift up a mighty voice,\n\'Til Jesus comes again.');
INSERT INTO page VALUES (6588,92,1,'Your People sing praises,\nLet laughter fill the world.\nYour People sing praises,\nLet love and faith be heard.\nThe power of death has been shattered,\nAnd Jesus ever will reign.\nSo come on lift up a mighty voice,\n\'Til Jesus comes again.');
INSERT INTO page VALUES (1393,93,1,'Father of life\nDraw me closer\nLord my heart is set on You\nLet me run the race of time\nWith Your life enfolding mine\nAnd let the peace of God\nLet it reign');
INSERT INTO page VALUES (1394,93,3,'Oh Holy Spirit\nLord, my comfort\nStrenghten me, hold my head up high\nAnd I stand upon Your Truth\nBringing glory unto You\nAnd let the peace of God\nLet it reign');
INSERT INTO page VALUES (1395,93,2,'Oh Lord I hunger\nFor more of You\nRise up within me\nLet me know Your Truth');
INSERT INTO page VALUES (1396,93,4,'Oh Lord I hunger\nFor more of You\nRise up within me\nLet me know Your Truth');
INSERT INTO page VALUES (1397,93,5,'Oh Holy spirit, saturate my soul\nAnd let the life of God\nFill me now\nLet Your healing power\nBreathe life and make me whole\nAnd let the peace of God\nLet it reign.');
INSERT INTO page VALUES (1398,93,6,'Oh Lord I hunger\nFor more of You\nRise up within me\nLet me know Your Truth');
INSERT INTO page VALUES (6117,94,3,'Jesus, what a beautiful name\nRescued my soul, my stronghold\nLifts me from shame\nForgiveness, security, power and love\nGrace that blows all fear away\nJesus what a beautiful name');
INSERT INTO page VALUES (6116,94,2,'Jesus, what a beautiful name\nTruth revealed, my future sealed\nHealed my pain\nLove and freedom, life and warmth\nGrace that blows all fear away\nJesus, what a beautiful name');
INSERT INTO page VALUES (6115,94,1,'Jesus, what a beautiful name\nSon of God, Son of Man\nLamb that was slain\nJoy and peace, strength and hope,\nGrace that blows all fear away\nJesus, what a beautiful name');
INSERT INTO page VALUES (8289,95,4,'When Mountains fall I\'ll stand\nBy the power of Your hand\nAnd in Your heart of hearts I\'ll dwell\nAnd that my soul knows very well.');
INSERT INTO page VALUES (8288,95,3,'Joy and strength each day I\'ll find\nAnd that my soul knows very well\nForgiveness, hope, I know is mine\nAnd that my soul knows very well.');
INSERT INTO page VALUES (8287,95,2,'When Mountains fall I\'ll stand\nBy the power of Your hand\nAnd in Your heart of hearts I\'ll dwell\nAnd that my soul knows very well.\n(repeat)');
INSERT INTO page VALUES (8286,95,1,'You make Your face to shine on me\nAnd that my soul knows very well\nYou lift me up, I\'m cleansed and free\nAnd that my soul knows very well.');
INSERT INTO page VALUES (1407,96,1,'My heart sings praises\nEach time I say Your name\nThis love is deeper\nThan simple words can say\nYou go before me\nYou make a perfect way\nMy one desire\nIs to give You perfect praise');
INSERT INTO page VALUES (1408,96,2,'In my heart\nYou are the power\nIn my night\nNever failing light\nWith every\nbreath that I take\nI\'ll declare the\nthings You\'ve done');
INSERT INTO page VALUES (1409,96,3,'In my mind\nMighty overcomer\nIn my soul\nThe reason why\nIn my life\nYou are the fire\nthat calls me on');
INSERT INTO page VALUES (1410,96,4,'And in my mind\nMighty overcomer\nIn my soul\nThe reason why\nIn my life\nYou are the fire\nthat calls me on');
INSERT INTO page VALUES (1411,97,1,'We\'re a generation\nSaved by grace and set apart\nTo change this land\n\nWe\'re standing strong and pressing on\nWe know in Jesus Christ we can\n\nThe Church of God is growing everyday\nWe\'re taking ground');
INSERT INTO page VALUES (1412,97,2,'And we are steppin\' out\n(Change our generation)\nWe\'re steppin\' out\n(Reaching every nation)\nWith the favour of God on us\nDay by Day, we\'re moving on in every way\nWe\'re steppin out');
INSERT INTO page VALUES (1413,97,3,'We\'re the chosen few\nWho speak His Word\nAnd manifest it in our lives\n\nWe\'re not moved by what the world says\nGod Jesus on our side\n\nWe\'re not dismayed\nby what we\nsee with our eyes\nWe walk by faith');
INSERT INTO page VALUES (12390,98,3,'(We\'ve got peace)\nIt\'s like a river\nAnd you\'ll never run it dry\nWe\'ve got power over fear and death\nAnd hearts filled up with joy');
INSERT INTO page VALUES (12389,98,1,'I\'ve found a friend O such a friend\nHe made my heart His home\nGod Himself is with me\nAnd I know I\'m never alone\nI know all my tomorrows will be\nbetter than all my hopes\nWe\'ve got love, grace, peace and power\nAnd joy in the Holy Ghost');
INSERT INTO page VALUES (12387,98,6,'(We\'ve got peace)\nIt\'s like a river\nAnd you\'ll never run it dry\nWe\'ve got power over fear and death\nAnd hearts filled up with joy');
INSERT INTO page VALUES (12388,98,4,'The Holy Spirit fills me up\nAnd I need him every day\nFor fire, faith and confidence\nAnd knowing what to say\nI gave my heart and all that I am\nTo the one who loves me most\nWe\'ve got love, grace, peace and power\nAnd joy in the Holy Ghost');
INSERT INTO page VALUES (6285,102,6,'Take my love; my Lord, I pour\nAt Thy feet its treasure store:\nTake myself, and I will be\nEver, only, all, for Thee.');
INSERT INTO page VALUES (9651,99,5,'And now this love of Christ\nShall flow like rivers\nCome wash your guilt away,\nlive again!');
INSERT INTO page VALUES (9652,99,6,'Amazing Love, O what sacrifice,\nThe Son of God giv\'n for me.\nMy debt He pays and my death\n   He dies.\nThat I might live, that I might live');
INSERT INTO page VALUES (9650,99,4,'Amazing Love, O what sacrifice,\nThe Son of God giv\'n for me.\nMy debt He pays and my death\n   He dies.\nThat I might live, that I might live');
INSERT INTO page VALUES (9649,99,3,'And so they watched Him die,\ndespised, rejected\nBut oh the blood He shed flowed\nfor me!');
INSERT INTO page VALUES (9647,99,1,'My Lord, what love is this\nThat pays so dearly that I,\nthe guilty one, may go free!');
INSERT INTO page VALUES (9648,99,2,'Amazing Love, O what sacrifice,\nThe Son of God giv\'n for me.\nMy debt He pays and my death\n   He dies.\nThat I might live, that I might live');
INSERT INTO page VALUES (1500,100,1,'He gave me beauty for ashes\nThe oil of joy for mourning\nThe garment of praise for the\nspirit of heaviness\nThe we might be trees of \nrighteousness\nThe planting of the Lord\nThat he might be glorified');
INSERT INTO page VALUES (1477,101,4,'Angels, help us to adore him;\nYe behold him face to face;\nSun and moon, bow down before him,\nDwellers all in time and space,\n\nPraise him, praise him,\nPraise him, Praise him,\nPraise with us the God of grace.');
INSERT INTO page VALUES (1476,101,3,'Father-like, he tends and spares us;\nWell our feeble frame he knows;\nIn his hands he gently bears us,\nRescues us from all our foes;\n\nPraise him, praise Him,\nPraise him, praise him,\nWidely as his mercy flows.');
INSERT INTO page VALUES (1475,101,2,'Praise him for his grace and favour\nTo our fathers in distress;\nPraise him, still the same for ever,\nSlow to chide, and swift to bless;\n\nPraise him, praise him,\nPraise him, praise him,\nGlorious in his faithfulness.');
INSERT INTO page VALUES (1474,101,1,'Praise, my soul, the King of heaven,\nTo his Feet thy tribute bring;\nRansomed, healed, restored, forgiven,\nWho like thee, his praise should sing?\n\nPraise him, praise him,\nPraise him, praise him,\nPraise the everlasting King.');
INSERT INTO page VALUES (6284,102,5,'Take my will, and make it Thine;\nIt shall be no longer mine:\nTake my heart, it is Thine own;\nIt shall be Thy royal throne.');
INSERT INTO page VALUES (6283,102,4,'Take my silver, and my gold,\nNot a mite would I with-hold;\nTake my intelect, and use\nEv\'ry pow\'r as Thou shalt choose.');
INSERT INTO page VALUES (6282,102,3,'Take my voice, and let me sing\nAlways, only, for my King;\nTake my lips, and let them be\nFilled with messages from Thee.');
INSERT INTO page VALUES (6281,102,2,'Take my hands, and let them move\nAt the impulse of Thy love;\nTake my feet, and let them be\nSwift and beautiful for Thee.');
INSERT INTO page VALUES (6280,102,1,'Take my life, And let it be \nConsecrated, Lord, to Thee;\nTake my moments and my days,\nLet them flow in cease-less praise.');
INSERT INTO page VALUES (1511,103,3,'When I tread the verge of Jordan,\nBid my anxious fears subside;\nDeath of death, and hell\'s destruction,\nLand me safe on Canaan\'s side;\nSongs of praises, songs of praises,\nI will ever give to You (give to You)\nI will ever give to You.');
INSERT INTO page VALUES (1510,103,2,'Open now the crystal fountain,\nWhere the healing stream does flow;\nLet the fire and cloudy pillar\nLead me all my journey through;\nStrong Deliverer, strong Deliverer,\nBe Thou still my strength and\nshield (strength and shield)\nBe Thou still my strength and shield.');
INSERT INTO page VALUES (1509,103,1,'Guide me, O thou great Jehovah,\nPilgrim through this barren land;\nI am weak, but You Are mighty;\nHold me with Your powerful hand;\nBread of heaven, Bread of heaven,\nFeed me till I want no\nmore (want no more)\nFeed me till I want no more.');
INSERT INTO page VALUES (1525,104,3,'A glorious band, the chosen few\nOn whom the spirit came,\nTwelve valient saints, their hope they knew,\nAnd mocked the cross and flame;\nThey climbed the steep ascent of heaven\nThrough peril, toil, and pain:\nO God, to us may grace be given\nTo follow in their train!');
INSERT INTO page VALUES (1524,104,2,'The martyr first, whose eagle eye\nCould pierce behind the grave,\nWho saw his master in the sky,\nAnd called on him to save:\nLike him, with pardon on his tongue,\nIn midst of mortal pain,\nHe prayed for them that did the wrong:\nWho follows in his train?');
INSERT INTO page VALUES (1523,104,1,'The Son of God goes forth to war,\nA kingly crown to gain;\nHis blood-red banner, streams afar;\nWho follows in his train?\nWho can drink his cup of woe,\nTriumphant over pain,\nWho patient bears his cross below,\nHe follows in his train.');
INSERT INTO page VALUES (1630,108,4,'On His word I\'m feeding, I shall not be moved;\nHe\'s the One that\'s leading, I shall not be moved,\nJust like a tree that planted by the waters, Lord,\nI shall not be moved, I shall not be, \nI shall not be moved;\nI shall not be, I shall not be moved;\nJust like a tree that planted by the waters, Lord,\nI shall not be moved (be moved).');
INSERT INTO page VALUES (1629,108,3,'If I trust Him ever, I shall not be moved;\nHe will fail me never, I shall not be moved,\nJust like a tree that planted by the waters, Lord,\nI shall not be moved, I shall not be, \nI shall not be moved;\nI shall not be, I shall not be moved;\nJust like a tree that planted by the waters, Lord,\nI shall not be moved (be moved).');
INSERT INTO page VALUES (1628,108,2,'In my Christ abiding, I shall not be moved;\nIn His love I\'m hiding, I shall not be moved,\nJust like a tree that planted by the waters, Lord,\nI shall not be moved, I shall not be, \nI shall not be moved;\nI shall not be, I shall not be moved;\nJust like a tree that planted by the waters, Lord,\nI shall not be moved (be moved).');
INSERT INTO page VALUES (1627,108,1,'Jesus is my Saviour, I shall not be moved;\nIn His love and favour, I shall not be moved,\nJust like a tree that planted by the waters, Lord,\nI shall not be moved, I shall not be, \nI shall not be moved;\nI shall not be, I shall not be moved;\nJust like a tree that planted by the waters, Lord,\nI shall not be moved (be moved).\n');
INSERT INTO page VALUES (8011,109,4,'Have faith in God\nLet your hope rest on the\nfaith He has placed in your heart\nNever give up, Never let go of\nthe faith He has placed in your heart');
INSERT INTO page VALUES (8009,109,2,'Have faith in God\nLet your hope rest on the\nfaith He has placed in your heart\nNever give up, Never let go of\nthe faith He has placed in your heart');
INSERT INTO page VALUES (8010,109,3,'O, Lord you guide me\nThrough all the darkness\nTurning my night into day\nYou\'ll never leave me\nNever forsake me\nThe power of the presence of God');
INSERT INTO page VALUES (8008,109,1,'Oh, Lord you lead me\nby the still waters\nQuietly restoring my soul\nYou speak words of wisdom\nThe promise of glory\nThe power of the presence of God');
INSERT INTO page VALUES (1534,110,1,'Blessed be the rock of my salvation\nBlessed be the rock of my salvation\nFor the Lord is on my side\nAnd He\'s made His victory mine\nBlessed be the rock of my salvation\n(repeat)');
INSERT INTO page VALUES (1535,110,2,'Blessed be the rock!\nBlessed be the rock!\nBlessed be the rock!\nBlessed be the rock!\nBlessed be the rock of my salvation!');
INSERT INTO page VALUES (1541,111,2,'Look and see I\'ve engraved you\nOn the palms of my hands\nLook and see I\'ve engraved you\nOn my hands\n(Repeat)');
INSERT INTO page VALUES (1694,116,5,'Spirit we need you\nTo lift us from this mire\nConsume and empower us\nWith your holy fire.');
INSERT INTO page VALUES (1693,116,4,'All the earth shall worship\nAt the throne of the king\nOf His great and awesome\npower we shall sing.\n(repeat)');
INSERT INTO page VALUES (1692,116,3,'Jesus, we love you,\nBecause you first loved us\nYou reached out and healed us,\nWith your mighty touch');
INSERT INTO page VALUES (1690,116,1,'Father, we adore you\nYou\'ve drawn us to this place.\nWe bow down before you\nHumbly on our face');
INSERT INTO page VALUES (1691,116,2,'All the earth shall worship\nAt the throne of the king\nOf His great and awesome\npower we shall sing.\n(repeat)\n');
INSERT INTO page VALUES (7919,124,3,'I will lift my voice\nto worship you my King\nI will find my strength\nin the shadow of your wings');
INSERT INTO page VALUES (4925,119,3,'           Faith\nI can move the mountain\n  I can do all the things\n  through Christ I know\n           Faith\n Standing and beleiving\n  Through Christ who\n     strengthens me');
INSERT INTO page VALUES (4923,119,1,'I\'m reaching for the prize\nI\'m giving everything\nI give my life for this\nIt\'s what I live for\nNothing will keep me from\nAll that You have for me\nYou hold my head up high\nI live for You\n');
INSERT INTO page VALUES (4924,119,2,'Greater is He that\'s living in me\nThan he that is in the world\n');
INSERT INTO page VALUES (8481,136,5,'Your love keeps following me\n(repeat a couple of times)');
INSERT INTO page VALUES (4252,121,2,'And It makes me wana sing\nJesus Lives\nIt makes me wana sing\nHe lives in me\nIt makes me wana sing\nNow I live\nIt makes me wana sing\nIn victory');
INSERT INTO page VALUES (4251,121,1,'I love Jesus\nYes I do\nI love Jesus\nHow \'bout you\n(repeat x4)');
INSERT INTO page VALUES (1806,122,3,'Your love is stronger than\nThe sound of Heaven\'s praises\nHigher than the lofty mountain peaks\nDeeper than the deepest ocean valleys\nStrong enough for me');
INSERT INTO page VALUES (1805,122,2,'You wash away my tears\nGave my joy and freedom\nLifting me through the years');
INSERT INTO page VALUES (1804,122,1,'Oh Lord You have shown Your favour\nYour every word stands true\nAnd I\'m found safe within Your harbour\nAnchored deep in You');
INSERT INTO page VALUES (9564,123,4,'And I surrender\nAll to you\nAll to you\n(repeat)');
INSERT INTO page VALUES (9565,123,5,'I\'m singing You this song\nI\'m waiting at the cross\nAnd all the world holds dear\nI count it all as loss\nFor the sake of knowing You\nThe glory of your name\nTo know the everlasting joy\nEven sharing in your pain');
INSERT INTO page VALUES (9563,123,3,'I\'m singing You this song\nI\'m waiting at the cross\nAnd all the world holds dear\nI count it all as loss\nFor the sake of knowing You\nThe glory of your name\nTo know the everlasting joy\nEven sharing in your pain');
INSERT INTO page VALUES (11135,283,2,'Breathe on me breath of God\nuntil my heart is pure\nUntil with You I will one will\nTo do and to endure.');
INSERT INTO page VALUES (11134,283,3,'Breathe on me breath of God\nTill I am wholly thine\nTill all this earthly part of me\nglows with your fire divine.');
INSERT INTO page VALUES (11133,283,1,'Breathe on me breath of God\nFill me with life anew\nThat I may love what You would love\nAnd do what You would do.');
INSERT INTO page VALUES (1807,122,4,'Oh Lord You have shown Your favour\nYour every word stands true\nAnd I\'m found safe within Your harbour\nAnchored deep in You');
INSERT INTO page VALUES (1808,122,5,'You wash away my tears\nGave my joy and freedom\nLifting me through the years');
INSERT INTO page VALUES (1809,122,6,'Your love is stronger than\nThe sound of Heaven\'s praises\nHigher than the lofty mountain peaks\nDeeper than the deepest ocean valleys\nStrong enough for me');
INSERT INTO page VALUES (1810,122,7,'');
INSERT INTO page VALUES (1811,122,8,'You wash away my tears\nGave my joy and freedom\nLifting me through the years');
INSERT INTO page VALUES (1812,122,9,'Your love is stronger than\nThe sound of Heaven\'s praises\nHigher than the lofty mountain peaks\nDeeper than the deepest ocean valleys\nStrong enough for me');
INSERT INTO page VALUES (7918,124,1,'Your love oh Lord\nReaches to the Heavens\nYour faithfullnes\nStretches to the sky');
INSERT INTO page VALUES (10861,326,5,'Wisdom unsearchable, \nGod the invisible,\nLove indestructible, \nin frailty appears,\nLord of infinity, \nstooping so tenderly,\nLifts our humanity, \nto the heights of His throne.');
INSERT INTO page VALUES (9566,123,6,'And I surrender\nAll to you\nAll to you\n(repeat)');
INSERT INTO page VALUES (10157,134,3,'He made me in His image\nAnd I\'m wonderfully made\nHe saved me through His only Son\nAnd I\'m wonderfully saved\n(repeat)');
INSERT INTO page VALUES (11856,141,2,'As we come today,\nwe remind ourselves\nOf what we do\nThat these songs are not\njust songs but signs\nof love for You');
INSERT INTO page VALUES (7999,282,2,'Forever He will be\nThe Lamb upon the throne;\nI gladly bow my knee\nAnd worship Him alone.');
INSERT INTO page VALUES (6475,125,4,'And everything I have I give\nto You my Lord the one I live for\nI live for You\nAnd all my days are gifts from You\nI pray I use them as you want me to\nuse them for You.');
INSERT INTO page VALUES (6473,125,2,'And Angels come and adore You\nAnd we your children worship You');
INSERT INTO page VALUES (6474,125,3,'You are my world, You are my God\nAnd I lay down my life for you\nYou are my Lord the one that I love\nNo one could ever take your place');
INSERT INTO page VALUES (4967,224,4,'O happy day!\nO happy day!\nwhen Jesus washed my sins away;\nhe taught me how to watch and pray,\nand live rejoicing every day;\nO happy day!\nO happy day!\nwhen Jesus washed my sins away;');
INSERT INTO page VALUES (10156,134,2,'Praise to the Father of Lights\nIn Him there\'s day there is no night\nEvery good gift comes from above\nA certain sign of the Father\'s love\n(repeat)');
INSERT INTO page VALUES (11310,137,5,'So let me say how much I love You\nWith all my heart I long for You\nFor I am caught in this \npassion of knowing\nThis endless love I\'ve found in You');
INSERT INTO page VALUES (9561,123,1,'I\'m giving you my heart\nAnd all that is within\nI lay all it down\nfor the sake of  you my king\nI\'m giving you my dreams\nI\'m laying down my rights\nI\'m giving up my pride\nFor the Promise of new life');
INSERT INTO page VALUES (6472,125,1,'My Father I adore You more\nThan anything my heart could wish for\nI just want You\nAnd Jesus my beloved Savior,\nEverything I have I owe to You\nI owe it all to You');
INSERT INTO page VALUES (3470,182,2,'You have turned my mourning into dancing\nYou have turned my sorrow into joy');
INSERT INTO page VALUES (7623,64,1,'Blessing, Honour,\nGlory to the Lamb.\nHoly, Righteous,\nWorthy is the Lamb.\n(repeat)');
INSERT INTO page VALUES (2030,135,4,'I sing for joy\nAt the work of Your hands\nForever I\'ll love You\nForever I\'ll stand\nNothing compares to the promise\nI have in You');
INSERT INTO page VALUES (2029,135,3,'Shout to the Lord\nAll the earth let us sing\nPower and majesty\nPraise to the King\nMountains bow down\nAnd the seas will roar\nAt the sound of Your name');
INSERT INTO page VALUES (2027,135,1,'My Jesus, my Saviour\nLord there is none like you\nAll of my days, I want to praise\nThe wonders of your mighty love');
INSERT INTO page VALUES (2028,135,2,'My comfort, my shelter\nTower of refuge and strength\nlet every breath, all that I am\nNever cease to worship you');
INSERT INTO page VALUES (10155,134,1,'I\'m changed I\'m not the same\nThe Father called me by my name\nHe called me through His Son\nThe Father\'s holy righteous One \n(repeat)\n\nWe are the first fruits\nThe Children of the King');
INSERT INTO page VALUES (8705,331,1,'Lord, You are more precious than silver\nLord, You are more costly than gold.\nLord, You are more beautiful than diamonds\nAnd nothing I desire compares with You.');
INSERT INTO page VALUES (8507,175,2,'Jesus is Lord of all the earth,\nHe is the King of creation.\n\n');
INSERT INTO page VALUES (5895,145,3,'You and I together forever\nNothing can stand in the way\nMy love for you\nGrows stronger each new day\nI\'m falling deeply in love with you');
INSERT INTO page VALUES (2373,129,5,'I\'ve found where I belong\nI\'m a living stone\nIn this house I will grow');
INSERT INTO page VALUES (2370,129,2,'God is awesome in this place\nWe sense His presence\nAs we sing His praise\n');
INSERT INTO page VALUES (2371,129,3,'There is Power here for miracles\nTo set the captives free\nAnd make the Broken Whole\n');
INSERT INTO page VALUES (4129,130,3,'I\'ll hold on to You\nMy strength an my refuge\nWhom shal I fear\nI know You are near\nAll of my days\nI live for You Lord\nEstablish my path\nThere\'s one thing I ask\n');
INSERT INTO page VALUES (4128,130,2,'That I may\nDwell in Your house forever\nLifting up Your name\nDwell In Your house forever more\n');
INSERT INTO page VALUES (4127,130,1,'You set me apart\nGave me a new heart\nFiled me with compassion\nTo share Your great love\nShow me your way\nI want to know You\nGuide me in truth\nMy hope is in You\n');
INSERT INTO page VALUES (11121,131,5,'You\'re my friend and you\'re my brother,\nEven though you are a King,\nI love you more than any other,\nSo much more than anything');
INSERT INTO page VALUES (11120,131,2,'You alone are my strength, my shield,\nTo you alone may my spirit yield, \nYou alone are my heart\'s desire,\nAnd I long to worship you.');
INSERT INTO page VALUES (11119,131,3,'I want you more than gold or silver,\nOnly you can satisfy,\nYou alone are the real joy giver,\nAnd the apple of my eye.');
INSERT INTO page VALUES (11118,131,1,'As the deer pants for the water,\nSo my soul longs after you,\nYou alone are my heart\'s desire, \nAnd I long to worship you.');
INSERT INTO page VALUES (11131,132,2,'Humbled for a season,\nTo receive a name,\nFrom the lips of sinners,\nUnto whom He came,\nFaithfully He bore it,\nSpotless to the last,\nBrought it back victorious,\nWhen from death He passed.\n');
INSERT INTO page VALUES (11130,132,3,'In our hearts enthrone Him,\nThere let Him subdue,\nAll that is not Holy,\nAll that is not true,\nCrown Him as your captain,\nIn temptation\'s hour,\nLet His will enfold you,\nIn its light and power.\n');
INSERT INTO page VALUES (11129,132,1,'At the name of Jesus,\nEvery knee shall bow,\nEvery tongue confess him,\nKing of glory now.\nIt\'s the Father\'s pleasure,\nWe should call Him Lord,\nWho from the beginning,\nWas the mighty Word.\n');
INSERT INTO page VALUES (11128,132,4,'Brothers this Lord Jesus\nShall return again,\nWith His Father\'s glory,\nWith His angel train,\nFor all wreaths of empire,\nMeet upon His brow,\nAnd our hearts confess Him,\nKing of glory now.');
INSERT INTO page VALUES (4447,133,5,'In this bread there is healing\nIn this cup there\'s life for ever.\nIn this moment, by the Spirit\nChrist is with us here.');
INSERT INTO page VALUES (4446,133,4,'Here we are, joined in One,\nChrist is with us, He is with us.\nWe\'ll proclaim \'til He comes\nJesus crucified.');
INSERT INTO page VALUES (4445,133,3,'In this bread there is healing\nIn this cup there\'s life for ever.\nIn this moment, by the Spirit\nChrist is with us here.');
INSERT INTO page VALUES (4444,133,2,'Here is grace, here is peace,\nChrist is with us, He is with us.\nKnow His grace, find His peace,\nFeast on Jesus here.');
INSERT INTO page VALUES (4443,133,1,'Here is bread, here is wine\nChrist is with us, He is with us.\nBreak the bread, drink the wine,\nChrist is with us here.');
INSERT INTO page VALUES (11117,131,4,'You alone are my strength, my shield,\nTo you alone may my spirit yield, \nYou alone are my heart\'s desire,\nAnd I long to worship you.');
INSERT INTO page VALUES (11855,141,7,'Come, come, come,\nlet us worship God,\nWith Our hands held high,\nand our hearts bowed down\nWe will run, run, run,\nthrough your gates, oh God\nWith a shout of love,\nWith a shout of love.');
INSERT INTO page VALUES (2473,147,2,'And your steadfast love\nMay your name be exalted\nHere on earth\nAnd in heav\'n above\nLai, lai, lai...');
INSERT INTO page VALUES (2372,129,4,'God is awesome\nHe\'s so awesome\nGod is awesome in this place\n');
INSERT INTO page VALUES (11309,137,2,'And the earth will shake\nas Your Word goes forth\nThe heavens can tremble and fall\nBut let me say how much I love You\nO my Saviour, my Lord and friend');
INSERT INTO page VALUES (11308,137,3,'Just let me hear Your finest whispers\nAs You gently call my name\nAnd let me see Your power \nand Your glory\nLet me feel Your Spirit\'s flame');
INSERT INTO page VALUES (11307,137,1,'Just let me say how much I love You\nLet me speak of Your mercy and grace\nJust let me live in the \nshadow of Your beauty\nLet me see You face to face');
INSERT INTO page VALUES (11306,137,4,'Let me find You in the desert\n\'til this sand is holy ground\nAnd I am found completely\nsurrendered\nTo You, my Lord and friend');
INSERT INTO page VALUES (9267,138,5,'The power and the glory of Your name\nThe power and the glory of Your name\nThe power and the glory of Your name\nThe name of the Lord\nThe Son of God');
INSERT INTO page VALUES (9266,138,4,'This life is mine\nSo perfect and so pure, this God in me\nThis glorious hope\nFrom earth to heaven, death to life\nThis future assured and secured\nBy this love in my heart');
INSERT INTO page VALUES (9265,138,3,'The power and the glory of Your name\nThe power and the glory of Your name\nThe power and the glory of Your name\nThe name of the Lord\nThe Son of God');
INSERT INTO page VALUES (9264,138,2,'This love is mine\nSo undeserved this glorious name\nThis Son, this God\nThis life, this death, this victory won\nForgiveness has flowed as this grace\nThat is mine fills my heart');
INSERT INTO page VALUES (9263,138,1,'This grace is mine\nThis glory earthbound, heaven sent\nThis plan divine\nThis life, this light that breaks my night\nThe Spirit of God, heaven falls like a dove\nTo my heart');
INSERT INTO page VALUES (2909,143,3,'I\'m living for this cause\nI lay down my life \nInto Your hands');
INSERT INTO page VALUES (2910,143,4,'I\'m living for the truth\nThe hope of the world\nIn You I\'ll stand\nCause all I want is You');
INSERT INTO page VALUES (5685,142,5,'God is great and his praise\nfills the earth, Fills the Heavens\nAnd Your name will be praised\nthrough all the Earth\nGod is great sing his praise\nAll the Earth, All the Heavens\n\'Cause we\'re living for \nthe glory of your name\nthe glory of your name');
INSERT INTO page VALUES (5683,142,3,'God is great and his praise\nfills the earth, Fills the Heavens\nAnd Your name will be praised\nthrough all the Earth\nGod is great sing his praise\nAll the Earth, All the Heavens\n\'Cause we\'re living for \nthe glory of your name\nthe glory of your name');
INSERT INTO page VALUES (2369,129,1,'Here in this house\nof the Great King\nWe\'ve come together\nnow to worship Him\nThis house is built\non Christ our Rock\nCan not be shaken,\nCan not be shaken.');
INSERT INTO page VALUES (12465,154,3,'Jesus, the expression of God\'s love\nThe grace of God, the word of God\nRevealed to us\nJesus, God\'s holiness displayed\nnow glorified, now justified\nHis kingdom comes');
INSERT INTO page VALUES (12466,154,2,'And this kingdom will know no end\nAnd its glory shall know no bounds\nFor the majesty and power\nOf this kingdom\'s King has come\nAnd this kingdom\'s reign\nAnd this kingdom\'s rule\nAnd this kingdom\'s power and authority\nJesus, God\'s righteousness revealed');
INSERT INTO page VALUES (11850,141,6,'You are the Holy King of all,\nHeaven and Earth are in your hands,\nAll of the angels sing your song,\nwe join them now.');
INSERT INTO page VALUES (11851,141,8,'Let this be a holy moment now\n            (repeat)');
INSERT INTO page VALUES (11852,141,4,'Come, come, come,\nlet us worship God,\nWith Our hands held high,\nand our hearts bowed down\nWe will run, run, run,\nthrough your gates, oh God\nWith a shout of love,\nWith a shout of love.');
INSERT INTO page VALUES (5684,142,4,'All to you O God we bring\nJesus teach us how live\nLet your fire burn in us\nthat all may hear\nAnd all may see');
INSERT INTO page VALUES (2446,148,1,'Jesus is Lord!\nCreation\'s voice proclaims it\nFor by his power, each tree and flower\nWas planned and made\nJesus is Lord!\nThe universe declares it\nSun, moon and stars in heaven\nCry Jesus is Lord!...');
INSERT INTO page VALUES (2824,155,4,'Jesus has risen\nHe\'s conquered the grave! \n[repeat]\n\nHey!');
INSERT INTO page VALUES (2911,143,5,'All I want is\nAll I want is You.....Jesus');
INSERT INTO page VALUES (2907,143,1,'Hope has found its home within me\nNow that i\'ve been found in you\nLet all i am be all You want me to be\n\'Cause all i want is more of You\nAll I want is more of You\n');
INSERT INTO page VALUES (2908,143,2,'Let Your presence fall upon us\nI want to see You face to face\nLet me live forever lost in Your love\n\'Cause all I want is more of You\nAll I want is more of You');
INSERT INTO page VALUES (12866,448,2,'Where streams of living water flow,\nMy ransomed soul he leadeth,\nAnd where the verdant pastures grow,\nWith food celestial feedeth.');
INSERT INTO page VALUES (12865,448,3,'Perverse and foolish oft I strayed,\nBut yet in love he sought me,\nAnd on His shoulder gently laid,\nAnd home rejoicing brought me.');
INSERT INTO page VALUES (5894,145,2,'You have stolen my heart\nI\'m captivated by you\nNever will you and I part\nI\'m falling deeply in love with you');
INSERT INTO page VALUES (5893,145,1,'In my life\nYou\'ve heard me say\nI love you\nHow do I show it\'s true\nHear my heart\nIt longs for more more of you\nI\'m falling deeply in love with you');
INSERT INTO page VALUES (6344,184,6,'Forever, forever\nI will praise You\nI will praise You');
INSERT INTO page VALUES (6343,184,5,'And I see You high and lifted up\nSeated on the throne\nLet Your glory shine upon me now\nI adore You alone');
INSERT INTO page VALUES (3604,185,2,'Oh Lord\nOh Lord\nRelease Your power\nAnd let Your presence fall');
INSERT INTO page VALUES (4645,186,2,'To See You high and lifted up\nShining in the light of your glory\nPour out your power and love\nAs we sing Holy, Holy, Holy');
INSERT INTO page VALUES (3603,185,1,'Lord, We proclaim you now\nOf Your mighty power\nAnd Your awesome majesty\nLord, come upon us now\nAnd release Your power\nAnd let Your presece fall');
INSERT INTO page VALUES (2472,147,1,'In the presence of your people\nI will praise your name\nFor alone you are holy\nEnthroned on the praises of Israel\nLet us celebrate your goodness\n');
INSERT INTO page VALUES (2447,148,3,'Jesus is Lord!\nYet from his throne eternal\nIn flesh he came,\nto die in pain\nOn Calv\'ry\'s tree\nJesus is Lord!\nFrom him all life proceeding\nYet gave his life a ransom\nThus setting us free...');
INSERT INTO page VALUES (4644,186,1,'Open the eyes of my heart Lord\nOpen the eyes of my heart\nI want to see you\nI want to see you\n(repeat)');
INSERT INTO page VALUES (2448,148,5,'Jesus is Lord!\nO\'er sin the mighty conqueror\nFrom death he rose and all his foes\nShall own his name\nJesus is Lord!\nGod sent his Holy Spirit\nTo show by works of power \nThat Jesus is Lord...');
INSERT INTO page VALUES (2449,148,2,'Jesus is Lord! Jesus is Lord!\nPraise him with hallelujahs\nFor Jesus is Lord!\n');
INSERT INTO page VALUES (2450,148,4,'Jesus is Lord! Jesus is Lord!\nPraise him with hallelujahs\nFor Jesus is Lord!\n');
INSERT INTO page VALUES (2451,148,6,'Jesus is Lord! Jesus is Lord!\nPraise him with hallelujahs\nFor Jesus is Lord!');
INSERT INTO page VALUES (4152,149,5,'Hallelujah Hallelujah, \nHallelujah Hallelujah, \nAnd we lift our hearts before you \nAs a token of our love,\nHallelujah Hallelujah.');
INSERT INTO page VALUES (4151,149,4,'Holy Spirit, Holy Spirit,\nCome and fill our hearts anew Holy Spirit,\nAnd we lift our voice before you \nAs a token of our love,\nHoly Spirit, Holy Spirit.\n');
INSERT INTO page VALUES (4150,149,3,'Precious Jesus, Precious Jesus,\nWe\'re so glad that you\'ve redeemed us,\nprecious Jesus,\nAnd we lift our hands before you \nAs a token of our love,\nPrecious Jesus, Precious Jesus.\n');
INSERT INTO page VALUES (4149,149,2,'Gracious Father, Gracious Father,\nWe\'re so blest to be your children \nGracious Father,\nAnd we lift our heads before you \nAs a token of our love,\nGracious Father, Gracious Father.\n');
INSERT INTO page VALUES (4148,149,1,'Holy, Holy, Holy, Holy, \nHoly, Holy, Lord God Almighty,\nAnd we lift our hearts before you\nAs a token of our love,\nHoly, Holy, Holy, Holy.\n');
INSERT INTO page VALUES (10849,150,2,'Holy, Holy, Holy, \nAll the saints adore thee\nCasting down their golden crowns \naround the glassy sea;\nCherubim and Seraphim \nfalling down before thee\nWho wert, and art, \nand evermore shalt be.');
INSERT INTO page VALUES (10848,150,3,'Holy, Holy, Holy, \nThough the darkness hide thee,\nThou the eye of sinful man \nthy glory may not see;\nOnly thou art holy; \nthere is none beside thee\nPerfect in pow\'r,\nin love and purity.\n');
INSERT INTO page VALUES (10847,150,1,'Holy, Holy, Holy, \nLord God almighty\nEarly in the morning \nour song shall rise to thee;\nHoly, Holy, Holy, \nMerciful and Mighty\nGod in three Persons blessed Trinity');
INSERT INTO page VALUES (10846,150,4,'Holy, Holy, Holy, \nLord God almighty\nAll thy works shall \npraise thy Name,\nin earth and sky and sea;\nHoly, Holy, Holy, \nMerciful and Mighty\nGod in three Persons blessed Trinity\nAmen.');
INSERT INTO page VALUES (2823,155,3,'We are a people of power\nWe are a people of praise!\nWe are a people of promise\nJesus has risen\nHe\'s conquered the grave!');
INSERT INTO page VALUES (11992,223,2,'Be still, for the glory of the Lord\nis shining all around.\nHe burns with holy fire,\nwith splendour He is crowned.\nHow awesome is the sight,\nOur radiant King of Light!\nBe still, for the glory of the Lord\nis shining all around.');
INSERT INTO page VALUES (4911,44,1,'Jesus, lover of my soul\nJesus, I will never let you go\nYou\'ve taken me, from the mirey clay\nSet my feet upon the rock\nAnd now I know');
INSERT INTO page VALUES (3565,183,4,'Jesus You are the\nSaviour of my soul\nAnd forever and ever\nI\'ll give my praises to You');
INSERT INTO page VALUES (3566,183,5,'King of Majesty\nI have one desire\nJust to be with You my Lord\nJust to be with You my Lord');
INSERT INTO page VALUES (3617,189,2,'Worthy is the Lamb that died, they cry\nTo be exalted thus, Worthy is the Lamb\nour lips reply, For He was slain for us.');
INSERT INTO page VALUES (3618,189,3,'Jesus is worthy to receive \nHonour and power divine\nAnd blessings more than we can give\nBe, Lord, for ever Thine.');
INSERT INTO page VALUES (3557,187,3,'Blessing and honour\nand glory and power\nForever, Forever.');
INSERT INTO page VALUES (3558,187,4,'In awe of You we worship');
INSERT INTO page VALUES (2485,153,1,'Master, speak! Thy servant heareth,\nWaiting for Thy gracious word,\nLonging for Thy voice that cheereth;\nMaster let it now be heard.\nI am listening Lord, for Thee!\nWhat hast Thou to say to me?');
INSERT INTO page VALUES (2486,153,2,'Speak to me by name, O Master,\nLet me know it is to me;\nSpeak that I may follow faster,\nWith a step more firm and free,\nWhere the Shepherd leads the flock,\nin the shadow of the rock.');
INSERT INTO page VALUES (2487,153,3,'Master, speak! though least and lowest\nLet me not unheard depart;\nMater speak: for Oh, Thou knowest\nAll the yearning of my heart;\nKnowest all its truest need;\nSpeak and make me blest indeed.');
INSERT INTO page VALUES (2488,153,4,'Master, speak! and make me ready,\nWhen Thy voice is truly heard,\nWith obedience glad and steady\nStill to follow ev\'ry word.\nI am listening, Lord, for Thee,\nMaster, speak, O speak to me!');
INSERT INTO page VALUES (3472,182,4,'You have turned my mourning into dancing\nYou have turned my sorrow into joy');
INSERT INTO page VALUES (4916,157,3,'\'...honouring and taking the small step,\ntrusting God is always bigger than\nour imaginations\'\n\n\'Care is the only thing the \nsystem cannot produce\'');
INSERT INTO page VALUES (12464,154,1,'Jesus, God\'s righteousness revealed\nThe son of man, the son of God\nHis Kingdom comes\nJesus redemption\'s sacrifice\nnow glorified, now justified\nHis Kingdom comes');
INSERT INTO page VALUES (12463,154,4,'And this kingdom will know no end\nAnd its glory shall know no bounds\nFor the majesty and power\nOf this kingdom\'s King has come\nAnd this kingdom\'s reign\nAnd this kingdom\'s rule\nAnd this kingdom\'s power and authority\nJesus, God\'s righteousness revealed');
INSERT INTO page VALUES (2822,155,2,'Risen, yes, born again!\nWe walk in the power of his name!\nPower to be the sons of God,\nSons of God!\nSons of God!\nWe are the sons,\nHey!\nSons of God!\nHey! Hey! Hey!');
INSERT INTO page VALUES (2656,156,5,'Your grace and Your mercy is all I need,\nYour loving kindness,\nYour hope and Your peace.\nReaching for Your love my soul\n  finds release,\nYour grace and Your mercy is all I need.\nYour grace and Your mercy is all I need.\nYour grace and Your mercy is all I need.');
INSERT INTO page VALUES (2655,156,4,'You lift my eyes to see\nthe hope I have in You.\nYou gently heal my heart,\nYour love and life burst through\nThe darkness of my soul,\nThe troubles and the pain,\nYour grace and Your mercy \nIs all I need.');
INSERT INTO page VALUES (2654,156,3,'Your grace and Your mercy is all I need,\nYour loving kindness,\nYour hope and Your peace.\nReaching for Your love my soul\n  finds release,\nYour grace and Your mercy is all I need.');
INSERT INTO page VALUES (2652,156,1,'Your grace and Your mercy is all I need,\nYour loving kindness,\nYour hope and Your peace.\nReaching for Your love my soul\n  finds release,\nYour grace and Your mercy is all I need.\n(repeat)');
INSERT INTO page VALUES (2653,156,2,'I open up my heart\nto the One who knows me best.\nYour grace and righteousness,\nPeace and perfect rest.\nMy heavy heart released,\nMy soul is now restored,\nYour grace and Your mercy \nIs all I need.');
INSERT INTO page VALUES (4492,158,2,'Jesus, Jesus\nJesus, friend for ever.');
INSERT INTO page VALUES (4493,158,3,'What a hope I\'ve found,\nMore faithful than a mother.\nIt would break my heart,\nTo ever lose each other.');
INSERT INTO page VALUES (2704,159,1,'I\'ll worship at your throne,\nwhisper my own love song.\nWith al my heart I\'ll sing,\nfor You my dad and King.\nI\'ll live for all my days,\nto put a smile on your face.\nAnd when we finally meet\nit\'ll be for etertity');
INSERT INTO page VALUES (4915,157,2,'\'... recognize that we are inescapably \ncommunal creatures\'\n\n\'... recognizing the power of the church\'s\nregular gathering and worship\'\n\n\'...reclaiming and giving more deliberate \nattention to Christian language\'');
INSERT INTO page VALUES (4914,157,1,'Professionalized, specialized,\nfederalized and capitalized,\nthe modern world system \'simply \ncannot register the wisdom inherent \nin any indigenous culture\'');
INSERT INTO page VALUES (2821,155,1,'We are a people of power\nWe are a people of praise!\nWe are a people of promise\nJesus has risen\nHe\'s conquered the grave!');
INSERT INTO page VALUES (3154,69,2,'The enemy whispered into my mind,\nDetermined to wear me down.\nAlert in the Spirit, I am not blind\nMy confession of faith\nHas that enemy bound');
INSERT INTO page VALUES (6841,172,4,'King of endless worth\nNo one could express\nhow much you deserve\nthough I\'m weak and poor\nAll I have is Yours\nEvery single breath');
INSERT INTO page VALUES (5884,160,4,'Lord, we exalt you on high\nJesus, You\'re worthy to be glorified,\nLet all of creation bow down!');
INSERT INTO page VALUES (3153,69,1,'I will rejoice,\nI will rejoice,\nI will rejoice,\nfor I\'ve made my choice\nTo rejoice in the Lord\n(Repeat)');
INSERT INTO page VALUES (4491,158,1,'What a friend I\'ve found,\nCloser than a brother.\nI have felt Your touch,\nMore intimate than lovers.');
INSERT INTO page VALUES (2705,159,2,'And oh, how wide You\nopen up your arms\nWhen I need your love,\nhow far you would come\nIf i ever was lost,\nand you said that all you feel for me\nIs undying love,\nthat you showed me through the cross');
INSERT INTO page VALUES (5882,160,2,'Blessing and favour fall like rain,\nReviving the hearts \nof Your children again\nJustice and mercy flow \nfrom Your throne\nRivers of love from Your heart.');
INSERT INTO page VALUES (5883,160,3,'All of creation sings out Your Praise,\nThe heavens declare you God,\nJesus, You\'re worthy to be glorified,\nLet all of creation bow down,\nGlory and honour\nto the Lamb on the throne,');
INSERT INTO page VALUES (2706,159,3,'I\'ll worship you my God\nI\'ll worship you my God\nI love you, I love you\nForever I will sing\nForever I will be with you\nBe with you');
INSERT INTO page VALUES (6987,171,4,'A fresh song I\'m singing\nFrom my heart straight to heaven\nAnd I long to hear your voice again\nAnd a new sound from heaven\nIs falling around me\nI will praise your name again');
INSERT INTO page VALUES (6838,172,1,'When the music fades\nand all is stripped away\nand I simply come\nlonging just to bring\nsomething thats of worth\nthat will bless Your heart');
INSERT INTO page VALUES (5881,160,1,'Jesus,\nYou are the Beginning and the End,\nCreator, God and King.\nGiver of life, Saviour of man,\nLord of everything.\n');
INSERT INTO page VALUES (6619,161,4,'My heart is open for You to move\nI lift up my voice and my arms too\nI know You\'re there\nand I know You\'re true\nNow All I need is You.');
INSERT INTO page VALUES (6618,161,3,'So won\'t you find me\nIn that place where\nYou know I should be\nWon\'t you take me to\nThat place where You\nknow I could be');
INSERT INTO page VALUES (6617,161,2,'All I need is You\nAll I need is You\nAll I need, All I need,\nAll I need is You');
INSERT INTO page VALUES (6616,161,1,'My heart is longing for a fresh touch\nI\'ve got a burning desire for my first love\nI know you\'re there\nand I know you\'re true\nNow all I need is You');
INSERT INTO page VALUES (4133,162,3,'Jesus I need you\nAs Lord of my life\nI give all I have unto you\nLord I want to come under\nYour heavenly hand\nAnd to praise you\nIn all that I do');
INSERT INTO page VALUES (4132,162,2,'Spirit of life\nYou are God\'s holy fire\nYou\'ve kindled my heart with your blaze\nAnd I know you\'re refining me\nChanging my life\nAnd by faith\nYou\'re revealing your ways\n');
INSERT INTO page VALUES (4131,162,1,'Father, I thank you\nFor all that you\'ve done\nYou gave your Son freely for me\nAnd I praise you for calling me\nDrawing me near\nOut of blindness\nYou caused me to see\n');
INSERT INTO page VALUES (4156,163,4,'Finish, then, Thy new creation;\nPure and spotless let us be;\nLet us see Thy great salvation\nPerfectly restored in Thee:\nChanged from glory into glory,\nTill in heaven we take our place,\nTill we cast our crowns before Thee,\nLost in wonder, love, and praise.');
INSERT INTO page VALUES (4155,163,3,'Come, Almighty to deliver,\nLet us all Thy grace receive;\nSuddenly return, and never,\nNever more Thy temples leave.\nThee we would be always blessing,\nServe Thee as Thy hosts above,\nPray, and praise Thee without ceasing,\nGlory in Thy perfect love.\n');
INSERT INTO page VALUES (4154,163,2,'Breathe, O breathe Thy loving Spirit\nInto every troubled breast!\nLet us all in Thee inherit,\nLet us find the promised rest;\nTake away our bent to sinning;\nAlpha and Omega be;\nEnd of faith, as its beginning,\nSet our hearts at liberty.\n');
INSERT INTO page VALUES (4153,163,1,'Love divine, all loves excelling,\nJoy of heaven, to earth come down;\nFix in us Thy humble dwelling;\nAll Thy faithful mercies crown.\nJesus, Thou art all compassion,\nPure, unbounded love Thou art;\nVisit us with Thy salvation; \nEnter every trembling heart.\n');
INSERT INTO page VALUES (5032,164,8,'Standing, standing,\nStanding on the promises\n of God my Saviour;\nStanding, standing,\nI\'m standing on the promises of God.');
INSERT INTO page VALUES (5031,164,7,'Standing on the\n promises I cannot fall,\nListening every moment\n to the Spirit\'s call,\nResting in my Saviour\n as my all in all,\nStanding on the promises of God.');
INSERT INTO page VALUES (5030,164,6,'Standing, standing,\nStanding on the promises\n of God my Saviour;\nStanding, standing,\nI\'m standing on the promises of God.');
INSERT INTO page VALUES (5029,164,5,'Stannding on the promises\n of Christ the Lord,\nBound to Him eternally\n by love\'s strong cord,\nOvercoming daily with\n the Spirit\'s Sword,\nStanding on the promises of God.');
INSERT INTO page VALUES (5028,164,4,'Standing, standing,\nStanding on the promises\n of God my Saviour;\nStanding, standing,\nI\'m standing on the promises of God.');
INSERT INTO page VALUES (5026,164,2,'Standing, standing,\nStanding on the promises\n of God my Saviour;\nStanding, standing,\nI\'m standing on the promises of God.');
INSERT INTO page VALUES (3926,165,6,'Thank you O our Father\nFor giving us your Son\nAnd leaving your Spirit\nTill your work on Earth is done.');
INSERT INTO page VALUES (3925,165,5,'When I stand in glory\nI will see His face\nAnd there I\'ll serve my King forever,\nIn that Holy Place');
INSERT INTO page VALUES (3923,165,3,'Jesus my Redeemer,\nName above all names,\nPrecious Lamb of God, Messiah\nO for sinners slain.');
INSERT INTO page VALUES (3924,165,4,'Thank you O our Father\nFor giving us your Son\nAnd leaving your Spirit\nTill your work on Earth is done.');
INSERT INTO page VALUES (4171,166,5,'When our eyes behold, in the dawning light,\nShining gates of pearl, our harbor bright,\nWe shall anchor fast to the heavenly shore,\nWith the storms all past for ever more.\n\nWe have an anchor that keeps the soul\nSteadfast and sure while the billows roll;\nFastened to the Rock which cannot move,\nGrounded firm and deep in the Saviour\'s love.');
INSERT INTO page VALUES (4170,166,4,'It will surely hold in the floods of death,\nWhen the waters cold chill our latest breath;\nOn the rising tide it can never fail,\nWhile our hopes abide within the veil.\n\nWe have an anchor that keeps the soul\nSteadfast and sure while the billows roll;\nFastened to the Rock which cannot move,\nGrounded firm and deep in the Saviour\'s love.\n');
INSERT INTO page VALUES (4169,166,3,'It will firmly hold in the straits of Fear,\nWhen the breakers tell that the reef is near;\nThough the tempest rave and the wild winds blow,\nNot an angry wave shall our bark o\'erflow.\n\nWe have an anchor that keeps the soul\nSteadfast and sure while the billows roll;\nFastened to the Rock which cannot move,\nGrounded firm and deep in the Saviour\'s love.\n');
INSERT INTO page VALUES (4168,166,2,'If \'tis safely moored, \'twill the storm withstand,\nFor \'tis well secured by the Saviour\'s hand;\nAnd the cables, passed from His heart to thine,\nCan defy the blast, through strength divine.\n\nWe have an anchor that keeps the soul\nSteadfast and sure while the billows roll;\nFastened to the Rock which cannot move,\nGrounded firm and deep in the Saviour\'s love.\n');
INSERT INTO page VALUES (4167,166,1,'Will your anchor hold in the storm of life,\nWhen the clouds unfold their wings of strife?\nWhen the strong tides lift, and the cables strain,\nWill your anchor drift or firm remain?\n\nWe have an anchor that keeps the soul\nSteadfast and sure while the billows roll;\nFastened to the Rock which cannot move,\nGrounded firm and deep in the Saviour\'s love.\n');
INSERT INTO page VALUES (5027,164,3,'Standing on the promises\n that cannot fail,\nWhen the howling storms\n of doubt and fear asail,\nBy the living word of God I shall prevail,\nStanding on the promises of God.');
INSERT INTO page VALUES (2793,167,1,'When we walk with the Lord\nIn the light of His Word\nWhat a glory He sheds on our way!\nWhile we do His good will,\nHe abides with us still,\nAnd with all who will trust and obey.\n');
INSERT INTO page VALUES (2794,167,2,'Trust and obey,\nfor there\'s no other way\nto be happy in Jesus,\nBut to trust and obey.\n');
INSERT INTO page VALUES (2795,167,3,'Not a burden we bear,\nNot a sorrow we share,\nBut our toil He doth richly repay;\nNot a grief or a loss,\nNot a frown or a cross,\nBut is blest if we trust and obey.\n');
INSERT INTO page VALUES (2796,167,4,'Trust and obey,\nfor there\'s no other way\nto be happy in Jesus,\nBut to trust and obey.\n');
INSERT INTO page VALUES (2797,167,5,'But we never can prove\nThe delights of His love\nUntil all on the altar we lay;\nFor the favour He shows\nAnd the joy He bestows\nAre for them who will trust and obey.\n');
INSERT INTO page VALUES (2798,167,6,'Trust and obey,\nfor there\'s no other way\nto be happy in Jesus,\nBut to trust and obey.\n');
INSERT INTO page VALUES (2799,167,7,'Then in fellowship sweet\nWe will sit at His feet\nOr we\'ll walk by His side in the way;\nWhat He says we will do,\nWhere He sends we will go;\nNever fear, only trust and obey.\n');
INSERT INTO page VALUES (2800,167,8,'Trust and obey,\nfor there\'s no other way\nto be happy in Jesus,\nBut to trust and obey.');
INSERT INTO page VALUES (12371,168,3,'Our Father who is in heaven,\nGlory to your name,\nYour kingdom come, your will be done,\nOn Earth as it is in heaven.\nForgive our sins as we forgive \nthose who sin against us.');
INSERT INTO page VALUES (13655,649,3,'What language shall I borrow\nto praise thee, heav\'nly friend,\nfor this, thy dying sorrow,\nthy pity without end?\nLord, make me thine for ever,\nnor let me faithless prove;\nO let me never, never\nabuse such dying love!');
INSERT INTO page VALUES (12173,169,1,'Hosanna, hosanna, \nhosanna in the highest!\nHosanna, hosanna, \nhosanna in the highest!\nLord, we lift up your name,\nWith hearts full of praise.\nBe exalted, O Lord my God.\nHosanna in the highest!');
INSERT INTO page VALUES (12172,169,4,'Lord, we lift up your name,\nWith hearts full of praise.\n\nBe exalted, O Lord my God.\nHosanna in the highest!\n(repeat)');
INSERT INTO page VALUES (5617,170,2,'Jesus Lord of all, Lord of all (x4)\nName above all names,\nName above all names.');
INSERT INTO page VALUES (5616,170,1,'We believe in God the Father\nMaker of the universe\nAnd in Christ His Son our saviour\nCome to us by virgin birth\nWe believe He died to save us\nBore our sins, was crucified\nThen from death He rose victorious\nAscended to the Father\'s side');
INSERT INTO page VALUES (3567,183,6,'Jesus You are the\nSaviour of my soul\nAnd forever and ever\nI\'ll give my praises to You');
INSERT INTO page VALUES (6986,171,3,'Never before have I found love\nNever before have I found freedom\nExcept in your touch\nMany paths I could have walked\nMany roads I could have chosen\nBut you are the one');
INSERT INTO page VALUES (6985,171,2,'I\'m in this world but I am not doing\nAll the things they do\nI\'m set apart, my life has changed\nMy heart has been made new\nI am here to make a difference\nAnd let the whole world see\nJesus lives\nHe has set me free');
INSERT INTO page VALUES (6984,171,1,'No more living in confusion\nMy sins are washed away\nThankyou Jesus that I have hope now\n\'Cause I have found the way\nI am not the same now\nAnd I will never be\nJesus lives\nHe has set me free');
INSERT INTO page VALUES (6342,184,4,'I love to be with You,\nTo seek Your face\nLord, please show Your power\nAnd fill this place');
INSERT INTO page VALUES (6341,184,3,'Forever, forever\nI will praise You\nI will praise You\nForever, forever\nI will praise You\nI will praise You');
INSERT INTO page VALUES (3564,183,3,'King of Majesty\nI have one desire\nJust to be with You my Lord\nJust to be with You my Lord');
INSERT INTO page VALUES (3563,183,2,'These words are from my heart\nThese words are not made up\nI will live for You\nI am devoted to You');
INSERT INTO page VALUES (6340,184,2,'You give me everything I need\nYou give me life\nLet Your glory shine upon me now\nI adore You alone');
INSERT INTO page VALUES (9895,173,6,'But this I know, all flesh shall see His glory,\nAnd He shall reep the\nharves He has sown\nAnd some glad day \nHis sun shall shine in splendour,\nWhen He the Saviour, \nSaviour of the world is known.');
INSERT INTO page VALUES (9896,173,7,'I cannot tell how all the lands \nshall worship, When at His biding, \nev\'ry storm is stilled.\nOr who can say how \ngreat the jubilation\nWhen all the hearts of \nmen with love are filled,');
INSERT INTO page VALUES (9894,173,5,'I cannot tell how He will win the nations,\nHow He will claim \nHis earthly heritage,\nHow satisfy the needs\nand aspirations\nOf East and West of\nsinner and of sage.');
INSERT INTO page VALUES (9893,173,4,'But this I know, He heals \nthe broken hearted, And stays our sin, \nand calms our lurking fear,\nAnd lifts the burden \nfrom the heavy laden,\nFor yet the Saviour,\nSaviour of the world is here.');
INSERT INTO page VALUES (9892,173,3,'I cannot tell how silently He suffered,\nAs with His peace \nHe graced this place of tears,\nOr how His heart upon \nthe Cross was broken,\nThe crown of pain to \nthree and thirty years.');
INSERT INTO page VALUES (7356,174,8,'Count Your blessings, name them one by one:\nCount your blessings, See what God has done;\nCount your blessings, name them one by one;\nCount your many blessings, see what God has done.');
INSERT INTO page VALUES (7355,174,7,'So, amid the conflict, whether great of small,\nDo not be discouraged, God is over all;\nCount your many blessings, angels will attend,\nHelp and comfort give you to your journey\'s end.\n');
INSERT INTO page VALUES (7353,174,5,'When you look at others with their lands and gold,\nThink that Christ has promised ou His wealth un-told;\nCount your many blessings, money cannot buy\nYour reward in Heaven, nor your home on high.\n');
INSERT INTO page VALUES (7354,174,6,'Count Your blessings, name them one by one:\nCount your blessings, See what God has done;\nCount your blessings, name them one by one;\nCount your many blessings, see what God has done.\n');
INSERT INTO page VALUES (7352,174,4,'Count Your blessings, name them one by one:\nCount your blessings, See what God has done;\nCount your blessings, name them one by one;\nCount your many blessings, see what God has done.\n');
INSERT INTO page VALUES (7351,174,3,'Are you ever burdened with a load of care?\nDoes the cross seem heavy you are called to bear?\nCount your many blessings, ev\'ry doubt will fly,\nAnd you will be singing as the days go by\n');
INSERT INTO page VALUES (7350,174,2,'Count Your blessings, name them one by one:\nCount your blessings, See what God has done;\nCount your blessings, name them one by one;\nCount your many blessings, see what God has done.\n');
INSERT INTO page VALUES (9937,181,1,'Hallelujah!\nAmen Brothers\nand Sisters!');
INSERT INTO page VALUES (8506,175,7,'Come let us praise the living God,\nJoyfully sing to our Saviour.\n\nAlleluia, Alleluia,\ngive thanks to the risen Lord,\nAlleluia, Alleluia,\ngive thanks to His name.');
INSERT INTO page VALUES (8505,175,6,'God has proclaimed the just reward,\nLife for us all, Alleluia.\n\nAlleluia, Alleluia,\ngive thanks to the risen Lord,\nAlleluia, Alleluia,\ngive thanks to His name.\n');
INSERT INTO page VALUES (8504,175,5,'We have been crucified with Christ,\nNow we shall live for ever.\n\nAlleluia, Alleluia, \ngive thanks to the risen Lord,\nAlleluia, Alleluia,\ngive thanks to His name.\n');
INSERT INTO page VALUES (8501,175,3,'Alleluia, Alleluia,\ngive thanks to the risen Lord,\nAlleluia, Alleluia,\ngive thanks to His name.');
INSERT INTO page VALUES (8502,175,1,'Alleluia, Alleluia,\ngive thanks to the risen Lord,\nAlleluia, Alleluia,\ngive thanks to His name.\n');
INSERT INTO page VALUES (3620,189,5,'The whole creation join in one,\nTo bless the sacred name\nOf Him that sits upon the throne,\nAnd to adore the Lamb.');
INSERT INTO page VALUES (6339,184,1,'You breathed Your breath of life \nInto my soul\nAnd from this breath\nI\'ll lift my praise to You');
INSERT INTO page VALUES (3562,183,1,'You know that I love You\nYou know that I want to\nKnow you so much more\nMore than I have before');
INSERT INTO page VALUES (4147,176,6,'Here I am Lord, Is it I Lord?, \nI have heard you calling in the night.\nI will go Lord, if you lead me.\nI will hold your people in my heart.');
INSERT INTO page VALUES (4146,176,5,'I, the Lord of wind and flame,\nI will tend the poor and lame,\nI will set a feast for them.\nMy hand will save.\nFinest bread I will provide,\nTill their hearts be satisfied.\nI will give new life to them.\nWhom shall I send?');
INSERT INTO page VALUES (4145,176,4,'Here I am Lord, Is it I Lord?, \nI have heard you calling in the night.\nI will go Lord, if you lead me.\nI will hold your people in my heart.');
INSERT INTO page VALUES (4143,176,2,'Here I am Lord, Is it I Lord?, \nI have heard you calling in the night.\nI will go Lord, if you lead me.\nI will hold your people in my heart.\n');
INSERT INTO page VALUES (4144,176,3,'I, the Lord of snow and rain,\nI have borne my people\'s pain,\nI have wept for love of them.\nThey turn away.\nI will break their hearts of stone,\nGive them hearts for love alone.\nI will speak my word to them.\nWhom shall I send?');
INSERT INTO page VALUES (4166,177,2,'This is the day that the Lord has made,\nWe shall rejoice and be glad in it,\nThis is the day, this is the day,\nThat the Lord has made.');
INSERT INTO page VALUES (4165,177,1,'This is the day, this is the day,\nThat the Lord has made,\nThat the Lord has made,\nWe shall rejoice, we shall rejoice,\nAnd be glad in it, and be glad in it.');
INSERT INTO page VALUES (9891,173,2,'But this I know, that He was born of Mary,\nThat Bethl\'hem\'s manger \nwas His only home,\nAnd that He Lived at \nNazareth and laboured,\nAnd so the Saviour, \nSaviour of the world is come.');
INSERT INTO page VALUES (4142,176,1,'I, the Lord of sea and sky, \nI have heard my people cry,\nAll who dwell in dark and sin,\nMy hand will save.\nI who made the stars of night, \nI will make their darkness bright.\nWho will bear my light to them?\nWhom shall I send?');
INSERT INTO page VALUES (8503,175,4,'Spread the good news\no\'er all the earth,\nJesus has died and has risen.\n\nAlleluia, Alleluia,\ngive thanks to the risen Lord,\nAlleluia, Alleluia,\ngive thanks to His name.\n');
INSERT INTO page VALUES (7349,174,1,'When upon life\'s billows you are tempest tossed,\nWhen you are discouraged, thinking all is lost,\nCount your many blessings, name them one by one\nAnd it will surprise you what the Lord has done.\n');
INSERT INTO page VALUES (11991,223,3,'Be still, for the power of the Lord\nis moving in this place.\nHe comes to cleanse and heal,\nto minister His grace.\nNo work too hard for Him,\nin faith receive from Him,\nBe still, for the power of the Lord\nis moving in this place.');
INSERT INTO page VALUES (5085,227,4,'Crown Him the Lord of love;\nBehold His hands and side,\nThose wounds, yet visible above,\nIn beauty glorified:\nAll hail, Redeemer, hail!\nFor Thou hast died for me:\nThy praise and glory shall not fail\nThrough all eternity.');
INSERT INTO page VALUES (9890,173,1,'I cannot tell why He who angels worship,\nShould set His love \nupon the sons of men,\nOr why, as Shepherd, \nHe should seek the wand\'rers,\nTo bring them back, \nthey know not how or when');
INSERT INTO page VALUES (3619,189,4,'Let all that dwell above the sky, \nAnd air and earth and seas,\nConspire to life Thy glories high,\nAnd speak Thine endless praise.');
INSERT INTO page VALUES (3471,182,3,'Your hand lifted me up\nI stand on higher ground\nYour praise rose in my heart\nAnd made this valley sing');
INSERT INTO page VALUES (3556,187,2,'Now Your presence fills this place\nBe exalted in our praise\nAs we worship I believe\nYou are near');
INSERT INTO page VALUES (3555,187,1,'In awe of You we worship\nAnd stand amazed at Your great love\nWe\'re changed from glory to glory\nWe set our hearts on You our God');
INSERT INTO page VALUES (3469,182,1,'Your light broke through my night\nRestored exceeding joy\nYour grace fell like rain\nAnd made this desert live');
INSERT INTO page VALUES (3662,192,1,'King of my life, I crown Thee now,\nThine shall the glory be;\nLest I forget Thy thorn-crowned brow,\nLead me to Calvary.\n\nLest I forget Gethsemane;\nLest I forget Thine agony;\nLest I forget Thy love for me,\nLead me to Calvary.');
INSERT INTO page VALUES (6053,199,4,'It\'s you I live for everyday,\nIt\'s you I live for everyday,\nIt\'s you I live for everyday.');
INSERT INTO page VALUES (8618,190,1,'Teach me to dance\nto the beat of your heart\nTeach me to move\n in the power of your Spirit\nTeach me to walk\n in the light of your presence\nTeach me to dance\n to the beat of your heart.');
INSERT INTO page VALUES (8619,190,2,'Teach me to love \nwith your heart of compassion\nTeach me to trust \nin the word of your promise\nTeach me to hope \nin the day of your coming\nTeach me to dance \nto the beat of your heart');
INSERT INTO page VALUES (8620,190,3,'You wrote the rhythm of life\nCreated heaven and earth\nIn you is joy without measure\nSo like a child in your sight\nI dance to see you delight\nFor I was made for your pleasure,\npleasure');
INSERT INTO page VALUES (8621,190,4,'Teach me to dance\nto the beat of your heart\nTeach me to move\n in the power of your Spirit\nTeach me to walk\n in the light of your presence\nTeach me to dance\n to the beat of your heart.');
INSERT INTO page VALUES (8622,190,5,'Teach me to love \nwith your heart of compassion\nTeach me to trust \nin the word of your promise\nTeach me to hope \nin the day of your coming\nTeach me to dance \nto the beat of your heart');
INSERT INTO page VALUES (8623,190,6,'Let all my movements express\nA heart that loves to say yes\nA will that leaps to obey you\nLet all my energy blaze\nTo see the joy in your face\nLet my whole being praise you,\nPraise you.');
INSERT INTO page VALUES (8624,190,7,'Teach me to dance\nto the beat of your heart\nTeach me to move\n in the power of your Spirit\nTeach me to walk\n in the light of your presence\nTeach me to dance\n to the beat of your heart.');
INSERT INTO page VALUES (8625,190,8,'Teach me to love\nwith your heart of compassion\nTeach me to trust\nin the word of your promise\nTeach me to hope\nin the day of your coming\n\nTeach me to dance to \nthe beat of your heart (x3)\n');
INSERT INTO page VALUES (7399,191,4,'Hold me close,\nLet your love surround me,\nBring me near,\nDraw me to your side,\nAnd as I wait....\nI\'ll rise up like the eagle,\nAnd I will soar with you,\nYour spirit leads me on,\nIn the power of your love');
INSERT INTO page VALUES (3664,192,3,'Let me, like Mary, through the gloom\nCome with a gift to thee;\nShow to me now the empty tomb,\nlead me to calvary\n\nLest I forget Gethsemane;\nLest I forget Thine agony;\nLest I forget Thy love for me,\nLead me to Calvary.');
INSERT INTO page VALUES (3665,192,4,'May I be willing Lord,\nto bear daily my cross for thee;\nEven the cup of grief to share,\nThoust hast borne all for me;\n\nLest I forget Gethsemane;\nLest I forget Thine agony;\nLest I forget Thy love for me,\nLead me to Calvary.');
INSERT INTO page VALUES (6051,199,2,'Everyday Lord I\'ll\nlearn to stand upon your word\nAnd I pray that I \nI might come to know you more\nThat you would guide me\nin every single step I take that\nEveryday I can be your\nlight unto the world');
INSERT INTO page VALUES (3696,193,1,'This is Holy ground\nWe\'re standing on Holy ground\nFor the Lord is here and\n where He is, is Holy');
INSERT INTO page VALUES (3697,193,2,'This is Holy ground\nwe\'re standing on Holy ground\nFor the Lord is here and\n where He is, Is Holy\nWe are standing on Holy ground\nand I know that there\n are angels all around\n\nLet us praise Jesus now\nWe are standing in His presence\n on holy ground.');
INSERT INTO page VALUES (5618,170,3,'We believe He sends His Spirit\nOn His church with gifts of power\nGod His word of truth affirming\nSends us to the nations now.\nHe will come again in glory\nJudge the living and the dead\nEvery knee shall bow before Him\nThen must every tongue confess');
INSERT INTO page VALUES (4965,224,2,'O happy day!\nO happy day!\nwhen Jesus washed my sins away;\nhe taught me how to watch and pray,\nand live rejoicing every day;\nO happy day!\nO happy day!\nwhen Jesus washed my sins away;');
INSERT INTO page VALUES (3787,194,6,'We worship at Your feet, \nwhere wrath and mercy meet.\nAnd a guilty world is washed \nby love\'s pure stream.\nFor us He was made sin, \nOh, help me take it in.\nDeep wounds of love cry \nout \'Father, forgive,\'\nI worship, I worship the \nLamb who was slain');
INSERT INTO page VALUES (3786,194,5,'Man of heaven, born to earth \nto restore us Your heaven.\nHere we bow in awe beneath \nYour searching eyes.\nFrom Your tears comes our joy, \nfrom Your death our life shall spring;\nBy Your resurrection power we shall arise.');
INSERT INTO page VALUES (3785,194,4,'We worship at Your feet, \nwhere wrath and mercy meet.\nAnd a guilty world is washed \nby love\'s pure stream.\nFor us He was made sin, \nOh, help me take it in.\nDeep wounds of love cry \nout \'Father, forgive,\'\nI worship, I worship the \nLamb who was slain');
INSERT INTO page VALUES (3784,194,3,'Come and weep, come and mourn, \nfor your sin that pierced Him there;\nSo much deeper than the wounds \nof thorn and nail.\nAll our pride, all our greed, \nall our fallenness and shame;\nAnd the Lord has laid the\n punishment on Him.');
INSERT INTO page VALUES (3783,194,2,'We worship at Your feet, \nwhere wrath and mercy meet.\nAnd a guilty world is washed \nby love\'s pure stream.\nFor us He was made sin, \nOh, help me take it in.\nDeep wounds of love cry \nout \'Father, forgive,\'\nI worship, I worship the \nLamb who was slain');
INSERT INTO page VALUES (3782,194,1,'Come and see, come and see, \ncome and see the King of love,\nSee the purple robe and crown \nof thorns He wears.\nSoldiers mock, rulers sneer as \nHe lifts the cruel cross;\nLone and friendless now he \nclimbs towards the hill.');
INSERT INTO page VALUES (12518,33,2,'This is our God, the servant King\nHe calls us now to follow Him;\nTo bring our lives as a daily offering\nOf worship to the Servant King.');
INSERT INTO page VALUES (12517,33,7,'So let us learn how to serve,\nAnd in our lives enthrone Him,\nEach other\'s needs to prefer,\nFor it is Christ we\'re serving.');
INSERT INTO page VALUES (12516,33,3,'There in the garden of tears,\nMy heavy load He chose to bear.\nHis heart with sorrow was torn,\nYet not my will but Yours, He said.');
INSERT INTO page VALUES (12515,33,1,'From heaven You came, helpless Babe,\nEntered our world Your glory veiled;\nNot to be served,  but to serve,\nAnd give Your life that we might live.');
INSERT INTO page VALUES (12514,33,4,'This is our God, the servant King\nHe calls us now to follow Him;\nTo bring our lives as a daily offering\nOf worship to the Servant King.');
INSERT INTO page VALUES (12513,33,6,'This is our God, the servant King\nHe calls us now to follow Him;\nTo bring our lives as a daily offering\nOf worship to the Servant King.');
INSERT INTO page VALUES (11964,195,2,'Forbid it Lord that I should boast,\nSave in the cross of Christ, my God:\nAll the vain things that charm me most,\nI sacrifice them to his blood.');
INSERT INTO page VALUES (11963,195,3,'See, from his head, his hands, his feet,\nSorrow and love flow mingled down!\nDid e\'er such love and sorrow meet,\nOr thorns compose so rich a crown?');
INSERT INTO page VALUES (11961,195,4,'Were the whole realm of nature mine,\nThat were an offering far too small;\nLove so amazing, so divine,\nDemands my soul, my life, my all.');
INSERT INTO page VALUES (11962,195,1,'When I survey the wondrous cross\nOn which the Prince of Glory died,\nMy richest gain I count but loss,\nAnd pour contempt on all my pride.');
INSERT INTO page VALUES (6050,199,1,'What to say Lord it\'s\nyou who gave me life and I\ncan\'t explain just how much\nyou mean to me now\nthat you have saved me Lord\nI give all that I am to you\nThat everyday I can be a light\nthat shines your name');
INSERT INTO page VALUES (3839,198,3,'Worthy is the lamb,\nSeated on the throne.\nCrown You now with many crowns.\nYou reign victorious.\nHigh and lifted up\nJesus son of God\nThe darling of heaven crucified\nWorthy is the Lamb\nWorthy is the Lamb');
INSERT INTO page VALUES (3837,198,1,'Thank You for the cross, Lord\nThank You for the price You paid\nBearing all my sin and shame,\nIn love You came\nand gave amazing Grace');
INSERT INTO page VALUES (3838,198,2,'Thank you for this love, Lord\nThank you for the nail pierced hands.\nWashed me in Your cleansing flow\nNow all I know, \nYour forgiveness and embrace.');
INSERT INTO page VALUES (3921,165,1,'There is a redeemer\nJesus, God\'s own Son\nPrecious Lamb of God, Messiah\nHoly One.');
INSERT INTO page VALUES (3922,165,2,'Thank you O our Father\nFor giving us your Son\nAnd leaving your Spirit\nTill your work on Earth is done.');
INSERT INTO page VALUES (5630,204,3,'Christ is risen! all the sadness \nof His earthly life is o\'er;\nThrough the open gates of gladness\nHe returns to life once more\nDeath and hell before Him bending, \nHe doth rise the victor now,\nAngels on His steps attending, \nglory round his wounded brow.');
INSERT INTO page VALUES (12512,33,8,'This is our God, the servant King\nHe calls us now to follow Him;\nTo bring our lives as a daily offering\nOf worship to the Servant King.');
INSERT INTO page VALUES (5681,142,1,'All creation cries to you\nWorshipping in spirit and in truth\nGlory to the faithfull one\nJesus Christ God\'s son');
INSERT INTO page VALUES (5682,142,2,'All creation gives you praise\nYou alone are truly great\nYou alone are God who reigns\nFor eternity');
INSERT INTO page VALUES (13631,274,3,'You are my Rock\nYou are my Lord\nA shelter from the storm\nA light in the dark\n\nAnd you are my shield\nThe power of my life\nYou lit a fire that burns within\nYou are my Rock');
INSERT INTO page VALUES (4253,121,3,'Jesus lives\nHe lives in me\nNow I live\nIn victory\n\n');
INSERT INTO page VALUES (6052,199,3,'Everyday It\'s you I live for,\nEveryday I\'ll follow after you\nEveryday I\'ll walk with you my Lord');
INSERT INTO page VALUES (5233,200,3,'Your love is surprising,\nI can feel is rising\nAll the joy that\'s growing\n deep inside of me\nEverytime I see you,\nall your goodness shines through\nAnd I can feel this God song,\nrising up in me');
INSERT INTO page VALUES (5232,200,2,'Hallelujah, Hallelujah, Hallelujah\nYour Love makes me sing\nHallelujah, Hallelujah, Hallelujah\nYour Love makes me sing');
INSERT INTO page VALUES (5231,200,1,'Your love is amazing,\nsteady and unchanging\nYour love is a mountain,\nfirm beneath my feet\nYour love is a mystery,\nhow you gently lift me\nWhen I am surrounded,\nyour love carries me');
INSERT INTO page VALUES (5025,164,1,'Standing on the promises of Christ my King,\nThro\' eternal ages let His praises ring;\nGlory in the highest, I will shout and sing,\nStanding on the promises of God.');
INSERT INTO page VALUES (5632,204,5,'Christ is risen! henceforth never \ndeath nor hell shall us enthrall;\nWe are Christ\'s, in Him for ever\n we have triumphed over all;\nAll the doubting and dejection \nof our trembling hearts have ceased.\n\'Tis His day of resurrection; \nlet us rise and keep the feast.');
INSERT INTO page VALUES (10025,208,2,'I\'ll always love you. \nI\'ll always sing to You. Jesus\nI long to worship You in \nSpirit and in truth');
INSERT INTO page VALUES (10026,208,3,'Every day I\'ll come\nto spend my life with You.\nLearning of Your heart, \nand what You\'re calling me to do.\nMy every breath belongs to You\n');
INSERT INTO page VALUES (5804,259,6,'Come, let us sing for joy to the Lord\nLet us shout aloud to\n  the rock of our salvation!\n(repeat)\n\nCome let us sing for joy to the Lord\n                                  (repeat x 4)');
INSERT INTO page VALUES (5794,261,2,'Our own Malawi, this land so fair,\nFertile and brave and free.\nWith its lakes, refreshing mountain air,\nHow greatly blest are we.\nHills and valleys, soil so rich and rare,\nGive us a bounty free.Wood and forest, \nplains so broad and fair,\nAll-beauteous Malawi.');
INSERT INTO page VALUES (5723,205,5,'No more we doubt thee,\nGlorious Prince of life!\nLife is naught without thee;\nAid us in our strife;\nMake us more than conquerors, \nthrough Thy deathless love;\nBring us safe through Jordan,\nTo thy home above.');
INSERT INTO page VALUES (5724,205,6,'Thine is the glory,\nRisen conquering Son;\nEndless is the victory\nThou o\'er death hast won.');
INSERT INTO page VALUES (9154,317,3,'Oh I feel  like dancing,\nIts foolishness I know\nBut when the world\nhas seen the light\nThey will dance with joy\nlike I\'m dancing now');
INSERT INTO page VALUES (6036,270,1,'I want to know You more and more\nI want to feel Your love pouring over me\nI want me heart to beat in Your arms\nI want to know the touch of my father.');
INSERT INTO page VALUES (5803,259,5,'Let us bow before him in our worship\nLet us kneel before God our great King;\nFor he is our God and we are his people\nThat\'s why we shout and sing!');
INSERT INTO page VALUES (5658,258,2,'And as a sign to you,\nThat we would love the same,\nOur hearts will sing that song,\nGod, let Your glory come.');
INSERT INTO page VALUES (5659,258,3,'You are good, You are good, \nAnd Your love endures\nYou are good, You are good, \nAnd Your love endures\nYou are good, You are good, \nAnd Your love endures Today.');
INSERT INTO page VALUES (5795,261,3,'Freedom ever, let us all unite \nTo build up Malawi.\nWith our love, our zeal and loyalty,\nBringing our best to her.\nIn time of war, or in time of peace,\nOne purpose and one goal.\nMen and women serving selflessly\nIn building Malawi.');
INSERT INTO page VALUES (12345,214,2,'There is a flowing river,\nWithin God\'s holy city,\nGod is in the midst of her-\nShe shall not be moved!\nGod\'s help is swiftly given,\nThrones vanish at his presence,\nGod the Lord of hosts us \nis with us evermore.');
INSERT INTO page VALUES (4192,118,3,'Lord You\'re more than enough for me\n\n');
INSERT INTO page VALUES (11885,213,1,'For you have set me free\nYour all that I seek\nYour love completes my life\nYour the air that I breathe\nand the Saviour of the world \nIs the reason I live and I will sing');
INSERT INTO page VALUES (5633,204,6,'Christ is risen! hallelujah! \nRisen our victorious Head;\nSing His praises, hallelujah!\nChrist is risen from the dead.');
INSERT INTO page VALUES (5628,204,1,'Christ is risen! Hallelujah!\nRisen our victorious Head.\nSing His praises, hallelujah!\nChrist is risen from the dead\nGratefully our hearts adore Him,\nas His light once more appears;\nbowing down in joy before Him,\nrising up from grief and tears');
INSERT INTO page VALUES (5629,204,2,'Christ is risen! hallelujah! \nRisen our victorious Head;\nSing His praises, hallelujah!\nChrist is risen from the dead.');
INSERT INTO page VALUES (5721,205,3,'Lo! Jesus meets us, \nrisen from the tomb;\nLovingly He greets us, \nscatters fear and gloom;\nLet His church with gladness, \nhymns of triumph sing,\nFor her Lord now liveth; \nDeath has lost its sting.');
INSERT INTO page VALUES (5722,205,4,'Thine is the glory, \nRisen conquering Son;\nEndless is the victory \nThou o\'er death hast won.');
INSERT INTO page VALUES (5719,205,1,'Thine is the glory, \nRisen conquering Son;\nEndless is the victory\nThou o\'er death hast won.\nAngels in bright raiment\nrolled the stone away,\nKept the folded grave \nclothes where Thy body lay.');
INSERT INTO page VALUES (5720,205,2,'Thine is the glory, \nRisen conquering Son;\nEndless is the victory\nThou o\'er death hast won.');
INSERT INTO page VALUES (10027,208,4,'And with this song we\'ll lift \nthe name of Jesus higher\nAnd with a shout we\'ll raise up one voice\n');
INSERT INTO page VALUES (11116,131,6,'You alone are my strength, my shield,\nTo you alone may my spirit yield, \nYou alone are my heart\'s desire,\nAnd I long to worship you.');
INSERT INTO page VALUES (4130,130,4,'Holy Spirit have your way\nSweet anointing teach our hearts,\nour lives we pray');
INSERT INTO page VALUES (9897,173,8,'But this I know, the skies \nwill thrill with rapture, And myriad, \nmyriad human voices sing,\nAnd Earth to Heav\'n, \nand Heav\' to Earth, will answer,\nAt last the Saviour, \nSaviour of the world is King!');
INSERT INTO page VALUES (5631,204,4,'Christ is risen! hallelujah! \nRisen our victorious Head;\nSing His praises, hallelujah!\nChrist is risen from the dead.');
INSERT INTO page VALUES (4073,206,7,'Raised from death to heaven ascending,\nlove\'s exalted King.\nLet His song of joy, unending,\nthrough the nations ring!');
INSERT INTO page VALUES (4072,206,6,'Christ is risen!\nDeath has been conquer\'d\nChrist is risen!\nHe shall reign for ever');
INSERT INTO page VALUES (4071,206,5,'Now the fear of death is broken,\nlove has won the crown.\nPris\'ners of the darkness listen,\nwalls are tumbling down.');
INSERT INTO page VALUES (4070,206,4,'Christ is risen!\nDeath has been conquer\'d\nChrist is risen!\nHe shall reign for ever');
INSERT INTO page VALUES (4069,206,3,'Hell has spent its fury on Him,\nleft Him crucified.\nYet, by blood. He boldly conquered,\nsin and death defied.');
INSERT INTO page VALUES (4068,206,2,'Christ is risen!\nDeath has been conquer\'d\nChrist is risen!\nHe shall reign for ever');
INSERT INTO page VALUES (4067,206,1,'In the tomb so cold they laid Him,\ndeath its victim claim\'d\nPow\'rs of hell, they could not hold Him;\nback to life He came');
INSERT INTO page VALUES (4088,207,6,'Because He lives\n I can face tomorrow,\nBecause He lives\n all fear is gone;\nBecause I know\n He holds the future.\nAnd life is worth the\n living just because, He lives');
INSERT INTO page VALUES (4087,207,5,'And then one day\n I\'ll cross the river,\nI\'ll fight life\'s final war with pain;\nAnd then as death\n gives way to victory,\nI\'ll see the lights of glory and \nI\'ll know He lives.');
INSERT INTO page VALUES (4086,207,4,'Because He lives\n I can face tomorrow,\nBecause He lives\n all fear is gone;\nBecause I know\n He holds the future.\nAnd life is worth the\n living just because, He lives');
INSERT INTO page VALUES (4085,207,3,'How sweet to hold\n a new-born baby,\nAnd feel the pride,\n and joy he gives;\nBut greater still the\n calm assurance,\nThis child can face\n uncertain days\nbecause He lives');
INSERT INTO page VALUES (4084,207,2,'Because He lives\n I can face tomorrow,\nBecause He lives\n all fear is gone;\nBecause I know\n He holds the future.\nAnd life is worth the\n living just because, He lives');
INSERT INTO page VALUES (4083,207,1,'God sent His Son,\n they called Him Jesus,\nHe came to love,\n heal and forgive;\nHe lived and died\n to buy my pardon,\nAn empty grave is there\n to prove my Saviour lives.');
INSERT INTO page VALUES (4074,206,8,'Christ is risen!\nDeath has been conquer\'d\nChrist is risen!\nHe shall reign for ever');
INSERT INTO page VALUES (13521,606,9,'Shout to the north and the south,\nSing to the east and the west.\nJesus is Saviour to all,\n Lord of heaven and earth.\n\n Lord of heaven and earth. (x3)');
INSERT INTO page VALUES (13522,613,5,'I\'d stay in the garden with Him,\nThough the night\n around me be falling,\nBut He bids me go\n through the voice of woe.\nHis voice to me is calling.');
INSERT INTO page VALUES (13523,613,2,'And He walks with me,\n And He talks with me,\n And He tells me I am His own;\nAnd the joy we share\n as we tarry there,\nNone other has ever known.');
INSERT INTO page VALUES (13524,613,3,'He speaks, and the sound of\n His voice is so sweet,\n the birds hush their singing,\nAnd the melody that\n He gave to me,\nWithin my heart is ringing.');
INSERT INTO page VALUES (4968,224,5,'Now rest, my long-divided heart,\nFixed on this blissful centre, rest;\nnor ever from thy Lord depart,\nwith him ev\'ry good possessed.');
INSERT INTO page VALUES (11886,213,3,'And I will wait on You\nIn the stillness Lord\nListen for Your voice\nPure as gold refines in\nYour presence Lord\nHere where I belong');
INSERT INTO page VALUES (11887,213,2,'And I will lift my voice\nTo the one who has saved me \nI will sing, I will sing\nAnd I\'ll cry out for more\nSaying Lord I need You\nI will reach out\nReaching for more of You in my heart');
INSERT INTO page VALUES (4254,210,1,'Lord You have my heart\nAnd I will search for your\'s\nJesus take my life\nAnd lead me on');
INSERT INTO page VALUES (4255,210,2,'Lord You have my heart\nAnd I will search for yours\nLet me be to you a sacrifice');
INSERT INTO page VALUES (4256,210,3,'And I will praise you Lord\nAnd I will sing of love come down\nAs You show me your face\nWe\'ll see your glory here');
INSERT INTO page VALUES (5799,259,1,'Come let us sing for joy to the Lord\n                                         (repeat x 4)');
INSERT INTO page VALUES (5800,259,2,'Come, let us sing for joy to the Lord\nLet us shout aloud to\n  the rock of our salvation!\nCome, let us sing for joy to the Lord\nLet us shout aloud to\n  the rock of our salvation!\n');
INSERT INTO page VALUES (5802,259,4,'Come, let us sing for joy to the Lord\nLet us shout aloud to\n  the rock of our salvation!\nCome, let us sing for joy to the Lord\nLet us shout aloud to\n  the rock of our salvation!\n');
INSERT INTO page VALUES (5801,259,3,'Let us come before him with thanksgiving\nAnd extol him with music and song\nFor the Lord our Lord is the great God\nThe great King above all gods');
INSERT INTO page VALUES (4336,212,3,'And I will live for all my days\nto raise the banner of truth and light\nTo sing about my Saviour\'s love\nAnd the best thing that happened \nwas that day I met You');
INSERT INTO page VALUES (4532,218,2,'Do you not know, have you not heard\nMy Father does not get weary\nHe\'ll give passion to a willing heart\nAnd even though the youth\nGet tired and faint\nStrength will come to those who wait.');
INSERT INTO page VALUES (4335,212,2,'Well I felt like dancing in \nthe streets \'cause Jesus is alive\nTo join with all who celebrate \nthat Jesus is alive\nThe joy of God is in this town \n\'cause Jesus is alive\nFor everybody\'s seen the truth \nthat Jesus is alive');
INSERT INTO page VALUES (4334,212,1,'Well, I hear they\'re singing \nin the streets \'cause Jesus is alive\nAnd all creation shouts aloud \nthat Jesus is alive\nNow surely we can all be \nchanged \'cause Jesus is alive\nAnd everybody here can know \nthat Jesus is alive');
INSERT INTO page VALUES (5857,209,4,'Praise you in the heavens\njoining with the angels\nPraising you forever and a day\nPraise you on the earth now\njoining with creation\nCalling all the nations to your praise');
INSERT INTO page VALUES (5856,209,3,'If we could see how much you\'re worth\nYour power your might your endless love\nThen surely we would never cease to praise');
INSERT INTO page VALUES (5855,209,2,'Praise you in the morning, \nPraise you in the evening\nPraise you when I\'m young and when I\'m old\nPraise you when I\'m laughing, \nPraise you when I\'m grieving\nPraise you every season of the soul');
INSERT INTO page VALUES (5854,209,1,'Let everything that, everything that\nEverything that has breath praise the Lord\nLet everything that, everything that\nEverything that has breath praise the Lord');
INSERT INTO page VALUES (4337,212,4,'I\'ve found Jesus');
INSERT INTO page VALUES (4970,224,7,'High heav\'n, that heard the solemn vow,\nthat vow renewed shall daily hear;\ntill in life\'s latest hour I bow,\nand bless in death a bond so dear.');
INSERT INTO page VALUES (6843,172,6,'I\'m coming back\n to the heart of worship\nAnd It\'s all about you,\nIt\'s all about you Jesus\nI\'m sorry Lord\n for the thing I\'ve made it\nWhen It\'s all about You\nIt\'s all about You Jesus.');
INSERT INTO page VALUES (6842,172,5,'I\'ll bring you more than a song\nfor a song in itself \nis not what you have required\nyou search much deeper within\nthrough the way things appear\nYour looking into my heart');
INSERT INTO page VALUES (6840,172,3,'I\'m coming back\n to the heart of worship\nAnd It\'s all about you,\nIt\'s all about you Jesus\nI\'m sorry Lord\n for the thing I\'ve made it\nWhen It\'s all about You\nIt\'s all about You Jesus.');
INSERT INTO page VALUES (6839,172,2,'I\'ll bring you more than a song\nfor a song in itself \nis not what you have required\nyou search much deeper within\nthrough the way things appear\nYour looking into my heart');
INSERT INTO page VALUES (12414,77,4,'Lord of the Heavens and the Earth,\nMy Saviour Redeemer, Risen Lord.\nAll honour and glory, \npower and strength,\nTo Him upon the Throne.');
INSERT INTO page VALUES (12344,214,3,'Come see the works of our maker,\nLearn of His deeds all-powerful,\nWars will cease across the world,\nWhen He shatters the spear.\nBe still and know your creator,\nUplift Him in the nations,\nGod the Lord of hosts\nis with us evermore.');
INSERT INTO page VALUES (12343,214,1,'God is our strength and refuge,\nOur present help in trouble,\nAnd we therefore will not fear,\nThough the earth should change.\nThough mountains shake and tremble,\nThough swirling floods are raging,\nGod the Lord of hosts \nis with us evermore.');
INSERT INTO page VALUES (4408,215,1,'Praise the name of Jesus,\nPraise the name of Jesus,\nHe\'s my rock, He\'s my fortress,\nHe\'s my deliverer, in Him will I trust,\nPraise the name of Jesus.');
INSERT INTO page VALUES (5406,216,2,'And it\'s not by might,\nAnd it\'s not by power,\nAnd it\'s not by strength,\nBut by my Spirit says the Lord.');
INSERT INTO page VALUES (5407,216,3,'We\'re not staying \'round,\nWe\'re not looking behind,\nWe\'re just passing through,\nStep by step and line by line');
INSERT INTO page VALUES (5405,216,1,'We\'re not looking back,\nWe\'re not looking down,\nWe\'re just looking up!\nStep by step and line by line');
INSERT INTO page VALUES (4464,217,6,'This is the Great Southland of the \nHoly Spirit, a land of red \ndust plains and summer rains,\nto this sunburnt land\nwe will see a flood, and to this\nGreat Southland His Spirit comes.');
INSERT INTO page VALUES (4463,217,5,'This is our nation, this is our land,\nthis lucky country, of dreams gone dry.\nAnd to these peoples we see a harvest\nand to this land, revival comes.');
INSERT INTO page VALUES (4462,217,4,'This is the Great Southland of the \nHoly Spirit, a land of red \ndust plains and summer rains, \nto this sunburnt land\nwe will see a flood, and to this\nGreat Southland His Spirit comes.');
INSERT INTO page VALUES (4461,217,3,'This is our nation, this is our land,\nthis land of plenty, this land of hope.\nThe richest harvest is in Her peoples\nwe see revival His Spirit comes.');
INSERT INTO page VALUES (4460,217,2,'This is the Great Southland of the \nHoly Spirit, a land of red \ndust plains and summer rains, \nto this sunburnt land\nwe will see a flood, and to this\nGreat Southland His Spirit comes.');
INSERT INTO page VALUES (4459,217,1,'This is our nation, this is our land,\nthis is our future, this is our hope.\nA land of reaping, a land of harvest,\nthis is our land, this is our home.');
INSERT INTO page VALUES (4531,218,1,'They that wait on the Lord\nWill renew their strength\nRun and not get weary\nWalk and not faint\nThey that wait on the Lord\nWill renew their strength\nRun and not get weary\nWalk and not faint');
INSERT INTO page VALUES (4471,219,1,'In the secret, in the quiet place\nIn the stillness, You are there\nIn the secret, in the quiet hour\nI wait only for You.\n\'Cause I want to know You more');
INSERT INTO page VALUES (4472,219,2,'I am reaching for the highest goal\nThat I might receive the prize\nPressing onward, pushing every\nhindrance aside out of my way\n\'Cause I want to know You more.');
INSERT INTO page VALUES (4473,219,3,'I want to know You,\nI want to hear Your voice\nI want to know You more\nI want to touch You,\nI want to see Your face\nI want to know You more');
INSERT INTO page VALUES (6478,220,3,'I live for You\nYou are my God\nYou are the truth\nYou\'re all that I need\nMy Soul it longs\nfor more of You.');
INSERT INTO page VALUES (6477,220,2,'You are why I sing\nYou are why I live\nEverything of me\nI place at Your feet\nYou are why I love\nYou are why I give\nEverything of me\nBelongs to you');
INSERT INTO page VALUES (6476,220,1,'I live for You\nAll that I am\nAll that I do\nMy heart beats with You\nEach day I wake I think of You');
INSERT INTO page VALUES (12929,258,6,'A sacrifice was made,\nAnd then Your fire came,\nThey knelt upon the ground,\nAnd with one voice they praised.');
INSERT INTO page VALUES (11990,223,1,'Be still, for the presence of the Lord,\nthe Holy One is here.\nCome, bow before Him now,\nwith reverence and fear.\nIn Him no sin is found,\nwe stand on holy ground.\nBe still, for the presence of the Lord,\nthe Holy one is here.');
INSERT INTO page VALUES (9410,22,1,'I know He rescued my soul\nHis blood has covered my sins\nI Believe, I Believe.\n\nMy shame He\'s taken away,\nMy pain is healed in His name.\nI Believe, I Believe.');
INSERT INTO page VALUES (5812,262,1,'Our God is an awesome God,\nHe reigns, from heaven above.\nWith wisdom, power and love\nOur God is an awesome God');
INSERT INTO page VALUES (10798,318,5,'\'Cause you mean more to me\nThan any earthly thing\nSo won\'t you reign in me again.');
INSERT INTO page VALUES (5933,268,1,'*Sue Sid\n*Luke\n*The Thitchener\'s\n*Beth\n*Dianne\n*Trudy\n*Craig\n*Lyn Peterson\n*Cheryl\n*Others*');
INSERT INTO page VALUES (5903,265,1,'Let us break bread together with the Lord,\nLet us break bread together with the Lord,\nWhen I fall on my knees,\nWith my face to the rising sun,\nO Lord have mercy on me.');
INSERT INTO page VALUES (4971,224,8,'O happy day!\nO happy day!\nwhen Jesus washed my sins away;\nhe taught me how to watch and pray,\nand live rejoicing every day;\nO happy day!\nO happy day!\nwhen Jesus washed my sins away;');
INSERT INTO page VALUES (4969,224,6,'O happy day!\nO happy day!\nwhen Jesus washed my sins away;\nhe taught me how to watch and pray,\nand live rejoicing every day;\nO happy day!\nO happy day!\nwhen Jesus washed my sins away;');
INSERT INTO page VALUES (4913,44,3,'Worship You my Lord\nUntil the very End');
INSERT INTO page VALUES (10791,263,1,'I will dance\nI will sing\nTo be mad for my king\nNothing Lord is hindering\nThis passion in my soul (x2)');
INSERT INTO page VALUES (10793,263,2,'And I\'ll become\nEven more undignified than this\nSome may say it\'s foolishness\nBut I\'ll become\nEven more undignified than this\nSome may say it\'s foolishness');
INSERT INTO page VALUES (10792,263,3,'Na na na na na na   \nHey!\nNa na na na na na\nHey!\nNa na na na na na');
INSERT INTO page VALUES (4966,224,3,'\'Tis done, the work of grace is done!\nI am the Lord\'s, and he is mine!\nHe drew me, and I followed on,\nglad to confess the voice divine.');
INSERT INTO page VALUES (5083,227,2,'Crown Him the Lord of life,\nWho triumphed o\'er the grave,\nAnd rose victorious in the strife\nFor those He came to save;\nHis glories now we sing\nWho died, and rose on high,\nWho died eternal life to bring,\nAnd lives that death may die.');
INSERT INTO page VALUES (4964,224,1,'O happy day! that fixed my choice on thee,\nmy Saviour and my God!\nWell may this glowing heart rejoice,\nand tell its raptures all abroad.');
INSERT INTO page VALUES (5486,233,3,'And I\'ll let my words be few\nJesus I am so in love with you');
INSERT INTO page VALUES (6467,278,4,'Yes Jesus loves me,\nYes Jesus loves me,\nYes Jesus loves me,\nThe Bible tells me so.');
INSERT INTO page VALUES (7154,225,7,'Matthew 13:1 - 13:52\n\na. Soils are critical\nb. Evil (weeds) are in the church;\nc. Small starts (mustard seeds) are not insignificant;\nd. Good works (yeast) may not be visible, \n    but effective;\ne. The kingdom is worth searching for (like a pearl);\nf.  It is found differently (like treasure)\n');
INSERT INTO page VALUES (5084,227,3,'Crown Him the Lord of peace,\nWhose power a scepter sways\nFrom pole to pole, that wars may cease,\nAnd all be prayer and praise:\nHis reign shall know no end,\nAnd round His pierced feet\nFair flowers of paradise extend\nTheir fragrance ever sweet.');
INSERT INTO page VALUES (5082,227,1,'Crown Him with many crowns,\nThe Lamb upon His throne;\nHark! how the heavenly anthem drowns\nAll music but its own:\nAwake, my soul, and sing,\nOf Him who died for thee,\nAnd hail Him as thy matchless King\nThrough all eternity.');
INSERT INTO page VALUES (5808,228,4,'All to Jesus I surrender,\nNow I feel the sacred flame.\nO the joy of full salvation!\nGlory, glory to His name!\nI surrender all,\nI surrender all;\nAll to Thee, my blessed Saviour,\nI surrender all.');
INSERT INTO page VALUES (5807,228,3,'All to Jesus I surrender,\nMake me, Saviour, wholy Thine;\nLet me feel the Holy Spirit,\nTruly know that Thou art mine;\nI surrender all,\nI surrender all;\nAll to Thee, my blessed Saviour,\nI surrender all.');
INSERT INTO page VALUES (5806,228,2,'All to Jesus I surrender,\nHumbly at His feet I bow,\nWorldly pleasures all forsaken;\nTake me, Jesus, take me now;\nI surrender all,\nI surrender all;\nAll to Thee, my blessed Saviour,\nI surrender all.');
INSERT INTO page VALUES (5805,228,1,'All to Jesus I surrender,\nAll to Him I freely give;\nI will ever love and trust Him,\nIn His presence daily live;\nI surrender all,\nI surrender all;\nAll to Thee, my blessed Saviour,\nI surrender all.');
INSERT INTO page VALUES (10929,229,3,'Fierce may be the conflict, \nStrong may be the foe,\nBut the King\'s own army \nNone can overthrow;\nRound His standard ranging, \nVict\'ry is secure,\nFor His truth unchanging \nMakes the triumph sure:\nJoyfully enlisting');
INSERT INTO page VALUES (10925,229,6,'By Thy grace divine, \nAlways on the Lord\'s side,\nSaviour, we are Thine.');
INSERT INTO page VALUES (10926,229,2,'By Thy grace divine, \nWe are on the Lord\'s side,\nSaviour, we are Thine.');
INSERT INTO page VALUES (10927,229,1,'Who is on the Lord\'s side?\nWho will serve the King?\nWho will be His helpers \nOther lives to bring?\nWho will leave the world\'s side? \nWho will face the foe?\nWho is on the Lord\'s side, \nWho for Him will go?\nBy Thy call of mercy,');
INSERT INTO page VALUES (10928,229,5,'Chosen to be soldiers \nIn an alien land,\nChosen, called, and faithful,\nFor our captain\'s band; \nIn the service royal\nLet us not grow cold, \nLet us be right loyal,\nNoble, true, and bold: Master, \nThou wilt keep us,');
INSERT INTO page VALUES (5044,230,1,'My Jesus, I love Thee,\nI know Thou art mine,\nFor Thee all the follies,\nof sin I resign;\nMy gracious Redeemer,\nmy Saviour art Thou;\nIf ever I loved Thee,\nmy Jesus, \'tis now.');
INSERT INTO page VALUES (5045,230,2,'I love Thee because\nThou hast first loved me,\nAnd puchased my pardon\non Calvary\'s tree;\nI love Thee for wearing\nthe thorns on Thy brow;\nIf ever I loved Thee,\nmy Jesus, \'tis now.');
INSERT INTO page VALUES (5046,230,3,'I\'ll love Thee in life,\nI will love Thee in death,\nAnd praise Thee as long \nas Thou lendest me breath;\nAnd say when the death \ndew lies cold on my brow,\nIf ever I loved Thee,\nmy Jesus, \'tis now.');
INSERT INTO page VALUES (5047,230,4,'In mansions of glory\nand endless delight\nI\'ll ever adore Thee\nin heaven so bright\nI\'ll sing with the glittering\ncrown on my brow,\nIf ever I loved Thee,\nmy Jesus, \'tis now.');
INSERT INTO page VALUES (5048,231,1,'Give me a sight, O Saviour,\nof Thy wondrous love to me,\nOf love that bought Thee down to earth,\nTo die on Calvary.\nO make me understand it,\nHelp me to take it in,\nWhat it meant to Thee, the Holy One,\nTo bear away my sin.');
INSERT INTO page VALUES (5049,231,2,'Was it nails, O Saviour,\nThat bound Thee to the tree?\nNay, \'twas Thine everlasting love,\nThy love for me, for me.\nO make me understand it,\nHelp me to take it in,\nWhat it meant to Thee, the Holy One,\nTo bear away my sin.');
INSERT INTO page VALUES (5050,231,3,'O wonder of all wonders,\nThat through Thy death for me,\nMy open sins, my secret sins,\nCan all forgiven be!\nO make me understand it,\nHelp me to take it in,\nWhat it meant to Thee, the Holy One,\nTo bear away my sin.');
INSERT INTO page VALUES (5051,231,4,'Then melt my heart, O Saviour,\nBend me, yes, break me down,\nUntil I own Thee Conqueror,\nAnd Lord and Sov\'reign crown.\nO make me understand it,\nHelp me to take it in,\nWhat it meant to Thee, the Holy One,\nTo bear away my sin.');
INSERT INTO page VALUES (5485,233,4,'The simplest of all love songs\nI want to bring to you\nSo I\'ll let my words be few\nJesus I am so in love with you');
INSERT INTO page VALUES (5129,238,1,'Here I am waiting\nAbide in me I pray\nHere I am longing\nfor You');
INSERT INTO page VALUES (5093,232,1,'It\'s You I want\nIt\'s You that I adore\nIt\'s You I live for\n\nIt\'s You I want\nIt\'s You I adore\nIt\'s You I long for');
INSERT INTO page VALUES (5094,232,2,'Look inside my heart and see\nJust how much You mean to me\nKnow that I\'m nothing without you Lord.');
INSERT INTO page VALUES (5095,232,3,'I now raise my hands to you\nFor each and everything you do\nI will praise you with all that I am\nOn these words I will stand');
INSERT INTO page VALUES (5483,233,1,'You are God in heaven\nand here am I on earth\nso I\'ll let my words be few\nJesus I am so in love with you');
INSERT INTO page VALUES (5484,233,2,'And I\'ll stand in awe of you\nYes I\'ll stand in awe of you');
INSERT INTO page VALUES (6047,234,2,'Hallelujah, Hallelujah Hallelujah,\nyour love makes me Sing!');
INSERT INTO page VALUES (6046,234,1,'Your love is amazing, steady and \nUnchanging\nYour love is a mountian firm \nBeneath my feet\nYour love is a mystery, how you\ngently lift me\nWhen I am surrounded, your love \nCarries me');
INSERT INTO page VALUES (5103,235,1,'I wanna sing a song of praise unto my God\nI wanna tell my Lord how much I love him\nI wanna dance and clap and lift my hands in priase\nFor He \'s the one who died to save us (x2)');
INSERT INTO page VALUES (5104,235,2,'Oh Lord you are so real to me\nYou\'ve opened up my eyes to see');
INSERT INTO page VALUES (5105,235,3,'I will lift my hands to you my God\nAnd tell you how much I love you\nI will sing a song of Joy for you\nHave set my heart on fire');
INSERT INTO page VALUES (5133,239,1,'More love, more power,\nmore of You in my life\nMore love, more power,\nmore of You in my life.');
INSERT INTO page VALUES (12791,239,3,'You are my Lord,\nYou are my Lord.');
INSERT INTO page VALUES (12792,239,2,'And I will worship You\nwith all of my heart\nAnd I will worship You\nwith all of my mind\nAnd I will worship You\nwith all of my strength');
INSERT INTO page VALUES (12148,249,5,'You\'ve shown your grace, Lord\nSo undeserved.\nBy Your Spirit, fill me up Lord,\nIgnite my heart.');
INSERT INTO page VALUES (11305,137,6,'And the depth of grace,\nthe forgiveness found\nTo be called a child of God\n\nJust makes me say \nhow much I love You\nO my Saviour, my Lord and friend\n(repeat)');
INSERT INTO page VALUES (12495,236,4,'All the worship that I can give,\nevery hour that I\'m yet to live\nEvery good thing I\'ve ever recieved,\nI wanna give back to You');
INSERT INTO page VALUES (12496,236,1,'Every tear that I\'ve ever wept\nEvery Hard place that I\'ve ever slept\nEvery old scar that justified hate\nI wanna give back to you');
INSERT INTO page VALUES (12497,236,3,'Oh God my helper, God my shelter\nWhen I am weak, You are strong\nGot my healer, my provider\nYour mercy is all that I\'m resting upon');
INSERT INTO page VALUES (10717,237,2,'Lord let Your mercy\nwash away all of my sin\nFill me up completely\nwith your love once again\nI need You, I want You,\nI love Your presence\nI need You, I want You,\nI love Your presence');
INSERT INTO page VALUES (10716,237,1,'I can feel You flowing through me\nHoly Spirit come and fill me up\nCome and fill me up\nLove and mercy fill my senses\nI am thirsty for Your presence Lord\nCome and fill me up');
INSERT INTO page VALUES (5130,238,2,'Hide me in Your arms\nBring me to my knees\nMay I know Jesus\nMore and More');
INSERT INTO page VALUES (5131,238,3,'Come live in me\nAll my life\nTake over\nCome breathe in me\nAnd I will rise\nOn eagle\'s wings');
INSERT INTO page VALUES (5545,243,2,'Let me be a shining light for You\nLet me be a joy to you always\nLet me be a shining light for You\nLet me be a joy to you always.');
INSERT INTO page VALUES (11150,245,5,'As we gaze on your kingly brightness\nSo our faces display your likeness\nEver changing from glory to glory\nMirrored here may our lives tell your story\nShine on me, shine on me.');
INSERT INTO page VALUES (9542,251,2,'Well It\'s true today,\nthat when people pray\nWell see dead men rise\nand the blind set free\nYes It\'s true and I beleive it\nI\'m living for you.');
INSERT INTO page VALUES (5657,258,1,'Lord let your glory fall,\nAs on that anchient day,\nSongs of enduring love,\nAnd then Your glory came.');
INSERT INTO page VALUES (12930,464,1,'I\'m making melody in my heart to You\nI\'m making melody in my heart to You\nPouring out Your praise\nWith everything within');
INSERT INTO page VALUES (6048,234,3,'You love is surprising, I can feel\nIt rising\nAll the loy that\'s growing deep\nInside of me\nEvery time I see you, all your\nGoodness shines through\nAnd I can feel a God song, rising\nUp in me\n');
INSERT INTO page VALUES (5166,240,1,'Exalt the Lord our God\nExalt the Lord our God\nand worship at His holy hill\nFor the Lord our God\nHis name is Holy\n(Repeat)');
INSERT INTO page VALUES (5167,240,2,'We worship you Lord\nFor your name is Holy\n(Repeat)');
INSERT INTO page VALUES (5171,241,2,'So exalt, lift up on high\nThe name of Jesus\nMagnify, come glorify\nChrist Jesus the King\nMajesty, worship His majesty\nJesus who died, now glorified\nKing of all Kings');
INSERT INTO page VALUES (5170,241,1,'Majesty, Worship His Majesty\nUnto Jesus, be all glory\nPower and praise\nMajesty, Kingdom Authority\nFlow from His throne\nUnto His own\nHis anthem raise');
INSERT INTO page VALUES (5546,243,3,'And Lord, I love to bring to You\nThe honour due Your name:\nJust look at what You\'ve done for me\nI\'ll never be the same');
INSERT INTO page VALUES (5230,242,4,'I\'m pressed but not crushed\nPersecuted not abandoned\nStruck down but not destroyed\nI\'m blessed beyond the curse\nFor His mercies will endure.\nThat His joy is gonna be my strength\nThough my sorrow\nmay last for the night\nHis joy comes in the morning.');
INSERT INTO page VALUES (5229,242,3,'Yes Lord, yes Lord,\nyes, yes Lord.\n\nAmen');
INSERT INTO page VALUES (5227,242,1,'I\'m trading my sorrows\nI\'m trading my shame\nI\'m laying them down\nfor the joy of the Lord');
INSERT INTO page VALUES (5228,242,2,'I\'m trading my sickness\nI\'m trading my pain\nI\'m laying them down\nfor the joy of the Lord');
INSERT INTO page VALUES (5544,243,1,'I love You Lord, I worship You,\nI love You Lord, always.\nSo thankfull Lord\nyou saved my life\nYou saved my life today.');
INSERT INTO page VALUES (6996,244,4,'I\'ll never know\nhow much it cost\nto see my sin\nupon that cross');
INSERT INTO page VALUES (6995,244,3,'King of all days\noh so highly exalted\nGlorious in heaven above\nHumbly You came to the\nearth You created\nAll for love\'s sake\nbecame poor');
INSERT INTO page VALUES (6993,244,1,'Light of the world\nYou stepped down in to darkness\nOpened my eyes let me see\nBeauty that made this heart adore You\nHope of a life spent with You');
INSERT INTO page VALUES (6994,244,2,'So here I am to worship\nHere I am to bow down\nHere I am to say\nthat You\'re my God\nYou\'re altogether lovely\nAltogether worthy\nAltogether wonderful to me');
INSERT INTO page VALUES (5234,200,4,'Your love makes me sing.');
INSERT INTO page VALUES (5780,260,1,'Through our God we\n shall do valiantly\nIt is He who will tread\n down our enemies\nWe\'ll sing and \n shout His victory\nChrist is King!\n');
INSERT INTO page VALUES (5272,9,8,'Ever singing march we onwards,\nvictors in the midst of strife;\nJoyful music leads us sunward\nin the triumph song of life.');
INSERT INTO page VALUES (5329,60,1,'I will sing of the mercies of the Lord forever\nI will sing, I will sing\nI will sing of the mercies of the Lord forever\nI will sing of the mercies of the Lord');
INSERT INTO page VALUES (11149,245,2,'Shine, Jesus, shine\nFill this land with the Father\'s glory\nBlaze Spirit blaze, set our hearts on fire.\nFlow, river flow, flood the nations\nwith grace and mercy\nSend forth your word,\nand let there be light');
INSERT INTO page VALUES (11148,245,3,'Lord, I come to your awesome presence\nFrom the shadows into your radiance\nBy the blood I may enter your brightness\nSearch me, try me, \nconsume all my darkness\nShine on me, shine on me.');
INSERT INTO page VALUES (11147,245,1,'Lord the light of your love\nis shining in the midst of the\ndarkness, shining.\nJesus, light of the world,\nshine upon us\nSet us free by the truth you now bring us\nShine on me, shine on me.');
INSERT INTO page VALUES (11146,245,4,'Shine, Jesus, shine\nFill this land with the Father\'s glory\nBlaze Spirit blaze, set our hearts on fire.\nFlow, river flow, flood the nations\nwith grace and mercy\nSend forth your word,\nand let there be light');
INSERT INTO page VALUES (11145,245,6,'Shine, Jesus, shine\nFill this land with the Father\'s glory\nBlaze Spirit blaze, set our hearts on fire.\nFlow, river flow, flood the nations\nwith grace and mercy\nSend forth your word,\nand let there be light');
INSERT INTO page VALUES (5335,247,2,'O tell of His might,\nO sing of His grace,\nWhose robe is the light,\nWhose canopy space,.\nHis chariots of wrath\nThe deep thunder clouds form,\nAnd dark is His path\nOn the wing of the storm.');
INSERT INTO page VALUES (11138,246,2,'Jesus, only son of the living God\nJesus, you willingly suffered\nThat through you we might know his love\nJesus, cleanse us your people and fill us\nPour down your Spirit upon us\nthat we as your body may show\nforth your love');
INSERT INTO page VALUES (11137,246,3,'Spirit, sent by the Son to dwell in us\nLiving and working within us\nTo make us more like Jesus\nSpirit, fall down upon us as fire\nFill and equip us with power\nAnd draw from us love and \npraise to the Lord');
INSERT INTO page VALUES (11136,246,1,'Father, Father of all things\nWe bless you\nFather, we love and adore you\nO Father, your children praise you\nFather, Father of light and of power\nFather, your greatness surrounds the earth\nAnd all of your children declare\n\'You are Lord!\'');
INSERT INTO page VALUES (5334,247,5,'Frail children of dust,\nAnd feeble as frail,\nIn Thee do we trust\nNor find Thee to fail;\nThy mercies how tender,\nHow firm to the end!\nOur Maker, Defender,\nRedeemer and Friend,');
INSERT INTO page VALUES (5333,247,1,'O worship the King,\nAll glorious above;\nO gratefully sing His\npow\'r and His love;\nOur shield and defender,\nThe Ancient of Days,\nPavilioned in splendour,\nAnd girded with praise.');
INSERT INTO page VALUES (5336,247,3,'The earth, with its store\nOf wonders untold,\nAlmighty, Thy pow\'r\nHath founded of old;\nHath stablished it fast\nBy a changeless decree,\nAnd round it hath cast,\nLike a mantle, the sea.');
INSERT INTO page VALUES (5337,247,4,'Thy bountiful care\nWhat tongue can recite?\nIt breathes in the air,\nIt shines in the light;\nIt steams from the hills,\nIt descends to the plain,\nAnd sweetly distils\nIn the dew and the rain.');
INSERT INTO page VALUES (5338,247,6,'O measureless Might,\nIneffable Love,\nWhile angels delight\nTo hymn Thee above,\nThe humbler creation,\nThough feeble their lays,\nWith true adoration\nShall sing to Thy praise');
INSERT INTO page VALUES (7398,191,3,'Lord unveil my eyes\nLet me see you face to face\nThe knowledge of your love\nAs you live in me\nLord renew my mind\nAs your will unfolds in my life\nIn living every day\nIn the power of your love.');
INSERT INTO page VALUES (7397,191,2,'Hold me close,\nLet your love surround me,\nBring me near,\nDraw me to your side,\nAnd as I wait....\nI\'ll rise up like the eagle,\nAnd I will soar with you,\nYour spirit leads me on,\nIn the power of your love');
INSERT INTO page VALUES (7396,191,1,'Lord I come to you\nLet my heart be changed, renewed\nFlowing from the grace\nthat I\'ve found in you.\nAnd Lord I\'ve come to know\nThe weaknesses I see in me\nWill be stripped away\nBy the power of Your love.');
INSERT INTO page VALUES (5408,216,4,'And it\'s not by might,\nAnd it\'s not by power,\nAnd it\'s not by strength,\nBut by my Spirit says the Lord.');
INSERT INTO page VALUES (5400,248,2,'And I will live in your life\nI will love with Your love\nI will tell all the world You are Lord\nI am filled with your power\n    overflowing with joy\nI will tell all the world.');
INSERT INTO page VALUES (5399,248,1,'You placed Your love inside of me\nYou placed Your love inside my heart.\nYou poured Your power inside of me\nYou poured Your power inside my heart.');
INSERT INTO page VALUES (7737,313,3,'Oh, the splendour of His greatness\nOh, the beauty of His love\nOh, the depths of His forgiveness\nThe wonder of the Father\'s love.');
INSERT INTO page VALUES (7732,313,1,'Oh, the splendour of His greatness\nOh, the beauty of His love\nOh, the depths of His forgiveness\nThe wonder of the Father\'s love.');
INSERT INTO page VALUES (9538,251,1,'Is it true today,\nthat when people pray,\nCloudles skies will break,\nKings and queens will shake,\nYes it\'s true and I beleive it,\nI\'m living for You');
INSERT INTO page VALUES (10067,250,4,'Thankyou for the cross,\nThankyou for the cross,\nThankyou for the cross my friend.');
INSERT INTO page VALUES (10064,250,1,'Jesus Christ,\nI think upon your sacrifice.\nYou became nothing,\nPoured out to death.\nMany times,\nI\'ve wondered at you gift of life.\nI\'m in that place once again,\nI\'m in that place once again.');
INSERT INTO page VALUES (10065,250,2,'Once again I look upon\nthe cross where you died.\nI\'m humbled by your mercy\nand I\'m broken inside.\nOnce again I thank you\nOnce again I pour out my life.');
INSERT INTO page VALUES (5660,258,4,'Voices in unison,\nGiving you thanks and praise,\nJoined by the instruments,\nAnd then Your glory came.\n');
INSERT INTO page VALUES (5782,260,3,'Through our God we\n shall do valiantly\nIt is He who will tread\n down our enemies\nWe\'ll sing and \n shout His victory\n\nChrist is King!   (x3)\n');
INSERT INTO page VALUES (9540,251,4,'Into Your arms\nInto Your arms again');
INSERT INTO page VALUES (9541,251,5,'Well It\'s true today\nthat when people stand\nWith the fire of God\nand the truth in hand\nWell see miracles, we\'ll see angels sing\nWe\'ll see broken hearts making history\nYes it\'s true and I beleive it,\nI\'m living for you');
INSERT INTO page VALUES (11526,252,5,'All day,\nAll day now\nAll day.');
INSERT INTO page VALUES (11525,252,2,'I love You, I follow You\nYou are my, my life\nI will read my bible and pray\nI will follow You all day');
INSERT INTO page VALUES (9097,264,2,'I will run, I will crawl\nI will scale these city walls,\nthese city walls\nOnly to be with You.');
INSERT INTO page VALUES (9098,264,5,'You broke the bonds,\nYou loosed the chains\nCarried the cross,\nof my shame, of my shame\nYou know I believe it.');
INSERT INTO page VALUES (5906,266,1,'Brother, sister, let me serve you,\nlet me be as Christ to you;\npray that I may have the grace to\nlet you be my servant too.');
INSERT INTO page VALUES (9094,264,1,'I will climb the highest mountain\nI will run through the fields\nOnly to be with You,\nOnly to be with You');
INSERT INTO page VALUES (9095,264,4,'I believe in the kingdom come\nThen all the colours\nwill bleed into one,\nbleed into one.\nBut yes I\'m still running.');
INSERT INTO page VALUES (9096,264,6,'Cause I finally found,\nwhat I\'m looking for,\nCause I finally found,\nwhat I\'m looking for!');
INSERT INTO page VALUES (5602,256,1,'Thy loving kindness is better than life\nThy loving kindness is better than life\nMy lips shall praise thee\nThus I will bless thee\nThy lovingkindness is better than life');
INSERT INTO page VALUES (11111,338,2,'O may this bounteous God,\nThrough all our life be near us,\nWith ever joyful hearts,\nAnd blessed peace to cheer us.\nAnd keep us in His grace,\nAnd guide us when perplexed,\nAnd free us from all ills,\nIn this world and the next.');
INSERT INTO page VALUES (11110,338,3,'All praise and thanks to God\nThe father now be given,\nThe Son, and Him who reigns,\nWith them in highest heaven.\nThe one eternal God. \nWhom earth and heaven adore.\nFor thus it was is now,\nAnd shall be evermore.');
INSERT INTO page VALUES (9539,251,3,'I\'m gonna be a history\nmaker in this land\nI\'m gonna be a speaker\nof truth to all mankind\nI\'m gonna stand,\nI\'m gonna run into Your arms\nInto Your arms again');
INSERT INTO page VALUES (5781,260,2,'For God has won the victory\nAnd set His people free\nHis word has slain the enemy\nThe earth shall stand\nand see that...');
INSERT INTO page VALUES (5603,256,2,'I will lift my hands up unto thy name\nI will lift my hands up unto thy name\nMy lips shall praise thee\nThus I will bless thee\nThy lovingkindness is better than life');
INSERT INTO page VALUES (9905,257,2,'I will praise You with all my life,\nI will praise You with all my strength,\nWith all my life,\nWith all my strength,\nAll of my hope is in You.');
INSERT INTO page VALUES (9904,257,1,'My life is in You, Lord,\nMy strength is in You, Lord,\nMy hope is in You, Lord\nIn You, it\'s in You.\n(repeat)');
INSERT INTO page VALUES (6118,94,4,'Joy and peace, strength and hope,\nGrace that blows all fear away\nJesus, what a beautiful name');
INSERT INTO page VALUES (12657,31,4,'And now,\nlet the weak say I am strong,\nlet the poor say I am rich,\nBecause of what the Lord\nhas done for us\n(repeat)\n\nGive thanks. (x3)');
INSERT INTO page VALUES (5896,145,4,'Deeply in love,\nDeeply in love with You');
INSERT INTO page VALUES (5904,265,2,'Let us drink wine together with the Lord,\nLet us drink wine together with the Lord,\nWhen I fall on my knees,\nWith my face to the rising sun,\nO Lord have mercy on me.');
INSERT INTO page VALUES (5907,266,2,'We are pilgrims on a journey\nand companions on the road;\nwe are here to help each other\nwalk the mile and bear the load.');
INSERT INTO page VALUES (5908,266,3,'I will hold the Christ-light for you\nin the night-time of your fear;\nI will hold my hand out to you,\nspeak the peace you long to hear.');
INSERT INTO page VALUES (5909,266,4,'I will weep when you are weeping;\nwhen you laugh I\'ll laugh with you;\nI will share your joy and sorrow\ntill we\'ve seen this journey through.');
INSERT INTO page VALUES (5910,266,5,'Brother, sister, let me serve you,\nlet me be as Christ to you;\npray that I may have the grace to\nlet you be my servant too.');
INSERT INTO page VALUES (6049,234,4,'Your love makes me sing');
INSERT INTO page VALUES (7147,272,8,'Mission is \n\na. Compassionate;\nb. Crucial;\nc. Sustained;\nd. Shared;\ne. Complex;\nf.  Strategic;\ng. Demanding; and\nh. Jesus shaped.');
INSERT INTO page VALUES (12368,168,4,'And lead us not into temptation\nbut deliver us from evil.\nFor yours is the kingdom, \nthe power and the glory,\nnow and for ever, Amen.');
INSERT INTO page VALUES (12369,168,1,'Our Father, who art in heaven,\nHallowed be thy name.\nThy kingdom come, \nthy will be done\non earth, as it is in heaven.\nGive us this day our daily bread;\nAnd forgive us our trespasses,');
INSERT INTO page VALUES (5941,267,4,'Jesus, my Shepherd, Brother, Friend,\nMy Prophet, Priest and King,\nMy Lord, my Life, my Way, my End,\nAccept the praise I bring.');
INSERT INTO page VALUES (5942,267,5,'Weak is the effort of my heart,\nAnd cold my warmest thought;\nBut when I see Thee as Thou art,\nI\'ll praise Thee as I ought.');
INSERT INTO page VALUES (5938,267,1,'How sweet the Name\n of Jesus sounds\n In a believer\'s ear!\nIt soothes his sorrows,\n heals his wounds,\n And drives away his fear.');
INSERT INTO page VALUES (5940,267,3,'Dear Name! the Rock on which I build,\nMy Shield and Hiding Place,\nMy never failing Treasury, filled\nWith boundless stores of grace;');
INSERT INTO page VALUES (5939,267,2,'It makes the wounded spirit whole,\nAnd calms the troubled breast;\nTis manna to the hungry soul,\nAnd to the weary rest.');
INSERT INTO page VALUES (7146,272,7,'Mission is \n\na. Compassionate;\nb. Crucial;\nc. Sustained;\nd. Shared;\ne. Complex;\nf.  Strategic;\ng. Demanding; \n');
INSERT INTO page VALUES (6105,271,1,'Fear not, for I am with you\nFear not, for I am with you\nFear not, for I am with you says the Lord\n(Repeat)');
INSERT INTO page VALUES (7145,272,6,'Mission is \n\na. Compassionate;\nb. Crucial;\nc. Sustained;\nd. Shared;\ne. Complex;\nf.  Strategic;\n\n');
INSERT INTO page VALUES (7143,272,4,'Mission is \n\na. Compassionate;\nb. Crucial;\nc. Sustained;\n');
INSERT INTO page VALUES (7144,272,5,'Mission is \n\na. Compassionate;\nb. Crucial;\nc. Sustained;\nd. Shared;\ne. Complex;\n\n\n');
INSERT INTO page VALUES (7142,272,3,'Mission is \n\na. Compassionate;\nb. Crucial;');
INSERT INTO page VALUES (5969,269,1,'Basic Teaching for Disciples \nabout Kingdom Ethics - \n5:1 - 7:27');
INSERT INTO page VALUES (5970,269,3,'Influence as Kingdom characters -\n\nsalt and light.');
INSERT INTO page VALUES (5971,269,4,'The Righteousness of Kingdom characters -\n\nin 6 examples.');
INSERT INTO page VALUES (5972,269,5,'The Devotion of Kingdom characters -\n\nin giving, prayer and fasting.');
INSERT INTO page VALUES (5973,269,6,'The Ambitions of Kingdom characters -\n\nvalues and trust.');
INSERT INTO page VALUES (5974,269,7,'The Relationships of Kingdom characters -\n\nbeing discerning.');
INSERT INTO page VALUES (5975,269,8,'Response of Kingdom characters - \n\nobedience, telling others, and \nbecoming what you are.');
INSERT INTO page VALUES (5976,269,2,'Our Kingdom character - \n\n8 paradoxes in which to rejoice and take heart');
INSERT INTO page VALUES (5977,269,9,'Summary:\n----------\na. Our Kingdom character\nb. Influence as Kingdom characters\nc. The Righteousness of Kingdom characters\nd. The Devotion of Kingdom characters\ne. The Ambitions of Kingdom characters\nf. The Relationships of Kingdom characters\ng. Response of Kingdom characters');
INSERT INTO page VALUES (6106,271,2,'I have redeemed you\nI have called you by name.\nChild, you are mine.\nWhen you walk through the waters\nI will be there\nAnd through the flame\nYou\'ll not (no way!) be drowned\nYou\'ll not (no way!) be burned\nFor I am with you.');
INSERT INTO page VALUES (6038,270,3,'You are my life, You are my Love\nYou\'re what my dreams are made up of\nYou\'re reaching out with open hands\nAnd You understand my heart\nYou\'re taking me higher, Im falling deeper\nDeeper in love with You');
INSERT INTO page VALUES (6037,270,2,'I want Your dreams that burn within me\nI want to glow inside with the truth\nCause it\'s you that I adore\nAnd Its only You that I live for Jesus');
INSERT INTO page VALUES (7140,272,1,'Mission is ');
INSERT INTO page VALUES (7141,272,2,'Mission is \n\na. Compassionate;\n');
INSERT INTO page VALUES (9935,18,2,'I\'ve got Jesus, Jesus\nHe calls me for His own\nAnd He lifts me, lifts me\nAbove the world I know');
INSERT INTO page VALUES (11104,273,2,'Elect from every nation,\nYet one o\'er all the earth,\nHer charter of slavation,\nOne Lord, one faith, one birth,\nOne holy name she blesses,\nPartahes one holy food,\nAnd to one hope she presses,\nWith every grace endued.');
INSERT INTO page VALUES (11103,273,3,'Mid toil and tribulation,\nand tumult of her war,\nShe waits the consummation\nOf peace for evermore,\nTill with the vision glorious\nHer longing eyes are blest,\nAnd the great Church victorous\nShall be the Church at rest.');
INSERT INTO page VALUES (11102,273,1,'The Church\'s one foundation\nIs Jesus Christ our Lord:\nShe is His new creation\nBy water and the word;\nFrom heaven He came and sought her,\nAnd for her life he died.');
INSERT INTO page VALUES (11101,273,4,'Yet she on earth has union\nWith God the Three in One,\nAnd mystic sweet communion\nWith those whose rest is won.\nO happy ones and holy;\nLord, give us grace that we,\nLike them, the meek and lowly,\nOn high may dweel with Thee.');
INSERT INTO page VALUES (6349,274,1,'You are my Rock\nYou are my Lord\nA shelter from the storm\nA light in the dark\n\nAnd you are my shield\nThe power of my life\nYou lit a fire that burns within\nYou are my Rock\n\n(repeat)');
INSERT INTO page VALUES (6265,38,2,'Blessed be the Lord God Almighty\nWho was and is and is to come\nBlessed be the Lord God Almighty\nWho reigns for evermore');
INSERT INTO page VALUES (6264,38,1,'Father in heaven, how we love you\nWe lift your name in all the Earth\nMay your kingdom be \nestablished in our praises\nAs your people declare \nyour mighty works!');
INSERT INTO page VALUES (6350,274,2,'Singing Amen\n   Glory to the Risen Lord\nSinging Amen\n   You made me dance and sing\n   You\'re everything\n(repeat)');
INSERT INTO page VALUES (7155,225,8,'Matthew 13:1 - 13:52\n\na. Soils are critical\nb. Evil (weeds) are in the church;\nc. Small starts (mustard seeds) are not insignificant;\nd. Good works (yeast) may not be visible, \n    but effective;\ne. The kingdom is worth searching for (like a pearl);\nf.  It is found differently (like treasure)\ng. There is a response to our response (like a dragnet).');
INSERT INTO page VALUES (7184,275,4,'Fall like fire, soak like rain.\nFlow like mighty waters again and again.\nSweep away the darkness,\nBurn away the chaff,\nAnd let a flame burn to glorify Your name.');
INSERT INTO page VALUES (9153,317,2,'I could sing of your love forever\nI could sing of your love forever');
INSERT INTO page VALUES (6453,276,1,'Lay hold, lay hold\nUpon the good things of the Lord\nLay hold, lay hold\nUpon the good things of the Lord\nAnd let your conversation be\nAcceptable in the sight of the Lord\n(repeat)');
INSERT INTO page VALUES (7182,275,2,'Fall like fire, soak like rain.\nFlow like mighty waters again and again.\nSweep away the darkness,\nBurn away the chaff,\nAnd let a flame burn to glorify Your name.');
INSERT INTO page VALUES (7183,275,3,'There are higher heights, there are deeper seas,\nWhatever you need to do Lord, do it in me.\nThe glory of God fills my life\nAnd I will never be the same again.');
INSERT INTO page VALUES (7181,275,1,'I will never be the same again.\nI can never return, I\'ve closed the door.\nI will walk the path, I\'ll run the race\nAnd I will never be the same again.\n(repeat)');
INSERT INTO page VALUES (6346,184,8,'Forever, forever\nI will praise You\nI will praise You');
INSERT INTO page VALUES (7153,225,6,'Matthew 13:1 - 13:52\n\na. Soils are critical\nb. Evil (weeds) are in the church;\nc. Small starts (mustard seeds) are not insignificant;\nd. Good works (yeast) may not be visible, \n    but effective;\ne. The kingdom is worth searching for (like a pearl);\n\n');
INSERT INTO page VALUES (7152,225,5,'Matthew 13:1 - 13:52\n\na. Soils are critical\nb. Evil (weeds) are in the church;\nc. Small starts (mustard seeds) are not insignificant;\nd. Good works (yeast) may not be visible, \n    but effective;\n\n\n');
INSERT INTO page VALUES (7148,225,1,'Matthew 13:1 - 13:52\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (7149,225,2,'Matthew 13:1 - 13:52\n\na. Soils are critical\n\n\n\n\n\n');
INSERT INTO page VALUES (7150,225,3,'Matthew 13:1 - 13:52\n\na. Soils are critical\nb. Evil (weeds) are in the church;\n\n\n\n\n');
INSERT INTO page VALUES (7151,225,4,'Matthew 13:1 - 13:52\n\na. Soils are critical\nb. Evil (weeds) are in the church;\nc. Small starts (mustard seeds) are not insignificant;\n\n\n\n');
INSERT INTO page VALUES (6466,278,3,'Jesus loves me! He who died\nHeaven\'s gates to open wide!\nHe will wash away my sin,\nLet His little children in.');
INSERT INTO page VALUES (6464,278,1,'For the Bible tells me so\n\nJesus loves me! this I know,\nFor the Bible tells me so;\nLittle ones to Him belong;\nThey are weak but He is strong.');
INSERT INTO page VALUES (6465,278,2,'Yes Jesus loves me,\nYes Jesus loves me,\nYes Jesus loves me,\nThe Bible tells me so.');
INSERT INTO page VALUES (6459,277,4,'And we sing glory, honour\nPower and strength to the Lord\nWe sing glory, honour\nPower and strength to the Lord');
INSERT INTO page VALUES (6460,277,5,'When your enemy presses in hard\n  do not fear\nThe battle belongs to the Lord\nTake courage my friend \n  your redemption is near\nThe battle belongs to the Lord');
INSERT INTO page VALUES (6458,277,3,'When the power of darkness\n  comes in like a flood\nThe battle belongs to the Lord\nHe\'ll raise up a standard the power\n  of his blood\nThe battle belongs to the Lord.\n');
INSERT INTO page VALUES (6457,277,2,'And we sing glory, honour\nPower and strength to the Lord\nWe sing glory, honour\nPower and strength to the Lord');
INSERT INTO page VALUES (6456,277,1,'In heavenly armour\n  we\'ll enter the land\nThe battle belongs to the Lord\nNo weapon that\'s\n  fashioned against us will stand\nThe battle belongs to the Lord');
INSERT INTO page VALUES (6454,276,2,'Let me be a minister of thy peace\nLet me be a minister of thy peace\nThat the world might see\nThe love of God in me');
INSERT INTO page VALUES (6455,276,3,'Lay hold, lay hold\nUpon the good things of the Lord\nLay hold, lay hold\nUpon the good things of the Lord\nAnd let your conversation be\nAcceptable in the sight of the Lord');
INSERT INTO page VALUES (11132,283,4,'Breathe on me breath of God\nSo shall I never die\nBut live with You, the perfect life\nOf Your eternity.');
INSERT INTO page VALUES (6461,277,6,'And we sing glory, honour\nPower and strength to the Lord\nWe sing glory, honour\nPower and strength to the Lord');
INSERT INTO page VALUES (6468,278,5,'Jesus loves me! loves me still,\nTho\' I\'m very weak and ill;\nFrom His shining throne on high,\nComes to watch me where I lie.');
INSERT INTO page VALUES (6469,278,6,'Yes Jesus loves me,\nYes Jesus loves me,\nYes Jesus loves me,\nThe Bible tells me so.');
INSERT INTO page VALUES (6470,278,7,'Jesus loves me! He will stay\nClose beside me all the way;\nIf I love Him, when I die\nHe will take me home on high.');
INSERT INTO page VALUES (6471,278,8,'Yes Jesus loves me,\nYes Jesus loves me,\nYes Jesus loves me,\nThe Bible tells me so.');
INSERT INTO page VALUES (7997,282,5,'Forever You will be\nThe Lamb upon the throne;\nI gladly bow my knee\nAnd worship You alone.');
INSERT INTO page VALUES (7998,282,1,'All heaven declares\nThe glory of the risen Lord;\nWho can compare\nWith the beauty of the Lord.');
INSERT INTO page VALUES (7995,282,4,'Forever You will be\nThe Lamb upon the throne;\nI gladly bow my knee\nAnd worship You alone');
INSERT INTO page VALUES (7996,282,3,'I will proclaim\nThe glory of the risen Lord\nWho once was slain\nTo reconcile man to God.');
INSERT INTO page VALUES (11154,284,2,'Jesus,\nWe love You,\nWe praise You,\nWe adore You.\nGlorify Your name in all the earth.\nGlorify Your name.\nGlorify Your name.\nGlorify Your name in all the earth.');
INSERT INTO page VALUES (11524,252,3,'I don\'t care what it costs anymore\n\'Cause You gave it all\nand I\'m following You\nI don\'t care what it takes anymore\nNo matter what happens\nI\'m going Your way');
INSERT INTO page VALUES (11522,252,4,'I love You I follow You\nYou are my, my life\nI will read my bible and pray\nI will follow You all day');
INSERT INTO page VALUES (11523,252,1,'I don\'t care what they say about me\nIt\'s alright, all right\nI don\'t care what they think about me\nIt\'s alright, They\'ll get it one day');
INSERT INTO page VALUES (7139,279,8,'a. Humility - like children;\nb. Welcoming - for the unwelcome;\nc. Wholeheartedness - don\'t make others stumble;\nd. Pastoral Care - like a shepherd;\ne. Openness - what and how;\nf. Forgiveness - mercy tales;\ng. No resentment.');
INSERT INTO page VALUES (7138,279,7,'a. Humility - like children;\nb. Welcoming - for the unwelcome;\nc. Wholeheartedness - don\'t make others stumble;\nd. Pastoral Care - like a shepherd;\ne. Openness - what and how;\nf. Forgiveness - mercy tales;\n');
INSERT INTO page VALUES (7137,279,6,'a. Humility - like children;\nb. Welcoming - for the unwelcome;\nc. Wholeheartedness - don\'t make others stumble;\nd. Pastoral Care - like a shepherd;\ne. Openness - what and how;\n\n');
INSERT INTO page VALUES (7136,279,5,'a. Humility - like children;\nb. Welcoming - for the unwelcome;\nc. Wholeheartedness - don\'t make others stumble;\nd. Pastoral Care - like a shepherd;\n\n\n');
INSERT INTO page VALUES (7132,279,1,'');
INSERT INTO page VALUES (7133,279,2,'a. Humility - like children;\n\n\n\n\n\n');
INSERT INTO page VALUES (7134,279,3,'a. Humility - like children;\nb. Welcoming - for the unwelcome;\n\n\n\n\n');
INSERT INTO page VALUES (7135,279,4,'a. Humility - like children;\nb. Welcoming - for the unwelcome;\nc. Wholeheartedness - don\'t make others stumble;\n\n\n\n');
INSERT INTO page VALUES (7337,280,3,'a. Nocturnal burglar - watchfulness;\nb. Misconducting Servant - Holiness vs. decay;\n\n\n');
INSERT INTO page VALUES (7338,280,4,'a. Nocturnal burglar - watchfulness;\nb. Misconducting Servant - Holiness vs. decay;\nc. 10 bridesmaids - readiness;\n\n');
INSERT INTO page VALUES (7339,280,5,'a. Nocturnal burglar - watchfulness;\nb. Misconducting Servant - Holiness vs. decay;\nc. 10 bridesmaids - readiness;\nd. Varied talents - reliability with responsibilities;\n');
INSERT INTO page VALUES (7340,280,6,'a. Nocturnal burglar - watchfulness;\nb. Misconducting Servant - Holiness vs. decay;\nc. 10 bridesmaids - readiness;\nd. Varied talents - reliability with responsibilities;\ne. Sheep and Goats - relational love.');
INSERT INTO page VALUES (7335,280,1,'');
INSERT INTO page VALUES (7336,280,2,'a. Nocturnal burglar - watchfulness;\n\n\n\n');
INSERT INTO page VALUES (7170,281,4,'a. His confession of faith.\nb. His confession of doubt.\nc. His living of doubt.\n');
INSERT INTO page VALUES (7169,281,3,'a. His confession of faith.\nb. His confession of doubt.\n\n');
INSERT INTO page VALUES (7167,281,1,'');
INSERT INTO page VALUES (7168,281,2,'a. His confession of faith.\n\n\n');
INSERT INTO page VALUES (11153,284,3,'Spirit,\nWe love You,\nWe praise You,\nWe adore You.\nGlorify Christ\'s name in all the earth.\nGlorify His name.\nGlorify His name.\nGlorify Christ\'s name in all the earth.');
INSERT INTO page VALUES (11152,284,1,'Father,\nWe love You,\nWe praise You,\nWe adore You.\nGlorify Your name in all the earth.\nGlorify Your name.\nGlorify Your name.\nGlorify Your name in all the earth.');
INSERT INTO page VALUES (11151,285,1,'Holy Spirit come\nMake my ears to hear\nMake my eyes to see\nMake my mouth to speak\nMake my heart to seek\nAnd my hands to reach out\nAnd touch the world with your love');
INSERT INTO page VALUES (11107,286,2,'There let it for Thy glory burn,\nWith inextinguishable blaze;\nAnd, trembling to its source return\nin humble love and fervent praise.');
INSERT INTO page VALUES (11108,286,3,'Jesus, confirm my heart\'s desire\nTo work and speak and think for Thee;\nStill let me guard the holy fire\nAnd still stir up Thy gift in me.');
INSERT INTO page VALUES (11105,286,4,'Ready for all Thy perfect will,\nMy acts of faith and love repeat,\nTill death Thine endless mercies seal,\nAnd make the sacrifice complete.');
INSERT INTO page VALUES (11106,286,1,'O Thou who camest from above\nThe pure celestial fire to impart,\nKindle a flame of sacred love\nOn the mean altar of my heart.');
INSERT INTO page VALUES (12165,289,2,'Hail to the Lamb who was slain\nWorthy to rule and to reign\nWounded that He might redeem\nPower to save, power to heal.');
INSERT INTO page VALUES (6975,292,1,'I am so tired of compromising\nI am so tired of lukewarm living\nSo here I am with arms wide open\nLord here I am\nMy heart\'s wide open');
INSERT INTO page VALUES (12755,292,3,'Take this heart of mine\nPlace your love inside\nI wanna go against the grain\nI wanna go against the grain');
INSERT INTO page VALUES (11144,287,5,'When you knock I\'ll open wide the door\nIt\'s my heart\'s desire to be with my Lord\nKing of Light, I\'ll turn you not away,\nYou alone are worthy of my days.');
INSERT INTO page VALUES (11143,287,2,'You alone are worthy, God\nOf power and glory\nYou alone are worthy of my days,\nYou alone are worthy, God\nOf power and glory,\nYou alone are worthy of my praise.');
INSERT INTO page VALUES (11142,287,3,'Take my feet to run the race for you\nTake my hands for love,\ntake my whole heart too\nKing of love, I\'m yours at work and play\nYou alone are worthy of my days.');
INSERT INTO page VALUES (11141,287,1,'I will make my life a psalm for you\nI will fill my lips from the cup of truth.\nKing of life, I choose to walk your way.\nYou alone are worthy of my days.');
INSERT INTO page VALUES (11140,287,4,'You alone are worthy, God\nOf power and glory\nYou alone are worthy of my days,\nYou alone are worthy, God\nOf power and glory,\nYou alone are worthy of my praise.');
INSERT INTO page VALUES (11139,287,6,'You alone are worthy, God\nOf power and glory\nYou alone are worthy of my days,\nYou alone are worthy, God\nOf power and glory,\nYou alone are worthy of my praise.');
INSERT INTO page VALUES (12164,289,1,'The Lord is our God,\nand Jesus our king\nNone can redeem \nbut the lamb who was slain\nBroken and bruised, \ndespised of the earth\nJesus has risen \nto give us new birth.');
INSERT INTO page VALUES (9562,123,2,'And I surrender\nAll to you\nAll to you\n(repeat)');
INSERT INTO page VALUES (13653,648,3,'Hallelujah,\nHallelujah.\nHallelujah.\nHallelujah.');
INSERT INTO page VALUES (13652,648,1,'Your love is greater than\n the stars above the sea.\nYet your love is closer\n than the pulse of my own heartbeat.');
INSERT INTO page VALUES (13650,648,2,'Praise you, Praise you,\nYour love will never fail.\nThough the mountains shake\nand the earth it trembles,\nYour love will never fail.');
INSERT INTO page VALUES (13651,648,4,'Your love is greater than\n the stars above the sea.\nYet your love is closer\n than the pulse of my own heartbeat.');
INSERT INTO page VALUES (13649,647,1,'Love - 691\nFaith - 474\nChurch/Assembly - 109/158\nthe Cross - 219\nMarriage - 42\nGod, Lord - 3910/6691\nJustice/Judgment - 142/145\nMercy - 121\nPeace - 246\nthe Nation, peoples - 733/151\n(NIV)');
INSERT INTO page VALUES (7097,297,3,'Let us lift up holy hands\nAnd magnify His name\n and worship Him\n(repeat)\n\nLet us lift up holy hands\n and magnify His name\nAnd worship Christ the Lord,\nWorship Him, Christ the Lord.');
INSERT INTO page VALUES (12869,450,4,'Consuming fire, fan into flame\nA passion for Your name\nSpirit of God fall in this place.\nLord have Your way,\nLord have Your way with us.');
INSERT INTO page VALUES (7171,281,5,'a. His confession of faith.\nb. His confession of doubt.\nc. His living of doubt.\nd. His living of faith.');
INSERT INTO page VALUES (6998,296,1,'How do you think \"the church\" is doing on\nthe Central Coast in reaching youth and\nyoung adults who havent yet found Jesus?\n\n1. What issues should we look at and...\n2. How might we do things better?\n\nHow would Jesus have us, \nas Christians do things better?\n');
INSERT INTO page VALUES (7115,293,1,'You are my Shepherd,\nI have no needs\nYou lead me by\npeaceful streams\nAnd you refresh my life');
INSERT INTO page VALUES (7116,293,2,'You hold my hand\nand you guide my steps\nI could walk\nthrough the valley of death\nAnd I won\'t be afraid');
INSERT INTO page VALUES (7117,293,3,'Because you are in control\n\n');
INSERT INTO page VALUES (13402,584,1,'The steadfast love\n of the Lord never ceases,\nHis mercies never\n come to an end,\nThey are new every morning,\nNew every morning,\nGreat is Thy faithfulness\n O Lord,\nGreat is Thy faithfulness.');
INSERT INTO page VALUES (7118,293,4,'You cause everything to work together\nYou truly have a sovereign plan\nAnd you know who I am\nAnd you made who I am\nAnd you love who I am');
INSERT INTO page VALUES (12415,77,1,'Lord of the Heavens and the Earth,\nMy Saviour Redeemer, Risen Lord.\nAll honour and glory, \npower and strength,\nTo Him upon the Throne.\n(repeat)');
INSERT INTO page VALUES (6991,295,2,'Set me on fire\nSet me on fire\nSet me on fire\nSet me on fire');
INSERT INTO page VALUES (6992,295,3,'Take this heart of mine\nPlace your love inside\nI wanna go against the grain\nI wanna go against the grain');
INSERT INTO page VALUES (6990,295,1,'I am so tired of compromising\nI am so tired of lukewarm living\nSo here i am with arms wide open\nLord, here i am\nMy hearts wide open\n');
INSERT INTO page VALUES (6999,296,2,'If Jesus was to walk through the streets\nof the Central Coast:\n\nWhat would Jesus see when he walked\nthrough here and...\nWhat would Jesus do about it?');
INSERT INTO page VALUES (7095,297,1,'We have come into His house\nAnd gathered in His \n name to worship Him\n(repeat)\n\nWe have come into His house\nAnd gathered in His name\nTo worship Christ the Lord\nWorship Him, Christ the Lord.');
INSERT INTO page VALUES (7096,297,2,'So forget about yourself\nAnd concentrate on Him\n and worship Him,\n(repeat)\n\nSo forget about yourself\nand concentrate on Him \nand worship Christ the Lord,\nWorship Him, Christ the Lord.\n');
INSERT INTO page VALUES (12877,452,5,'Beautiful One I love You,\nBeautiful One I adore,\nBeautiful One my soul must sing.');
INSERT INTO page VALUES (10797,318,2,'But my one request\nAnd Lord my only aim\nIs that You reign in me again.');
INSERT INTO page VALUES (7081,298,1,'Spirit of the living God,\nFall afresh on me,\nSpirit of the living God,\nFall afresh on me;\nBreak me, melt me,\nMould me, fill me,\nSpirit of the living God, \nFall afresh on me.');
INSERT INTO page VALUES (7082,298,2,'Spirit of the living God,\nmove among us all,\nmake us one in heart and mind,\nmake us one in love,\nhumble, caring,\nselfless, sharing,\nspirit of the living God,\nfill our lives with love.');
INSERT INTO page VALUES (7083,299,1,'Spirit of God, unseen as the wind,\nGentle as is the dove:\nTeach us the truth, and help us believe,\nShow us the saviours love.');
INSERT INTO page VALUES (7084,299,2,'You spoke to us, long, long ago,\nGave us the written word,\nWe read it still, needing the truth,\nThrough it God\'s voice is heard');
INSERT INTO page VALUES (7085,299,3,'Spirit of God, unseen as the wind,\nGentle as is the dove:\nTeach us the truth, and help us believe,\nShow us the saviours love.');
INSERT INTO page VALUES (7086,299,4,'Without your help we fail our Lord,\nWe cannot live His way,\nWe need your power; we need your strength,\nFollowing Christ each day.');
INSERT INTO page VALUES (7087,299,5,'Spirit of God, unseen as the wind,\nGentle as is the dove:\nTeach us the truth, and help us believe,\nShow us the saviours love.');
INSERT INTO page VALUES (7091,300,1,'Sing my tongue the Saviours glory,\nOf His cross the mystery sing,\nLift on high the wondrous trophy,\nTell the triumph of the King,\nHe, the worlds Redeemer conquers\nDeath, through death now vanquishing.');
INSERT INTO page VALUES (7092,300,2,'Born for us and for us given,\nSon of Man, like us below\nHe as man, like us below,\nDwells, the seed of life to sow,\nHe, our heavy grief partaking,\nThus fulfils His life of woe.');
INSERT INTO page VALUES (7093,300,3,'Word made flesh! His word life giving,\nGives His flesh our meat to be,\nBids us drink His blood believing,\nThrough His death, we life shall see,\nBlessed they, who thus receiving\nAre from death and sin set free.');
INSERT INTO page VALUES (7094,300,4,'Praise for ever, thanks and blessing,\nYours, our gracious Father be,	\nPraise be yours, dear Christ for bringing,\nLife and immortality,\nPraise be yours, God\'s quickening Spirit,\nPraise through all eternity.');
INSERT INTO page VALUES (9544,20,2,'Lord I give You my heart\nI give You my soul\nI live for You alone\nEvery breath that I take\nEvery moment I\'m awake\nLord have Your way in me');
INSERT INTO page VALUES (7111,301,1,'O worship the King,\n All glorious above,\nO gratefully sing,\n His power and His love,\nOur shield and defender,\n the ancient of days,\nPavilioned in splendour,\n and girded with praise.');
INSERT INTO page VALUES (7112,301,2,'O tell of His might,\n O sing of His grace,\nWhose robe is the light,\n Whose canopy space,\nHis chariots of wrath,\n The deep thunder clouds form,\nAnd dark is His path,\n On the wings of the storm');
INSERT INTO page VALUES (7113,301,3,'Frail children of dust,\n And feeble as frail, \nIn Thee do we trust,\n nor find Thee to fail,\nThy mercies how tender,\n How firm to the end,\nOur Maker, Defender,\n Redeemer and Friend.');
INSERT INTO page VALUES (7114,301,4,'O measureless might,\n Ineffable love, \nWhile angels delight,\n to hymn Thee above,\nThe humbler creation,\n Though feeble their lays,\nWith true adoration,\n Shall sing to Thy praise.');
INSERT INTO page VALUES (7185,275,5,'There are higher heights, there are deeper seas,\nWhatever you need to do Lord, do it in me.\nThe glory of God fills my life\nAnd I will never be the same again.\nAnd I will never be the same again..\nAnd I will never be the same again...');
INSERT INTO page VALUES (12413,77,6,'Glory, glory, hallelujah,\nPraises to the Great I Am.\nHosanna, join with angels singing,\nworthy is the Lamb of God.');
INSERT INTO page VALUES (7380,43,3,'I want to be your hands\nAnd be your feet\nLord make me your servant\nI want to tell your love\nTo everyone I meet\nLord make me your servant\n(repeat)');
INSERT INTO page VALUES (8480,136,4,'And it\'s higher\n(reaches from heaven to man)\nIt\'s wider\n(anyone can come in)\nIt\'s deeper\n(it covers any sin)\nAnd I know this one thing\nWherever I go\nI know...');
INSERT INTO page VALUES (7214,52,6,'Holy, Holy, Holy is the Lord,\nSee the coming of the King\nHoly is the Lord. \n(repeat)\n\nSee the coming of the King\nHoly is the Lord. ');
INSERT INTO page VALUES (8478,136,2,'And it\'s higher\n(reaches from heaven to man)\nIt\'s wider\n(anyone can come in)\nIt\'s deeper\n(it covers any sin)\nAnd I know this one thing\nWherever I go\nI know...');
INSERT INTO page VALUES (8479,136,3,'You loved me as you found me\nYour love keeps following me\nYou wrapped your arms around me\nYour love keeps following me\nBy grace I\'m what I should be\nYour love keeps following me\nYou saw me as I could be\nYour love keeps following me');
INSERT INTO page VALUES (7358,303,2,'I exalt thee, I exalt thee\nI exalt thee, O Lord\nI exalt thee, I exalt thee\nI exalt thee, O Lord');
INSERT INTO page VALUES (7357,303,1,'For thou Lord art high above all the earth\nThou art exalted far above all gods\nFor thou Lord art high above all the earth\nThou art exalted far above all gods');
INSERT INTO page VALUES (8477,136,1,'You loved me as you found me\nYour love keeps following me\nYou wrapped your arms around me\nYour love keeps following me\nBy grace I\'m what I should be\nYour love keeps following me\nYou saw me as I could be\nYour love keeps following me');
INSERT INTO page VALUES (7344,302,3,'We bring the sacrifice of praise\nInto the house of the Lord\nWe bring the sacrifice of praise\nInto the house of the Lord');
INSERT INTO page VALUES (7343,302,2,'And we offer up to you\nThe sacrifices of thanksgiving,\nAnd we offer up to you\nThe sacrifices of joy.');
INSERT INTO page VALUES (7342,302,1,'We bring the sacrifice of praise\nInto the house of the Lord\nWe bring the sacrifice of praise\nInto the house of the Lord\n(repeat)');
INSERT INTO page VALUES (9545,20,3,'This is my desire\nTo honour You\nLord with all my heart\nI worship You\nAll I have within me\nI give You praise\nAll that I adore\nIs in You');
INSERT INTO page VALUES (11239,307,2,'Come to the Father,\nThough your gift is small\nBroken hearts, broken lives,\nHe will take them all,\nThe power of the Word,\nThe power of His blood,\nEverything was done,\nSo you would come.');
INSERT INTO page VALUES (7401,304,1,'Ladies and Gentleman,\n\nPlease deactivate any electronic devices\nthat are likely to disrupt the peace and\nserenity of this worship service.\n\nThank you for your considerate gesture\nin complying with this request.');
INSERT INTO page VALUES (11238,307,3,'Nothing you can do,\nCould make Him love you more,\nAnd nothing that you\'ve done\nCould make Him close the door.\nBecause of His great love,\nHe gave His only Son,\nEverything was done,\nSo you would come.');
INSERT INTO page VALUES (8632,306,1,'God will make a way,\nWhere there seems to be no way,\nHe works in ways we cannot see,\nHe will make a way for me.\nHe will be my guide,\nHold me closely to His side,\nWith love and strength for each new day,\nHe will make a way, He will make a way.\n(repeat)');
INSERT INTO page VALUES (8634,306,3,'God will make a way,\nWhere there seems to be no way,\nHe works in ways we cannot see,\nHe will make a way for me.\nHe will be my guide,\nHold me closely to His side,\nWith love and strength for each new day,\nHe will make a way, He will make a way.');
INSERT INTO page VALUES (12312,310,2,'Come let us enter in to\nall that Christ has done.\nAs now by faith we taste\nthe victory He has won');
INSERT INTO page VALUES (11036,316,2,'Hey lord\nYou\'re the one\nYou set our hearts\non fire');
INSERT INTO page VALUES (8633,306,2,'By a road way in the wilderness \nHe\'ll lead me,\nAnd rivers in the desert will I see.\nHeaven and earth will fade,\nBut His word will still remain,\nHe will do something new today');
INSERT INTO page VALUES (7485,305,1,'Come into His presence with thanksgiving \nIn your heart and give Him praise,\nAnd give Him praise.\nCome into His presence with thanksgiving\nIn your heart your voices raise,\nYour voices raise.\nGive glory and honour and power unto Him\nJesus the name above all names');
INSERT INTO page VALUES (7902,314,2,'I believe in the risen Lord,\nseated on the throne\nCasting down the strongholds\nof the enemy\nHe\'s the first of all creation\nThe beginning and the end\nLet the earth proclaim\nThere\'s salvation in his name.');
INSERT INTO page VALUES (11237,307,1,'Before the world began,\nYou were on His mind,\nAnd every tear you cry,\nIs precious in His eyes,\nBecause of His great love,\nHe gave His only Son,\nEverything was done,\nSo you would come,');
INSERT INTO page VALUES (11236,307,4,'Come to the Father,\nThough your gift is small\nBroken hearts, broken lives,\nHe will take them all,\nThe power of the Word,\nThe power of His blood,\nEverything was done,\nSo you would come.');
INSERT INTO page VALUES (7493,308,1,'Jesus name above all names\nBeautiful Saviour,\nGlorious Lord,\nEmmanuel, God is with us,\nBlessed redeemer,\nLiving word. ');
INSERT INTO page VALUES (11115,309,2,'I know not how this saving faith\nTo me He did impart,\nNor how believing in His Word\nWrought peace with-in my heart.\nBut I know whom I have believed,\nand am persuaded that He is able\nTo keep that which I\'ve committed\nUnto Him against that day.');
INSERT INTO page VALUES (11114,309,3,'I know not how the Spirit moves,\nConvincing men of sin,\nRevealing Jesus thro\' the Word,\nCreating faith in Him.\nBut I know whom I have believed,\nand am persuaded that He is able\nTo keep that which I\'ve committed\nUnto Him against that day.');
INSERT INTO page VALUES (11113,309,1,'I know not why God\'s wondrous grace\nTo me He hath made known,\nNor why, unworthy, Christ in love\nRedeemed me for His own.\nBut I know whom I have believed,\nand am persuaded that He is able\nTo keep that which I\'ve committed\nUnto Him against that day.');
INSERT INTO page VALUES (11112,309,4,'I know not when my Lord may come,\nAt night or noon-day fair,\nNor if I\'ll walk the vale with Him,\nOr meet Him in the air.\nBut I know whom I have believed,\nand am persuaded that He is able\nTo keep that which I\'ve committed\nUnto Him against that day.');
INSERT INTO page VALUES (10795,318,1,'Over all the earth\nYou reign on high\nEvery mountain stream\nEvery sunset sky');
INSERT INTO page VALUES (10796,318,3,'Lord reign in me\nReign in your power\nOver all my dreams\nIn my darkest hour\nYou are the Lord\nOver all I am\nSo won\'t you reign\nin me again');
INSERT INTO page VALUES (7697,311,6,'The Kingdom of God in the old testament\nThe United Kingdom - Solomon\nThe People of God became the Kingdom of Israel\nA changed situation\nGreat prosperity\n');
INSERT INTO page VALUES (12311,310,3,'I have been justified, sanctified\nforgiven and made free,\nfor the love of God\nis shed abroad in me.\n\nI am a child of God, set apart,\nAnd blameless in His sight.\nFor by the grace of God\nmy life is hid with Christ');
INSERT INTO page VALUES (7901,314,1,'I\'m standing on the Rock,\nand my name is on the roll\nWo -oh I\'m a believer\nHe\'s the rock of all ages\nHe\'s the shepard of my soul\nWo -oh I\'m a believer');
INSERT INTO page VALUES (7695,311,4,'The Kingdom of God in the old testament\nThe United Kingdom - Solomon\nThe People of God became the Kingdom of Israel\n\n\n');
INSERT INTO page VALUES (7696,311,5,'The Kingdom of God in the old testament\nThe United Kingdom - Solomon\nThe People of God became the Kingdom of Israel\nA changed situation\n\n');
INSERT INTO page VALUES (12309,310,4,'For by the grace of God\nmy life is hid with Christ');
INSERT INTO page VALUES (12310,310,1,'I have been justified, sanctified\nforgiven and made free,\nfor the love of God\nis shed abroad in me.\n\nI am a child of God, set apart,\nAnd blameless in His sight.\nFor by the grace of God\nmy life is hid with Christ\n\n(repeat)');
INSERT INTO page VALUES (7694,311,3,'The Kingdom of God in the old testament\nThe United Kingdom - Solomon\n\n\n\n');
INSERT INTO page VALUES (7693,311,2,'The Kingdom of God in the old testament\n\n\n\n\n');
INSERT INTO page VALUES (7739,313,7,'Oh, the splendour of His greatness\nOh, the beauty of His love\nOh, the depths of His forgiveness\nThe wonder of the Father\'s love.');
INSERT INTO page VALUES (11035,316,3,'Jesus (Jesus)\nYou\'re the one\n(You\'re the one)\nYou set my heart\non fire.');
INSERT INTO page VALUES (7691,311,7,'The Kingdom of God in the old testament\nThe United Kingdom - Solomon\nThe People of God became the Kingdom of Israel\nA changed situation\nGreat prosperity\n\n                 Is anything new under the sun?');
INSERT INTO page VALUES (7692,311,1,'           Tonights Sermon\n\nThe Kingdom - Gods\' or Mans?');
INSERT INTO page VALUES (9543,20,1,'This is my desire\nTo honour You\nLord with all my heart\nI worship You\nAll I have within me\nI give You praise\nAll that I adore\nIs in You');
INSERT INTO page VALUES (9152,317,1,'Over the mountains and the sea,\nYour river runs with love for me\nAnd I will open up my heart\nand let the healer set me free\nI\'m happy to be in the truth,\nand I will daily lift my hands\nFor I will always sing of when\nYour love came down');
INSERT INTO page VALUES (7903,314,3,'I\'m a believer');
INSERT INTO page VALUES (10794,318,4,'Over every thought\nOver every word\nMay my life reflect\nthe beauty of my Lord');
INSERT INTO page VALUES (7733,313,2,'Jesus the Lamb for sacrifice\nShows forth His Father\'s plan\nIn love to bring back to His side\nthe rebel heart of man.');
INSERT INTO page VALUES (7734,313,4,'His Spirit given freely\nPoured out on all who believe\nThat \"the God of creation is \nmighty to save\"\nAnd salvation I freely receive');
INSERT INTO page VALUES (11091,312,2,'Unresting, unhasting, \n  and silent as light,\nNor wanting, nor wasting, \n  Thou rulest in might;\nThy justice like mountains \n  high soaring above,\nThy clouds which are fountains \n  of goodness and love.');
INSERT INTO page VALUES (11090,312,3,'To all, life Thou givest\n  to both great and small;\nIn all life Thou livest, \n  the true life of all;\nWe blossom and flourish as \n  leaves on the tree,\nAnd wither and perish, \n  but naught changes Thee.');
INSERT INTO page VALUES (11089,312,1,'Immortal, invisible God only wise,\nIn light inaccessible hid \n  from our eyes,\nMost blessed, most glorious, \n  the Ancient of days\nAlmighty, victorious, \n  Thy great name we praise.');
INSERT INTO page VALUES (7735,313,6,'Behold, our God makes all things new\nThe Father of us all;\nAnd pure we bow before His throne,\nIn praise forevermore');
INSERT INTO page VALUES (7736,313,8,'The wonder of the Father\'s love');
INSERT INTO page VALUES (11088,312,4,'Great Father of glory, \n  pure Father of light,\nThine angels adore Thee, \n  all veiling their sight;\nAll praise we would render; \n  O help us to see\nTis only the splendour of \n  light hideth Thee!');
INSERT INTO page VALUES (12146,249,7,'Ignite my Heart');
INSERT INTO page VALUES (12147,249,2,'You set me apart Lord\nTo make me new\nBy Your Spirit\nLift me up Lord\nRefresh my heart');
INSERT INTO page VALUES (12145,249,3,'And I will worship You Lord\nWith all of my heart\nAnd I will follow You Lord\nRefresh my heart\n(repeat)');
INSERT INTO page VALUES (12144,249,1,'Refresh my heart Lord\nRenew my love\nPour your Spirit into my soul\nRefresh my heart');
INSERT INTO page VALUES (12143,249,4,'Ignite my heart, Lord;\nInflame my soul.\nI desire to love Your Word,\nTo live for You.');
INSERT INTO page VALUES (12142,249,6,'Christ living through my \n      life, Lord\nIn every part\nTo follow You my Saviour,\nIgnite my heart\n(repeat)');
INSERT INTO page VALUES (10024,208,1,'I just want to love, \nI just want to sing\nTo the One above who \nhas touched this thirsty soul\nAnd now I\'ll never be the same.');
INSERT INTO page VALUES (12316,-5,1,'');
INSERT INTO page VALUES (12406,28,5,'Put on the garment of praise\nfor the spirit of heaviness\nLift up your voice to God!\n\nPraise with the spirit\nAnd with understanding\nO, magnify the Lord.');
INSERT INTO page VALUES (11034,316,1,'Hey Lord\nO Lord\nHey Lord\nYou know\nwhat we need');
INSERT INTO page VALUES (11080,320,2,'We\'ve longed to see the roses\nBut never felt the thorns\nAnd brought our pretty crowns\nBut never paid the price');
INSERT INTO page VALUES (11078,320,3,'Find me in the river\nFind me there\nFind me on my knees\nwith my soul laid bare\nEven though you\'re gone\nand I\'m cracked and dry\nFind me in the river\nIm waiting here');
INSERT INTO page VALUES (8127,319,1,'I will worship\n With all of my heart\nI will praise You\n With all of my strength');
INSERT INTO page VALUES (8030,315,1,'');
INSERT INTO page VALUES (7738,313,5,'Oh, the splendour of His greatness\nOh, the beauty of His love\nOh, the depths of His forgiveness\nThe wonder of the Father\'s love.');
INSERT INTO page VALUES (8128,319,2,'I will seek You\n All of my days\nI will follow\n All of Your ways');
INSERT INTO page VALUES (8129,319,3,'I will give You all my worship\nI will give You all my praise\nYou alone I long to worship\nYou alone are worthy of my praise');
INSERT INTO page VALUES (8130,319,4,'I wil bow down,\n and hail You as King\nI will serve You,\n give You everything');
INSERT INTO page VALUES (13394,319,5,'I will lift up, \n my eyes to Your throne\nI will trust You,\n I will trust You alone.');
INSERT INTO page VALUES (11077,320,1,'Find me in the river,\nFind me on my knees\nI\'ve walked against the water\nNow I\'m waiting if you please');
INSERT INTO page VALUES (11076,320,4,'Find me in the river,\nfind me on my knees\nI\'ve walked against the water\nNow I\'m waiting if you please');
INSERT INTO page VALUES (8172,321,1,'Colours of day dawn into the mind, \nThe sun has come up the night is behind,\nGo down in the city, into the street,\nLet\'s give the message to the people we meet.');
INSERT INTO page VALUES (8173,321,2,'So light up the fire and let the flame burn,\nOpen the door, let Jesus return,\nTake seeds of the Spirit; let the fruit grow,\nTell the people of Jesus let His love show.');
INSERT INTO page VALUES (8174,321,3,'Go into the park, on into the town,\nThe sun still shines on, it never goes down,\nThe light of the world is risen again,\nThe people of darkness are needing a friend.');
INSERT INTO page VALUES (8175,321,4,'So light up the fire and let the flame burn,\nOpen the door, let Jesus return,\nTake seeds of the Spirit; let the fruit grow,\nTell the people of Jesus let His love show.');
INSERT INTO page VALUES (8176,321,5,'Open your eyes, look into the sky,\nThe darkness has come the sun came to die,\nThe evening draws on, the sun disappears,\nBut Jesus is living; His spirit is near,');
INSERT INTO page VALUES (8177,321,6,'So light up the fire and let the flame burn,\nOpen the door, let Jesus return,\nTake seeds of the Spirit; let the fruit grow,\nTell the people of Jesus let His love show.\n(repeat)');
INSERT INTO page VALUES (11932,322,2,'Be Thou my wisdom,\nThou my true word,\nI ever with Thee, and\nThou with me Lord,\nThou my great father,\nand I Thy true son,\nThou in me dwelling,\nand I with Thee one.');
INSERT INTO page VALUES (11931,322,3,'Be Thou my breast-plate,\nmy sword for the fight;\nBe Thou my armour and\nbe Thou my might:\nThou my soul\'s shelter and\nThou my high tower\nRaise Thou me heav\'nward,\nO pow\'r of my pow\'r.');
INSERT INTO page VALUES (11930,322,1,'Be thou my vision, \nO Lord of my heart,\nNaught be all else to me,\nsave that Thou art\nThou my best thought,\nby day or by night,\nWaking or sleeping,\nThy presence my light.');
INSERT INTO page VALUES (11929,322,4,'Riches I need not,\nnor man\'s empty praise,\nThou mine inheritance,\nnow and always,\nThou and Thou only,\nfirst in my heart,\nHigh King of Heaven,\nmy treasure Thou art.');
INSERT INTO page VALUES (11158,323,2,'Sing Hallelujah\nSing Hallelujah to our God\nSing Hallelujah\nSing Hallelujah to our God');
INSERT INTO page VALUES (11157,323,3,'When I look to your face\nYour glory shines on me\nand the heavens rejoice\nwhen I look to your face\nthe world that I know\ndisappears without a trace');
INSERT INTO page VALUES (11156,323,1,'When I come to Your throne\nAll I see is you\nand the peace that you bring\nWhen I come to your throne\nIt\'s everlasting joy');
INSERT INTO page VALUES (11155,323,4,'When I am with you I can\'t help but sing\nabout this joy You\'ve given me\nWhen I see Your face you wash away my tears');
INSERT INTO page VALUES (8202,324,5,'I\'m saving my highest praise\nI\'m lifting up my finest all to You,\nmy King');
INSERT INTO page VALUES (8201,324,4,'For You are my God, My God forever\nAnd Your love is greater than life\nAnd I am Yours, I am Yours forever\nEvery day I\'ll draw near to You.');
INSERT INTO page VALUES (8200,324,3,'You\'ve given me a new song\n\"Praise to my God\"\nAll of my days I will tell\nOf this love in my heart.');
INSERT INTO page VALUES (8199,324,2,'For You are my God, My God forever\nAnd Your love is greater than life\nAnd I am Yours, I am Yours forever\nEvery day I\'ll draw near to You.');
INSERT INTO page VALUES (8198,324,1,'Early I will seek You,\nI\'ll search after You\nIn the secret place I\'ll find You\nAnd I\'ll lift up my heart.');
INSERT INTO page VALUES (8203,324,6,'For You are my God, My God forever\nAnd Your love is greater than life\nAnd I am Yours, I am Yours forever\nEvery day I\'ll draw near to You.');
INSERT INTO page VALUES (11127,325,5,'I have no help but Thine to lean upon,\nAnother arm save Thine to lean upon,\nIt is enough my Lord enough indeed,\nMr strength is in Thy might, Thy might alone.');
INSERT INTO page VALUES (11126,325,2,'Here would I feed upon the bread of God,\nHere drink with Thee the royal wine of heav\'n;\nHere would I lay aside each earthly load,\nHere taste afresh the calm of sin for');
INSERT INTO page VALUES (11125,325,3,'This is the hour of banquet and of song;\nThis is the heav\'nly table spread for me;\nHere let me feast, and, feastering, still prolong\nThe brief, bright hour of fellowship with Thee.');
INSERT INTO page VALUES (11124,325,1,'Here O my Lord, I see Thee face to face;\nHere would I touch and hadnle thing unseen,\nHere grasp with firmer hand th\'eternal grace,\nAnd all my helplessness upon Thee lean.');
INSERT INTO page VALUES (11123,325,4,'Too soon we rise the symbols disappear,\nThe feast though not the love is past and gone,\nThe bread and wine remove, but Thou art here,\nNearer than ever, still my shield and sun.');
INSERT INTO page VALUES (11122,325,6,'Feast after feast thus comes and passes by, \nYet passing points to the glad feast above,\nGiving sweet foretaste of the festal joy,\nThe lambs great bridal feast of bliss and love.');
INSERT INTO page VALUES (10857,326,4,'O what a mystery, \nmeekness and majesty,\nBow down and worship,\nFor this is your God,\n this is your God.');
INSERT INTO page VALUES (10858,326,1,'Meekness & majesty, \nmanhood and deity,\nIn perfect harmony, \nthe man who is God,\nLord of Eternity, \ndwells in humanity,\nKneels in humility, \nWashes our feet.');
INSERT INTO page VALUES (10859,326,3,'Father\'s pure radiance, \nperfect in innocence,\nYet learns obedience, \nto death on a cross,\nSuffering to give us life, \nconquering \nthrough sacrifice,\nAnd as they crucify, \nprays Father forgive.');
INSERT INTO page VALUES (8310,327,4,'I will not forget,\n your love for me and yet\nmy heart forever is wandering\nJesus be my guide,\n hold me to your side\nand I will love you to the end');
INSERT INTO page VALUES (8311,327,5,'Thy Word is a lamp unto my feet,\nand a light unto my path.\nThy Word is a lamp unto my feet,\nand a light unto my path.\nAnd a Light unto my path\nYou\'re the Light unto my path');
INSERT INTO page VALUES (9151,329,4,'Who is this king of Glory,\nwith strength and majesty,\nAnd wisdom beyond measure,\nOh gracious King of Kings\nThe Lord of Earth and Heaven,\nThe creator of all things\nHe is the King of Glory,\nHe\'s everything to me');
INSERT INTO page VALUES (8309,327,3,'Thy Word is a lamp unto my feet,\nand a light unto my path.\nThy Word is a lamp unto my feet,\nand a light unto my path.');
INSERT INTO page VALUES (8307,327,1,'Thy Word is a lamp unto my feet,\nand a light unto my path.\nThy Word is a lamp unto my feet,\nand a light unto my path.');
INSERT INTO page VALUES (8308,327,2,'When I feel afraid,\n think I\'ve lost my way\nstill you\'re there right beside me\nNothing will I fear,\n as long as you are near.\nPlease be near me to the end');
INSERT INTO page VALUES (10856,326,6,'O what a mystery, \nmeekness and majesty,\nBow down and worship,\nFor this is your God,\n this is your God,\n this is your God.');
INSERT INTO page VALUES (8290,95,5,'When Mountains fall I\'ll stand\nBy the power of Your hand\n\nAnd in Your heart of hearts I\'ll dwell\nAnd that my soul knows very well. (x3)');
INSERT INTO page VALUES (11109,338,1,'Now thank we all our God,\nWith hearts and hands and voices\nWho wondrous things hath done,\nIn whom His world rejoices.\nWho from our mothers arms,\nHath blessed us on our way,\nWith countless gifts of love\nAnd still is ours today.');
INSERT INTO page VALUES (8313,328,1,'Let the weak say I am strong\nLet the poor say I am rich\nLet the blind say I can see\nIt\'s what the Lord has done in me\n(repeat)');
INSERT INTO page VALUES (8314,328,2,'Hosanna Hosanna\nTo the Lamb that was slain\nHosanna Hosanna\nJesus died and rose again\n(repeat)');
INSERT INTO page VALUES (8315,328,3,'Into the river I will wade\nThere my sins are washed away\nFrom the heavens mercy streams\nOf the Saviours love for me');
INSERT INTO page VALUES (8316,328,4,'Hosanna Hosanna\nTo the Lamb that was slain\nHosanna Hosanna\nJesus died and rose again');
INSERT INTO page VALUES (8317,328,5,'I will rise from waters deep\nInto the saving arms of God\nI will sing salvation songs\nJesus Christ has set me free');
INSERT INTO page VALUES (8318,328,6,'Hosanna Hosanna\nTo the Lamb that was slain\nHosanna Hosanna\nJesus died and rose again\n(repeat)\n\nJesus died and rose again\nJesus died and rose again');
INSERT INTO page VALUES (9150,329,3,'His name is Jesus,\nPrecious Jesus\nLord Almighty,\nKing of my heart,\nKing of Glory');
INSERT INTO page VALUES (8798,333,8,'Am I ready to hoist my sail to catch the\nWind of the Spirit?');
INSERT INTO page VALUES (8797,333,7,'5. You can\'t tell where it\'s going\n\nThe Spirit\'s destiny is unknown\nWe can\'t calculate where He will take us.');
INSERT INTO page VALUES (9148,329,1,'Who is this King of Glory,\nthat pursues me with his love\nAnd haunts me with each hearing,\nof his softly spoken words\nMy conscience is a reminder,\nof forgiveness that I need\nWho is the King of glory,\nwho offers it to me');
INSERT INTO page VALUES (9149,329,2,'Who is the King of angels,\nOh blessed Prince of Peace\nRevealing things of Heaven,\nand all its mysteries\nMy spirits ever longing,\nfor His grace in which to stand\nWho is this King of Glory,\nSon of God and Son of Man');
INSERT INTO page VALUES (8712,332,1,'I love you, Lord, And I lift my voice\nTo worship you - O my soul rejoice\nTake joy, My King In what you hear\nLet me be a sweet, sweet sound\nIn your ear');
INSERT INTO page VALUES (9021,336,4,'Tell me what You want\nme to do Lord God\nTell me what You want\nfor my life\nIt\'s Yours O God it\'s Yours');
INSERT INTO page VALUES (11075,320,6,'And my heart burns for you');
INSERT INTO page VALUES (8489,330,3,'I will not boast in anything,\nNo gifts, no pow\'r, no wisdom:\nBut I will boast in Jesus Christ,\nHis death and resurrection.\nWhy should I gain from his reward?\nI cannot give an answer.\nBut this I know with all my heart,\nHis wounds have paid my ransom.');
INSERT INTO page VALUES (8487,330,1,'How deep the Fathers\' love for us,\nHow vast beyond all measure,\nThat he should give his only Son\nTo make a wretch his treasure.\nHow great the pain of searing loss,\nThe Father turns his face away,\nAs wounds which mar the Chosen One\nBring many souls to glory.');
INSERT INTO page VALUES (8488,330,2,'Behold the man upon a Cross,\nMy sin upon his shoulders:\nAshamed, I hear my mocking voice\nCall out among the scoffers.\nIt was my sin that held him there\nUntil it was accomplished;\nHis dying breath has brought me life -\nI know that it is finished');
INSERT INTO page VALUES (8794,333,4,'2. Wherever it wishes\n\nThe Spirit is sovereign\nHe is free,\nunbound by our ideas, traditions');
INSERT INTO page VALUES (8795,333,5,'3. You hear the sound it makes\n\nThe Spirit\'s presence is evident\nExamples of His activity abound');
INSERT INTO page VALUES (8706,331,2,'And who can weigh the value of knowing You\nWho can judge the worth of who You are\nWho can count the blessings of loving You\nWho can say just how great You are.');
INSERT INTO page VALUES (8830,334,1,'I am not ashamed\nof the Gospel of his name\nFor it is the power!\nThe power of my salvaltion\nAnd I am not ashamed,\nof the Gospel of his Kingdom\nI have been delivered,\nJesus set me free');
INSERT INTO page VALUES (8831,334,2,'I\'m saved!\nS.A.V.E.D\nI\'m saved!\nJesus set me free\n(repeat)');
INSERT INTO page VALUES (8694,70,5,'Lord, for ourselves, \nin living power remake us -\nself on the cross and \nChrist upon the throne,\npast put behind us, \nfor the future take us:\nLord of our lives, \nto live for Christ alone.');
INSERT INTO page VALUES (8693,70,4,'Lord, for our world, \nwhere men disown and doubt you,\nloveless in strength, \nand comfort-less in pain,\nhungry and helpless,\nlost indeed without you:\nLord, of the world \nwe pray that Christ may reign.');
INSERT INTO page VALUES (8796,333,6,'4. You don\'t know where it comes from\n\nThe mysterious origin of the Spirit\nYou can\'t anticipate what He will do.');
INSERT INTO page VALUES (8793,333,3,'1. The wind blows\n\nThe Spirit is at work\nAlways at work - \nUniquely in Jesus');
INSERT INTO page VALUES (8792,333,2,'The Spirit is in the Wind\n\nThe wind - powerful, refreshing\nSo it is with the Holy Spirit');
INSERT INTO page VALUES (8832,334,3,'I am not ashamed\nof the Gospel of his name\nFor it is the power!\nThe power of my salvaltion\nAnd I am not ashamed,\nof the Gospel of his Kingdom\nI have been delivered,\nJesus set me free');
INSERT INTO page VALUES (9099,264,3,'Cause I finally found,\nwhat I\'m looking for,\nCause I finally found,\nwhat I\'m looking for!');
INSERT INTO page VALUES (9019,336,2,'I just want to be with You\nBe where You are\nDwell in Your presence O God\nO I want to walk with You');
INSERT INTO page VALUES (8791,333,1,'The Spirit is in the Wind\nJohn 3\n--------');
INSERT INTO page VALUES (11904,344,2,'So keep my heart pure,\nAnd my ways true,\nAs I follow You.\nKeep me humble,\nI\'ll stay mindful,\nOf your mercies, Lord.');
INSERT INTO page VALUES (9458,343,4,'I adore you\nI\'m in awe of you\nI want more of you\nI want all of you');
INSERT INTO page VALUES (9392,341,8,'Now is the time to live for You\nNow is the time I\'m found in You\nNow is the time Your Kingdom comes');
INSERT INTO page VALUES (8939,335,2,'Suffered hell and death\nIn the power of righteousness\nDeath is swallowed up in victory\nRisen from the grave\nSalvation had been made\nWorthy is the lamb that was slain');
INSERT INTO page VALUES (9391,341,7,'Now is the time to worship You\nNow is the time to offer You\nAll of my thoughts,\nmy dreams and plans\nI lay them down');
INSERT INTO page VALUES (8938,335,1,'Holy one of God\nSon of Righteousness\nRisen Lamb of God\nPrince of Peace\nRejected and despised\nSuffered, crucified\nThis risen Lamb of God\nJesus Christ');
INSERT INTO page VALUES (9390,341,6,'Created for a destiny\nI live in Him, He lives in me\nAnd filled with this hope in God\nReflecting His glory');
INSERT INTO page VALUES (9020,336,3,'And I will climb this mountain\nAnd I step off the shore\nAnd I have chosen to follow\nAnd be by Your side forever more');
INSERT INTO page VALUES (9018,336,1,'Oh dear God we ask for your favour\nCome and sweep through this place\nO we desire You');
INSERT INTO page VALUES (9206,339,1,'Jesus shall reign where\'er the sun\nDoes His successive journey run\nHis kingdom spread\n from shore to shore,\nTill moons shall wax\n and wane no more.');
INSERT INTO page VALUES (9207,339,2,'To him shall endless prayer be made,\nAnd endless praises crown his head,\nHis name like sweet\n perfume shall rise,\nWith every morning sacrifice.');
INSERT INTO page VALUES (9208,339,3,'People and realms of every tongue,\nDwell on His love with sweetest song,\nAnd infant voices shall proclaim, \nTheir early blessings on His name.');
INSERT INTO page VALUES (9209,339,4,'Blessings abound where \'er He reigns,\nThe prisoner leaps to loose his chains,\nThe weary find eternal rest,\nAnd all the sons of want are blessed.');
INSERT INTO page VALUES (9210,339,5,'Let every creature rise and bring,\nTheir grateful honours to our King,\nAngels descend with songs again,\nAnd earth repeat the loud Amen ');
INSERT INTO page VALUES (10310,340,2,'He dies to atone, \nfor sins not His own,\nYour debt He has paid \nand your work He has done,\nYou all may receive, \nthe peace He did leave,\nWho made intercession, \nMy Father forgive.');
INSERT INTO page VALUES (10309,340,3,'For you and for me,\nHe prayed on the tree,\nThe prayer is accepted\nthe sinner is free,\nThe sinner am I,\nwho on Jesus rely,\nAnd come for the pardon,\nGod cannot deny.');
INSERT INTO page VALUES (10308,340,1,'All you that pass by, \nto Jesus draw nigh,\nTo you is it nothing \nthat Jesus should die,\nYour ransom and peace, \nyour surety He is,\nCome see if there ever \nwas sorrow like His.');
INSERT INTO page VALUES (10307,340,4,'His death is my plea,\nmy advocate see,\nAnd hear the blood speak \nthat has answered for me,\nHe purchased the grace,\nwhich now I embrace,\nO Father, you know He\nhas died in my place.');
INSERT INTO page VALUES (9389,341,5,'This love, this strength\nThis word fulfilled, this promise sure\nThis hope in me\nA shelter from the storm\nIn life and love');
INSERT INTO page VALUES (9388,341,4,'Now is the time to live for You\nNow is the time I\'m found in You\nNow is the time Your Kingdom comes');
INSERT INTO page VALUES (11901,344,4,'So keep my heart pure,\nAnd my ways true,\nAs I follow You.\nKeep me humble,\nI\'ll stay mindful,\nOf your mercies, Lord.');
INSERT INTO page VALUES (9444,342,2,'And I believe that He\'s here now,\n  (I believe that He\'s here)\nStanding in our midst,\nHere with the power to heal now,\n  (With the power to heal)\nAnd the grace to forgive');
INSERT INTO page VALUES (9387,341,2,'Now healed and whole\nAnd risen in His righteousness\nI live in Him, He lives in me\nAnd filled with this hope in God\nReflecting His glory');
INSERT INTO page VALUES (9459,343,5,'Hallelujah praise the Lord most high\nWe give you all our Praise\n(x2)');
INSERT INTO page VALUES (9580,346,2,'You seed of heaven\'s chosen race,\nAnd ransomed from the fall,\nHail him who saves you by His grace,\nAnd crown Him Lord of all.');
INSERT INTO page VALUES (9457,343,3,'For you took\nmy place that day on calvary\nAnd you died for me\nO\' Lord How can it be');
INSERT INTO page VALUES (9455,343,1,'When you look at me\nWhat do you see\nYou say precious\nI say how can it be');
INSERT INTO page VALUES (9456,343,2,'When I think of you\nMy heart beats true\nTo think that I\nWould be loved by you');
INSERT INTO page VALUES (9385,341,1,'This love, this hope\nThis peace of God this righteousness\nThis faith, this joy\nThis life complete in me');
INSERT INTO page VALUES (9446,342,4,'And I believe that You\'re here now,\n  (I believe that You\'re here)\nStanding in our midst,\nHere with the power to heal now,\n  (With the power to heal)\nAnd the grace to forgive');
INSERT INTO page VALUES (9386,341,3,'Now is the time to worship You\nNow is the time to offer You\nAll of my thoughts,\nmy dreams and plans\nI lay them down');
INSERT INTO page VALUES (9445,342,3,'I believe in You, Lord,\nI believe you are the Son of God,\nI believe You died and rose again,\nI believe you paid for us all,');
INSERT INTO page VALUES (9443,342,1,'I believe in Jesus,\nI believe He is the Son of God,\nI believe He died and rose again,\nI believe He paid for us all,');
INSERT INTO page VALUES (11903,344,3,'I\'ll cherish your word,\nI\'l seek Your presence\nI\'ll chase after You,\nWith all I have\nAs one day I know\nI\'ll see You face to face');
INSERT INTO page VALUES (9572,345,2,'You make me walk on water\nShine in the dark\nYou make me soar over mountains\nPut dreams in my heart\nI walk by faith and live in praise\nAnd I thank you for your grace');
INSERT INTO page VALUES (9571,345,1,'I come I stand before you\nI bring an offering of praise\nI believe as I stand Before you\nI recieve the love that you gave');
INSERT INTO page VALUES (9581,346,3,'Let every nation, every tribe,\nOn this terrestrial ball,\nTo Him all majesty ascribe,\nAnd crown Him Lord of all.');
INSERT INTO page VALUES (9644,351,2,'I am not afraid\n (no I\'m not afraid)\nI am not dismayed\n (no I\'m not dismayed)\n\n\'Cause I\'m walkin\' in faith and victory\nCome on and walk in faith and victory\nFor the Lord your God is with you');
INSERT INTO page VALUES (9645,351,3,'Be Bold! (be bold)\nBe Strong! (be strong)\nFor the Lord your God is with you\nBe Bold! (be bold)\nBe Strong! (be strong)\nFor the Lord your God is with you');
INSERT INTO page VALUES (9643,351,1,'Be Bold! (be bold)\nBe Strong! (be strong)\nFor the Lord your God is with you\nBe Bold! (be bold)\nBe Strong! (be strong)\nFor the Lord your God is with you');
INSERT INTO page VALUES (10008,353,7,'1. Matthew 16 - Rock & Stone\n2. John 8 - Father of lies\n3. Exodus Story - Murmuring and grumbling\n4. 1 Corinthians 10 - The challenge\nto Christian Community\n5. John 6 - Commitment or alienation\n6. Phillipians 2 - Handling the Diversity\nwithin unity');
INSERT INTO page VALUES (9579,346,1,'All hail the power of Jesus\' name!\nLet angels prostrate fall;\nBring forth the royal diadem,\nAnd crown Him Lord of all.');
INSERT INTO page VALUES (9573,345,3,'Walkin\'\nWalkin\' on the water\nWalkin\'\nWalkin\' on the water');
INSERT INTO page VALUES (9582,346,4,'O that with yonder sacred throng\nWe at His feet may fall,\nJoin in the everlasting song,\nAnd crown Him Lord of all.');
INSERT INTO page VALUES (9583,347,1,'Salvation belongs to our God,\nWho sits upon the throne;\nAnd unto the Lamb,\nPraise and glory,\nWisdom and thanks,\nHonour and power and strength');
INSERT INTO page VALUES (9584,347,3,'And we the redeemed shall be strong\nIn purpose and unity,\nDeclaring aloud\nPraise and glory,\nWisdom and thanks,\nHonour and power and strength');
INSERT INTO page VALUES (9585,347,5,'Praise and glory,\nWisdom and thanks,\nhonor and power and strength\nBe to our God forever and ever,\nBe to our God forever and ever,\nBe to our God forever and ever,\nAmen');
INSERT INTO page VALUES (9586,347,2,'Be to our God forever and ever,\nBe to our God forever and ever,\nBe to our God forever and ever,\nAmen');
INSERT INTO page VALUES (9587,347,4,'Be to our God forever and ever,\nBe to our God forever and ever,\nBe to our God forever and ever,\nAmen');
INSERT INTO page VALUES (9612,348,1,'They that wait upon the Lord\nshall renew their strength,\nthey shall mount up with wings\nas eagles.\nThey shall run and not be weary,\nThey shall walk and not faint,\nteach us Lord,\nteach us Lord to wait.');
INSERT INTO page VALUES (9599,349,1,'You are holy, Lord.\nYou are holy, Lord.\nIn your awesome presence I stand.\nYou have taken away my shame,\nsuch is the pow\'r in your holy name.\nYou\'ll always be my God\nAnd I will be your child.');
INSERT INTO page VALUES (9600,349,2,'You are faithful, Lord.\nYou are faithful, Lord.\nIn your awesome presence I stand.\nEvery promise is steadfast and sure,\nand you will love me \'til time is no more.\nYou\'ll always be my God\nAnd I will be your child.');
INSERT INTO page VALUES (9601,349,3,'You are mighty, Lord.\nYou are mighty, Lord.\nIn your awesome presence I stand.\nLike the crashing of waves on the sand,\nLet your Spirit flood over this land.\nYou\'ll always be my God\nAnd I will be your child.');
INSERT INTO page VALUES (9602,349,4,'Like the crashing of waves on the sand,\nLet your Spirit flood over this land.\nYou\'ll always be my God\nAnd I will be your child.\nYou\'ll always be my God\nAnd I will be your child.');
INSERT INTO page VALUES (9603,350,7,'The King is among us,\nHis Spirit is here,\nLet\'s draw near and worship,\nLet songs fill the air.');
INSERT INTO page VALUES (9604,350,1,'The King is among us,\nHis Spirit is here,\nLet\'s draw near and worship,\nLet songs fill the air.');
INSERT INTO page VALUES (9605,350,2,'He looks down upon us,\nDelight in His face,\nEnjoying His children\'s love,\nEnthralled by our praise.');
INSERT INTO page VALUES (9606,350,3,'For each child is special,\nAccepted and loved,\nA love gift from Jesus\nTo His Father above.');
INSERT INTO page VALUES (9607,350,4,'And now He is giving\nHis gifts to us all,\nFor no one is worthless\nAnd each one is called.');
INSERT INTO page VALUES (9608,350,5,'The Spirit\'s anointing\nOn all flesh comes down,\nAnd we shall be channels\nFor works like His own.');
INSERT INTO page VALUES (9609,350,6,'We come now believing\nYour promise of power,\nFor we are Your people\nAnd this is Your hour.');
INSERT INTO page VALUES (10014,353,6,'1. Matthew 16 - Rock & Stone\n2. John 8 - Father of lies\n3. Exodus Story - Murmuring and grumbling\n4. 1 Corinthians 10 - The challenge\nto Christian Community.\n5. John 6 - Commitment or alienation');
INSERT INTO page VALUES (13344,570,1,'I\'m here to meet with you\nCome and meet with me\nI\'m here to find you\nReveal yourself to me');
INSERT INTO page VALUES (13322,565,1,'<UL>\n<LI>Three types of Temptation\nand resisting them:</LI>\n\n1.World\n2.Flesh\n3.Satan\n');
INSERT INTO page VALUES (13335,568,4,'Go and tell them\nthe blind will see\nThe lame shall walk\nand the slave is free\nShout the news\nthat the lost is saved\nIn the name of Jesus\nthe dead are raised yeah\n');
INSERT INTO page VALUES (13367,576,1,'What is my true relationship\nwith God?\nWhat is my true relationship\nwith my Church?\nAm I as involved as God wants me to be\nor am I as involved as I want to be?');
INSERT INTO page VALUES (10012,353,4,'1. Matthew 16 - Rock & Stone\n2. John 8 - Father of lies\n3. Exodus Story - Murmuring and grumbling');
INSERT INTO page VALUES (10013,353,5,'1. Matthew 16 - Rock & Stone\n2. John 8 - Father of lies\n3. Exodus Story - Murmuring and grumbling\n4. 1 Corinthians 10 - The challenge\nto Christian Community.');
INSERT INTO page VALUES (10011,353,3,'1. Matthew 16 - Rock & Stone\n2. John 8 - Father of lies');
INSERT INTO page VALUES (10009,353,1,'Hebrews 3 and 4 -\nStephen Fyson');
INSERT INTO page VALUES (10010,353,2,'1. Matthew 16 - Rock & Stone');
INSERT INTO page VALUES (11100,354,2,'This is my Father\'s world,\nThe birds their carols raise;\nThe morning light, the lily white\nDeclare the Maker\'s praise.\nThis my Father\'s world,\nHe shines in all that\'s fair;\nIn the rustling grass I hear Him pass,\nHe speaks to me ev\'rywhere.');
INSERT INTO page VALUES (11099,354,3,'This is my Father\'s world,\nO let me ne\'er forget That\nthough the wrong seems oft so strong,\nGod is the Ruler yet.\nThis is my Father\'s world,\nThe battle is not done;\nJesus who died shall be satisfied,\nand earth and heaven be one.');
INSERT INTO page VALUES (10066,250,3,'Now you are exalted\nto the highest place\nKing of the heavens\nwhere one day I\'ll bow\nBut for now I marvell\nat your saving grace\nand I\'m full of praise once again\nI\'m full of praise once again.');
INSERT INTO page VALUES (10222,355,5,'And when I think that\nGod His Son not sparing,\nSent Him to die, \nI scarce can take it in\nThat on the cross, \nmy burden gladly bearing,\nHe bled and died \nto take away my sin.');
INSERT INTO page VALUES (10220,355,7,'When Christ shall come \nwith shout of acclamation,\nAnd take me home, \nwhat joy shall fill my heart,\nThen I shall bow in \nhumble adoration,\nAnd there proclaim my God, \nhow great Thou art.');
INSERT INTO page VALUES (10357,358,2,'He is greater than -> Angels (pantheists)');
INSERT INTO page VALUES (10355,358,3,'He is greater than -> Angels (pantheists)\n                            > Moses (humanists)');
INSERT INTO page VALUES (11098,354,1,'This is my Father\'s world,\nAnd to my list\'ning ears,\nnature sings, and round me rings\nThe music of the spheres.\nThis is my Father\'s world,\nI rest me in the thought\nOf rock and trees, of skies and seas;\nHis hand wonders wrought.');
INSERT INTO page VALUES (10221,355,2,'Then sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art,\nThen sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art.');
INSERT INTO page VALUES (10216,355,6,'Then sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art,\nThen sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art.');
INSERT INTO page VALUES (10217,355,4,'Then sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art,\nThen sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art.');
INSERT INTO page VALUES (10219,355,3,'When through the woods\nand forest glades I wander,\nAnd hear the birds sing\nsweetly through the trees,\nWhen I look down from\nlofty mountain grandeur,\nAnd hear the brook,\nand feel the gentle breeze.');
INSERT INTO page VALUES (10218,355,1,'O Lord my God, \nwhen I in awesome wonder,\nConsider all the works \nThy hand has made,\nI see the stars; \nI hear the rolling thunder,\nThy power throughout the\nuniverse displayed.');
INSERT INTO page VALUES (10320,356,3,'BORN AGAIN!');
INSERT INTO page VALUES (10321,356,2,'I\'m a new creation\nWashed in his blood\nI\'ve had a transformation\nNow I\'m living in the power of God.');
INSERT INTO page VALUES (11212,373,1,'Praise to the Lord, the Almighty,\nthe King of creation!\nO my soul, praise Him,\nfor He is thy health and salvation!\nAll ye who hear,\nNow to His temple draw near;\nJoin me in glad adoration!');
INSERT INTO page VALUES (10319,356,1,'Born again, born to win,\nI\'m a child of the most high God\nBorn again, born to win,\nI\'m a child of the King.');
INSERT INTO page VALUES (12370,168,2,'as we forgive those who \ntrespass against us.\nAnd lead us not \ninto temptation;\nBut deliver us from evil.\nFor thine is the kingdom, \nand the power and the\nglory, forever and ever, Amen. ');
INSERT INTO page VALUES (10361,359,1,'I sing the mighty pow\'r of God,\nThat made the mountains rise;\nThat spread the flowing seas abroad,\nAnd built the lofty skies.\nI sing the wisdom that ordained\nThe sun to rule the day;\nThe moon shines full at His command,\nAnd all the stars obey.');
INSERT INTO page VALUES (10860,326,2,'O what a mystery, \nmeekness and majesty,\nBow down and worship,\nFor this is your God,\n this is your God.');
INSERT INTO page VALUES (10420,361,2,'Holy, Holy, \nHoly is the Lord. \nSee the coming of the King,\nHoly is the Lord.');
INSERT INTO page VALUES (11213,373,3,'Praise to the Lord,\nwho doth prosper thy work\nand defend thee;\nSurely His goodness and mercy\nhere daily attend thee.\nPonder anew \nWhat the Almighty can do,\nIf with His love He befriend thee.');
INSERT INTO page VALUES (11521,252,6,'Anyone around can see\nJust how good You\'ve been to be\nFor all my friends who don\'t know You\nI pray that You would save them too');
INSERT INTO page VALUES (10215,355,8,'Then sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art,\nThen sings my soul \nmy Saviour God to Thee,\nHow great Thou art, \nHow great Thou art.');
INSERT INTO page VALUES (10356,358,7,'He is greater than -> Angels (pantheists)\n                            > Moses (humanists)\n                            > High Priest (religiousity)\nWe can be confident\nWe can move on > What stops us?\n                            > Hebrews 6: 1-6\n                            (3 theories)');
INSERT INTO page VALUES (10354,358,1,'Sermon:\n\n\n\nIs Jesus adequate enough?');
INSERT INTO page VALUES (10353,358,4,'He is greater than -> Angels (pantheists)\n                            > Moses (humanists)\n                            > High Priest (religiousity)');
INSERT INTO page VALUES (10352,358,6,'He is greater than -> Angels (pantheists)\n                            > Moses (humanists)\n                            > High Priest (religiousity)\nWe can be confident\nWe can move on > What stops us?');
INSERT INTO page VALUES (10351,358,8,'He is greater than -> Angels (pantheists)\n                            > Moses (humanists)\n                            > High Priest (religiousity)\nWe can be confident\nWe can move on > What stops us?\n                            > Hebrews 6: 1-6\n                            (3 theories)\nOr we have a continually repentant heart');
INSERT INTO page VALUES (10358,358,5,'He is greater than -> Angels (pantheists)\n                            > Moses (humanists)\n                            > High Priest (religiousity)\nWe can be confident');
INSERT INTO page VALUES (10362,359,3,'There\'s not a plant or flow\'r below,\nBut makes Your glories known;\nAnd clouds arise, and tempests blow,\nBy order from Your throne;\nWhile all that borrows life from You\nIs ever in Your care,\nAnd everywhere that man can be,\nThou, God, art present there.');
INSERT INTO page VALUES (10363,359,2,'I sing the goodness of the Lord.\nThat filled the earth with food;\nHe formed the creatures with His Word,\nAnd then pronounced them good.\nLord how Your wonders are displayed,\nWhere\'er I turn my eye:\nIf I survey the ground I tread,\nOr gaze upon the sky! ');
INSERT INTO page VALUES (10364,360,4,'O Lord We praise your name.\nO Lord We magnify your name,\nPrince of Peace, Mighty God,\nO Lord God Almighty.');
INSERT INTO page VALUES (10365,360,1,'O Lord, our Lord, \nHow majestic is your name in all the earth!\nO Lord, our Lord, \nHow majestic is your name in all the earth!');
INSERT INTO page VALUES (10366,360,3,'O Lord, our Lord, \nHow majestic is your name in all the earth!\nO Lord, our Lord, \nHow majestic is your name in all the earth!');
INSERT INTO page VALUES (10367,360,2,'O Lord We praise your name.\nO Lord We magnify your name,\nPrince of Peace, Mighty God,\nO Lord God Almighty.\n');
INSERT INTO page VALUES (10419,361,3,'The heavens shall declare \nthe glory of His name,\nAll creation bow \nat the coming of the King.\nEvery eye shall see, \nevery heart shall know,\nEvery knee shall bow, \nevery tongue confess;');
INSERT INTO page VALUES (10418,361,1,'The heavens shall declare \nthe glory of His name,\nAll creation bow \nat the coming of the King.\nEvery eye shall see, \nevery heart shall know,\nEvery knee shall bow, \nevery tongue confess;');
INSERT INTO page VALUES (10417,361,4,'Holy, Holy, \nHoly is the Lord. \nSee the coming of the King,\nHoly is the Lord.\n\n\nSee the coming of the King,\nHoly is the Lord. ');
INSERT INTO page VALUES (10547,362,2,'Wonderful the matchless grace of Jesus,\nDeeper than the mighty rolling sea;\nHigher than the mountain, \nsparkling like a fountain,\nAll sufficient grace for even me, \nfor even me;\nBroader than the scope \nof my transgressions,\nGreater far than all my sin and shame;\nO magnify the precious name of Jesus,\nPraise His name!');
INSERT INTO page VALUES (10546,362,7,'My wonderful Lord, my wonderful Lord,\nBy angels and seraphs in heaven adored;\nI bow at Your feet, My Saviour to meet,\nMy wonderful, wonderful Lord.');
INSERT INTO page VALUES (10545,362,3,'It is glory just to walk with Him \nwhose blood has ransomed me;\nIt is rapture for my soul each day;\nIt is joy divine to feel Him near \nwhere\'er my path may be;\nBless the Lord, it\'s glory all the way!');
INSERT INTO page VALUES (10544,362,1,'Wonderful grace of Jesus,\nGreater than all my sin;\nHow shall my tongue describe it,\nWhere shall its praise begin?\nTaking away my burden,\nSetting my spirit free,\nFor the wonderful grace \nof Jesus reaches me.');
INSERT INTO page VALUES (10543,362,4,'It is glory just to walk with Him,\nIt is glory just to walk with Him;\nHe will guide my steps aright,\nThro\' the vale and o\'er the height;\nIt is glory just to walk with Him?.');
INSERT INTO page VALUES (10542,362,6,'I have found a deep peace \nthat I never had known\nAnd a joy this world could not afford,\nSince I yielded control \nof my body and soul\nTo my wonderful, wonderful Lord.');
INSERT INTO page VALUES (10541,362,8,'It is glory just to walk with Him,\nIt is glory just to walk with Him;\nHe will guide my steps aright,\nThro\' the vale and o\'er the height;\nIt is glory just to walk with Him?.\n\nO magnify the precious name of Jesus,\nPraise His name!');
INSERT INTO page VALUES (10576,363,2,'Were you there when they laid Him in the tomb?\nWere you there when they laid Him in the tomb?\nOh____, Sometimes it causes me to tremble,\ntremble, tremble.\nWere you there when they laid Him in the tomb?');
INSERT INTO page VALUES (10575,363,3,'Were you there when He rose up from the grave?\nWere you there when He rose up from the grave?\nOh____, Sometimes it causes me to tremble,\ntremble, tremble.\nWere you there when He rose up from the grave?');
INSERT INTO page VALUES (10574,363,1,'Were you there when they crucified my Lord?\nWere you there when they crucified my Lord?\nOh____, Sometimes it causes me to tremble,\ntremble, tremble.\nWere you there when they crucified my Lord?');
INSERT INTO page VALUES (10573,363,4,'Crown Him with many crowns,\nThe Lamb upon His throne;\nHark! How the heav\'nly anthem drowns\nAll music but its own!\nAwake my soul, and sing\nOf Him Who died for thee,\nAnd hail Him as your matchless King\nThru all eternity.');
INSERT INTO page VALUES (10384,364,1,'When I survey the wondrous Cross\nOn which the Prince of Glory died,\nMy richest gain I count but loss,\nAnd pour contempt on all my pride.');
INSERT INTO page VALUES (10385,364,3,'Were the whole realm of nature mine,\nThat were an off\'ring far too small,\nLove so amazing, so divine,\nDemands my soul, my life, my all!\nDemands my soul, my life, my all!');
INSERT INTO page VALUES (10386,364,2,'See from His head, His hands, His feet\nSorrow and love flow mingled down:\nDid e\'er such love and sorrow meet, \nOr thorns compose so rich a crown?');
INSERT INTO page VALUES (11902,344,1,'Day after day, I\'l search to find you\nDay after day, I\'ll wait for you\nThe deeper I go,\nThe more I love Your name...');
INSERT INTO page VALUES (10657,74,5,'Your kingdom shall reign\nover all the earth\nSing unto the ancient of days\nFor none can compare\nto your matchless worth\nSing unto the ancient of days');
INSERT INTO page VALUES (10688,365,5,'Just as I am, You will receive,\nWill welcome, pardon, cleanse, relieve;\nBecause Your promise I believe,\nO Lamb of God, I come, I come!');
INSERT INTO page VALUES (10687,365,2,'Just as I am, and waiting not\nTo rid my soul of one dark blot,\nTo you whose blood \ncan cleanse each spot,\nO Lamb of God, I come, I come!');
INSERT INTO page VALUES (10686,365,3,'Just as I am, though tossed about\nWith many a conflict, many a doubt,\nFightings and fears within, without,\nO Lamb of God, I come, I come!');
INSERT INTO page VALUES (10685,365,1,'Jesus said, \n\"Whoever comes to Me, \nI will not cast out\" \nJohn 6:37b\n\nJust as I am, without one plea,\nBut that Your blood was shed for me,\nAnd that You call me come to you,\nO Lamb of God, I come, I come!');
INSERT INTO page VALUES (10683,365,6,'Just as I am, Your love unknown\nHas broken every barrier down;\nNow to be Yours, yes! Yours alone,\nO Lamb of God, I come, I come!');
INSERT INTO page VALUES (10684,365,4,'Just as I am, poor, wretched, blind;\nSight, riches, healing of the mind,\nYes! All I need, in you to find,\nO Lamb of God, I come, I come!');
INSERT INTO page VALUES (11081,320,5,'We didnt count on suffering\nWe didnt count on pain\nBut if the blessing\'s in the valley\nThen in the river I will wait');
INSERT INTO page VALUES (10836,366,2,'\'O great jehovah\nour saviour our God\nYour greatness abounds\nthrough all the earth');
INSERT INTO page VALUES (10970,369,2,'Every step I take\nIs a step of faith,\nNo weapon formed against me\nShall prosper,\nEvery prayer I make\nIs a prayer of faith,\nAnd if my God is for me,\nThen who can be against me');
INSERT INTO page VALUES (10930,229,4,'By Thy grace divine, \nWe are on the Lord\'s side,\nSaviour, we are Thine.');
INSERT INTO page VALUES (10835,366,3,'Hallelujah\n   Hallelujah\n      Hallelujah');
INSERT INTO page VALUES (10833,366,4,'Praise the Lord most high.');
INSERT INTO page VALUES (10834,366,1,'Praise the Lord most high\nSing hallelujah');
INSERT INTO page VALUES (10548,362,5,'My wonderful Lord, my wonderful Lord,\nBy angels and seraphs in heaven adored;\nI bow at Your feet, My Saviour to meet,\nMy wonderful, wonderful Lord.');
INSERT INTO page VALUES (10969,369,1,'I walk by faith,\nEach step by faith,\nTo live by faith,\nI put my trust in you\n(repeat)');
INSERT INTO page VALUES (10962,368,1,'King of Kings and Lord of Lords\nGlory, hallelujah\nKing of Kings and Lord of Lords\nGlory, hallelujah\n\nJesus, Prince of Peace\nGlory, hallelujah\nJesus, Prince of Peace\nGlory, hallelujah');
INSERT INTO page VALUES (10940,367,4,'That\'s why I call you Savior, \nthat\'s why I call you friend.\nYou touched my heart, You touched my soul,\nand helped me start all over again.\nThat\'s why I love you Jesus, \nthat\'s why I\'ll always care.\nYou gave me love when \nnobody gave me a prayer\nthat\'s why I\'ll always care.');
INSERT INTO page VALUES (10941,367,1,'You gave me time when \nno one gave me time of day.\nYou looked deep inside\nwhile the rest of the world looked away.\nYou smiled at me when there \nwere just frowns everywhere.\nYou gave me love when\nnobody gave me a prayer.');
INSERT INTO page VALUES (10942,367,3,'You gave me laughter \nafter I cried all my tears.\nYou heard my dreams \nwhile the rest of the world closed its ear.\nI looked in your eyes and \nI found the tenderness there.\nYou gave me love when \nnobody gave me a prayer.');
INSERT INTO page VALUES (10943,367,2,'That\'s why I call you Savior, \nthat\'s why I call you friend.\nYou touched my heart, You touched my soul,\nand helped me start all over again.\nThat\'s why I love you Jesus, \nthat\'s why I\'ll always care.\nYou gave me love when \nnobody gave me a prayer\nthat\'s why I\'ll always care.');
INSERT INTO page VALUES (13528,614,1,'That the Church agrees to the sale of\nthe Gosford City Baptist Pre-School\nbusiness to the Central Coast Grammar\nSchool for an amount not less than\n$300 000 and to Lease the Pre-School\nproperty to the Central Coast Grammar\nSchool at not less than $75 000 per\nannum for a period of 5 years with\noptions for renewal for further 5 year\nperiods up to a maximum of 30 years.');
INSERT INTO page VALUES (12332,-7,2,'3-3');
INSERT INTO page VALUES (12329,382,1,'Australians all let us rejoice,\nFor we are young and free;\nWe\'ve golden soil and wealth for toil,\nOur home is girt by sea;\nOur land abounds in Nature\'s gifts\nOf beauty rich and rare;');
INSERT INTO page VALUES (11074,372,2,'For it\'s only in\nYour will,\nthat I am free');
INSERT INTO page VALUES (11072,372,1,'Jesus, all for Jesus\nAll I am and have\nAnd ever hope to be');
INSERT INTO page VALUES (11073,372,3,'All of my ambitions\nhopes and plans\nI surrender these\ninto your hands.');
INSERT INTO page VALUES (11211,373,4,'Praise to the Lord,\nO let all that is in me adore Him!\nAll that hath life and breath,\nCome now with praises before Him.\nLet the Amen sound from \nHis people again,\nGladly for aye we adore Him.');
INSERT INTO page VALUES (11214,373,2,'Praise to the Lord,\nwho o\'er all things\nso wondrously reigneth,\nShelters thee under His wings,\nyea, so gently sustaineth!\nHast thou not seen\nHow thy desires e\'er have been\nGranted in what He ordaineth?');
INSERT INTO page VALUES (12095,375,2,'My life belongs to You\nYou gave Your life for me\nYour grace is all I need\nJesus, You\'re all I need');
INSERT INTO page VALUES (12096,375,5,'And I will sing for you always\n\'Cause in your presence God\nis where I want to stay');
INSERT INTO page VALUES (11520,374,2,'We will go from\nstrength to strength\ntill we see you face to face');
INSERT INTO page VALUES (12094,375,3,'Hold me in Your arms\nnever let me go\nI want to spend\neternity with You');
INSERT INTO page VALUES (11517,374,4,'For You are Holy\nFor You are Holy\nFor You are Holy Lord\n');
INSERT INTO page VALUES (11518,374,1,'Blessed are those\nwho dwell in your house\nThey are ever praising You\nBlessed are those\nwho\'s strength is in You\nWho\'s hearts are set\non our God');
INSERT INTO page VALUES (11519,374,3,'Hear our prayer\nOh Lord God Almghty\nCome bless our land\nAs we seek You,\nWorship You');
INSERT INTO page VALUES (11513,376,4,'Praise Him (Praise Him),\nPraise Him (Praise Him),\nPraise Him (Praise Him),\nPraise Him in everything');
INSERT INTO page VALUES (11857,141,5,'Lord with confidence we come \nbefore your throne of grace\nNot that we deserve to come\nbut you have paid the way.');
INSERT INTO page VALUES (12411,14,2,'How I adore you\nHow I adore, I adore you\nHow I adore you\nHow I adore, I adore you');
INSERT INTO page VALUES (11789,377,1,'When I am weak, then you are strong\nWhen I am lost, you light my way\nWhen I am down, you lift me up\nYou fill my heart with heaven\'s joy');
INSERT INTO page VALUES (12093,375,1,'I stand before You lord\nAnd give You all my praise\nYour love is all I need\nJesus, You\'re all I need');
INSERT INTO page VALUES (12092,375,4,'And now that You\'re near\nEverything is different\nEverything is so different Lord\nI know I\'m not the same\nMy life You\'ve changed\nI wanna be with You\nI wanna be with you');
INSERT INTO page VALUES (11514,376,1,'I give you praise for You deserve it\nI give you praise for what you\'ve done\nI give you praise for You are able\nI give you praise \'til I overcome\nI give you praise when the sun is shining\nI give you praise in the dark of night\nI give you praise when tha battle rages\nI give you praise \'til it works out right');
INSERT INTO page VALUES (11515,376,3,'Heaven Opens as\nwe sing Your praise\nAngels join us as\nwe praise Your name');
INSERT INTO page VALUES (11516,376,2,'The Shout of the King is among us\nGod lives here in our praises\nThe Shout of the King is among us\nPraise Him, Praise Him,\nPraise Him in everything');
INSERT INTO page VALUES (11786,377,9,'I gotta tell the world\nAbout your saving love\n\'Cause I cant hold it any longer');
INSERT INTO page VALUES (12503,388,2,'He laid His glory by,\nHe wrapped Him in our clay;\nUnmarked by human eye,\nThe latent God-head lay;\nInfant of days He here became,\nAnd bore the mild Immanuel\'s name.');
INSERT INTO page VALUES (12410,14,5,'Heaven\'s praise surrounds us\n  in this place\nAs we offer up our songs\n  of praise to you\nNations turn and see\n  your holy face');
INSERT INTO page VALUES (12757,197,2,'holiday Events.....\nNewtown Mission presents\nCornerstone Connect\nCreative Arts Workshop & gig\n\nfeaturing the jive express\nand mike mccarthy\n\nSaturday 11th October\nWade will be taking a crew down');
INSERT INTO page VALUES (12762,429,1,'It\'s your body broken there\nIt\'s your body broken there\nAs you died you took my place\nA once-forever sacrifice\nCleanses me\nFor Eternity\n   (Women echo: Eternity)\nMy Jesus, God\'s precious sacrifice\n');
INSERT INTO page VALUES (11788,377,8,'It makes me wanna dance\nIt makes me wanna shout\nIt makes me wanna laugh\nand cry out loud');
INSERT INTO page VALUES (12748,427,5,'              1. Alone and suffering (1-2)\n                                 Vs.\n      Praise of the community (3-5) based\n           on the Creator in history\n\n       2.Persecuted and put down (6-8)\n                                Vs.\nRecognition of the intimate Creator (9-11)\n\n        3.Surrounded and wasted (12-18)\n                                Vs.\n              Deliverer Creator (20-21)');
INSERT INTO page VALUES (11787,377,2,'You have the words that give me life\nAll Your promises are true\nYour love for me will never fail\nAnd I will listen to you');
INSERT INTO page VALUES (11784,377,3,'And It\'s all by the love of the Father\nAnd it\'s all by the love of God\nIt\'s all by the power of the Spirit\nWorking here within my heart');
INSERT INTO page VALUES (11785,377,7,'\'Cause I\'ve been touched\nby the love of the Father\nI\'ve been touched by the hand of God\nI\'ve been filled with the power\nof His Spirit\nAnd I\'m changed forever more');
INSERT INTO page VALUES (12398,197,1,'WELCOME TO ONE80\nTHIS IS OUR LAST NITE\nHERE! \n\nOne80 RestartS\nSUNDAY October 19th\nOnE80 Gromz RestartS\nFRIDAY October 17th\nAT WAMBY SCHOOL');
INSERT INTO page VALUES (11783,377,6,'And It\'s all by the love of the Father\nAnd it\'s all by the love of God\nIt\'s all by the power of the Spirit\nWorking here within my heart');
INSERT INTO page VALUES (11854,141,3,'This is a holy moment now,\nSomething of heaven touches earth,\nVoices of angels all resound,\nwe join their song');
INSERT INTO page VALUES (11853,141,1,'As we come today');
INSERT INTO page VALUES (11985,379,1,'Lord, We lift your name on high;\nLord, We love to sing your praises.\nWe\'re so glad You\'re in our lives;\nWe\'re so glad You came to save us.');
INSERT INTO page VALUES (11986,379,2,'You came from heaven to Earth\nTo show the way;\nFrom the Earth to the cross,\nOur debts to pay.\nFrom the cross to the grave,\nFrom the grave to the sky;\nLord, We lift your name on high');
INSERT INTO page VALUES (11790,377,4,'When I am weak, then you are strong\nWhen I am lost, you light my way\nWhen I am down, you lift me up\nYou fill my heart with heaven\'s joy');
INSERT INTO page VALUES (11791,377,5,'You have the words that give me life\nAll Your promises are true\nYour love for me will never fail\nAnd I will listen to you');
INSERT INTO page VALUES (12132,380,3,'Lord of the Church,\nwe seek a father\'s blessing,\nA true repentance\nand a faith restored,\nA swift obedience\namd a new posessing,\nFilled with the Holy Spirit\nof the Lord!');
INSERT INTO page VALUES (11960,378,2,'Angels bow down before You,\nworship and adore,\nfor You have the words\nof eternal life,\nYou are Jesus Christ the Lord.');
INSERT INTO page VALUES (11959,378,3,'Hosanna to the Son of David!\nHosanna to the King of kings!\nGlory in the highest heaven,\nfor Jesus the Messiah reigns!');
INSERT INTO page VALUES (11958,378,1,'You are the King of glory,\nYou are the Prince of peace,\nYou are the Lord of\n heav\'n and earth,\nYou\'re the Son of righteousness.');
INSERT INTO page VALUES (12658,31,3,'Give thanks with a grateful heart\nGive thanks to the Holy One\nGive thanks because He\'s given\nJesus Christ His Son');
INSERT INTO page VALUES (12133,380,2,'We turn to Christ,\namid our fear and failing,\nThe will that lacks the\ncourage to be free,\nThe weary labours,\nall but unavailing\nTo bring us nearer\nwhat a church should be');
INSERT INTO page VALUES (12130,380,4,'We turn to Christ \nfrom all our restless striving,\nUn-numbered voices\nwith a single prayer --\nThe living water\nfor our souls reviving\nIn Christ to live,\nand love and serve and care');
INSERT INTO page VALUES (12131,380,1,'Lord of the Church,\nwe pray for our renewing:\nChrist over all,\nOur undivided aim.\nFire of the spirit,\nburn for our enduing,\nWind of the spirit,\nFan the living flame');
INSERT INTO page VALUES (12129,380,6,'So lead us on\ntill toil and trouble ended\nOne church triumphant\none new song shall sing\nTo praise his glory\nrisen and asceneded\nChrist over all,\nthe everlasting King');
INSERT INTO page VALUES (12175,169,2,'Glory, glory, glory\nto the King of kings!\nGlory, glory, glory\nto the King of kings!\nLord we lift up your name,\nWith hearts full of praise.\nBe exalted O Lord my God.\nGlory to the King of kings!');
INSERT INTO page VALUES (12194,67,1,'I will call upon the Lord (echo)\nWho is worthy to be praised (echo)\nSo shall I be saved from \nmy enemies (echo)');
INSERT INTO page VALUES (12174,169,3,'Hosanna, hosanna, \nhosanna in the highest!\nHosanna, hosanna, \nhosanna in the highest!\nLord, we lift up your name,\nWith hearts full of praise.\nBe exalted, O Lord my God.\nHosanna in the highest!');
INSERT INTO page VALUES (12379,383,4,'\'Tis mercy all!\n let earth adore,\nLet angels minds\n inquire no more.');
INSERT INTO page VALUES (12134,380,5,'Lord of the Church\nwe long for uniting\nTrue to one calling,\nby one vision stirred.\nOne cross proclaiming\nand one creed reciting\nOne in the truth\nof Jesus and his word');
INSERT INTO page VALUES (12320,1,2,'Amazing love!\nhow can it be\nThat Thou, my God,\nshouldst die for me.');
INSERT INTO page VALUES (12304,381,5,'On the third day, \n  He was raised up with Glory\nReigning on high, \n  the risen Son\nWe have new life, \n  a new hope, a new future\nNow we cry\n  \"Come, Lord Jesus Come!\"');
INSERT INTO page VALUES (12303,381,2,'Behold the Lamb of God,\nwho takes away our sin\nThe light of the world,\nthe Son of God\nWorthy is the Lamb\nto receive our praise\nGlory and honour and power');
INSERT INTO page VALUES (12302,381,3,'He turned not His face\n  from our pain and destruction\nHe drank the bitter cup to the end\nHe who knew no sin\n  took the punishment for us\nDeserted by God, man and friend');
INSERT INTO page VALUES (12301,381,1,'He walked on earth,\n  showing glimpses of heaven\nDemons, death,\n  disease had no hand\nThe wind and the waves\n  were obedient before Him\nWell may they say, \"Who is this man?\"');
INSERT INTO page VALUES (12300,381,4,'Behold the Lamb of God,\nwho takes away our sin\nThe light of the world,\nthe Son of God\nWorthy is the Lamb\nto receive our praise\nGlory and honour and power');
INSERT INTO page VALUES (12299,381,6,'Behold the Lamb of God,\nwho takes away our sin\nThe light of the world,\nthe Son of God\nWorthy is the Lamb\nto receive our praise\nGlory and honour and power');
INSERT INTO page VALUES (12331,-7,1,'1-2');
INSERT INTO page VALUES (12319,1,1,'And can it be that I should gain,\nAn interest in the Saviour\'s blood?\nDied He for me, who caused His pain?\nFor me, who depths of love Divine!\n\'Tis mercy all! let earth adore,\nLet angel minds inquire no more.');
INSERT INTO page VALUES (12271,8,5,'Rejoice Rejoice! Christ is in you\nThe hope of glory in our hearts\nHe lives! He lives! His breath is in you\nArise a mighty army, we arise!');
INSERT INTO page VALUES (12330,382,2,'In history\'s page,\nlet every stage\nAdvance Australia fair!\nIn joyful strains\nthen let us sing,\n\"Advance Australia fair!\"');
INSERT INTO page VALUES (12381,383,5,'He left His Father\'s throne above,\nSo free, so infinite His grace;\nEmptied Himself of all but love,\nAnd bled for Adam\'s helpless race;\n\'Tis mercy all, immense and free;\nFor, O my God, it found out me.');
INSERT INTO page VALUES (12380,383,10,'Bold I approach\n the eternal throne,\nAnd claim the crown,\nthro\' Christ my own.');
INSERT INTO page VALUES (12375,383,9,'No condemnation now I dread;\nJesus, and all in Him, is mine!\nAlive in Him, my living Head,\nAnd clothed in righteousness Divine,\nBold I approach the eternal throne,\nAnd claim the crown,\nthro\' Christ my own.');
INSERT INTO page VALUES (12376,383,2,'Amazing love!\nhow can it be\nThat Thou, my God,\nshouldst die for me.');
INSERT INTO page VALUES (12333,-7,3,'4-4');
INSERT INTO page VALUES (12334,-7,4,'5-5');
INSERT INTO page VALUES (12335,-7,5,'6-7');
INSERT INTO page VALUES (12336,-7,6,'8-9');
INSERT INTO page VALUES (12337,-7,7,'10-10');
INSERT INTO page VALUES (12338,-7,8,'11-11');
INSERT INTO page VALUES (12339,-7,9,'12-12');
INSERT INTO page VALUES (12340,-8,1,'17-18');
INSERT INTO page VALUES (12341,-8,2,'19-20');
INSERT INTO page VALUES (12342,-8,3,'21-21');
INSERT INTO page VALUES (12782,262,2,'Our God is a heaps grouse God,\nHe reigns, from heaven above.\nWith wisdom, power and love\nOur God is an heaps grouse God');
INSERT INTO page VALUES (12626,401,3,'Come to Bethlehem, and see\nHim whose birth the angels sing\nCome, adore on bended knee\nChrist the Lord, the newborn King\n\nGloria in excelsis deo\nGloria in excelsis deo');
INSERT INTO page VALUES (12377,383,8,'My chains fell off,\n my heart was free;\nI rose, went forth,\n and followed Thee.');
INSERT INTO page VALUES (12378,383,1,'And can it be that I should gain,\nAn interest in the Saviour\'s blood?\nDied He for me, who caused His pain?\nFor me, who Him to death pursued?\nAmazing love! how can it be\nThat Thou, my God shouldst die for me?');
INSERT INTO page VALUES (12372,383,6,'\'Tis mercy all,\n immense and free;\nFor, O my God,\n it found out me.');
INSERT INTO page VALUES (12373,383,3,'\'Tis mystery all!\nTh\' Immortal dies!\nWho can explore His strange design?\nIn vain the first-born seraph tries\nTo sound the depths of love Divine!\n\'Tis mercy all! let earth adore,\nLet angels minds inquire no more.');
INSERT INTO page VALUES (12374,383,7,'Long my imprisoned spirit lay\nFast bound in sin and nature\'s night;\nThine eye diffused a quick\'ning ray,\nI woke, the dungeon flamed with light;\nMy chains fell off, my heart was free;\nI rose, went forth, and followed Thee.');
INSERT INTO page VALUES (12384,384,1,'Praise Him you heavens\nAnd all that\'s above\nPraise Him you angels\nAnd heavenly hosts\nLet the whole earth praise Him');
INSERT INTO page VALUES (12385,384,3,'Great in power\nGreat in glory\nGreat in mercy\nKing of Heaven\nGreat in battle\nGreat in wonder\nGreat in Zion\nKing over all the earth');
INSERT INTO page VALUES (12386,384,2,'Praise Him the sun moon\nAnd bright shining stars\nPraise Him you heavens\nAnd waters and skies\nLet the whole earth praise Him');
INSERT INTO page VALUES (12391,98,2,'(We\'ve got love)\nMy God is never wrong\nAnd He makes time for me\n(We\'ve got grace)\nIt blew apart my chains\nAnd set this sinner free\n');
INSERT INTO page VALUES (12392,98,5,'(We\'ve got love)\nMy God is never wrong\nAnd He makes time for me\n(We\'ve got grace)\nIt blew apart my chains\nAnd set this sinner free\n');
INSERT INTO page VALUES (12412,14,4,'How I adore you\nHow I adore, I adore you\nHow I adore you\nHow I adore, I adore you');
INSERT INTO page VALUES (12561,385,2,'Joy to the earth!\nthe Saviour reigns;\nLet men their songs employ;\nWhile fields and floods,\nrocks, hills and plains\nRepeat the sounding joy,\nrepeat the sounding joy,\nrepeat, repeat \nthe sounding joy.');
INSERT INTO page VALUES (12559,385,1,'Joy to the world!\nthe Lord is come;\nLet earth receive her King;\nLet every heart prepare Him room,\nAnd heaven and nature sing,\nand heaven and nature sing,\nand heaven, and heaven \nand nature sing.');
INSERT INTO page VALUES (12560,385,3,'No more let sins\nand sorrows grow,\nNor thorns infest the ground;\nHe comes to make\nHis blessings flow\nFar as the curse is found,\nfar as the curse is found,\nfar as, far as\nthe curse is found.');
INSERT INTO page VALUES (12558,385,4,'He rules the world\nwith truth and grace,\nAnd makes the nations prove\nThe glories of His righteousness,\nAnd wonders of His love,\nand wonders of His love,\nand wonders, and wonders\nof His love.');
INSERT INTO page VALUES (12538,226,1,'Quick access to todays announcements');
INSERT INTO page VALUES (12779,431,10,'The problem of pain... and some answers:\n\nTwo basic principles -\n  1. Natural laws\n  2. Human freedom\n\n\n\n');
INSERT INTO page VALUES (12583,112,1,'1. In what decade did you come to faith?\n2. What do you believe is the\n \'measure of faith\' that Paul\n mentions in Romans 12:3?\n3. Is faith able to be quantified &\n if so what methods\n would you use to do this?');
INSERT INTO page VALUES (13449,598,1,'Holy, Holy, God almighty,\n who was and is to come\nGod of Glory, You\'re so worthy\nAll of the saints bow down');
INSERT INTO page VALUES (12692,418,4,'Call me,\nGuide me,\nLead me,\nWalk beside me;\nI give my life to the Potter\'s hand.');
INSERT INTO page VALUES (12500,388,4,'Made perfect first in love,\nAnd sanctified by grace,\nWe shall from earth remove,\nAnd see His glorious face:\nThen shall His love be fully shown\nAnd man shall then be lost in God.');
INSERT INTO page VALUES (12501,388,1,'Let earth and heaven combine,\nAngels and men agree,\nTo praise in songs divine\nThe incarnate Deity,\nOur God contracted to a span,\nIncomprehensively made man.\n\n');
INSERT INTO page VALUES (12502,388,3,'Unsearchable the love\nThat has the Saviour brought;\nThe grace is far above\nOr man or angel\'s thought;\nSuffice for us that God, we know,\nOur God is manifest below.');
INSERT INTO page VALUES (12468,389,1,'I make a vow\nMy life will always honour Christ\nWhether I live or die\nI belong to Him\nHe bore my sin\nI owe this life to my savig King');
INSERT INTO page VALUES (12469,389,2,'Hallelujah\nI am not my own\nYou are in control\nHallelujah\n');
INSERT INTO page VALUES (12470,390,1,'I need direction in my life\nWould You show me Your way\n\'Cause I know it is right\nI need Your lovin\' in my life\nYou\'re the only one whose love\nis better that life');
INSERT INTO page VALUES (12471,390,3,'I need Your grace in my life\nWould You show me Your way\n\'Cause I know it is right\nI need Your favour in my life\nYou\'re the only one whose love\nis better that life');
INSERT INTO page VALUES (12472,390,2,'Jesus I long to see Your face\nJesus I long\nJesus I long to see Your face\nJesus I long');
INSERT INTO page VALUES (12491,391,4,'You are the Great and Mighty\nRisen Lord my King of Glory\nYou reign in strength and power\nAwesome God, my strong tower');
INSERT INTO page VALUES (12493,391,3,'You are the Great and Mighty\nRisen Lord my King of Glory\nOh my soul bless the Lord\n\nYou reign in strength and power\nAwesome God, my strong tower\nOh my soul bless the Lord');
INSERT INTO page VALUES (12492,391,1,'To You my love, my joy, my song\nI lift my voice, my heart\nand soul, in worship\n\nAs eagles soar across the sky\nSo my spirit reaches high\ntoward You');
INSERT INTO page VALUES (12498,236,2,'Every failure and success\nEvery year in the wilderness\nWhen you made all my\ntwisted ways straight\nI wanna give back to you');
INSERT INTO page VALUES (12494,391,2,'As the dear pants for the water\nso my soul cries for You\n\nAs a child, has rest in arms of love\nso I rest in You');
INSERT INTO page VALUES (12499,236,5,'Every wrong turn on every road\nEvery bad seed I ever sowed\nEvery fear that I wasted in vain,\nI wanna give back to you');
INSERT INTO page VALUES (12548,392,1,'M: Good manager arrangement\r\nT: thanks\r\nM: where wise men?\r\nT: arrive two years, coffee table\r\nM: great\r\nMr: wallet?\r\nM: Kitchen\r\nMr: Found it\r\nMr: Breifcase?\r\nM: front door, busy day today\r\nMr: found it\r\nM: really?\r\nMr: pre-christmas meeting, then lunch\r\nM: whos that?\r\nMr: Party animal, played ball, beat him, time?..Wow, gotta go\r\nM: hold on, listen to toms verse\r\nMr: sorry it\'s busy now\r\nMr: ok son, let me hear it\r\nT: Verse\r\nT: dad?\r\nMr: yea, great, cya\r\nM: breifcase!\r\nMr: Oh yea, bye\r\nT: bye\r\nM: bye');
INSERT INTO page VALUES (12549,392,2,'Je: hi\r\nBa: hi\r\nJo: morning\r\nBa: Shooping?\r\nJe: K\r\nB: great, old outfit bad\r\nMr: morning all, still painting here?\r\nBa: strong smell, complexion\r\nMr: Make it quick, John-sales report?\r\nJo: sold 30M, sales tapering\r\n');
INSERT INTO page VALUES (12550,393,4,'Tell out, my soul,\nthe glories of His word!\nFirm is His promise, \nand His mercy sure. \nTell out, my soul, \nthe greatness of the Lord\nTo children\'s children \nand for ever more!');
INSERT INTO page VALUES (12551,393,1,'Tell out, my soul,\nthe greatness of the Lord!\nUn-numbered blessings,\ngive my spirit voice;\nTender to me the \npromise of His word,\nIn God my Saviour \nshall my heart rejoice');
INSERT INTO page VALUES (12552,393,3,'Tell out, my soul,\nthe greatness of His might!\nPowers and dominions \nlay their glory by.\nProud hearts and stubborn\nwill are put to flight,\nThe hungry fed, \nthe humble lifted high.');
INSERT INTO page VALUES (12553,393,2,'Tell out, my soul,\nthe greatness of His name!\nMake known His might,\nthe deeds His arm has done;\nHis mercy sure from \nage to age the same;\nHis holy name -\nthe Lord, the Mighty One.');
INSERT INTO page VALUES (12585,394,2,'Sing hallelujah to\n wonderful counsellor\nSing hallelujah to\n the mighty God\nSing hallelujah to\n the Father forever\nSing hallelujah to\n the true Prince of Peace');
INSERT INTO page VALUES (12584,394,1,'For unto us a child is born,\na son is given.\nCome Holy Spirit, \ncome father this child.\nThe virgin Mary shall\nbe His mother\nAnd His name shall\nbe called Emmanuel.');
INSERT INTO page VALUES (12592,395,1,'God did not just order\nMary to be the mother\nof His son.');
INSERT INTO page VALUES (12593,395,4,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n   * Deborah\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12594,395,5,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n   * Deborah\n   * Hannah\n\n\n\n\n\n');
INSERT INTO page VALUES (12590,395,2,'1. Mary knew OT women who did \n   important tasks for God:\n\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12591,395,8,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n   * Deborah\n   * Hannah\n2. Mary knew and trusted God \n   in a personal way\n3. God provided Mary with the \n   support she needed:\n   * Elizabeth\n');
INSERT INTO page VALUES (12589,395,9,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n   * Deborah\n   * Hannah\n2. Mary knew and trusted God \n   in a personal way\n3. God provided Mary with the \n   support she needed:\n   * Elizabeth\n   * Joseph');
INSERT INTO page VALUES (12587,395,3,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12588,395,7,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n   * Deborah\n   * Hannah\n2. Mary knew and trusted God \n   in a personal way\n3. God provided Mary with the \n   support she needed:\n\n');
INSERT INTO page VALUES (12586,395,6,'1. Mary knew OT women who did \n   important tasks for God:\n   * Miriam\n   * Deborah\n   * Hannah\n2. Mary knew and trusted God \n   in a personal way\n\n\n\n');
INSERT INTO page VALUES (12595,396,8,'Hark, now hear the angels sing,\na new king born today,\nand man will live for evermore,\nbecause of Christmas day.\nTrumpets sound and angels sing,\nlisten to what they say,\nthat man will live for evermore,\nbecause of Christmas day.');
INSERT INTO page VALUES (12596,396,5,'Now Joseph and his wife, Mary, \ncome to Bethlehem that night,\nthey find no place to born the child, \nnot a single room was in sight.');
INSERT INTO page VALUES (12597,396,9,'Long time ago in Bethlehem, \nso the Holy Bible say,\nMary\'s boy child, Jesus Christ, \nwas born on Christmas Day.');
INSERT INTO page VALUES (12598,396,3,'While shepherds watch their flocks by night, \nthey see a bright new shining star,\nthey hear a choir sing, \nthe music seemed to come from afar.');
INSERT INTO page VALUES (12599,396,2,'Hark, now hear the angels sing,\na new king born today,\nand man will live for evermore,\nbecause of Christmas day.\nTrumpets sound and angels sing,\nlisten to what they say,\nthat man will live for evermore,\nbecause of Christmas day.');
INSERT INTO page VALUES (12600,396,10,'Hark, now hear the angels sing,\na new king born today,\nand man will live for evermore,\nbecause of Christmas day.\nTrumpets sound and angels sing,\nlisten to what they say,\nthat man will live for evermore,\nbecause of Christmas day.');
INSERT INTO page VALUES (12601,396,6,'Hark, now hear the angels sing,\na new king born today,\nand man will live for evermore,\nbecause of Christmas day.\nTrumpets sound and angels sing,\nlisten to what they say,\nthat man will live for evermore,\nbecause of Christmas day.');
INSERT INTO page VALUES (12602,396,1,'Long time ago in Bethlehem, \nso the Holy Bible say,\nMary\'s boy child, Jesus Christ, \nwas born on Christmas Day.');
INSERT INTO page VALUES (12603,396,4,'Hark, now hear the angels sing,\na new king born today,\nand man will live for evermore,\nbecause of Christmas day.\nTrumpets sound and angels sing,\nlisten to what they say,\nthat man will live for evermore,\nbecause of Christmas day.');
INSERT INTO page VALUES (12604,396,7,'By and by they find a little nook \nin a stable all forlorn,\nand in a manger cold and dark, \nMary\'s little boy was born.');
INSERT INTO page VALUES (12605,397,6,'Not in that poor lowly stable,\nWith the oxen standing by,\nWe shall see Him; but in Heaven,\nSet at God\'s right hand on high;\nWhere like stars His children crowned\nAll in white shall wait around.');
INSERT INTO page VALUES (12606,397,4,'For He is our childhood\'s pattern;\nDay by day, like us He grew;\nHe was little, weak and helpless,\nTears and smiles like us He knew;\nAnd He feeleth for our sadness,\nAnd He shareth in our gladness.');
INSERT INTO page VALUES (12607,397,1,'Once in royal David\'s city\nStood a lowly cattle shed,\nWhere a mother laid her Baby\nIn a manger for His bed:\nMary was that mother mild,\nJesus Christ her little Child..');
INSERT INTO page VALUES (12608,397,3,'And, through all His wondrous childhood,\nHe would honour and obey,\nLove and watch the lowly maiden,\nIn whose gentle arms He lay:\nChristian children all must be\nMild, obedient, good as He.');
INSERT INTO page VALUES (12609,397,2,'He came down to earth from heaven,\nWho is God and Lord of all,\nAnd His shelter was a stable,\nAnd His cradle was a stall;\nWith the poor, and mean, and lowly,\nLived on earth our Saviour holy.');
INSERT INTO page VALUES (12610,397,5,'And our eyes at last shall see Him,\nThrough His own redeeming love,\nFor that Child so dear and gentle\nIs our Lord in Heav\'n above,\nAnd He leads His children on\nTo the place where He is gone.');
INSERT INTO page VALUES (12616,160,5,'Jesus, Your name is faithful and true,\nRedeemer, Lord and friend,\nHere in Your hands, my life is secure,\nYour love will never end.');
INSERT INTO page VALUES (12611,398,4,'Thou camest, O Lord,\nWith the living word,\nThat should set Thy people free;\nBut, with mocking scorn,\nAnd with crown of thorn,\nThey bore Thee to Calvary:\nO come to my heart Lord Jesus;\nThere is room in my heart for thee!');
INSERT INTO page VALUES (12612,398,1,'Thou didst leave thy throne\nAnd thy kingly crown\nWhen thou camest to earth for me,\nBut in Bethlehem\'s home\nWas there found no room\nFor Thy holy nativity:\nO come to my heart Lord Jesus;\nThere is room in my heart for thee!');
INSERT INTO page VALUES (12613,398,3,'The foxes found rest\nAnd the bird its nest\nIn the shade of the forest tree;\nBut Thy couch was the sod,\nO Thou Son of God,\nIn the deserts of Galilee:\nO come to my heart Lord Jesus;\nThere is room in my heart for thee!');
INSERT INTO page VALUES (12614,398,2,'Heaven\'s arches rang\nWhen the angels sang\nProclaiming Thy royal decree;\nBut of lowly birth\nCam\'st Thou, Lord, on earth,\nAnd in great humility;\nO come to my heart Lord Jesus;\nThere is room in my heart for thee!');
INSERT INTO page VALUES (12615,398,5,'When heavens shall ring,\nAnd the angels sing\nAt Thy coming to victory,\nLet thy voice call me home,\nSaying, \'Yet there is room-\nThere is room at My side for thee!\'\nAnd my heart shall rejoice,\n Lord Jesus,\nWhen Thou comest\n and callest for me.');
INSERT INTO page VALUES (12649,406,3,'Yea, Lord, we greet thee,\nborn this happy morning,\nJesus to Thee be glory given!\nWord of the father \nnow in flesh appearing;');
INSERT INTO page VALUES (12617,399,4,'O, may we keep and\n ponder in our mind\nGod\'s wondrous love\nin saving lost mankind;\nTrace we the Babe\nWho hath retrieved our loss,\nFor the poor manger\n to the bitter cross;\nTread in His steps,\n assisted by His grace,\nTill man\'s first heav\'nly\nstate again takes place.');
INSERT INTO page VALUES (12618,399,1,'Christians, \nawake! salute the happy morn,\nWhere on the Saviour \nof mankind was born;\nRise to adore the mystery of  love,\nWhich hosts of angels\nchanted from above:\nWith them the joyful\n tidings first begun\nOf God Incarnate, of the Virgin\'s Son.');
INSERT INTO page VALUES (12619,399,3,'He spake; and straight-way\n the celestial choir,\nIn hymns of joy unknown\n before conspire;\nThe praises of redeeming\n love they sang,\nand heav\'ns whole orb\n with hallelujahs rang;\nGod\'s highest glory\n was their anthem still,\n\"Peace upon earth,\n and unto men good-will.\"');
INSERT INTO page VALUES (12620,399,2,'Then to the watchful\n sheperds it was told,\nWho heard th\' angelic herald\'s voice,\n\"Behold, I bring good tidings\nof a Saviour\'s birth\nTo you and all the nations upon earth:\nThis day hath God fulfilled\nHis promised word,\nThis day is born a Saviour,\nChrist the Lord.\"');
INSERT INTO page VALUES (12621,399,5,'Then may we hope,\nth\' angelic hosts among,\nTo join redeemed,\na glad triumphant throng:\nHe that was born up this joyful day\nAround us all his glory shall display;\nSaved by His love,\nincessant we shall sing\nEternal praise to heav\'ns\nAlmighty King.');
INSERT INTO page VALUES (12622,400,4,'Saints, before the altar bending,\nWatching long in hope and fear,\nSuddenly the Lord, descending,\nIn His temple shall appear;\nCome and worship,\ncome and worship,\nWorship Christ, the newborn King!');
INSERT INTO page VALUES (12623,400,1,'Angels, from the realms of glory,\nWing your flight o\'er all the earth;\nYou who sang creation\'s story,\nNow proclaim Messiah\'s birth:\nCome and worship,\ncome and worship,\nWorship Christ, the newborn King!');
INSERT INTO page VALUES (12624,400,3,'Sages, leave you contemplations,\nBrighter visions beam afar;\nSee the great Desire of nations,\nYe have seen His natal star:\nCome and worship,\ncome and worship,\nWorship Christ, the newborn King!');
INSERT INTO page VALUES (12625,400,2,'Shepherds, in the fields abiding,\nWatching o\'er your flocks by night,\nGod with man is now residing,\nYonder shines the infant Light:\nCome and worship,\ncome and worship,\nWorship Christ, the newborn King!');
INSERT INTO page VALUES (12627,401,1,'Angels we have heard on high,\nSweetly singing o\'er the plains\nAnd the mountains in reply,\nEchoing their joyous strains\n\nGloria in excelsis deo\nGloria in excelsis deo');
INSERT INTO page VALUES (12628,401,2,'Sheperds, why this jubilee?\nWhy your joyous strains prolong?\nWhat the gladsome tidings be\nWhich inspire your heavenly song?\n\nGloria in excelsis deo\nGloria in excelsis deo');
INSERT INTO page VALUES (12629,401,4,'See Him in a manger laid,\nWhom the choirs of angels praise\nMary, Joseph, lend your aid,\nWhile our hearts in love we raise\n\nGloria in excelsis deo\nGloria in excelsis deo');
INSERT INTO page VALUES (12630,402,4,'Where children pure and \n  happy pray to the blessd Child,\nWhere misery cries out to Thee, \n  Son of the mother mild;\nWhere charity stands watching \n  and faith holds wide the door,\nThe dark night wakes, the glory breaks, \n  and Christmas comes once more.');
INSERT INTO page VALUES (12631,402,1,'O little town of Bethlehem, \n  how still we see thee lie!\nAbove thy deep and dreamless \n  sleep the silent stars go by.\nYet in thy dark streets \n  shineth the everlasting Light;\nThe hopes and fears of all the years \n  are met in thee tonight');
INSERT INTO page VALUES (12632,402,3,'How silently, how silently,\n  the wondrous Gift is giv\'n;\nSo God imparts to human hearts\n  the blessings of His heav\'n.\nNo ear may hear His coming,\n  but in this world of sin,\nWhere meek souls will receive\n  Him still, the dear Christ enters in.');
INSERT INTO page VALUES (12633,402,2,'For Christ is born of Mary,\n  and gathered all above,\nWhile mortals sleep, the angels\n  keep their watch of wondering love.\nO morning stars together,\n  proclaim the holy birth,\nAnd praises sing to God the King,\n  and peace to men on earth!');
INSERT INTO page VALUES (12634,402,5,'O holy Child of Bethlehem, \n  descend to us, we pray;\nCast out our sin, and enter in, \n  be born in us today.\nWe hear the Christmas angels \n  the great glad tidings tell;\nO come to us, abide with us, \n  our Lord Emmanuel!');
INSERT INTO page VALUES (12635,403,6,'Glorious now, behold Him arise\nKing, and God, and sacrifice\nHeaven sings alleluya\nAlleluia, Alleluia \n  Earth to the heav\'ns replies\n');
INSERT INTO page VALUES (12636,403,4,'Frankincense to offer have I\nIncense owns a Deity nigh\nPrayer and praising, all men raising\nWorship Him, God must high');
INSERT INTO page VALUES (12637,403,1,'We three kings of Orient are\nBearing gifts we traverse afar\nField and fountain, moor and mountain\nFollowing yonder star');
INSERT INTO page VALUES (12638,403,3,'Born a king on Bethlehem plain\nGold I bring, to crown him again\nKing for ever, ceasing never\nOver us all to reign');
INSERT INTO page VALUES (12639,403,2,'O star of wonder, star of night\nStar with royal beauty bright\nWestward leading, still proceeding\nGuide us to Thy perfect light');
INSERT INTO page VALUES (12640,403,5,'Myrrh is mine; its bitter perfume\nBreathes a life of gathering gloom\nSorrowing, sighing, bleeding, dying\nSealed in the stone-cold tomb');
INSERT INTO page VALUES (12641,404,1,'Dashing through the snow\nIn a one-horse open sleigh\nThrough the fields we go\nLaughing all the way.\nBells on bob-tail ring\nMaking spirits bright\nWhat fun it is to ride and sing\nA sleighing song tonight.\n                       \n');
INSERT INTO page VALUES (12642,404,2,'Jingle bells, jingle bells\nJingle all the way,\nOh what fun it is to ride\nIn a one-horse open sleigh, O\nJingle bells, jingle bells\nJingle all the way,\nOh what fun it is to ride\nIn a one-horse open sleigh\n');
INSERT INTO page VALUES (12643,405,1,'O Holy night, the stars are brightly shining\nIt is the night of the dear Saviour\'s birth\nLong lay the world in sin and error pining\nTill He appeared and the soul felt His worth\n');
INSERT INTO page VALUES (12646,405,3,'Led by the light of faith serenely beaming\nWith glowing hearts by His cradle we stand\nSo led by light of a star sweetly gleaming\nHere came the wise men from the Orient land');
INSERT INTO page VALUES (12647,405,2,'A thrill of hope, the weary world rejoices\nFor yonder beams a new and glorious morn\nFall on your knees! Oh, hear the angel voices!\nO night divine! O night when Christ was born!\nO night divine! O night, O night divine!');
INSERT INTO page VALUES (12648,405,5,'Truly he taught us to love one another\nHis law is love and His gospel is peace\nChains shall He break, for the slave is our brother\nAnd in His name all oppression shall cease');
INSERT INTO page VALUES (12650,406,1,'O come, all ye faithful, \njoyful and triumphant,\ncome ye, O come ye,\nto Bethlehem,\nCome and behold him,\nBorn the king of angels;');
INSERT INTO page VALUES (12644,405,6,'Sweet hymns of joy in grateful chorus rise we\nLet all within us praise His holy name\nChrist is the Lord\nThen ever, ever praise we\nHis pow\'r and glory ever more proclaim\nHis pow\'r and glory ever more proclaim\n');
INSERT INTO page VALUES (12645,405,4,'The King of Kings lay in lowly manger\nIn all our trials born to be our friend\nHe knows our need\nTo our weakness no stranger\nBehold your King! before the lowly bend!\nBehold your King! before Him bend!');
INSERT INTO page VALUES (12651,406,4,'O come, let us adore Him, (Ladies)\nO come, let us adore Him, (Men)\nO come, let us adore Him, (All)\nChrist the Lord.');
INSERT INTO page VALUES (12652,406,2,'O come, let us adore Him, (Ladies)\nO come, let us adore Him, (Men)\nO come, let us adore Him, (All)\nChrist the Lord.');
INSERT INTO page VALUES (12653,407,1,'For unto us a child is born.\nUnto us a Son is given;\nAnd the government shall be\nupon His shoulder;\nAnd His name shall be called\nWonderful, \nCounsellor,\nthe Mighty God!\n\nThe Everlasting Father, and\nthe Prince of Peace is He!');
INSERT INTO page VALUES (12654,408,1,'Come on ring those bells!\nLight the Christmas tree!\nJesus is the King,\nBorn for you and me.\nCome on ring those bells!\nEverybody say\nJesus we remember\nthis your birthday.');
INSERT INTO page VALUES (12655,408,3,'Come on ring those bells!\nLight the Christmas tree!\nJesus is the King,\n Born for you and me.\nCome on ring those bells!\nEverybody say\nJesus we remember\n this your birthday.\n(repeat)');
INSERT INTO page VALUES (12656,408,2,'Celebrations come because \nof something good.\nCelebrations we love to recall.\nMary had a baby\nboy in Bethlehem!\nThe greatest celebration \nof them all!');
INSERT INTO page VALUES (12679,414,4,'May the love of Jesus fill me\nAs the waters fill the sea\nHim exalting, self reducing\nThis is victory');
INSERT INTO page VALUES (12674,413,4,'Our restless spirits yearn for Thee,\nWhere\'er our changeful lot is cast,\nGlad when Thy gracious smile we see,\nBlest when our faith can hold Thee fast.');
INSERT INTO page VALUES (12670,412,4,'Lord Jesus Christ,\nI would come to you,\nLive my life for you, Son of God,\nAll your commands I know are true,\nYour many gifts will make me new,\nInto my life your \npower breaks through,\nLiving Lord.');
INSERT INTO page VALUES (12664,410,1,'A new commandment I give unto you \nThat you love one another,\nas I have loved you.\nThat you love one another,\nas I have loved you.');
INSERT INTO page VALUES (12665,410,2,'By this shall all men know \nthat you are my disciples.\nIf you have love one for another.\nBy this shall all men know\nThat you are my disciples\nIf you have love one for another.');
INSERT INTO page VALUES (12693,418,1,'Beautiful Lord, \nWonderful Saviour,\nI know for sure\nall of my days are\nheld in your hand,\ncrafted into your perfect plan.');
INSERT INTO page VALUES (12690,417,1,'Psalm 139 - God Pursues\r\nRev. Gavin Collinson\r\nA man who has never tried to flee God has never experienced the God who is really God.Is God the perfect picture of love, goodness, benevolence OR a just God who knows everything about us?One great Scottish divine said: This is the psalm I should wish to have before me on my death-bed.\r\n1-6      The All-seeing God7-12    The All-present God13-18  The All-creative God19-24  The All-holy God\r\nVv 1-6  The all-seeing GodPs 139 is the reflection of a man who has made an astounding discovery  the discovery that God knows him personally. Psalmist sees the searching eye of God has been over all his life.  Everywhere he meets Gods eye testing him and watching him continually.  God knows what he will say before a word is uttered.Even his thoughts are known.  Sees he does not belong entirely to himself or live his life exclusively for his own sake.\r\nGod not only knows about him but God cares for him.But how can God with a whole universe before him be interested in one little person?  Is this thought paralysing or liberating? Psalmist doesnt even try to answer the dilemma he is confronting, but accepts that he is man and God is God.  Such knowledge is too wonderful for me: it is high, I cannot attain it.\r\nVv 7-12  The all-present GodHis further discovery is that the God who knows and cares for him, pursues him.People today still seek the same escape routes as the psalmist many years ago. \r\nv. 8  They try to hide in heavenly things  elevated feelings of success and pleasure which lift one out of ones problems. Others go to hell to avoid God. v. 9 Others try the farthest limits of space. v.11  Some seek darkness to cover. \r\nVv 13-16  all creating, personal  GodBut God whom we try to escape has known us from before we were born.  Why, therefore, should we want to escape from him?Wonder is the beginning of worship. God is even interested in the unborn child. Our God brings not accusation, but forgiveness.\r\nVv 17-18  Gods presence\r\nGods awaiting presence greets him on awaking each morning.  Vv 19-21  Psalmists opposition to Gods enemies.How can there be such a vindictive hatred in psalmist against those who would oppose God?Vv 22-24  Final prayer of peace\r\n');
INSERT INTO page VALUES (12666,411,4,'May the shadow of Thy presence,\nAround our camp be spread,\nBaptise us with the courage \nWith which Thou blessed our dead,\nO keep us in the pathway\nTheir saintly feet have trod\nFor the might of thine arm\nwe bless Thee,\nOur God our fathers God.');
INSERT INTO page VALUES (12667,411,1,'For the might of Thine arm\nwe bless Thee,\nOur God our fathers God.\nThou has kept thy pilgrim people,\nBy the strength of Thy staff and rod,\nThou has called us to the journey,\nWhich faithless feet ne\'er trod,\nFor the might of thine arm\nwe bless Thee,\nOur God our fathers God.');
INSERT INTO page VALUES (12668,411,3,'We are watchers of a beacon,\nWhose light must never die.\nWe are guardians of an altar,\nThat shows Thee ever nigh,\nWe are children of the freemen\nwho sleep beneath the sod\nFor the might of thine arm\nwe bless Thee,\nOur God our fathers God.');
INSERT INTO page VALUES (12669,411,2,'For the love of Christ constraining,\nThat bound their hearts as one,\nFor the faith in truth and freedom\nIn which their work was done,\nFor the peace of God\'s evangel\nWhere with their feet were shod,\nFor the might of thine arm\nwe bless Thee,\nOur God our fathers God.');
INSERT INTO page VALUES (12671,412,1,'Lord Jesus Christ,\nyou have come to us,\nYou are one with us, Mary\'s Son,\nCleansing our souls from all their sin,\nPouring your love and goodness in,\nJesus our love for you we sing,\nLiving Lord.');
INSERT INTO page VALUES (12672,412,3,'Lord Jesus Christ,\nyou have come to us,\nBorn as one of us, Mary\'s son,\nLed out to die on Calvary,\nRisen from death to set us free,\nLiving Lord Jesus, help us see,\nYou are Lord.');
INSERT INTO page VALUES (12673,412,2,'Lord Jesus Christ, now and every day,\nTeach us how to pray, Son of God,\nYou have commanded us to do,\nThis in remembrance, Lord of you,\nInto our lives your \npower breaks through,\nLiving Lord.');
INSERT INTO page VALUES (12675,413,1,'Jesus Thou joy of loving hearts,\nThou fount of life Thou light of men,\nFrom the best bliss that earth imparts,\nWe turn unfilled to Thee again.');
INSERT INTO page VALUES (12676,413,3,'We taste Thee O Thou living bread,\nAnd long to feast upon Thee still,\nWe drink of Thee the fountain Head,\nAnd thirst our souls from Thee to fill.');
INSERT INTO page VALUES (12677,413,2,'Thy truth unchanged hath ever stood,\nThou savest those that on Thee call,\nTo them that seek Thee Thou art good,\nTo them that find Thee, All in all.');
INSERT INTO page VALUES (12678,413,5,'O Jesus ever with us stay,\nMake all our moments calm and bright,\nChase the dark night of sin away,\nShed o\'er the world Thy holy light.');
INSERT INTO page VALUES (12680,414,1,'May the mind of Christ my Saviour,\nLive in me from day to day,\nBy His love and power controlling \nAll I do and say.');
INSERT INTO page VALUES (12681,414,3,'May the peace of God my father,\nRule my life in everything,\nThat I may be calm to comfort,\nSick and sorrowing.');
INSERT INTO page VALUES (12682,414,2,'May the word of God dwell richly.\nIn my heart from hour to hour,\nSo that all may see I triumph,\nOnly through His power.');
INSERT INTO page VALUES (12683,414,5,'May I run the race before me,\nStrong and brave to face the foe,\nLooking only unto Jesus,\nAs I onward go.');
INSERT INTO page VALUES (12685,416,4,'And I worship you\nI give my life to you\nI fall down on my knees\nYes I worship you\nI give my life to you\nI fall down on my knees');
INSERT INTO page VALUES (12684,415,1,'I worship you almighty God\nThere is none like you\nI worship you O Prince of Peace\nThat is what I want to do\nI give you praise\nFor you are my righteousness\nI worship you almighty God\nThere is none like you.');
INSERT INTO page VALUES (12686,416,1,'I give you all the honour\nAnd praise that\'s due your name\nFor you are the King of glory\nThe creator of all things');
INSERT INTO page VALUES (12687,416,3,'As your Spirit moves upon me now\nYou meet my deepest need\nAnd I lift my hands up to your throne\nYour mercy I\'ve received');
INSERT INTO page VALUES (12688,416,2,'And I worship you\nI give my life to you\nI fall down on my knees\nYes I worship you\nI give my life to you\nI fall down on my knees');
INSERT INTO page VALUES (12689,416,5,'You have broken chains that bound me\nYou\'ve set this captive free\nI will lift my voice to praise your name\nFrom all eternity');
INSERT INTO page VALUES (12702,419,4,'Jesus,\nO Jesus, \ncome and fill our lives;\nJesus,\nO Jesus,\ncome and make me whole.');
INSERT INTO page VALUES (12691,416,6,'And I worship you\nI give my life to you\nI fall down on my knees\nYes I worship you\nI give my life to you\nI fall down on my knees\n\nI worship you.');
INSERT INTO page VALUES (12694,418,3,'Take me,\nMould me,\nUse me,\nFill me;\nI give my life to the Potter\'s hand.');
INSERT INTO page VALUES (12695,418,2,'You gently call me\ninto your presence,\nguiding me by your Holy Spirit;\nTeach me dear Lord\nto live all of my life\nthrough your eyes.\nI\'m captured by your holy calling,\nset me apart,\nI know your drawing me to yourself;\nLead me Lord, I pray.');
INSERT INTO page VALUES (12696,419,1,'O, let the Son of God enfold you\nwith his Spirit and his love;\nLet him fill your heart and\n satisfy your soul;\nO, let him have the \nthings that hold you\nand his Spirit, like a dove,\nwill descend upon your life \nand make you whole.');
INSERT INTO page VALUES (12697,419,2,'Jesus,\nO Jesus, \ncome and fill our lives;\nJesus,\nO Jesus,\ncome and make me whole.');
INSERT INTO page VALUES (12703,419,3,'O come and sing this\nsong with gladness\nas your hearts are filled with joy;\nLift your hands in sweet\nsurrender to his name;\nO, give him all your\ntears and sadness,\ngive him all your years of pain,\nand you\'ll enter into life\nin Jesus\' name.');
INSERT INTO page VALUES (12783,432,1,'rain down oh my Lord\nrain down on me\nfill my heart oh my Lord\nwith humilty');
INSERT INTO page VALUES (12698,420,4,'Come to my heart,\nO thou wonderful love;\nCome and abide,\nlifting my life till it rises above\nenvy and falsehood and pride;\nSeeking to be\nlowly and humble, a learner of Thee');
INSERT INTO page VALUES (12699,420,1,'Come, let us sing of a wonderful love,\ntender and true;\nOut of the heart of the Father above,\nstreaming to you and to you:\nWonderful love\ndwells in the heart of the Father above.');
INSERT INTO page VALUES (12700,420,3,'Jesus is seeking the wanderers yet;\nWhy do they roam?\nLove only waits to forgive and forget;\nHome, weary wanderer, home.\nWonderful love\ndwells in the heart of the Father above.');
INSERT INTO page VALUES (12701,420,2,'Jesus, the Saviour, this gospel to tell,\njoyfully came;\nCame with the helpless and\nhopeless to dwell,\nsharing their sorrow and shame;\nseeking the lost,\nsaving, redeeming\nat measureless cost.');
INSERT INTO page VALUES (12704,421,1,'Father, Father\nI rest in your love;\nFather, Father\nI rest in your love.\nTrials and pressures I may\nnot understand\nBut I know you\'re with me.\nYou hold me in your hand.');
INSERT INTO page VALUES (12705,421,2,'Father, Father\nI rest in your love;\nFather, Father\nI rest in your love.');
INSERT INTO page VALUES (12706,422,4,'Be exalted, O God\nAbove the heavens\nLet thy glory be\nover all the earth\n\nBe exalted, O God\nAbove the heavens\nLet thy glory, let thy glory\nLet thy glory be over all the earth');
INSERT INTO page VALUES (12707,422,1,'I will give thanks to thee\nO Lord, among the people\nI will sing praises to thee\nAmong the nations\nFor thy steadfast love is great\nIs great to the heavens\nAnd thy faithfulness\nThy faithfulness to the clouds');
INSERT INTO page VALUES (12708,422,3,'I will give thanks to thee\nO Lord, among the people\nI will sing praises to thee\nAmong the nations\nFor thy steadfast love is great\nIs great to the heavens\nAnd thy faithfulness\nThy faithfulness to the clouds');
INSERT INTO page VALUES (12709,422,2,'Be exalted, O God\nAbove the heavens\nLet thy glory be\nover all the earth\n(repeat)');
INSERT INTO page VALUES (12712,423,4,'This is all my hope and peace\nNothing but the blood of Jesus\nThis is all my righteousness\nNothing but the blood of Jesus\n\nOh! precious is the flow\nThat makes me white as snow;\nNo other fount I know,\nNothing but the blood of Jesus');
INSERT INTO page VALUES (12713,423,1,'What can wash away my sin?\nNothing but the blood of Jesus\nWhat can make me whole again?\nNothing but the blood of Jesus\n\nOh! precious is the flow\nThat makes me white as snow;\nNo other fount I know,\nNothing but the blood of Jesus');
INSERT INTO page VALUES (12714,423,3,'Nothing can for sin atone\nNothing but the blood of Jesus\nNaught of good that I have done\nNothing but the blood of Jesus\n\nOh! precious is the flow\nThat makes me white as snow;\nNo other fount I know,\nNothing but the blood of Jesus');
INSERT INTO page VALUES (12716,423,2,'For my pardon this I see\nNothing but the blood of Jesus\nFor my cleansing, this my plea\nNothing but the blood of Jesus\n\nOh! precious is the flow\nThat makes me white as snow;\nNo other fount I know,\nNothing but the blood of Jesus');
INSERT INTO page VALUES (12765,430,4,'He lives, all glory to his name;\nHe lives, my Saviour, still the same;\nWhat joy the blest assurance gives:\nI know that my Redeemer lives!');
INSERT INTO page VALUES (12732,425,1,'The Lord\'s my Shepherd,\nI shall not want.\nHe leads me to, lush meadows.\nHe takes me to the quiet pools\nAnd sends me in the right, directions\n\nFor it\'s He\nFor it\'s He');
INSERT INTO page VALUES (12718,424,1,'Psalm 51 : Will God Forgive\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12728,424,3,'Psalm 51 : Will God Forgive\n\nVv 1-2: Appeal\nVv 3-5: Confession\n\n\n\n');
INSERT INTO page VALUES (12719,424,2,'Psalm 51 : Will God Forgive\n\nVv 1-2: Appeal\n\n\n\n\n');
INSERT INTO page VALUES (12722,424,6,'Psalm 51 : Will God Forgive\n\nVv 1-2: Appeal\nVv 3-5: Confession\nVv 6-9: Restoration\nVv 10-13: Inward renewal\nVv 14-17: Humble Worship\n');
INSERT INTO page VALUES (12723,424,9,'TO PONDER\n* Have I acknowledged my sinfulnes \n  which seperates me from God  the\n  basic missing of the mark?\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12720,424,5,'Psalm 51 : Will God Forgive\n\nVv 1-2: Appeal\nVv 3-5: Confession\nVv 6-9: Restoration\nVv 10-13: Inward renewal\n\n');
INSERT INTO page VALUES (12721,424,11,'TO PONDER\n* Have I acknowledged my sinfulnes \n  which seperates me from God  the\n  basic missing of the mark?\n* Do I still live with unresolved sin in \n  my life\n* Does the joy of my experience with God\n  flow naturally on to others?\n\n\n\n');
INSERT INTO page VALUES (12724,424,12,'TO PONDER\n* Have I acknowledged my sinfulnes \n  which seperates me from God  the\n  basic missing of the mark?\n* Do I still live with unresolved sin in \n  my life\n* Does the joy of my experience with God\n  flow naturally on to others?\n* How does my experience of and with\n  God affect my sense of worship in all\n  parts of my life?\n');
INSERT INTO page VALUES (12725,424,8,'TO PONDER\n\n\n\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12733,425,2,'Even though I walk through\n  death\'s dark vale,\nHe stays, right beside me.\nAnd his beauty and love\n  chase after me,\nEveryday, of my life.\n\nFor it\'s He\nFor it\'s He');
INSERT INTO page VALUES (12727,424,7,'Psalm 51 : Will God Forgive\n\nVv 1-2: Appeal\nVv 3-5: Confession\nVv 6-9: Restoration\nVv 10-13: Inward renewal\nVv 14-17: Humble Worship\nVv 18-19: A peoples\' prayer');
INSERT INTO page VALUES (12729,424,13,'TO PONDER\n* Have I acknowledged my sinfulnes \n  which seperates me from God  the\n  basic missing of the mark?\n* Do I still live with unresolved sin in \n  my life\n* Does the joy of my experience with God\n  flow naturally on to others?\n* How does my experience of and with\n  God affect my sense of worship in all\n  parts of my life?\n           YES, GOD WILL FORGIVE');
INSERT INTO page VALUES (12730,424,10,'TO PONDER\n* Have I acknowledged my sinfulnes \n  which seperates me from God  the\n  basic missing of the mark?\n* Do I still live with unresolved sin in \n  my life\n\n\n\n\n\n');
INSERT INTO page VALUES (12731,424,4,'Psalm 51 : Will God Forgive\n\nVv 1-2: Appeal\nVv 3-5: Confession\nVv 6-9: Restoration\n\n\n');
INSERT INTO page VALUES (12734,426,6,'How lovely on the mountains\nare the feet of Him who brings\ngood news, good news.\nAnnouncing peace,\nproclaiming news of happiness,\nour God reigns, our God reigns,\nour God reigns, our God reigns,\nour God reigns, our God reigns!');
INSERT INTO page VALUES (12735,426,4,'Meek as a lamb that\'s led\nout to the slaughter house,\nDumb as a sheep before it\'s shearer.\nHis life ran down upon the\nground like pouring rain,\nThat we might be born again.\nThat we might be, that we might be,\nthat we might be born again.');
INSERT INTO page VALUES (12736,426,1,'How lovely on the mountains\nare the feet of Him who brings\ngood news, good news.\nAnnouncing peace,\nproclaiming news of happiness,\nour God reigns, our God reigns,\nour God reigns, our God reigns,\nour God reigns, our God reigns!');
INSERT INTO page VALUES (12737,426,3,'It was our sin and guilt that\nbruised and wounded Him.\nIt was our sin that brought Him down.\nWhen we like sheep had gone astray,\nour Shepherd came\nAnd on His shoulders bore our shame.\nOn His shoulders, on His shoulders,\nOn His shoulders He bore our shame.');
INSERT INTO page VALUES (12738,426,2,'He had no stately form,\nHe had no majesty,\nThat we should be drawn to Him.\nHe was despised and\nwe took no account of Him,\nYet now He reigns with the Most High.\nNow He reigns, now He reigns,\nnow He reigns with the Most High.');
INSERT INTO page VALUES (12739,426,5,'Out from the tomb He\ncame with grace and majesty,\nHe is alive, He is alive.\nGod loves us so,\nsee here His hands,\nHis feet, His side;\nYes, we know, He is alive.\nHe is alive, He is alive,\nHe is alive, He is alive.');
INSERT INTO page VALUES (12740,382,4,'With courage \nlet us all combine\nTo advance Australia fair,\nIn joyful strains \nthen let us sing,\n\"Advance Australia fair!\"');
INSERT INTO page VALUES (12741,382,3,'Beneath our radiant southern Cross,\nWe\'ll toil with hearts and hands;\nTo make this Commonwealth of ours\nRenowned of all the lands;\nFor those who\'ve come across the seas\nWe\'ve boundless plains to share;');
INSERT INTO page VALUES (12742,382,5,'Oh God who made this ancient land\nAnd set it round with sea\nSustain us all who dwell herein\nOne people strong and free\nGrant we may guard its generous gifts\nIts beauty rich and rare');
INSERT INTO page VALUES (12743,382,6,'In Your great name \nmay we proclaim\nAdvance Australia Fair\nWith thankful hearts\nthen let us sing\n\"Advance Australia Fair!\"');
INSERT INTO page VALUES (12754,427,11,'Do we act as though our God is alive and\n  listens, sustains justice and is the One\n     God who allows life to continue - \n      to the extent that others notice?');
INSERT INTO page VALUES (12770,431,8,'The problem of pain... and some answers:\n\nTwo basic principles -\n\n\n\n\n\n');
INSERT INTO page VALUES (12744,427,1,'                        Question\n         Why do people cry out to God,\neven if they normally don\'t pray or go to\n                    church (chapel)?\n\n\n\n');
INSERT INTO page VALUES (12745,427,2,'                        Question\n         Why do people cry out to God,\neven if they normally don\'t pray or go to\n                    church (chapel)?\n\nIf Psalm 23 taps into the reassurance of\nthe Lord against fear, then Psalm 22 is\nthe introduction of this, and takes us\nfrom anguish to praise by reminding us\nthat our Creator God is close not only\nto us, but also to our troubles.');
INSERT INTO page VALUES (12746,427,3,'              1. Alone and suffering (1-2)\n                                 Vs.\n      Praise of the community (3-5) based\n           on the Creator in history');
INSERT INTO page VALUES (12747,427,4,'              1. Alone and suffering (1-2)\n                                 Vs.\n      Praise of the community (3-5) based\n           on the Creator in history\n\n       2.Persecuted and put down (6-8)\n                                Vs.\nRecognition of the intimate Creator (9-11)');
INSERT INTO page VALUES (12749,427,6,'Praise and celebration because our God:\n \n\n\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12750,427,8,'Praise and celebration because our God:\n  a.Listens (22-24) - to our aloneness\n  b.Sustains the downtrodden (25-28) -\n   in the face of persecution for His names\n   sake, and \n\n\n\n\n\n\n');
INSERT INTO page VALUES (12751,427,10,'Praise and celebration because our God:\n  a.Listens (22-24) - to our aloneness\n  b.Sustains the downtrodden (25-28) -\n   in the face of persecution for His names\n   sake, and \n  c.Blesses (allows to grow - 29-31) in the\n   face of being wasted for Him.\n\nDo we act as though our God is alive and\nlistens, sustains justice and is the One\nGod who allows life to continue - \nto the extent that others notice?');
INSERT INTO page VALUES (12752,427,9,'Praise and celebration because our God:\n  a.Listens (22-24) - to our aloneness\n  b.Sustains the downtrodden (25-28) -\n   in the face of persecution for His names\n   sake, and \n  c.Blesses (allows to grow - 29-31) in the\n   face of being wasted for Him.\n\n\n\n\n');
INSERT INTO page VALUES (12753,427,7,'Praise and celebration because our God:\n  a.Listens (22-24) - to our aloneness\n\n\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12756,292,2,'Set me on fire\nSet me on fire\nSet me on fire\nSet me on fire');
INSERT INTO page VALUES (12758,428,4,'I worship You, I worship You\nThe reason I live is to worship you\nI worship You, I worship You\nThe reason I live is to worship you');
INSERT INTO page VALUES (12759,428,1,'When I look into your holiness\nWhen I gaze into your loveliness\nWhen all things that surround\nbecome shadows in the light of you\nWhen I\'ve found the joy\nof reaching your heart\nWhen my will becomes\nenthralled in your love\nWhen all things that surround\nbecome shadows in the light of you');
INSERT INTO page VALUES (12760,428,3,'When I gaze upon your perfectness\nAnd I think of my unworthiness\nThen the freedom from\nsin is more awesome\nin the light of you\nSince I\'ve found the \njoy of knowing your love\nThat your Word is so powerful and true\nThen the things that would crowd\nBecome shadows in the light of you');
INSERT INTO page VALUES (12761,428,2,'I worship You, I worship You\nThe reason I live is to worship you\nI worship You, I worship You\nThe reason I live is to worship you');
INSERT INTO page VALUES (12763,429,3,'It\'s your life so freely given\nIt\'s your life so freely given\nCauses us to fall before\nSuch unbounded sacrifice\nMelts our hearts\nLove forever free\n   (Women echo: forever free)\nLord Jesus, God\'s precious sacrifice');
INSERT INTO page VALUES (12764,429,2,'It\'s your blood that cleanses me\nIt\'s your blood that gives me life\nIt\'s your blood that took my place\nIn redeeming sacrifice\nWashes me\nWhiter than the snow\n   (Women echo: than the snow)\nMy Jesus, God\'s precious sacrifice');
INSERT INTO page VALUES (12766,430,1,'I know that my Redeemer lives:\nWhat joy the blest assurance gives!\nHe lives, He lives who once was dead;\nHe lives, my everlasting Head.');
INSERT INTO page VALUES (12767,430,3,'He lives, and grants me daily breath;\nHe lives, and I shall conquer death;\nHe lives, my mansion to prepare;\nHe lives, to bring me safely there.');
INSERT INTO page VALUES (12768,430,2,'He lives, to bless me with his love;\nHe lives, to plead for me above;\nHe lives, my hungry soul to feed;\nHe lives, to help in times of need.');
INSERT INTO page VALUES (12769,431,1,'CLAUDIA and her comforters:\n\n\n\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12773,431,3,'CLAUDIA and her comforters:\n\n* The Deacon - \n                     What is God teaching you?\n* The Widow - \n                     Face it with a smile\n\n\n\n\n\n');
INSERT INTO page VALUES (12780,431,12,'The problem of pain... and some answers:\n\nTwo basic principles -\n  1. Natural laws\n  2. Human freedom\n\nLIGHT FROM SCRIPTURE:\n- Old testament\n- New testament');
INSERT INTO page VALUES (12771,431,6,'CLAUDIA and her comforters:\n\n* The Deacon - \n                     What is God teaching you?\n* The Widow - \n                     Face it with a smile\n*  TV Evangelist - \n                     Believe and God will heal\n* The Spiritual giant - \n                     Thank you Lord!\n* The Pastor - \n                     God is using you');
INSERT INTO page VALUES (12772,431,4,'CLAUDIA and her comforters:\n\n* The Deacon - \n                     What is God teaching you?\n* The Widow - \n                     Face it with a smile\n*  TV Evangelist - \n                     Believe and God will heal\n\n\n\n');
INSERT INTO page VALUES (12781,431,13,'The problem of pain... and some answers:\n\nTwo basic principles -\n  1. Natural laws\n  2. Human freedom\n\nLIGHT FROM SCRIPTURE:\n- Old testament\n');
INSERT INTO page VALUES (12774,431,7,'The problem of pain... and some answers:\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12777,431,11,'The problem of pain... and some answers:\n\nTwo basic principles -\n  1. Natural laws\n  2. Human freedom\n\nLIGHT FROM SCRIPTURE:\n- Old testament\n');
INSERT INTO page VALUES (12775,431,2,'CLAUDIA and her comforters:\n\n* The Deacon - \n                     What is God teaching you?\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12776,431,5,'CLAUDIA and her comforters:\n\n* The Deacon - \n                     What is God teaching you?\n* The Widow - \n                     Face it with a smile\n*  TV Evangelist - \n                     Believe and God will heal\n* The Spiritual giant - \n                     Thank you Lord!\n\n');
INSERT INTO page VALUES (12778,431,9,'The problem of pain... and some answers:\n\nTwo basic principles -\n  1. Natural laws\n\n\n\n\n');
INSERT INTO page VALUES (12802,436,4,'Jesus, You are the light of the world\nJesus, You are the light of my life\nJesus, You are the light of the world\nJesus, You are the light of my life');
INSERT INTO page VALUES (13251,552,1,'I come to the garden alone\nWhile the dew is still on the roses,\nAnd the voice I hear\nFalling on my ear\nThe Son of God discloses.');
INSERT INTO page VALUES (12784,433,6,'From the rising to the setting sun\nHis love endures forever\nBy the grace of God we will carry on\nHis love endures forever');
INSERT INTO page VALUES (12785,433,4,'Sing praise\nSing praise\nSing praise\nSing praise');
INSERT INTO page VALUES (12786,433,1,'Give thanks to the\nLord our God and King\nHis love endures forever\nFor He is good. He is above all things\nHis love endures forever');
INSERT INTO page VALUES (12787,433,3,'With a mighty hand and outstreched arm\nHis love endures forever.\nFor the life that\'s been reborn\nHis love endures forever.');
INSERT INTO page VALUES (12788,433,7,'His love endures forever');
INSERT INTO page VALUES (12789,433,2,'Sing Praise\nSing Praise');
INSERT INTO page VALUES (12790,433,5,'Forever God is faithful,\nForever God is strong,\nForever God is with us,\nForever, Forever...');
INSERT INTO page VALUES (12793,197,3,'\nSOUL SURVIVOR \nWORSHIP NIGHT\n\nTHIS WEDNESDAY\n@DAYSPRING CHURCH\n730PM\nWITH MIKE P AND TIM HUGHES');
INSERT INTO page VALUES (13393,319,6,'I wil give You all my worship\nI will give You all my praise\nYou alone I long to worship\nYou alone are worthy of my praise');
INSERT INTO page VALUES (12820,440,6,'How do we receive God\'s gifts?\nThese children are at the very centre\nof life in the kingdom. Mark this: unless\nyou accept God\'s kingdom in the\nsimplicity of a child, you\'ll never get in\".\nThen gathering the children up in his arms,\nhe laid his hands of blessing on them.\"');
INSERT INTO page VALUES (12794,262,3,'Oh Lord You\'re an awesome God,\nYou reign, from heaven above.\nWith wisdom,power and love\nOh Lord You\'re an awesome God');
INSERT INTO page VALUES (12795,434,4,'He breaks the power of cancelled sin,\nHe sets the prisoner free,\nHe sets the prisoner free,\nHis blood can make the foulest clean,\n\nHis blood availed for me.  x 3');
INSERT INTO page VALUES (12796,434,1,'O, for a thousand tongues to sing,\nMy great redeemers praise,\nMy great redeemers praise,\nThe glories of my God and King,\n\nThe triumphs of His grace x 3');
INSERT INTO page VALUES (12797,434,3,'Jesus the name that charms our fears,\nThat bids our sorrows cease,\nThat bids our sorrows cease,\nTis music in the sinners ears,\n\nTis life and health and peace x 3');
INSERT INTO page VALUES (12798,434,2,'My gracious Master and my God,\nAssist me to proclaim,\nAssist me to proclaim,\nTo spread thru all the earth abroad,\n\nThe honours of Thy name x 3');
INSERT INTO page VALUES (12799,435,1,'God forgave my sin in Jesus\' name,\n I\'ve been born again in Jesus\' name;\nand in Jesus\' name I come to you\n to share His love as He told me to.');
INSERT INTO page VALUES (12800,435,3,'All pow\'r is given in Jesus\' name,\n in earth and heav\'n in Jesus\' name;\nand in Jesus\' name I come to you\n to share his pow\'r as He told me to.');
INSERT INTO page VALUES (12801,435,2,'He said: \'Freely, freely\n you have received,\n freely, freely give;\ngo in my name and\n because you believe,\n others will know that I live.\'');
INSERT INTO page VALUES (12803,436,1,'Jesus, You are the light of the world\nJesus, You are the light of the world\n\nAnd I will love You\n  with all of my heart\nAnd I will serve You\n  with all of my strength');
INSERT INTO page VALUES (12804,436,3,'Jesus, You are the light of my life\nJesus, You are the light of my life\n\nAnd I will love You\n  with all of my heart\nAnd I will serve You\n  with all of my strength');
INSERT INTO page VALUES (12805,436,2,'Jesus, You are the light of the world\nJesus, You are the light of the world\n\nAnd when the darkness\n  gathers all around me\nI know You\'re there,\n  I know You\'ll walk beside me');
INSERT INTO page VALUES (12808,438,6,'Do thy friends despise forsake thee?\nTake it to the Lord in pray\'r;\nIn his arms He\'ll take and sheild thee,\nThou wilt find a solace there.');
INSERT INTO page VALUES (12806,437,1,'Jesus fill me with Your love,\nJesus heal me with Your love.\nYour righteousness, Your holiness,\nThrough Your love are mine.');
INSERT INTO page VALUES (12807,437,2,'Jesus touch me with Your love,\nJesus change me with Your love.\nOpen my eyes, open my ears,\nOpen my heart with Your love.');
INSERT INTO page VALUES (12809,438,4,'Can we find a friend so faithful,\nWho will all our sorrows share?\nJesus knows our ev\'ry weakness;\nTake it to the Lord in pray\'r.');
INSERT INTO page VALUES (12810,438,1,'What a Friend we have in Jesus,\nAll our sins and greifs to bear;\nWhat a privilege to carry\nEv\'ry thing to God in pray\'r');
INSERT INTO page VALUES (12811,438,3,'Have we trials and temptations?\nIs there trouble anywhere?\nWe should never be discouraged;\nTake it to the Lord in pray\'r,');
INSERT INTO page VALUES (12812,438,2,'Oh what peace we often forfeit;\nOh what needless pain we bear;\nAll because we do not carry\nEv\'ry thing to God in pray\'r.');
INSERT INTO page VALUES (12813,438,5,'Are we weak and heavy laden,\nCumbered with a load of care?\nPrecious savour, still our refuge\nTake it to the Lord in pray\'r.');
INSERT INTO page VALUES (12814,439,4,'My table thou hast furnished\nIn presence if my foes;\nMy head thu dost ith oil anoint,\nAnd my cup overflows.');
INSERT INTO page VALUES (12815,439,1,'The Lord\'s my sheperd, I\'ll not want;\nHe makes me down to lie\nIn pastures green; He leadeth me\nThe quiet waters by.');
INSERT INTO page VALUES (12816,439,3,'Yea, though I walk in death\'s dark vale,\nYet will I not fear none ill,\nFor though art with me; and thy rod\nAnd staff me comfort still.');
INSERT INTO page VALUES (12817,439,2,'My soul he doth restore again;\nAnd me to walk doth make\nWithin the paths of righteousness;\nEv\'n for his own Name\'s sake.');
INSERT INTO page VALUES (12818,439,5,'Goodness and mercy all my life\nShall surely follow me;\nAnd in God\'s house for evermore\nMy dwelling place shall be.');
INSERT INTO page VALUES (12863,448,4,'In death\'s dark vale I fear no ill,\nWith Thee dear Lord beside me,\nThy rod and staff my comfort still,\nThy cross before to guide me.');
INSERT INTO page VALUES (12928,258,5,'Your presence like a cloud,\nUpon that ancient day,\nThe preists were overwhelmed\nBecause Your glory came');
INSERT INTO page VALUES (12827,441,4,'MEN: Over sin He has conquered\n LADIES: (Hallelujah, He has conquered)\nMEN: Over death victorious,\n LADIES: (Hallelujah, victorious)\nMEN: Over sickness He has triumphed,\n LADIES: (Hallelujah, He has triumphed)\nALL: Jesus reigns over all!');
INSERT INTO page VALUES (12821,440,4,'What has He given us?\nd.HIS SON\n\"This is how much God loved the\nworld: He gave his Son, His one\nand only Son. And this is why:\nso that no one need be destroyed;\nby believing in Him, anyone can\nhave a whole and lasting life\".\nJohn 3:16');
INSERT INTO page VALUES (12822,440,1,'What has He given us?\na.PEACE \nJesus said: \"Peace I leave with you, my\npeace I give you. I do not give to you as\nthe world gives. Do not let your hearts be\ntroubled and do not be\nafraid.\" John 14:27');
INSERT INTO page VALUES (12823,440,3,'What has He given us?\nc.FREEDOM/FORGIVENESS\n\"He sent me to announce\npardon to prisoners and recovery of\nsight to the blind, to set the burdened\nand battered free!\"\nLuke 4:18 ');
INSERT INTO page VALUES (12825,440,2,'What has He given us?\nb.LIFE \n\"I came so they can have\nreal and eternal life, more and better\nlife than they ever dreamed of\".\nJohn 10:10');
INSERT INTO page VALUES (12826,440,5,'How do we receive God\'s gifts?\nMark 10:13-16 \"The people brought\nchildren to Jesus, hoping he might touch\nthem. The disciples shooed them off. But\nJesus was irate and let them know it:\n\"Don\'t push these children away. \nDon\'t ever get between them and me.');
INSERT INTO page VALUES (12828,441,1,'For this purpose Christ was revealed\nto destroy all the works of the evil one.\nChrist in us has overcome,\nso with gladness we sing\nand welcome his kingdom in');
INSERT INTO page VALUES (12829,441,3,'In the name of Jesus we stand,\nBy the power of His blood\nWe now claim this ground.\nsatan has no authority here,\nPowers of darkness must flee,\nFor Christ has the victory.');
INSERT INTO page VALUES (12830,441,2,'MEN: Over sin He has conquered\n LADIES: (Hallelujah, He has conquered)\nMEN: Over death victorious,\n LADIES: (Hallelujah, victorious)\nMEN: Over sickness He has triumphed,\n LADIES: (Hallelujah, He has triumphed)\nALL: Jesus reigns over all!');
INSERT INTO page VALUES (12831,442,1,'All hail King Jesus,\nAll hail Emmanuel\nKing of Kings\nLord of Lords,\nbright morning star.\nAnd throughout eternity\nI\'ll sing your praises,\nand I\'ll reign with you\nthroughout eternity.');
INSERT INTO page VALUES (12832,443,1,'Jesus, we enthrone You\nWe proclaim You are King.\nStanding here in the midst of us\nWe raise You up with our praise\nAnd as we worship, build Your throne\nAnd as we worship, build Your throne, \nAnd as we worship, build Your throne.\nCome, Lord Jesus, and take Your place.');
INSERT INTO page VALUES (12833,443,2,'Jesus, we exalt You\nWe bow down to You Lord\nWith us now, in this holy time\nYou fill our hearts with Your love.\nAnd as we worship, touch our lives\nAnd as we worship, heal our souls\nAnd as we worship, lift our hearts\nOh, Lord Jesus, You are our God.');
INSERT INTO page VALUES (12834,444,1,'To keep Your lovely face\never before my eyes,\nthis is my prayer.\nmake it my strong desire;\nthat in my secret heart \nno other love competes,\nno rival throne survives,\nand I serve only You.');
INSERT INTO page VALUES (12864,448,1,'The King of love my shepherd is,\nWhose goodness faileth never,\nI nothing lack if I am His,\nAnd he is mine forever.');
INSERT INTO page VALUES (12835,445,1,'Blessed are the people\n who come in the name of the Lord,\n waving before them His banner high,\n raising a cross and a crown.\nBlessing and honour\n they bring to the nations they serve.\nBlessed are the people\n who live in the kingdom of God.');
INSERT INTO page VALUES (12836,445,3,'Blessed are the people\n who worship the name of the Lord,\n entering in at the gate of love,\n worship to give at the throne;\nPraising and thanksgiving to\n bring down the faith for the land.\nBlessed is the worship\n we share in the Kingdom of God.');
INSERT INTO page VALUES (12837,445,2,'Blessed are the people\n who walk in the ways of the Lord,\n sharing together a common ground,\n living in peace before man;\n Who walk not in the council\n of ungodly men of the world.\nBlessed are the people\n who walk in the kingdom of God.');
INSERT INTO page VALUES (12838,446,11,'BORN AGAIN');
INSERT INTO page VALUES (12839,446,7,'BORN AGA');
INSERT INTO page VALUES (12840,446,17,'BOR');
INSERT INTO page VALUES (12841,446,2,'BO');
INSERT INTO page VALUES (12842,446,1,'B');
INSERT INTO page VALUES (12843,446,18,'BO');
INSERT INTO page VALUES (12844,446,16,'BORN');
INSERT INTO page VALUES (12845,446,13,'BORN AGA');
INSERT INTO page VALUES (12846,446,6,'BORN AG');
INSERT INTO page VALUES (12847,446,3,'BOR');
INSERT INTO page VALUES (12848,446,9,'BORN AGAIN');
INSERT INTO page VALUES (12849,446,12,'BORN AGAI');
INSERT INTO page VALUES (12850,446,14,'BORN AG');
INSERT INTO page VALUES (12851,446,15,'BORN A');
INSERT INTO page VALUES (12852,446,8,'BORN AGAI');
INSERT INTO page VALUES (12853,446,4,'BORN');
INSERT INTO page VALUES (12854,446,10,'BORN AGAIN!');
INSERT INTO page VALUES (12855,446,5,'BORN A');
INSERT INTO page VALUES (12862,448,6,'And so through all the length of days,\nThy goodness faileth never, \nGood shepherd may I sing Thy praise,\nWithin Thy house forever.');
INSERT INTO page VALUES (12856,447,6,'Never give up, make it your aim\nPractice being Godly\nIf you\'ve been forgiven in Jesus\' name\nPractice being Godly\nHe paid the price for all our sin\nHis Holy Spirit dwells within\nSo centre all you do on him . . .\nPractice being Godly.');
INSERT INTO page VALUES (12857,447,4,'Never give up, make it your aim\nPractice being Godly\nIf you\'ve been forgiven in Jesus\' name\nPractice being Godly\nHe paid the price for all our sin\nHis Holy Spirit dwells within\nSo centre all you do on him . . .\nPractice being Godly.');
INSERT INTO page VALUES (12858,447,1,'Have you seen those fit and healthy guys\nAlways doin\' their exercise?\nWell it\'s better to work for a\nheavenly prize\nSo practice being Godly.');
INSERT INTO page VALUES (12859,447,3,'You can lift big weights, you can \nswim or run\nTrain everyday to be number one\nBut it\'s better to train for the life to come\nPractice being Godly.');
INSERT INTO page VALUES (12860,447,2,'Never give up, make it your aim\nPractice being Godly\nIf you\'ve been forgiven in Jesus\' name\nPractice being Godly\nHe paid the price for all our sin\nHis Holy Spirit dwells within\nSo centre all you do on him . . .\nPractice being Godly.');
INSERT INTO page VALUES (12861,447,5,'Well, walk with the Lord wherever you go\nWhatever you\'re doing, He will know\nSay, \'Yes! God\'\nTo sin say, \'No!\'\nPractice being Godly.');
INSERT INTO page VALUES (12867,448,5,'Thou spread\'st a table in my sight,\nThine junction grace bestoweth,\nAnd O what transport of delight,\nFrom Thy pure chalice floweth.');
INSERT INTO page VALUES (12927,453,9,'You give and take away,\nYou give and take away!\nMy heart will choose to say\nLord blessed be Your name.');
INSERT INTO page VALUES (12909,316,4,'La la,\nLa la, La la, la la la\nLa la, La la, la la la\nLa la, La la, la!\n');
INSERT INTO page VALUES (12868,449,1,'Praise God from whom\n all blessings flow,\nPraise Him all creatures\n here below,\nPraise Him above\n you heavenly host,\nPraise Father, \n Son and Holy Ghost.');
INSERT INTO page VALUES (12870,450,1,'There must be more than this\nO breath of God come breathe within\nThere must be more than this\nSpirit of God we wait for You\nFill us anew we pray\nFill us anew we pray');
INSERT INTO page VALUES (12871,450,3,'Come like a rushing wind\nClothe us with power\n from on high\nNow set the captives free\nLeave us abandoned\n to Your praise\nLord let Your glory fall,\nLord let Your glory fall.');
INSERT INTO page VALUES (12872,450,2,'Consuming fire, fan into flame\nA passion for Your name\nSpirit of God fall in this place.\nLord have Your way,\nLord have Your way with us.');
INSERT INTO page VALUES (12873,451,4,'My heart and flesh cry out\nFor You, the living God;\nYour Spirit\'s water for my soul.\nI\'ve tasted and I\'ve seen,\nCome once again to me;\nI Will draw near to You,\nI Will draw near to You.');
INSERT INTO page VALUES (12874,451,1,'How lovely is Your dwelling place,\nOh Lord Almighty\nMy soul it longs\nand even faints for you\nFor here my heart is satisfied,\nwithin Your presence\nI sing beneath the shadow\nof your wings');
INSERT INTO page VALUES (12875,451,3,'One thing that I ask\nAnd I would seek\nTo see Your beauty\nTo find You in the place\nwhere Your Glory dwells.\n');
INSERT INTO page VALUES (12876,451,2,'Better is one day in Your courts\nBetter is one day in Your house\nBetter is one day in Your courts\nThan thousands elsewhere');
INSERT INTO page VALUES (13527,613,4,'And He walks with me,\n And He talks with me,\n And He tells me I am His own;\nAnd the joy we share\n as we tarry there,\nNone other has ever known.');
INSERT INTO page VALUES (12878,452,4,'You opened my eyes\n  to Your wonders anew,\nYou captured my heart\n  with this love\n\'Cos nothing on earth is\n  as beautiful as You.');
INSERT INTO page VALUES (12879,452,1,'Wonderful, so wonderful\nIs Your unfailing love,\nYour cross has spoken mercy over me.\n\nNo eye has seen, no ear has heard,\nNo heart could fully know\nHow glorious, how beautiful You are.');
INSERT INTO page VALUES (12880,452,3,'Powerful, so powerful,\nYour glory fills the skies,\nYour mighty works\ndisplayed for all to see.\n\nThe beauty of your majesty\nAwakes my heart to sing:\nHow marvellous,\nhow wonderful You are.');
INSERT INTO page VALUES (12881,452,2,'Beautiful One I love You,\nBeautiful One I adore,\nBeautiful One my soul must sing.');
INSERT INTO page VALUES (12882,452,6,'My soul, my soul must sing.\nMy soul, my soul must sing.\nMy soul, my soul must sing.\nBeautiful One.');
INSERT INTO page VALUES (12883,453,6,'Blessed be Your name\n on the road marked with suffering\nThough there\'s pain in the offering,\nblessed be Your name.');
INSERT INTO page VALUES (12884,453,4,'Blessed be the name of the Lord,\nBlessed be Your name.\nBlessed be the name of the Lord,\nBlessed be Your glorious name.');
INSERT INTO page VALUES (12926,453,8,'Blessed be the name of the Lord,\nBlessed be Your name.\nBlessed be the name of the Lord,\nBlessed be Your glorious name.');
INSERT INTO page VALUES (12885,453,1,'Blessed be Your name\n in the land that is plentiful\nWhere Your streams of abundance flow\n blessed be Your name');
INSERT INTO page VALUES (12886,453,3,'Every blessing You pour\n out I\'ll turn back to praise.\nWhen the darkness closes\nin Lord still I will say...');
INSERT INTO page VALUES (12887,453,7,'Every blessing You pour\n out I\'ll turn back to praise.\nWhen the darkness closes\nin Lord still I will say...');
INSERT INTO page VALUES (12888,453,2,'Blessed be Your name\n when I\'m found in the desert place\nThough I walk through the wilderness,\nblessed be Your name');
INSERT INTO page VALUES (12889,453,5,'Blessed be Your name\n when the sun\'s shining down on me,\nWhen the world\'s \'all as it should be\',\nblessed be Your name.\n');
INSERT INTO page VALUES (12890,454,1,'Holy, Holy,\nHoly is the Lord God almighty.\n(repeat)\n\nWho was, and is,\n and is to come,\nWho was, and is,\n and is to come.');
INSERT INTO page VALUES (12891,454,2,'Lift up His name with\n the sound of singing,\nLift up His name in all the earth.\nLift up your voice and\n give Him glory,\nFor He is worthy to praised.');
INSERT INTO page VALUES (12920,463,4,'a. The movement from the Jews,\n      to the Samaritans to the Galileans\n\nb. Was Jesus rough with this man?\n\nc. The faith decision - to insist on \n     Jesus\' presence, or to trust His word.\n\nd. What are the areas of our lives\n      where we have this struggle?');
INSERT INTO page VALUES (12892,455,4,'Show Your power, O Lord our God.\nShow Your power, O Lord our God,\nOur God');
INSERT INTO page VALUES (12893,455,1,'He is the Lord, and He reigns on high:\nHe is the Lord.\nSpoke into the darkness, created the light.\nHe is the Lord.\nWho is like unto Him,\n  never ending in days?\nHe is the Lord\nAnd He comes in power\n  when we call on His name:\nHe is the Lord');
INSERT INTO page VALUES (12894,455,3,'Your gospel, O Lord,\n  is the hope for our nation\nYou are the Lord.\nIt\'s power of God for our salvation:\nYou are the Lord.\nWe ask not for riches, but look to the cross:\nYou are the Lord.\nAnd for our inheritance give us the lost:\nYou are the Lord.');
INSERT INTO page VALUES (12895,455,2,'Show Your power, O Lord our God.\nShow Your power, O Lord our God,\nOur God');
INSERT INTO page VALUES (12911,316,5,'Praise you,\nPraise you\nPraise you');
INSERT INTO page VALUES (12896,456,1,'Jesus, Jesus,\nHoly and\n anointed One,\nJesus.');
INSERT INTO page VALUES (12897,457,1,'');
INSERT INTO page VALUES (12898,458,4,'For it\'s the mystery of the universe,\nYou\'re the God of holiness,\nyet You welcome souls like me.\nAnd with the blessing of Your father\'s heart,\nYou discipline the ones You love,\nthere\'s kindness in Your majesty.\nJesus, those who recognise Your pow\'r,\nknow just how wonderful You are,\nthat you draw near.');
INSERT INTO page VALUES (12899,458,1,'O sacred King,\nO holy King,\nhow can I honour You rightly,\nhonour that\'s right for Your name?');
INSERT INTO page VALUES (12900,458,3,'O sacred Friend,\nO holy Friend,\nI don\'t take what You give lightly,\nfriendship instead of disgrace.');
INSERT INTO page VALUES (12901,458,2,'For it\'s the mystery of the universe,\nYou\'re the God of holiness,\nyet You welcome souls like me.\nAnd with the blessing of Your father\'s heart,\nYou discipline the ones You love,\nthere\'s kindness in Your majesty.\nJesus, those who recognise Your pow\'r,\nknow just how wonderful You are,\nthat you draw near.');
INSERT INTO page VALUES (12902,456,3,'Jesus, Jesus\nRisen and\n exalted One,\nJesus.');
INSERT INTO page VALUES (12903,456,2,'Your name is like\n honey on my lips\nYour Spirit like\n water to my soul\nYour word is a\n lamp unto my feet\nJesus I love You,\n I love You.');
INSERT INTO page VALUES (12904,459,4,'Astounded, Astounded\n that your gospel beckoned me\nSurrounded,  Surrounded\n but I\'ve never felt so free.');
INSERT INTO page VALUES (12905,459,1,'Befriended, Befriended by\nthe king above all kings\nSurrendered, Surrendered\nto the friend above all friends');
INSERT INTO page VALUES (12906,459,3,'This will be my story\nThis will be my song\nYou\'ll always be my Savior\nJesus, you will always\nhave my heart');
INSERT INTO page VALUES (12907,459,2,'Invited, Invited deep\ninto this mystery\nDelighted, Delighted\nby the wonders I have seen');
INSERT INTO page VALUES (12908,459,5,'Determined, Determined now\n  to live this life for You.\nYou\'re so worthy,\n  my greatest gift would be\n  the least you\'re due');
INSERT INTO page VALUES (12912,461,4,'Love flies higher, walks through fire\nDoesn\'t change from day to day\nIf it\'s really love it just won\'t give up\nLove will never pass away');
INSERT INTO page VALUES (12913,461,1,'He can make a way where there isn\'t a way,\nThat\'s what the love of God can do.\nEverything can start new every day,\nThat\'s what the love of God can do.');
INSERT INTO page VALUES (12914,461,3,'The whole world changed\n  when love stepped in,\nThat\'s what the love of God can do.\nHearts to save and a world to win,\nThat\'s what the love of God can do');
INSERT INTO page VALUES (12915,461,2,'Love flies higher, walks through fire\nDoesn\'t change from day to day\nIf it\'s really love it just won\'t give up\nLove will never pass away');
INSERT INTO page VALUES (12916,461,5,'Love is patient, love is kind\nIf someone else wins, love doesn\'t mind\nLove believes, love forgives\nAnd God is the start of all of this.');
INSERT INTO page VALUES (12917,462,1,'You bless my life \n and heal me inside,\nOver and over again.\n\nYou touched my heart\n and brought peace of mind,\nOver and over again.');
INSERT INTO page VALUES (12918,462,3,'You\'ve been so kind\n and patient with me,\nOver and over again.\n\nAnd when I have strayed\n you showed me the way,\nOver and over again.');
INSERT INTO page VALUES (12919,462,2,'And all I can say is I love you,\nAnd all I can say is I need you,\nAnd all I can say is I thank you, Lord,\nFor all that you\'ve done in my life.');
INSERT INTO page VALUES (12931,464,3,'How can hearts not love Your name\nHow can souls not sing Your praise\nJesus You\'ve put music in my soul');
INSERT INTO page VALUES (12921,463,1,'a. The movement from the Jews,\n      to the Samaritans to the Galileans\n\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12922,463,3,'a. The movement from the Jews,\n      to the Samaritans to the Galileans\n\nb. Was Jesus rough with this man?\n\nc. The faith decision - to insist on \n     Jesus\' presence, or to trust His word.\n\n\n');
INSERT INTO page VALUES (12923,463,2,'a. The movement from the Jews,\n      to the Samaritans to the Galileans\n\nb. Was Jesus rough with this man?\n\n\n\n\n\n');
INSERT INTO page VALUES (12932,464,2,'I\'m making melody in my heart to You\nI\'m making melody in my heart to You\nYours will always be\nThe song I love to sing');
INSERT INTO page VALUES (12938,466,1,'To God be the glory\nTo God be the glory\nTo God be the glory\nFor the things He has done\nWith His blood He has saved me\nWith His power He has raised me\nTo God be the glory\nFor the things He has done');
INSERT INTO page VALUES (12953,469,4,'Set our feet on lofty places;\nGird our lives that they may be\nArmored with all Christ like graces\nIn the fight to set men free.\nGrant us wisdom, Grant us courage,\nThat we fail not man nor Thee!');
INSERT INTO page VALUES (12939,467,4,'Jesus O Jesus\nHoly is the Lamb of God\nJesus O Jesus\nWorthy is the Lamb of God\n');
INSERT INTO page VALUES (12940,467,1,'Hold my hand and walk with me\nYou\'re the Light that makes me see\nOn this path my soul You lead\nOh my Shepherd walk with me');
INSERT INTO page VALUES (12941,467,3,'My Saviour, glorious One\nMy Redeemer, living in my heart\nNow and forever, Your Kingdom come\nJesus Son of God\nJesus Son of God');
INSERT INTO page VALUES (12942,467,2,'I need You more than breath\nYou\'re my hope, in You I live\nAngels worship at Your throne\nPower and glory to You alone');
INSERT INTO page VALUES (12943,468,1,'I am the bread of life\nHe who comes to me\n  shall not hunger\nHe who believes in me\n  shall not thirst\nNo one can come to me\nUnless the Father draw him');
INSERT INTO page VALUES (12944,468,3,'The bread that I give\nIs my flesh for the\n  life of the world\nAnd he who eats\n  of this bread\nHe shall live forever,\nhe shall live forever.');
INSERT INTO page VALUES (12945,468,2,'And I will raise Him up\nAnd I will raise Him up\nAnd I will raise Him up\n  on the last day');
INSERT INTO page VALUES (12958,470,1,'Rejoice in the Lord always\nAnd again I say rejoice!\nRejoice in the Lord always\nAnd again I say rejoice!\nRejoice, rejoice\nAnd again I say rejoice!\nRejoice, rejoice\nAnd again I say rejoice!');
INSERT INTO page VALUES (12981,474,1,'I used to think maybe you loved me\nNow I know for sure\nI used to think I didn\'t need thee\nThen you opened the door\nSo I give my heart give my soul\nGive you all that I am\n\'cause I just can\'t wait to get back\nto the promised land');
INSERT INTO page VALUES (12952,391,5,'Oh my soul bless the Lord');
INSERT INTO page VALUES (12968,473,1,'* Jesus gives comfort and\nre-assurance to His disciples.\n\n\n\n\n\n\n');
INSERT INTO page VALUES (12954,469,1,'God of grace and God of glory,\nOn Thy people pour Thy power\nCrown Thine ancient church\'s story;\nBring her bud to glorious flower.\nGrant us wisdom, Grant us courage,\nFor the facing of this hour');
INSERT INTO page VALUES (12955,469,3,'Cure Thy children\'s waring madness,\nBend our pride to Thy control;\nShame our wanton, selfish gladness,\nRich in things and pour in soul.\nGant us wisdom, Grant us courage,\nLest we miss Thy kingdoms goal.');
INSERT INTO page VALUES (12956,469,2,'Lo! the hosts of e-vil round us,\nScorn Thy Christ, assail His ways!\nFrom the fears that long have bound us\nFree our hearts to faith and praise:\nGrant us wisdom, Grant us courage,\nFor the living of these days');
INSERT INTO page VALUES (12957,469,5,'Save us from weak resignation\nTo the e-vils we deplore;\nLet the search for Thy salvation\nBe our glory ever more.\nGrant us wisdom, Grant us courage,\nServing The whom we adore.');
INSERT INTO page VALUES (12959,471,1,'It\'s no longer I that liveth\nBut Christ that liveth in me\nIt\'s no longer I that liveth\nBut Christ that liveth in me\nHe lives! He lives!\nJesus is alive in me\nIt\'s no longer I that liveth\nBut Christ that liveth in me');
INSERT INTO page VALUES (12961,351,4,'I am not afraid\n (no I\'m not afraid)\nI am not dismayed\n (no I\'m not dismayed)\n\n\'Cause I\'m walkin\' in faith and victory\nCome on and walk in faith and victory\nFor the Lord your God is with you\n\nBE BOLD!');
INSERT INTO page VALUES (12967,472,5,'I believe in the one called Saviour\nI believe He\'s the risen One \nI believe that I\'ll live forever\nI believe that the king will come');
INSERT INTO page VALUES (12963,472,1,'Have you heard of the one called Saviour?\nHave you heard of his perfect love?\nHave you heard of the one in heaven?\nHave you heard how he gave his Son?');
INSERT INTO page VALUES (12964,472,3,'     Jesus, You are my best friend\n         And you will always be\nAnd nothing could ever change that!');
INSERT INTO page VALUES (12966,472,4,'And Nothing will ever change that!');
INSERT INTO page VALUES (12965,472,2,'\'Cause I have found this love\n  And I believe in the son\n    Show me your way!');
INSERT INTO page VALUES (12969,89,2,'Glory, Jesus, glory,\nYou do the fighting for me.\nPraise you Jesus, praise you,\nWith you there\'s always victory.');
INSERT INTO page VALUES (12970,473,4,'* Jesus gives comfort and\nre-assurance to His disciples.\n\n* The Holy Spirit wil be given\nas Companion, Strengthener.\n\n* 5 Sayings of the Spirit.\n\n* Jesus will return himself.');
INSERT INTO page VALUES (12971,473,3,'* Jesus gives comfort and\nre-assurance to His disciples.\n\n* The Holy Spirit wil be given\nas Companion, Strengthener.\n\n* 5 Sayings of the Spirit.\n\n');
INSERT INTO page VALUES (12972,473,2,'* Jesus gives comfort and\nre-assurance to His disciples.\n\n* The Holy Spirit wil be given\nas Companion, Strengthener.\n\n\n\n');
INSERT INTO page VALUES (12973,473,6,'Mark 13 gives us 4 strands\nof future prophecies:\n* The destruction of Jerusalem\n\n\n');
INSERT INTO page VALUES (12974,473,7,'Mark 13 gives us 4 strands\nof future prophecies:\n* The destruction of Jerusalem\n* Persecution\n\n');
INSERT INTO page VALUES (12975,473,9,'Mark 13 gives us 4 strands\nof future prophecies:\n* The destruction of Jerusalem\n* Persecution\n* The last day\n* His own return');
INSERT INTO page VALUES (12976,473,8,'Mark 13 gives us 4 strands\nof future prophecies:\n* The destruction of Jerusalem\n* Persecution\n* The last day\n');
INSERT INTO page VALUES (12977,473,5,'Mark 13 gives us 4 strands\nof future prophecies:\n\n\n\n');
INSERT INTO page VALUES (12978,473,11,'* Time. History is moving towards\na climax under God\'s control.\n\n* A challenge to the way we live.\n\n');
INSERT INTO page VALUES (12979,473,12,'* Time. History is moving towards\na climax under God\'s control.\n\n* A challenge to the way we live.\n\n* An incentive to share the Good News.');
INSERT INTO page VALUES (12980,473,10,'* Time. History is moving towards\na climax under God\'s control.\n\n\n\n');
INSERT INTO page VALUES (12982,474,3,'I feel alive');
INSERT INTO page VALUES (12983,474,2,'I\'m walkin on sunshine\nwoawueyroooohh (x3)\n\nAnd it\'s startin to feel good\n\n');
INSERT INTO page VALUES (13752,672,3,'These though we bring them\n in trembling and fearfulness\nHe will accept for\n the name that is dear,\nMornings of joy give\n for evenings of tearfulness,\nTrust for our trembling\n and hope for our fear.');
INSERT INTO page VALUES (13753,672,4,'O worship the Lord\n in the beauty of holiness,\nBow down before Him\n His glory proclaim,\nWith gold of obedience\n and incense of lowliness,\nKneel and adore Him\n the Lord is His name.');
INSERT INTO page VALUES (13754,673,1,'For God so loved the world.\nHe gave His only Son.\nTo die on Calv\'ry\'s tree.\nFrom sin to set me free;\nSome day He\'s coming back.\nWhat glory that will be\n Wonderful His love to me.');
INSERT INTO page VALUES (13751,672,1,'O worship the Lord\n in the beauty of holiness,\nBow down before him\n His glory proclaim,\nWith gold of obedience,\n and incense of lowliness,\nKneel and adore Him,\n the Lord is his name.');
INSERT INTO page VALUES (13750,672,2,'Low at His feet lay\n thy burden of carelessness,\nHigh on His heart\n he will bear it for thee,\nComfort thy sorrows\n and answer thy prayerfulness,\nGuiding thy steps\n as may best for thee be.');
INSERT INTO page VALUES (13686,656,1,'You chose the cross with every breath\nthe perfect life, the perfect death\nYou chose the cross\nA crown of thorns You wore for us\nAnd crowned us with eternal life\nYou chose the cross\nAnd though Your soul was\n overwhelmed with pain\nObedient to death You overcame');
INSERT INTO page VALUES (13687,656,3,'You loosed the chords of sinfulness\nAnd broke the chains of my disgrace\nYou chose the cross\nUp from the grave victorious\nYou rose again so glorious\nYou chose the cross\nThe sorrow that surrounded\n You was mine\n\"Yet not my will but Yours be done\"\n You cried');
INSERT INTO page VALUES (13688,656,2,'I\'m lost in wonder\nI\'m lost in love\nI\'m lost in praise for evermore\nBecause of Jesus\'\n unfailing love\nI am forgiven\nI am restored');
INSERT INTO page VALUES (13689,657,3,'Lo! Jesus meets us, \nrisen from the tomb;\nLovingly He greets us, \nscatters fear and gloom;\nLet His church with gladness, \nhymns of triumph sing,\nFor her Lord now liveth; \nDeath has lost its sting.\n');
INSERT INTO page VALUES (13690,657,5,'No more we doubt thee,\nGlorious Prince of life!\nLife is naught without thee;\nAid us in our strife;\nMake us more than conquerors, \nthrough Thy deathless love;\nBring us safe through Jordan,\nTo thy home above.\n');
INSERT INTO page VALUES (13691,657,1,'Thine be the glory, \nRisen conquering Son;\nEndless is the victory\nThou o\'er death hast won.\nAngels in bright raiment\nrolled the stone away,\nKept the folded grave \nclothes where Thy body lay.\n');
INSERT INTO page VALUES (13692,657,6,'Thine be the glory,\nRisen conquering Son;\nEndless is the victory\nThou o\'er death hast won.\n');
INSERT INTO page VALUES (13693,657,2,'Thine be the glory, \nRisen conquering Son;\nEndless is the victory\nThou o\'er death hast won.\n');
INSERT INTO page VALUES (13694,657,4,'Thine be the glory, \nRisen conquering Son;\nEndless is the victory \nThou o\'er death hast won.\n');
INSERT INTO page VALUES (13695,658,7,'Tho\' sometimes He\n leads thro\' waters deep,\nTrials fall across the way,\nTho\' sometimes the path\n seems rough and steep,\nSee His footprints all the way.');
INSERT INTO page VALUES (13696,658,10,'Jesus, Jesus, Jesus,\n Sweetest name I know.\nFills my ev\'ry longing,\n Keeps me singing as I go.');
INSERT INTO page VALUES (13697,658,8,'Jesus, Jesus, Jesus,\n Sweetest name I know.\nFills my ev\'ry longing,\n Keeps me singing as I go.');
INSERT INTO page VALUES (13698,658,3,'All my life was wrecked\n by sin and strife,\nDiscord filled my heart with pain,\nJesus swept across\n the broken strings,\nStirred the slumb\'ring chords again.');
INSERT INTO page VALUES (13699,658,1,'There\'s within my heart a melody\nJesus whispers sweet and low,\nfear not, I am with you,\n peace, be still,\nIn all life\'s ebb and flow.');
INSERT INTO page VALUES (13700,658,5,'Feasting on the riches of His grace,\nResting \'neath His shelt\'ring wing,\nAlways looking on His smiling face,\nThat is why I shout and sing.');
INSERT INTO page VALUES (13701,658,2,'Jesus, Jesus, Jesus,\n Sweetest name I know.\nFills my ev\'ry longing,\n Keeps me singing as I go.');
INSERT INTO page VALUES (13702,658,6,'Jesus, Jesus, Jesus,\n Sweetest name I know.\nFills my ev\'ry longing,\n Keeps me singing as I go.');
INSERT INTO page VALUES (13703,658,4,'Jesus, Jesus, Jesus,\n Sweetest name I know.\nFills my ev\'ry longing,\n Keeps me singing as I go.');
INSERT INTO page VALUES (13704,658,9,'Soon He\'s coming back\n to welcome me\nFar beyond the starry sky;\nI shall wing my flight\n to worlds unknown,\nI shall reign with Him on high.');
INSERT INTO page VALUES (13705,659,1,'Let the Lord have His way\nIn your life everyday\nThere\'s no rest, there\'s no peace\nuntil the Lord has His way\nPlace your life in His hands\nRest secure in His plans\nLet the Lord, let the Lord\n have His way');
INSERT INTO page VALUES (13706,660,1,'I\'ve got a wonderful saviour\nI\'ve got a wonderful saviour\nI\'ve got a wonderful saviour\nJesus my Lord\nHe walks with me & talks with me\nTells me that He loves me &\n and will always with me be\nI\'ve got a wonderful saviour\n Is He yours?');
INSERT INTO page VALUES (13707,661,2,'Go & tell me the story of the\n Christ on Calvary\nGo & tell me the story of the\n Christ on Calvary\nHe\'ll forgive their sin,\n He will save their souls\nHe\'ll cleanse their hearts,\n He will make them whole\nGo & tell me the story of the\n Christ on Calvary');
INSERT INTO page VALUES (13708,661,1,'Stop & let me tell you\nWhat the Lord has done for me\nStop & let me tell you\nWhat the Lord has done for me\nHe forgave my sin &\n He save my soul\nHe cleansed my heart &\n He made me whole\nStop & let me tell you\nWhat the Lord has done for me');
INSERT INTO page VALUES (13709,662,6,'Take me Lord\nI am Your child\nSend me Lord\nSet my heart on fire.\n(repeat)');
INSERT INTO page VALUES (13710,662,4,'I\'m Your child\nMy life is Yours to use\nContrite before You\nYour will I choose');
INSERT INTO page VALUES (13711,662,3,'Take me Lord\nI am Your child\nSend me Lord\nSet my heart on fire.\n(repeat)');
INSERT INTO page VALUES (13712,662,2,'And in my life\nLet Your life be seen\nSo that the world may know\nI am Your child.');
INSERT INTO page VALUES (13713,662,1,'I\'m Your child\nI give my life to you\nWholly available\nFaithful and true.');
INSERT INTO page VALUES (13714,662,5,'That through my life\nJesus Christ will shine\nOthers may seek to find\nAnd be Your child.');
INSERT INTO page VALUES (13715,663,2,' ');
INSERT INTO page VALUES (13716,663,1,'Working bee\nNext Saturday\n* 8:30 AM *');
INSERT INTO page VALUES (13718,114,2,'He\'s the Lily of the Valley\nHe\'s the Bright and Morning Star\nHe\'s the fairest of Ten Thousand\nEverybody ought to know');
INSERT INTO page VALUES (13719,114,3,'Everybody ought to know\nEverybody ought to know\nEverybody ought to know\nwho Jesus is. (repeat)');
INSERT INTO page VALUES (13720,664,2,'Come Holy Spirit, dark is the hour,\nWe need Your filling,\n Your love and Your mighty power\nMove now among us, stir us we pray,\nCome Holy Spirit,\n revive your Church today.');
INSERT INTO page VALUES (13725,664,4,'Come Holy Spirit, dark is the hour,\nWe need Your filling,\n Your love and Your mighty power\nMove now among us, stir us we pray,\nCome Holy Spirit,\n revive your Church today.\nRevive the Church today.\nRevive the Church today.');
INSERT INTO page VALUES (13721,664,1,'The Holy Spirit came at Pentecost,\nHe came in mighty fullness then;\nHis witness through\n believers won and lost,\nAnd multitudes were born again.\nThe early Christians scattered\n o\'er the world,\nThey preached the gospel fearlessly;\nTho\' some were martyred\n and to lions hurled,\nThey marched along in victory');
INSERT INTO page VALUES (13726,664,3,'Then in an age when\n darkness gripped the earth,\nThe just shall live by faith was learned,\nThe Holy Spirit gave the church new birth,\nin later years the great revivals came\nWhen saints would\n seek the Lord and pray,\nO once again we need that Holy flame.');
INSERT INTO page VALUES (13727,666,3,'Stand up, stand up for Jesus \nThe strife will not be long,\nThis day the noise of battle,\nThe next the victor\'s song,\nTo him that overcometh,\nA crown of life shall be,\nHe, with the King of glory,\nShall reign eternally.');
INSERT INTO page VALUES (13728,666,1,'Stand up, stand up for Jesus \nYe soldiers of the cross,\nLift high His royal banner \nIt must not suffer loss\nFrom vict\'ry unto vict\'ry,\nHis army shall He lead,\nTill every foe is vanquished\nAnd Christ is Lord indeed.');
INSERT INTO page VALUES (13729,666,2,'Stand up, stand up for Jesus \nStand in His strength alone,\nThe arm of flesh will fail you,\nYe dare not trust your own;\nPut on the gospel armour,\nEach piece put on with prayer,\nWhere duty calls or danger,\nBe never wanting there.');
INSERT INTO page VALUES (13749,671,1,'Consider Christ\nthe source of our salvation.\nThat He should take\nthe penalty for me.\nThough he was pure,\na lamb without a blemish;\nHe took my sins\nand nailed them to the tree.');
INSERT INTO page VALUES (13748,671,3,'Consider Christ\nthat He could trust His Father\nin the garden of Gethsemane.\nThough full of dread\n and fearful of the anguish;\nHe drank the cup\n that was reserved for me.');
INSERT INTO page VALUES (13747,671,4,'Consider Christ\nfor death He has defeated.\nAnd He arose,\nappeared for all to see.\nAnd now He sits\nat God\'s right hand in heaven;\nwhere He prepares\na resting place for me.');
INSERT INTO page VALUES (13746,671,2,'My Lord and God\nYou are so rich in mercy\nMere words alone\n are not sufficient thanks.\nSo take my life,\n transform, renew and change me\nThat I might be a living sacrifice');
INSERT INTO page VALUES (13738,667,1,'I need direction\nWhere will I go\nI need the truth\nHow will I know\nI need a new life\nTired of living this way\nI heard that Jesus came to\nmake a way');
INSERT INTO page VALUES (13739,667,2,'He said\nI am the Way\nI am the Truth and Life\nThere\'s One way to God\nOne way through Jesus Christ\n \nI want You Jesus\nHey! Hey! Hey! Hey!');
INSERT INTO page VALUES (13740,668,1,'Holy  -  Faithful\nPerson  -  Powerful\nForgiving - Sovereign\nGracious - Merciful\nLove  - Omnipotent\nOmnipresent - Omniscient');
INSERT INTO page VALUES (13741,669,2,'How great is your love,\nit reaches to the heavens,\nhow great is the heart\nthat sought and rescued me.');
INSERT INTO page VALUES (13742,669,3,'How great are you, Lord,\nhow great is your mercy\nHow great are the things\nThat you have done for me\nHow great are you, Lord,\nyour loving kindness\n\nis filling my heart as I sing,\nHow great are you, Lord..\n(repeat)');
INSERT INTO page VALUES (13743,669,1,'How great are you, Lord,\nhow great is your mercy\nHow great are the things\nThat you have done for me\nHow great are you, Lord,\nyour loving kindness\nis filling my heart as I sing,\nHow great are you, Lord..');
INSERT INTO page VALUES (13744,670,2,'\"Blessing and honour, glory and power,\n Be unto Him who sitteth upon the throne,\n And unto the Lamb, for ever and ever,\n Worthy is the Lamb that was slain.\"');
INSERT INTO page VALUES (13745,670,1,'And I beheld and I heard the voice\n of many angels, round the throne,\n and the beasts and the elders,\nAnd the number of them was ten\n thousand times ten thousand,\n and thousands and thousands,\n saying with a loud voice;');
INSERT INTO page VALUES (13685,655,2,'Surrounded by Your glory,\n what will my heart feel?\nWill I dance for You Jesus,\n or in awe of You be still?\nWill I stand in Your presence,\n to my knees will I fall?\nWill I sing \'hallelujah\' -\n will I be able to speak at all?\nI can only imagine, I can only imagine.');
INSERT INTO page VALUES (13684,655,3,'I can only imagine what that day comes\nAnd I find myself standing in the Son\nI can only imagine, when all I will do,\nIs forever, forever worship You\nI can only imagine');
INSERT INTO page VALUES (13683,655,1,'I can only imagine what it will be like\nWhen I walk by your side\nI can only imagine what my eyes will see\nWhen your face is before me\nI can only imagine');
INSERT INTO page VALUES (13682,654,4,'Christ for the Yao we sing\nThe Yao to Christ we bring\nWith joyful song\nThe new born souls whose days,\nReclaimed from errors ways\nInspired with hope and praise\nTo Christ belong.\n');
INSERT INTO page VALUES (13681,654,2,'Christ for the Yao we sing\nThe Yao to Christ we bring\nWith fervent prayer\nThe wayward and the lost\nBy restless passions tossed\nRedeemed at countless cost \nFrom dark despair.\n');
INSERT INTO page VALUES (13679,654,1,'Christ for the Yao we sing\nThe Yao to Christ we bring\nWith loving zeal\nThe poor and them that mourn\nThe faint and overborne\nSin-sick and sorrow worn\nWhom Christ doth heal\n');
INSERT INTO page VALUES (13680,654,3,'Christ for the Yao we sing\nThe Yao to Christ we bring\nWith one accord.\nWith us the work to share\nWith us reproach to dare\nWith us the cross to bear\nFor Christ our Lord.\n');
INSERT INTO page VALUES (13678,653,4,'Christ for the world we sing\nThe world to Christ we bring\nWith joyful song\nThe new born souls whose days,\nReclaimed from errors ways\nInspired with hope and praise\nTo Christ belong.');
INSERT INTO page VALUES (13677,653,2,'Christ for the world we sing\nThe world to Christ we bring\nWith fervent prayer\nThe wayward and the lost\nBy restless passions tossed\nRedeemed at countless cost \nFrom dark despair.');
INSERT INTO page VALUES (13676,653,3,'Christ for the world we sing\nThe world to Christ we bring\nWith one accord.\nWith us the work to share\nWith us reproach to dare\nWith us the cross to bear\nFor Christ our Lord.');
INSERT INTO page VALUES (13629,142,7,'God is great and his praise\nfills the earth, Fills the Heavens\nAnd Your name will be praised\nthrough all the Earth\nGod is great sing his praise\nAll the Earth, All the Heavens\n\n\'Cause we\'re living for \nthe glory of your name\n(repeat)\n\nthe glory of your name');
INSERT INTO page VALUES (13630,142,6,'Holy is the Lord\nThe whole Earth sings\nThe whole Earth sings\n(repeat)');
INSERT INTO page VALUES (13632,274,4,'Singing Amen\n   Glory to the Risen Lord\nSinging Amen\n   You made me dance and sing\n   You\'re everything\n(repeat)\n\nYou are my Rock!');
INSERT INTO page VALUES (13633,644,4,'When ends life\'s transient dream, \nWhen death\'s cold sullen stream\n Shall o\'er me roll,\nBlest Saviour, then, in love,\n Fear and distrust remove;\nO bear me safe above,\n A ransomed soul!');
INSERT INTO page VALUES (13634,644,1,'My faith looks up to Thee,\nThou Lamb of calvary,\nSaviour divine!\nNow hear me while I pray,\n Take all my guilt away,\nO let me from this day\n Be wholly Thine!');
INSERT INTO page VALUES (13635,644,2,'May Thy rich grace impart\n Strength to my fainting heart,\nMy zeal inspire\n As Thou hast died for me,\nO may my love to Thee\nPure, warm, and changeless be\n A living fire!');
INSERT INTO page VALUES (13636,644,3,'While life\'s dark maze I tread,\nAnd griefs around me spread\nBe Thou my guide;\nBid darkness turn to day,\nWipe sorrow\'s tears away,\nNor let me ever stray\nFrom Thee aside.');
INSERT INTO page VALUES (13637,645,4,'1. The providence of a caring Father (4-11)\n2. Remember the weaker ones (12-17)\n3. The benefits of grace (18-24)\n4. A warning to the wise (25-29)\n\n');
INSERT INTO page VALUES (13638,645,1,'1. The providence of a caring Father (4-11)\n\n\n\n\n\n');
INSERT INTO page VALUES (13639,645,5,'1. The providence of a caring Father (4-11)\n2. Remember the weaker ones (12-17)\n3. The benefits of grace (18-24)\n4. A warning to the wise (25-29)\n5. Examples of the faithful\nand Jesus himself (1-3)');
INSERT INTO page VALUES (13640,645,2,'1. The providence of a caring Father (4-11)\n2. Remember the weaker ones (12-17)\n\n\n\n\n\n');
INSERT INTO page VALUES (13641,645,3,'1. The providence of a caring Father (4-11)\n2. Remember the weaker ones (12-17)\n3. The benefits of grace (18-24)\n\n\n\n');
INSERT INTO page VALUES (13642,646,1,'Bind us together Lord,\nBind us together with\nCords that cannot be broken,\nBind us together Lord,\nBind us together with  \nBind us together with Love.');
INSERT INTO page VALUES (13643,646,7,'Bind us together Lord,\nBind us together with\nCords that cannot be broken,\nBind us together Lord,\nBind us together with\nBind us together with Love.');
INSERT INTO page VALUES (13644,646,5,'Bind us together Lord,\nBind us together with\nCords that cannot be broken,\nBind us together Lord,\nBind us together with\nBind us together with Love');
INSERT INTO page VALUES (13645,646,4,'Made for the Glory of God,\nPurchased by His precious Son,\nBorn with the right to be clean,\nFor Jesus the vict\'ry has won.');
INSERT INTO page VALUES (13646,646,3,'Bind us together Lord,\nBind us together with\nCords that cannot be broken,\nBind us together Lord,\nBind us together with\nBind us together with Love');
INSERT INTO page VALUES (13647,646,2,'There is only one God,\nThere is only one King,\nThere is only one body,\nThat is why we sing.');
INSERT INTO page VALUES (13648,646,6,'You are the family of God,\nYou are the promise divine,\nYou are God\'s chosen desire,\nYou are the glorious new wine');
INSERT INTO page VALUES (13656,649,4,'Be near me, Lord, when dying;\nO show thyself to me;\nand for my succour flying,\ncome, Lord, to set me free:\nthese eyes, new faith receiving,\nfrom Jesus shall not move;\nfor he who dies believing,\ndies safely through thy love.');
INSERT INTO page VALUES (13657,649,2,'O Lord of life and glory,\nwhat bliss till now was thine!\nI read the wondrous story,\nI joy to call thee mine.\nThy grief and thy compassion\nwere all for sinners\' gain;\nmine, mine was the transgression,\nbut thine the deadly pain.');
INSERT INTO page VALUES (13658,650,3,'When Heavens hills at last I roam\nForever settled in my home\nI\'ll join the saints round your throne\nYour kingdom Lord, rolls ever on\n\nLa La La La etc.');
INSERT INTO page VALUES (13659,650,1,'These thousand hills roll ever on\nFootprints of a mighty God\nThey bring me to my knees in praise\nAmazing Love, Amazing Grace');
INSERT INTO page VALUES (13660,650,5,'These thousand hills roll ever on\nRipples of a coming storm\nThe morning star precedes the dawn\nThese thousand hills roll ever on');
INSERT INTO page VALUES (13661,650,2,'Was on a hill my Saviour died\nA broke heart and bleeding side\nHill of the Skull, Mount Calvary\nThe Blood He shed,\n He shed for me');
INSERT INTO page VALUES (13662,650,4,'These thousand hills roll ever on\nFootprints of a mighty God\nThey bring me to my knees in praise\nAmazing Love, Amazing Grace');
INSERT INTO page VALUES (13664,651,4,'They shall not grow old,\n as we that are left grow old;\nAge shall not weary them,\n nor the years condemn.\nAt the going down of the\n sun and in the morning\n\nWe will remember them.');
INSERT INTO page VALUES (13665,651,2,'They went with songs to the battle,\n they were young,\nStraight of limb, true of eye,\n steady and aglow.\nThey were staunch to the\n end against odds uncounted,\nThey fell with their faces to the foe.');
INSERT INTO page VALUES (13666,651,3,'But where our desires are\n and our hopes profound,\nfelt as a wellspring that\n is hidden from sight,\nTo the innermost heart of their\n own land they are known\nAs the stars that are\n known to the Night.');
INSERT INTO page VALUES (13668,652,4,'Lord without You\n I was so lost\nBut in You I am found\nYou have drawn me\nTo Calvary\'s Cross\nChains of sin You unbound');
INSERT INTO page VALUES (13667,414,6,'May His beauty rest upon me,\nAs I seek the lost to win,\nAnd may they forget the channel,\nSeeing only Him.\n');
INSERT INTO page VALUES (13669,652,3,'Thank you Jesus for all You have done\nThank you Father for sending your Son\nNow your Spirit has filled\n My heart with praise\nIncomparable are the\n depths of Your Love\nAnd Your Wondrous Grace\n Is more than enough\nI will tell of the Splendour\n and Glory of Your Name');
INSERT INTO page VALUES (13670,652,2,'I will not be silent\nBut lift up my voice\nGive thanks for Your Mercy\nIn You I\'ll rejoice');
INSERT INTO page VALUES (13671,652,6,'Thank you Jesus for all You have done\nThank you Father for sending your Son\nNow your Spirit has filled\n My heart with praise\nIncomparable are the\n depths of Your Love\nAnd Your Wondrous Grace\n Is more than enough\nI will tell of the Splendour\n and Glory of Your Name');
INSERT INTO page VALUES (13672,652,1,'No greater Love\nHas ever been shown\nThan You laid Your life down\nNo greater triumph\nHas ever been known\nYour death cry was victory\'s sound!');
INSERT INTO page VALUES (13673,652,7,'The Glory of Your Name\nThe Glory of Your Name\nThe Glory of Your Name');
INSERT INTO page VALUES (13674,652,5,'I will not be silent\nBut lift up my voice\nGive thanks for Your Mercy\nIn You I\'ll rejoice');
INSERT INTO page VALUES (13144,499,1,'He\'s all I need, He\'s all I need\nJesus is all I need\n(repeat)\nI take him now, I take him now\nFor all that I need\n(repeat)\nWe worship thee,\nWe worship thee,\nIn spirit and truth\n(repeat)');
INSERT INTO page VALUES (13143,498,1,'This is my rest forever\nHere will I dwell\nFor the Lord has chosen Zion\nHe has desired it for his habitation\nI will abundantly bless her provision\nAnd satisfy her poor with bread\nI will clothe her priest with salvation\nAnd her saints shall\n shout aloud for joy');
INSERT INTO page VALUES (13138,497,4,'Lifted up was He to die.\n\'It is finished!\' was His cry;\nNow in heaven exalted high;\nHallelujah! what a Saviour!');
INSERT INTO page VALUES (13139,497,1,'Man of Sorrows! What a name\nFor the Son of God, who came\nRuined sinners to reclaim!\nHallelujah! what a Saviour!');
INSERT INTO page VALUES (13140,497,3,'Guilty, vile, and helpless we;\nSpotless Lamb of God was He:\nFull atonement -- can it be?\nHallelujah! what a Saviour!');
INSERT INTO page VALUES (13141,497,2,'Bearing shame and scoffing rude,\nin my place condemned He stood;\nSealed my pardon with His blood:\nHallelujah! what a Saviour!');
INSERT INTO page VALUES (13142,497,5,'When He comes, our glorious King,\nAll His ransomed home to bring,\nThen anew this song we\'ll sing:\nHallelujah! what a Saviour!');
INSERT INTO page VALUES (13202,534,1,'Alleluia (x8)\n\nLord we love you...\nHe\'s our bridegroom...\nBlessed Jesus...\nMy Redeemer...\nJesus is Lord...\nHe is coming...\nAlleluia...');
INSERT INTO page VALUES (13146,501,1,'To get a touch from\n the Lord is so real\nTo get a touch from\n the Lord is so real\nIf you draw night to him,\nHe will draw night to you\nTo get a touch from\n the Lord is so real');
INSERT INTO page VALUES (13145,500,1,'Sweep over my soul,\nsweep over my soul;\nSweet Spirit\n sweep over my soul\nMy rest is complete as\n I sit at his feet\nSweet Spirit\n sweep over my soul');
INSERT INTO page VALUES (13147,501,2,'Hallelujah, hallelujah\nJesus is coming,\n is coming again\nHallelujah, hallelujah\nJesus is coming again..');
INSERT INTO page VALUES (13148,502,1,'He brought my soul out of prison\nThat I might praise his name\nThe righteous shall\n compass me about\nFor he has dealt bountifully\nWith me, with me,\nwith me, with me.');
INSERT INTO page VALUES (13152,506,1,'God is moving by his Spirit\nMoving through all the earth\nSigns and wonder\n when God moveth\nMove O Lord in me');
INSERT INTO page VALUES (13150,504,1,'Anointed, anointed of the Father\nRose of Sharon fair\nBright and morning star\nLovely, he\'s altogether lovely\nAnointed, anointed of the Lord');
INSERT INTO page VALUES (13149,503,1,'For thou art great\nAnd doeth wondrous things\nThou art God alone\nTeach my thy way O Lord\nI will walk in thy truth\nUnite my heart to fear thy name\nI will praise thee O Lord my God\nWith all my heart\nAnd I will glorify thy name\n forevermore');
INSERT INTO page VALUES (13151,505,1,'I get so thrilled with Jesus\nEvery moment of the day\nI get so thrilled with Jesus\nHe\'s the truth, the life, the way\nI get so thrilled with Jesus\nHe satisfies my longing soul\nI get so thrilled with Jesus\nHe\'s the one who makes me whole');
INSERT INTO page VALUES (13154,508,1,'Jesus himself took my weakness\n and carried away my sickness\nJesus himself took my weakness\n and carried away my sickness');
INSERT INTO page VALUES (13156,510,1,'For from him, and through him\nand to him are all things\nTo God be the glory forever,\namen.\n(repeat)');
INSERT INTO page VALUES (13153,507,1,'Therefore with joy\n shall ye draw water\nOut of the wells of salvation\nAnd in that day shall ye say\n\"Praise the Lord\"\n(repeat)');
INSERT INTO page VALUES (13155,509,1,'Not my will be thine be done\nBut let the fulness of the Son\nRule within this life\n that I have offered thee\nUntil everything I do\nBecomes the thing that pleases you\nAbba Father I would be a son indeed');
INSERT INTO page VALUES (13164,517,1,'He is my everything\nHe is my all\nHe is my everything\nBoth great and small\nHe gave his life\nMade everything new\nHe is my everything\nNow how about you');
INSERT INTO page VALUES (13157,511,1,'We are gathering together unto him\nWe are gathering together unto him\nUnto him shall the gathering\n of the people be\nWe are gathering together unto him');
INSERT INTO page VALUES (13158,512,1,'It\'s a new and living way,\nwalk ye in it\nIt\'s an new and living way\n God has planned\nIt\'s a new and living way\nI am walking day by day\nI am guided and led\n by his right hand');
INSERT INTO page VALUES (13159,513,1,'Blessed be the Lord God,\n the God of Israel.\nBlessed be the Lord God,\n the God of Israel.\nWho only doeth wondrous things\nWho only doeth wondrous things\nAnd let the whole earth be filled');
INSERT INTO page VALUES (13160,513,2,'With his glory, amen,\n amen, amen, amen\nBlessed be the Lord God,\n the God of Israel.\nBlessed be the Lord God,\n the God of Israel.\nAmen, amen, amen');
INSERT INTO page VALUES (13161,514,1,'It\'s a new hour,\n it\'s a new day\nIt\'s a new visitation\n in a great new way\nRevealing the Father,\n exalting the Son\nChanging God\'s people\nAnd making them one');
INSERT INTO page VALUES (13168,520,6,'He lives, he lives,\nChrist Jesus lives today!\nHe walks with me and talks\n with me along life\'s narrow way.\nHe lives, he lives,\nsalvation to impart!\nYou ask me how I know He lives?\nHe lives within my heart.');
INSERT INTO page VALUES (13162,515,1,'Not by might, nor by power\nBut by my Spirit saith the Lord\nNot by might, nor by power\nBut by my Spirit saith the Lord\nThis mountain shall be removed\nThis mountain shall be removed\nThis mountain shall be removed\nBut by my Spirit saith the Lord');
INSERT INTO page VALUES (13163,516,1,'We see the Lord, we see the Lord\nAnd he is high and lifted up\nAnd his train fills the temple\nHe is high and lifted up\nAnd his train fill the temple\nThe angels cry \'Holy\'\nThe angels cry \'Holy\'\nThe angels cry \'Holy is the Lord\'');
INSERT INTO page VALUES (13165,517,2,'Like honey in the rock\nSweet honey in the rock\nFor he tastes like\n honey in the rock\nO taste and see that\n the Lord is good\nFor he tastes like\n honey in the rock');
INSERT INTO page VALUES (13166,518,1,'Whoso offereth praise glorifieth me\nWhoso offereth praise glorifieth me\nAnd to him that ordereth his\n conversation aright\nWill I show the salvation of God');
INSERT INTO page VALUES (13212,540,1,'For all that You\'ve done\nI will thank You\nFor all that You\'re going to do\nFor all that You\'ve promised\nand all that You are\nIs all that has carried me through');
INSERT INTO page VALUES (13167,519,1,'Behold, God is my salvation\nI will trust him, I will trust him\nBehold, God is my salvation\nI will trust him and not be afraid\nTherefore with joy\n shall you draw water\n(repeat twice)\n\nOut of the wells of salvation');
INSERT INTO page VALUES (13169,520,4,'He lives, he lives,\nChrist Jesus lives today!\nHe walks with me and talks\n with me along life\'s narrow way.\nHe lives, he lives,\nsalvation to impart!\nYou ask me how I know He lives?\nHe lives within my heart.');
INSERT INTO page VALUES (13170,520,1,'I serve a risen Saviour,\n He\'s in the world today;\nI know that he is living,\n whatever men may say;\nI see His hand of mercy,\n I hear His voice of cheer,\nAnd just the time I need Him\n He\'s always near.');
INSERT INTO page VALUES (13171,520,3,'In all the world around me\n I see His loving care,\nAnd tho\' my heart grows weary\n I never will despair;\nI know that He is leading,\n thro\' all the stormy blast,\nThe day of His appearing\n will come at last.');
INSERT INTO page VALUES (13172,520,2,'He lives, he lives,\nChrist Jesus lives today!\nHe walks with me and talks\n with me along life\'s narrow way.\nHe lives, he lives,\nsalvation to impart!\nYou ask me how I know He lives?\nHe lives within my heart.');
INSERT INTO page VALUES (13173,520,5,'Rejoice, rejoice, O Christian,\n lift up your voice and sing\nEternal hallelujahs to\n Jesus Christ the King!\nThe Hope of all who seek Him,\n the Help of all who find,\nNone other is so loving,\n so good and kind.');
INSERT INTO page VALUES (13174,521,1,'Lift up your heads\nto the coming King\nBow before him\n and adore him sing\nTo His Majesty\nLet your praises be\nPure and holy,\n giving glory\nTo the King of Kings');
INSERT INTO page VALUES (13175,522,1,'Take our bread,\n we ask you\nTake our hearts,\n we love you\nTake our lives,\n O Father, we are yours\n(repeat)\n\nWe are yours.');
INSERT INTO page VALUES (13176,522,3,'Your holy people standing\n washed in your blood\nSpirit-filled yet hungry\n we await your food\nWe are poor but we\'ve\n bought ourselves\nThe best that we could\nWe are yours,\n we are yours...');
INSERT INTO page VALUES (13177,522,2,'Yours as we stand at\n the table you set\nYours as we eat the bread\n our hearts can\'t forget\nWe are the sing of your\n life with us yet\nWe are yours,\n we are yours...');
INSERT INTO page VALUES (13178,523,1,'There is a river of\n the water of life\nAs clear as crystal\nIt\'s flowing out from\n the throne\nOf God and the lamb');
INSERT INTO page VALUES (13179,523,2,'The Spirit and the\n bride say \'Come\'\nLet him who hears\n say \'Come\'\nLet him who thirsts\n drink life\nOf the river of life,\n without charge');
INSERT INTO page VALUES (13180,524,1,'Be still and know\n that I am God\n  (repeat twice)\n\nI am the Lord\n that healeth thee\n  (repeat twice)\n\nIn thee O Lord\n do I put my trust\n  (repeat twice)');
INSERT INTO page VALUES (13181,525,1,'Cause me to come to\n thy river, O Lord\nCause me to drink at\n thy river, O Lord\nCause me to live in\n thy river, O Lord\n\nCause me to come\nCause me to drink\nCause me to live');
INSERT INTO page VALUES (13182,526,1,'Therefore, being justified by faith\nWe have peace with God\nThrough our Lord Jesus Christ...');
INSERT INTO page VALUES (13183,526,3,'But God commended his\n love to all of us\nIn that while we were yet sinners\nChrist died for us...');
INSERT INTO page VALUES (13184,526,2,'Because the love Of God\nIs shed abroad in our hearts\nBy the Holy Ghost\nWhich is given, which is given\nUnto us, to us, unto us');
INSERT INTO page VALUES (13191,530,1,'Jesus, you are so\n precious and lovely\nJesus, you are so\n tender and true\nJesus I love you\nJesus I love you\nWonderful Son of God');
INSERT INTO page VALUES (13185,527,1,'O cloud of great glory\nThou presence of God\nDescend now, on wings\nof the Spirit of love\n(repeat)\n\nO cloud of great glory\nThou presence of God\nDescend now,\n and hover over me');
INSERT INTO page VALUES (13186,528,1,'Praise ye the Lord\nPraise God in his sanctuary\nPraise him in the firmament\n of his power\nPraise him according\nPraise him according to his\n excellent greatness');
INSERT INTO page VALUES (13187,528,3,'Praise him upon the\n loud cymbals\nPraise him upon the\n high sounding cymbals\nLet everything that hath\n breath praise the Lord\nPraise ye the Lord');
INSERT INTO page VALUES (13188,528,2,'Praise him with the\n sound of the trumpet\nPraise him with the\n psaltery and harp\nPraise him with the\n timbrel and dance\nPraise him with stringed\n instruments and organs');
INSERT INTO page VALUES (13189,529,1,'I will bless the Lord at all times\nHis praise shall continually\n be in my mouth\nMy soul shall make her\n boast in the Lord\nThe humble shall hear and be glad\nThe humble shall hear and be glad');
INSERT INTO page VALUES (13190,529,2,'O magnify the Lord with me\nAnd let us exalt\n his name together\nI sought the Lord\n and he heard my cry\nAnd delivered me from all my fears\nAnd delivered me from all my fears');
INSERT INTO page VALUES (13192,531,1,'Sing praises to God,\n sing praises\nSing praises to God,\n sing praises\nFor he is the king\n of all the earth\nSing praises to his name');
INSERT INTO page VALUES (13217,542,6,'To the praise of His Glorious Grace\nTo the praise of His Glory and Power\nTo Him be all Glory, Honour and Praise\nFor ever and ever and ever... Amen');
INSERT INTO page VALUES (13193,532,4,'I fear no foe,\n with Thee at hand to bless;\nIlls have no weight,\n and tears no bitterness.\nWhere is death\'s sting?\n Where, grave, thy victory?\nI triumph still,\n if Thou abide with me!\n');
INSERT INTO page VALUES (13194,532,1,'Abide with me;\n fast falls the eventide;\nThe darkness deepens;\n Lord with me abide!\nWhen other helpers fail\n and comforts flee,\nHelp of the helpless,\n O abide with me.\n');
INSERT INTO page VALUES (13195,532,3,'I need Thy presence\n every passing hour.\nWhat but Thy grace can\n foil the tempter\'s power?\nWho, like Thyself,\n my guide and stay can be?\nThrough cloud and sunshine,\n Lord, abide with me.\n');
INSERT INTO page VALUES (13196,532,2,'Swift to its close ebbs\n out life\'s little day;\nEarth\'s joys grow dim;\n its glories pass away;\nChange and decay in\n all around I see;\nO Thou who changest not,\n abide with me.\n');
INSERT INTO page VALUES (13197,532,5,'Hold thou thy cross\n before my closing eyes;\nShine through the gloom,\n and point me to the skies:\nHeav\'n\'s morning breaks,\n and earth\'s vain shadows flee:\nIn life, in death,\n O Lord, abide with me.');
INSERT INTO page VALUES (13198,533,4,'I surrender to You\nI surrender to You\nEverything I am and\n ever hope to be\nI surrender to You');
INSERT INTO page VALUES (13199,533,1,'You\'re softening my heart\nTo the knowledge of your love\nAnd opening my eyes\nYou light the way to love you\nWords alone cannot express\nAll the hope that You\n have placed with me\nIn between each heartbeat Lord\nI surrender');
INSERT INTO page VALUES (13200,533,3,'You gently pick me up\nWash me with your love\nAnd opening my eyes\nYou speak the Word\nHealing, releasing all\n the hurts and fears\nBy the hope that You\n have placed within me\nIn between each heartbeat Lord\nI surrender');
INSERT INTO page VALUES (13201,533,2,'I surrender to You\nI surrender to You\nEverything I am and\n ever hope to be\nI surrender to You');
INSERT INTO page VALUES (13203,535,1,'His name is wonderful (x3)\nJesus my Lord\nHe is the mighty king,\n master of everything\nHis name is wonderful,\n Jesus my Lord.');
INSERT INTO page VALUES (13204,535,2,'He\'s the great shepherd\nThe rock of all ages\nAlmighty God is he\nBow down before him,\n love and adore him\nHis name is wonderful,\n Jesus my Lord.');
INSERT INTO page VALUES (13206,537,1,'Heavenly Father, I appreciate you\nHeavenly Father, I appreciate you\nI love you, adore you,\n bow down before you\nHeavenly Father, I appreciate you');
INSERT INTO page VALUES (13205,536,1,'Sweet Jesus, sweet Jesus\nWhat a wonder you are\nYou are brighter than\n the morning star\nYou\'re fairer, much fairer\nThan the lily that grows\n by the wayside\nYou\'re precious,\n more precious than gold.');
INSERT INTO page VALUES (13207,537,3,'Holy Ghost, what a comfort you are\nHoly Ghost, what a comfort you are\nYou lead us, you guide us,\nYou live right inside us\nHoly Ghost, what a comfort you are');
INSERT INTO page VALUES (13208,537,2,'Son of God, what a wonder you are\nSon of God, what a wonder you are\nYou cleansed my soul from sin\nYou set the Holy Ghost within\nSon of God, what a wonder you are');
INSERT INTO page VALUES (13210,539,1,'And you shall seek me\n and you shall find me\nWhen you shall search for me\nWith all your heart\nAnd I will be found of you\nAnd I will be found of you');
INSERT INTO page VALUES (13209,538,1,'Set my spirit free\nThat I might worship thee\nSet my spirit free\nThat I might praise thy name\nLet all bondage go\n and let deliverance flow\nSet my spirit free to worship thee');
INSERT INTO page VALUES (13211,539,2,'When you shall seek me\n with all your heart\nAnd I will be found of you\nAnd I will be found of you\nWhen you shall seek me\n with all your heart');
INSERT INTO page VALUES (13213,540,3,'Thank You for loving\nAnd setting me free\nThank You for giving\nYour life just me\nHow I thank You\nJesus I thank You\nGratefully thank you\nThank You');
INSERT INTO page VALUES (13214,540,2,'Jesus I thank You\nAnd I thank You\nThank You Lord\nThank You\nThank You Lord');
INSERT INTO page VALUES (13215,541,1,'Create in me a clean heart O God\nAnd renew a right spirit within me.');
INSERT INTO page VALUES (13216,541,2,'Cast me not away from Thy presence, O Lord\nAnd take not Thy Holy Spirit from me.\nRestore unto me the joy of Thy salvation\nAnd renew a right spirit within me.');
INSERT INTO page VALUES (13218,542,4,'To the praise of His Glorious Grace\nTo the praise of His Glory and Power\nTo Him be all Glory, Honour and Praise\nFor ever and ever and ever... Amen');
INSERT INTO page VALUES (13219,542,1,'Oh the mercy of God,\n the Glory of Grace\nThat You chose to redeem us,\n to forgive and restore\nAnd You call us Your children,\n chosen in Him\nTo be holy and blameless,\n to the Glory of God.');
INSERT INTO page VALUES (13220,542,3,'Oh the riches of Grace,\n the depths of His love\nIn Him is redemption,\n the forgiveness of sin\nAnd You call us as righteous,\n Predestined in Him\nFor the praise of His Glory,\n Included in Christ.');
INSERT INTO page VALUES (13221,542,2,'To the praise of His Glorious Grace\nTo the praise of His Glory and Power\nTo Him be all Glory, Honour and Praise\nFor ever and ever and ever... Amen');
INSERT INTO page VALUES (13222,542,5,'Oh the Glory of God,\n Expressed in His Son\nHis image and likeness,\n revealed to us all\nThe plan of the ages,\n completed in Christ\nThat we be presented,\n perfected in Him.');
INSERT INTO page VALUES (13227,543,1,'You are my God\nI am Your servant\nYou are my Lord\nMy Lord and saviour\nYou are my friend\nMy joy and comfort\nYou are my Lord\nYou are my God');
INSERT INTO page VALUES (13228,543,2,'Hear, hear the angels sing\nAll creation brings you the glory\nAnd I will lift my heart in faith\nLift my eyes to see You\nIn holiness, in righteousness\nIn majesty - You are my God.');
INSERT INTO page VALUES (13229,544,4,'And Your love...\nThere is nothing stronger\nNothing can go deeper\nWho can separate us\n from Your love.');
INSERT INTO page VALUES (13230,544,1,'Your love...\nIs higher than the mountains\nDeeper than the oceans\nWider than the sea.');
INSERT INTO page VALUES (13231,544,3,'And Your love...\nNothing can come close\nNothing will replace it\nWho can separate us\n from Your love.');
INSERT INTO page VALUES (13232,544,2,'And Your love...\nReaches to the heavens\nIs falling like the rivers\nLeading to the seas.');
INSERT INTO page VALUES (13233,545,1,'You rescued me,\n and picked me up\nA living hope,\n of grace revealed\nA life transformed,\n in righteousness\nOh Lord you have rescued me');
INSERT INTO page VALUES (13234,545,3,'And You loved me,\n before I knew You\nAnd you knew me for all time\nI\'ve been created in\n Your image, oh Lord');
INSERT INTO page VALUES (13465,602,1,'Jesus, take me as I am\nI can come no other way\nTake me deeper into you\nMake my flesh life melt away\nMake me like a precious stone\nCrystal clear and finely honed\nLife of Jesus shining through\nGiving glory back to you');
INSERT INTO page VALUES (13235,545,2,'Forgiving me,\n you healed my heart\nAnd set me free,\n from sin and death\nYou brought me life,\n You\'ve made me whole\nOh Lord You have rescued me');
INSERT INTO page VALUES (13236,546,1,'Let God arise\nHis enemies be scattered\n(repeat twice)\nLet God, let God arise');
INSERT INTO page VALUES (13237,547,1,'Surely goodness and mercy\n shall follow me\nAll the days,\n all the days of my life\n(repeat)');
INSERT INTO page VALUES (13238,547,2,'And I shall dwell in the\n house of the Lord forever\nAnd I shall feast at the\n table spread for me\nSurely goodness and mercy\n shall follow me\nAll the days,\n all the days of my life');
INSERT INTO page VALUES (13239,548,1,'For the beauty of the earth\nfor the beauty of the skies\nfor the love which from our birth\nover and around us lies\nChrist our God to thee we raise\nThis our sacrifice of praise\n');
INSERT INTO page VALUES (13240,548,3,'For the church that evermore\nlifteth holy hands above\noffering up on every shore\nher pure sacrifice of love\nChrist our God to thee we raise\nThis our sacrifice of praise');
INSERT INTO page VALUES (13241,548,2,'For the joy of human love\nbrother sister, parent child,\nfriends on earth and friends above,\nfor all gentle thoughts and mild\nChrist our God to thee we raise\nThis our sacrifice of praise\n');
INSERT INTO page VALUES (13242,549,1,'There is none like You,\nNo-one else can touch\n my heart like You do,\nI could search for all\n eternity long\nAnd find there is\n none like you.');
INSERT INTO page VALUES (13243,549,3,'There is none like You,\nNo-one else can touch\n my heart like You do,\nI could search for all\n eternity long\nAnd find there is\n none like you.');
INSERT INTO page VALUES (13244,549,2,'Your mercy flows\n like a river wide\nAnd healing comes\n from Your hand.\nSuffering children are\n safe in Your arms.\nThere is none like You.');
INSERT INTO page VALUES (13245,550,4,'When Israel was a child,\n I loved him.\nIt was I who taught Ephraim to walk,\n taking them by the arms;\nbut they did not realise\n it was I who healed them.\nI led them with cords of\n human kindness with ties of love\n\nHosea 11:1-4');
INSERT INTO page VALUES (13246,550,1,'Listen to me...\nall you who remain of\n the house of Israel,\n you whom I have upheld\n since your birth,\n carried from the womb -\nI have made, and I will bear;\nI will carry and will save.\n\nIsaiah 46:3');
INSERT INTO page VALUES (13247,550,3,'Can a mother forget the \n baby at her breast and\n have no compassion on\n the child she has borne?\nThough she may forget,\n I will not forget you!\n See, I have engraved\n you on the palms of my hands.\n\nIsaiah 49:15,16');
INSERT INTO page VALUES (13248,550,2,'As a mother comforts her child,\n so I will comfort you... \nyou will nurse and be carried\n on her arm and\n dandled on her knees.\n\nIsaiah 66:12-13');
INSERT INTO page VALUES (13250,552,4,'And he walks with me\n and he talks with me\nAnd he tells me I am his own;\nAnd the joy we share\n as we tarry there\nNone other has ever known.');
INSERT INTO page VALUES (13249,551,1,'Thanks Mum for:\n* A good sense of humour\n* Love\n* Knowing when you\'re lied to\n* Doing special things\n - like cuddles & kisses\n* Helping me when I\'m sick\n* liking my presents\n* liking flowers\n* liking lots of flowers\n* giving the best hugs\n');
INSERT INTO page VALUES (13252,552,3,'He speaks and the\n sound of his voice\nIs so sweet the birds\n hush their singing,\nAnd the melody that\n he gave to me\nWithin my heart is ringing.');
INSERT INTO page VALUES (13253,552,2,'And he walks with me\n and he talks with me\nAnd he tells me I am his own;\nAnd the joy we share\n as we tarry there\nNone other has ever known.');
INSERT INTO page VALUES (13254,553,4,'Then sings my soul,\n my saviour God to Thee\nHow great Thou art!\n  How great Thou art!\nThen sings my soul,\n my saviour God to Thee\nHow great Thou art!\n  How great Thou art!');
INSERT INTO page VALUES (13255,553,1,'O Lord my God, it is with\n awe and wonder\nThat I behold, the good\n things you have made!\nI see the storm and\n hear the roll of thunder,\nBut know that stars\n still shine behind the rain.');
INSERT INTO page VALUES (13256,553,3,'I see your hand in\n every golden sunrise\nIn every tree, on every\n snow clad peak;\nIn rolling plains, the\n purple headed mountains,\nThe vast, unfathomed\n waters of the deep.');
INSERT INTO page VALUES (13257,553,2,'Then sings my soul,\n my saviour God to Thee\nHow great Thou art!\n  How great Thou art!\nThen sings my soul,\n my saviour God to Thee\nHow great Thou art!\n  How great Thou art!');
INSERT INTO page VALUES (13258,554,1,'Low in the grave he lay, Jesus my saviour! \nWaiting the coming day, Jesus my lord!\nUp from the grave he a-rose,\nWith a mighty triumph o\'er his foes\nHe arose a victor from the dark domain\nAnd He lives for ever\nwith His saints to reign.\nHe arose, He arose,\nHallelujah! Christ Arose!');
INSERT INTO page VALUES (13259,554,3,'Death can not keep his prey,\nJesus my Saviour!\nHe tore the bars away, Jesus my lord!\nUp from the grave he a-rose,\nWith a mighty triumph o\'er his foes\nHe arose a victor from the dark domain\nAnd He lives for ever\nwith His saints to reign.\nHe arose, He arose,\nHallelujah! Christ Arose!');
INSERT INTO page VALUES (13260,554,2,'Vainly they watched His bed,\nJesus my Saviour!\nVainly they seal the dead, Jesus my lord!\nUp from the grave he a-rose,\nWith a mighty triumph o\'er his foes\nHe arose a victor from the dark domain\nAnd He lives for ever\nwith His saints to reign.\nHe arose, He arose,\nHallelujah! Christ Arose!');
INSERT INTO page VALUES (13266,557,4,'I want to give all of me,\ngiving You all of me');
INSERT INTO page VALUES (13262,555,1,'Exalt the Lord our God\nExalt the Lord our God\nAnd worship at His footstool\nWorship at His footstool\nHoly is He, holy is He');
INSERT INTO page VALUES (13261,220,4,'You are why I sing\nYou are why I live\nEverything of me\nI place at Your feet\nYou are why I love\nYou are why I give\nEverything of me\nBelongs to you');
INSERT INTO page VALUES (13263,556,1,'This is my body\nBroken for you\nBringing you wholeness\nMaking you free\nTake it and eat it\nAnd as you do\nDo it in love for me');
INSERT INTO page VALUES (13264,556,2,'This is my blood\nPoured out for you\nBringing forgiveness\nMaking you free\nTake it and drink it\nAnd as you do\nDo it in love for me');
INSERT INTO page VALUES (13407,271,3,'Fear not, for I am with you\nFear not, for I am with you\nFear not, for I am with you says the Lord\n(Repeat)');
INSERT INTO page VALUES (13265,450,5,'Lord let your glory fall');
INSERT INTO page VALUES (13267,557,1,'I tremble at your presence\nShaken by the truth,\nThat You are God.\nNo deed can bring you pleasure\nOr a word add a measure,\nto who You are.');
INSERT INTO page VALUES (13268,557,3,'Bless the Lord,\nwith all that\'s within me\nBless the lord\nMay kingdoms fall\nand rulers crawl\nBefore Your throne');
INSERT INTO page VALUES (13269,557,2,'I lift my heart in worship\ntaken by the truth,\nYou are God\nSilenced by virtue\nSurrendered in awe,\nof who you are');
INSERT INTO page VALUES (13270,558,1,'<UL>\n<LI>The Feast of Pentecost</LI>\n<LI>50 Days from the beginning of Passover</LI>\n<LI>A harvest of Thanksgiving.</LI>\n\n<LI>Jesus, looking beyond His\ndeath and being concerned to give\ncomfort and re-assurance to His\nDisciples, promises another Comforter\nor Helper who will stay with them\nforever</LI>.\n');
INSERT INTO page VALUES (13271,558,4,'<UL>\n<LI>IN THE LIFE OF THE CHRISTIAN</LI>\n<LI>The Holy Spirit continues to convince\nus of sin, of righteousness and of\njudgement and He guides us\nto remember</LI>\n\n<LI>The purpose in being God\'s people</LI>');
INSERT INTO page VALUES (13272,558,3,'<UL>\n<LI>IN THE LIFE OF THE UNBELIEVER</LI>\n<LI>The Holy Spirit convinces\n the world of sin</LI>\n\n<LI>Of righteousness</LI>\n\n<LI>And of judgement</LI>');
INSERT INTO page VALUES (13273,558,2,'Peter at the Pentecost taught that\nmen would need to turn, to repent.\nBut only the power of the Holy\nSpirit can bring the deep conviction\nwhich leads to repentance.');
INSERT INTO page VALUES (13274,558,6,'<UL>\n<LI>WHAT EVIDENCE IS THERE THAT\nTHE HOLY SPIRIT IS WITHIN US?</LI>\n<LI>1. Conviction of our need and\nour conversion - John 16:7-11</LI>\n<LI>2. An inner peace and assurance\nthat is God with us - Romans 8:16</LI>\n<LI>3. Enlightment through the scriptures,\nguidance in our actions - John 14:26</LI>\n<LI>4. A change in character -\n2 Timothy 1:7, Galatians 5:22</LI>');
INSERT INTO page VALUES (13275,558,5,'<UL>\n<LI>IN THE LIFE OF THE CHRISTIAN</LI>\n<LI>The aim of growing and arriving at\nspiritual maturity</LI>\n\n<LI>Our being the Body of Jesus Christ,\nthrough which God\'s purpose can be\nrealised in the world</LI>');
INSERT INTO page VALUES (13406,271,4,'I have redeemed you\nI have called you by name.\nChild, you are mine.\nWhen you walk through the waters\nI will be there\nAnd through the flame\nYou\'ll not (no way!) be drowned\nYou\'ll not (no way!) be burned\nFor I am with you.');
INSERT INTO page VALUES (13282,560,6,'I will celebrate Your\n love forever, Yahweh\nAge on age, my words\n proclaim Your love\nFor I claim that love is\n built to last forever\nFounded firm,\nYour faithfulness\n');
INSERT INTO page VALUES (13283,560,3,'Yahweh, that assembly\n of those who love you\nApplaud your marvellous word\nWho in the skies can\n compare with Yahweh?\nWho can rival him?\n');
INSERT INTO page VALUES (13284,560,7,'I have revealed my chosen servant\nAnd he can rely on me\nGiven him my love to last forever\nHe shall rise in my name...\n');
INSERT INTO page VALUES (13285,560,9,'He will call to me, my Father, my God!\nFor I make him my first born Son\nI cannot take back my given promise\nI\'ve called him to shine like the sun...\n');
INSERT INTO page VALUES (13286,560,2,'I will celebrate Your\n love forever, Yahweh\nAge on age, my words\n proclaim Your love\nFor I claim that love is\n built to last forever\nFounded firm,\nYour faithfulness\n');
INSERT INTO page VALUES (13287,560,8,'I will celebrate Your\n love forever, Yahweh\nAge on age, my words\n proclaim Your love\nFor I claim that love is\n built to last forever\nFounded firm,\nYour faithfulness\n');
INSERT INTO page VALUES (13288,560,4,'I will celebrate Your\n love forever, Yahweh\nAge on age, my words\n proclaim Your love\nFor I claim that love is\n built to last forever\nFounded firm,\nYour faithfulness\n');
INSERT INTO page VALUES (13289,560,1,'I have made a covenant\n with my chosen\nGiven my servant my word\nI have made your name\n to last forever\nBuilt to outlast all time...\n');
INSERT INTO page VALUES (13290,560,10,'I will celebrate Your\n love forever, Yahweh\nAge on age, my words\n proclaim Your love\nFor I claim that love is\n built to last forever\nFounded firm,\nYour faithfulness\n');
INSERT INTO page VALUES (13291,560,5,'Happy the people who\n learn to aclaim you\nThey rejoice in your light\nYou are our glory and\n you are our courage\nOur hope belongs to you...\n');
INSERT INTO page VALUES (13526,613,6,'And He walks with me,\n And He talks with me,\n And He tells me I am His own;\nAnd the joy we share\n as we tarry there,\nNone other has ever known.');
INSERT INTO page VALUES (13525,613,1,'I come to the garden alone,\n While the dew is still on the roses;\nAnd the voice I hear falling on my ear,\n The Son of God discloses.');
INSERT INTO page VALUES (13304,562,1,'Praise the Lord, you heavens adore Him,\nPraise Him angels in the height,\nSun and moon, rejoice before Him,\nPraise him all the stars of light,\nPraise the Lord for he has spoken,\nWorlds His mighty voice obeyed,\nLaws which never shall be broken,\nFor your guidance He has made.');
INSERT INTO page VALUES (13305,562,2,'Praise the Lord, for he is glorious,\nNever shall His promise fail,\nGod has made His saints victorious,\nSin and death shall not prevail,\nPraise the God of our salvation,\nHosts on high His power proclaim,\nHeaven and earth and all creation,\nPraise and magnify His name.\n');
INSERT INTO page VALUES (13334,568,6,'Lift your hands,\nLift your hands.');
INSERT INTO page VALUES (13409,586,1,'Lord it was You who\nCreated the heavens\nLord it was Your hand\nThat put the stars in their place\nLord it is Your voice\nThat commands the morning\nEven oceans and thier waves\nBow at Your feet');
INSERT INTO page VALUES (13307,563,1,'Praise Him! praise Him!\nJesus, our blessed Redeemer!\nSing, O Earth,\nHis wonderful love proclaim!\nHail Him! hail Him!\nhighest archangels in glory;');
INSERT INTO page VALUES (13308,563,3,'Praise Him! praise Him\ntell of His excellent greatness\nPraise Him! praise Him!\never in joyful song');
INSERT INTO page VALUES (13309,563,2,'Strength and honour give to\n His holy name!\nLike a shepherd,\n Jesus will guard His children;\nIn His arms He\n carries them all day long:');
INSERT INTO page VALUES (13310,563,5,'Hail Him! hail Him!\nJesus the crucified:\nSound His praises!\nJesus who bore\n our sorrows,\nLove unbounded,\n wonderful,\ndeep, and strong:');
INSERT INTO page VALUES (13311,563,4,'Praise Him! praise Him!\nJesus, our blessed Redeemer!\nFor our sins He suffered\n and bled and died;\nHe our Rock,\nour hope of\n eternal salvation,\n');
INSERT INTO page VALUES (13312,563,6,'Praise Him! praise Him\ntell of His excellent greatness\nPraise Him! praise Him!\never in joyful song');
INSERT INTO page VALUES (13313,563,8,'Crown Him! crown Him!\nprophet and priest and king!\nChrist is coming,\nover the world victorious,\nPow\'r and glory\n unto to the Lord belong:');
INSERT INTO page VALUES (13314,563,7,'Praise Him! praise Him!\nJesus, our blessed Redeemer!\nHeav\'nly portals loud\n with hosannas ring!\nJesus, Saviour,\nreigneth forever and ever;');
INSERT INTO page VALUES (13315,563,9,'Praise Him! praise Him\ntell of His excellent greatness\nPraise Him! praise Him!\never in joyful song');
INSERT INTO page VALUES (13495,608,6,'Set up your throne,\n that earth\'s despair may cease\nBeneath the shadow\n of its healing peace.\n\nLift high the cross,\n the love of Christ proclaim,\nTill all the world adores\n His sacred name.');
INSERT INTO page VALUES (13443,597,1,'Great is Your faithfulness,\nO God my Father,\nThere is no shadow\n of turning with You;\nYou never change,\n Your compassions\n they fail not;\nAs You have been\n You forever will be.');
INSERT INTO page VALUES (13318,564,1,'You are my hiding place,\nYou always fill my heart \nwith songs of deliverance.\nWhenever I am afraid \nI will trust in You.');
INSERT INTO page VALUES (13319,564,3,'You are my hiding place,\nYou always fill my heart \nwith songs of deliverance.\nWhenever I am afraid \nI will trust in You.');
INSERT INTO page VALUES (13320,564,2,'I will trust in You;\nLet the weak say,\n\"I am strong \nin the strength of the Lord\".');
INSERT INTO page VALUES (13324,565,3,'<UL>\n<LI>Three types of Temptation\nand resisting them:</LI>\n\n<LI>Gen. 3              Mat. 4</LI>\n<LI>1.World\nGood for food          Stones to food</LI>\n<LI>2.Flesh\nPleasing to the eye  Throw off</LI>\n<LI>3.Satan\nGaining of wisdom    Worship me</LI></UL>');
INSERT INTO page VALUES (13323,565,2,'<UL>\n<LI>Three types of Temptation\nand resisting them:</LI>\n\n<LI>Gen. 3                       </LI>\n<LI>1.World\nGood for food                               </LI>\n<LI>2.Flesh\nPleasing to the eye               </LI>\n<LI>3.Satan\nGaining of wisdom                    </LI></UL>');
INSERT INTO page VALUES (13329,567,4,'  And I\nI tremble');
INSERT INTO page VALUES (13330,567,1,'Shaken like a leaf\nAfraid to lift my eyes\nAfraid of your glory\nAshamed of my pride');
INSERT INTO page VALUES (13331,567,3,'And I beckon You\n  to forgive everything\nThat I\'ve ever done');
INSERT INTO page VALUES (13332,567,2,'Then You call me in\nTo Your holy place\nI fall down\nDown my face');
INSERT INTO page VALUES (13333,567,5,'I am just a child\nShowered in yor grace\nYou\'re the Holy God\nYour glory fills this place');
INSERT INTO page VALUES (13336,568,1,'Let Your Glory fly');
INSERT INTO page VALUES (13337,568,3,'Lift Your hands up\nLook to the sky\nThe Lord is coming\nComing to Australia\nCan you feel the fire\nCan you see the waves\nIt\'s blowing through\nIt\'s coming to Australia again');
INSERT INTO page VALUES (13338,568,2,'If my people will humbly pray\nTurn from sin and their wicked ways\nThe I will hear them and heal their land\nAnd show my glory and power again');
INSERT INTO page VALUES (13339,568,5,'Oh God could this be\nThe land of the free\nThe land of the free');
INSERT INTO page VALUES (13340,569,4,'Yes I fall on my knees\nTo get back on my feet again\nAnd I\'ll run hard for You\nto enter Your rest');
INSERT INTO page VALUES (13341,569,1,'Healer, heal me\nSaviour, save me\nMaker, Change me\nLover, Love me');
INSERT INTO page VALUES (13342,569,3,'So I fall on my knees\nTo get back on my feet again\nAnd I cry out for You\nTo hear You speak to me');
INSERT INTO page VALUES (13343,569,2,'\'cause I\'m so tired\nOf living for\nThe kind of love\nthat only lasts for a while\nThe pain\nThe shame\nTears me up inside');
INSERT INTO page VALUES (13345,570,2,'As I wait You make me strong\nAs I long, draw me to Your arms\nAs I stand and sing Your praise\nYou come, You come\nAnd fill this place\nWon\'t You come, won\'t You come\nAnd fil this place.');
INSERT INTO page VALUES (13346,571,6,'You\'re the reason for the stars\n  that decorate my night\nSo I sing, yeah I sing\nYou\'re the maker');
INSERT INTO page VALUES (13347,571,4,'You still amaze me\nYou still amaze me\nBigger than the sky\nBrighter than the sun\nYou\'re the one');
INSERT INTO page VALUES (13348,571,1,'There\'s nothing new under the sun\nLeft for me to do\nThe last great thrills I felt are fleeting');
INSERT INTO page VALUES (13349,571,3,'And you, Yeah');
INSERT INTO page VALUES (13350,571,7,'And I\'m free to be loved,\nI\'m alive from Your gentle touch\nI\'m touched from the sky,\nLet me cry, You\'re amazing.');
INSERT INTO page VALUES (13351,571,2,'Once I was excited for\n  the things the world could give\nBut no more\nI\'m only thrilled by you');
INSERT INTO page VALUES (13352,571,5,'You filled me with the things I need\n  and gave me Something more\nAnd I\'ve ran with the freedom\nThat you gave me');
INSERT INTO page VALUES (13357,567,6,'And I beckon You\n  to forgive everything\nThat I\'ve ever done');
INSERT INTO page VALUES (13353,572,4,'Oh Lord,\n We ask for the nations');
INSERT INTO page VALUES (13354,572,1,'You said\n \"Ask and you will recieve\n  Whatever you need\"\nYou said\n \"Pray and I\'ll hear from heaven\n  And I\'ll heal Your land\"');
INSERT INTO page VALUES (13355,572,3,'You said\n \"Ask and I\'ll give the nations to you\"\nOh Lord, That\'s the cry of my heart\nDistant shores and the islands will see\nYour light, as it rises on us!');
INSERT INTO page VALUES (13356,572,2,'You said\n  You\'re glory will fill the earth\n  Like water the sea\nYou said\n \"Lift up your eyes,\n  The harvest is here\n  Your kingdom is near\"');
INSERT INTO page VALUES (13358,567,7,'  And I\nI tremble');
INSERT INTO page VALUES (13359,573,4,'When I\'m far away\nThen You draw me\nWhen I am afraid\nYou surround me');
INSERT INTO page VALUES (13360,573,1,'When I\'m faithless\nYou are faithfull\nWhen I\'m longing\nYou surround me');
INSERT INTO page VALUES (13361,573,3,'La La La Hey La La\nLa La La I\'ll sing for you\nLa La La Hey La La\nDemonstrate my Love for You');
INSERT INTO page VALUES (13362,573,2,'And when I am empty\nYou drown me in your sweet embrace\nAnd when I am broken\nYou come restore my joy again');
INSERT INTO page VALUES (13363,574,1,'In my life Lord,\n be glorified,\nBe glorified,\nIn my life Lord,\n be glorified, today.');
INSERT INTO page VALUES (13364,574,2,'In your Church Lord,\n be glorified,\nBe glorified,\nIn your Church Lord,\n be glorified, today.');
INSERT INTO page VALUES (1,1,1,'Loving\nGod\nIs\nThe\n\nMost\nImportant\nThing');
INSERT INTO page VALUES (13365,575,1,'Change my heart O God,\n make it ever true.\nChange my heart O God,\n may I be like you.\n(Repeat)');
INSERT INTO page VALUES (13366,575,2,'You are the potter\nI am the clay\nMould me and make me\nThis is what I pray.');
INSERT INTO page VALUES (13427,591,1,'I sing a simple song of love\n  to my saviour, to my Jesus\nI\'m greatful for the things You\'ve done\nMy loving Saviour, oh precious Jesus\nMy heart is glad that\n You\'ve called me Your own\nThere\'s no place I\'d rather be');
INSERT INTO page VALUES (13368,576,5,'');
INSERT INTO page VALUES (13369,576,3,'<li>The future is a free gift</li>\n<li>Why did Jesus die for us?</li>\n<li>Why is there a need for a saviour?</li>\n<li>Are there any exceptions?</li>\n<li>What are the consequences of sin?</li>\n');
INSERT INTO page VALUES (13370,576,2,'God will wipe away every tear from\ntheir eyes; and death shall be no more,\nneither shall there be anguish nor\ngrief nor pain any more, for the old\nconditions and the former order of\nthings have passed away\n');
INSERT INTO page VALUES (13371,576,4,'<li>What provision has been made\nto pay for this free gift?</li>\n');
INSERT INTO page VALUES (13372,577,1,'Therefore the redeemed\n of the Lord shall return\nAnd come with singing unto Zion\nAnd everlasting joy shall\n be upon their heads\n(repeat)');
INSERT INTO page VALUES (13373,577,2,'They shall obtain\n gladness and joy\nAnd sorrow and\n mourning shall flee away\nTherefore the redeemed\n of the Lord shall return\nAnd come with singing unto Zion\nAnd everlasting joy\n shall be upon their heads');
INSERT INTO page VALUES (13536,616,3,'If I can do my duty\n as a Christian ought,\nIf I can bring back\n beauty to a world upwrought,\nIf I can spread love\'s\n message the Master taught,\nThen my living shall not be in vain.');
INSERT INTO page VALUES (13535,616,4,'Then my living shall not be in vain,\nThen my living shall not be in vain,\nIf I can help somebody\n as I pass along,\nThen my living shall not be in vain.');
INSERT INTO page VALUES (13384,579,1,'* Miniseries of the church\n(especially Girls\' brigade)\n* Preschool service\n(10th August)\n* Church AGM\n* Blue mountains weekend\nfor the oldies!!!\n* Lyn Petersen\n');
INSERT INTO page VALUES (13386,579,2,'* Pam Edwards\n* Marie Brown & family\n* Scripture in schools\n  and the Kids Games\n* Those of the church who\n  have recently suffered\n  bereavement.');
INSERT INTO page VALUES (13387,580,4,'4 things to prevent strife\n\n1. Jesus is your Companion\n2. Love. unconquerable good will.\n3. The Holy Spirit\n4. Kindness and compassion');
INSERT INTO page VALUES (13385,579,3,'* Those of the church who\n  have moved home recently\n* Bruce Debenham, who is\n  undergoing treatment for\n  cancer\n* The Girvan family\n* Pastoral team and deacons');
INSERT INTO page VALUES (13388,580,1,'A letter...written for a reason\n\nPAUL:\n<ul>\n<li>* Was used by God to bring the\n   church at Philippi into being\n<li>* Was in prison\n<li>* Sees signs of strife\n<li>* Wants the church to be effective');
INSERT INTO page VALUES (13389,580,3,'He works with us in all kinds of situations\n\nHe gives Joy\n\nHe provides\n\nHe gives contentment\n\nSO BEWARE DISUNITY');
INSERT INTO page VALUES (13390,580,2,'Philippi needs to know\n  the message of Good News\n\nThere is One God not many\n\nThe God at the centre of the\n  universe is a good God\n\nFear of death has been taken away');
INSERT INTO page VALUES (13391,580,5,'The greatest passage Paul\n  ever wrote about Jesus .. 2:5-11\n\nHis attitude is our example \n.... and what an example!');
INSERT INTO page VALUES (13654,649,1,'O sacred head, once wounded,\nwith grief and pain weighed down,\nhow scornfully surrounded with thorns,\n thine only crown!\nHow pale art thou with anguish,\nwith sore abuse and scorn!\nHow does that visage languish,\nwhich once was bright as morn!');
INSERT INTO page VALUES (13396,583,4,'And I know you hold me\nAnd I know you love me\nAnd I know you guide me');
INSERT INTO page VALUES (13397,583,1,'As I stand\nAnd as I wait for you\nI know you hold me,\nI know you hold me\nand as I come,\nAnd give the honour due\nI know you love me,\nI know you love me');
INSERT INTO page VALUES (13398,583,3,'To the depths of my heart\nTo the depths of my soul\nTo the depths of my life Lord\nYou are in control');
INSERT INTO page VALUES (13399,583,2,'And now all Your glory is all I see\nAs You pour Your gracious love\n  all over me\n');
INSERT INTO page VALUES (13403,585,1,'O the deep, deep love of Jesus!\nVast, unmeasured, boundless free;\nRolling as a mighty ocean\nIn its fullness over me.\nunderneath me, all around me,\nIs the fullness of Thy love:\nLeading onward,\nLeading homeward,\nTo my glorious rest above.');
INSERT INTO page VALUES (13404,585,3,'O the deep, deep love of Jesus!\nLove of ev\'ry love the best;\n\'tis an ocean vast of blessing,\n\'tis a haven sweet of rest.\nO the deep, deep love of Jesus!\n\'tis heav\'n of heav\'ns to me;\nAnd its lifts me up to glory,\nFor it lifts me up to Thee.');
INSERT INTO page VALUES (13405,585,2,'O the deep, deep love of Jesus!\nSpread His praise from shore to shore,\nHow He loveth, ever loveth,\nchangeth never, nevermore,\nHow He watches o\'er His loved ones,\nDied to call them all His own;\nHow for them He intercedeth,\nWatcheth o\'er them from the throne.');
INSERT INTO page VALUES (13408,271,5,'Fear not, for I am with you\nFear not, for I am with you\nFear not, for I am with you says the Lord\n\nFEAR NOT!');
INSERT INTO page VALUES (13410,586,3,'I am Your beloved\nYour creation\nAnd You love me as I am\nYou have called me chosen\nFor Your kingdom\nUnashamed to call me Your own\nI am Your beloved');
INSERT INTO page VALUES (13411,586,2,'Lord who am I,\nCompared to Your glory, Oh Lord\nLord who am I\nCompared to Your majesty');
INSERT INTO page VALUES (13412,587,1,'We are heirs of the Father\nWe are joint heirs with the Son\nWe are children of the Kingdom\nWe are family - we are one');
INSERT INTO page VALUES (13413,588,1,'Abba Father, let me be\nYours and yours alone\nMay my will forever be\nEvermore your own\nNever let my heart grow cold\nNever let me go\nAbba Father, let me be\nYour and yours alone');
INSERT INTO page VALUES (13414,589,6,'Glory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nHis truth is marching on.');
INSERT INTO page VALUES (13415,589,3,' I have seen Him in the watch-fires\n of a hundred circling camps\nThey have builded Him an altar\n in the evening dews and damps\nl can read His righteous sentence\n by the dim and flaring lamps\nHis day is marching on. ');
INSERT INTO page VALUES (13416,589,7,'He has sounded forth the\n trumpet that shall never call retreat\nHe is sifting out the hearts of men\n before His judgement-seat\nOh, be swift, my soul, to answer\n Him! be jubilant, my feet!\nOur God is marching on.');
INSERT INTO page VALUES (13417,589,9,'In the beauty of the lilies\n Christ was born across the sea,\nWith a glory in His bosom that\n transfigures you and me:\nAs He died to make men holy,\n let us die to make men free,\nWhile God is marching on.');
INSERT INTO page VALUES (13418,589,2,'Glory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nHis truth is marching on.');
INSERT INTO page VALUES (13419,589,8,'Glory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nHis truth is marching on.');
INSERT INTO page VALUES (13420,589,1,'Mine eyes have seen the glory\n of the coming of the Lord\nHe is trampling out the vintage\n where the grapes of wrath are stored,\nHe has loosed the fateful\n lightening of His terrible swift sword\nHis truth is marching on.');
INSERT INTO page VALUES (13421,589,4,'Glory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nHis truth is marching on.');
INSERT INTO page VALUES (13422,589,10,'Glory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nGlory! Glory! Hallelujah!\nHis truth is marching on.');
INSERT INTO page VALUES (13423,589,5,'I have read a fiery gospel writ\n in burnish`d rows of steel,\n\"As ye deal with my contemners,\n So with you my grace shall deal;\"\nLet the Hero, born of woman,\n crush the serpent with his heel\nSince God is marching on. ');
INSERT INTO page VALUES (13483,605,4,'Behold He comes,\n riding on the clouds,\nShining like the sun,\n at the trumpet call;\nLift your voice,\n it\'s the year of Jubilee\nAnd out of Zion\'s hill\n salvation comes.');
INSERT INTO page VALUES (13434,593,1,'I am a new creation\nNo more in condemnation\nHere in the grace of God I stand.\nMy heart is overflowing\nMy love just keeps on growing,\nHere in the grace of God I stand.');
INSERT INTO page VALUES (13425,197,4,'G12 AND SOME CELLS TO CONTINUE\nDURING HOLIDAYS\n\nSEE YOUR CELL LEADER IF UNSURE');
INSERT INTO page VALUES (13452,389,4,'Only by the cross I am saved');
INSERT INTO page VALUES (13482,197,5,'Black Stump\nNEXT WEEKEND\n\nSee Katie and Brooke to rego\nCost about $100 bucks\nBYO everything');
INSERT INTO page VALUES (13428,591,2,'In Your arms of love\nIn Your arms of love\nHolding me still\nHolding me near\nIn Your arms of love');
INSERT INTO page VALUES (13429,592,4,'God of wonders beyond our galaxy\nYou are Holy, Holy\nThe universe declares your majesty\nYou are Holy, Holy\nLord of Heaven and Earth\nLord of Heaven and Earth');
INSERT INTO page VALUES (13430,592,1,'Lord of all creation\nOf water, earth and sky\nThe heavens are your tabernacle\nGlory to the Lord on high');
INSERT INTO page VALUES (13431,592,3,'Early in the morning\nI will celebrate the light\nAnd as I stumble in the darkness\nI will call your name by night');
INSERT INTO page VALUES (13432,592,2,'God of wonders beyond our galaxy\nYou are Holy, Holy\nThe universe declares your majesty\nYou are Holy, Holy\nLord of Heaven and Earth\nLord of Heaven and Earth');
INSERT INTO page VALUES (13433,592,5,'\n\nHallelujah to the\nLord of Heaven and Earth');
INSERT INTO page VALUES (13460,601,4,'Come on and celebrate, \ncelebrate,\ncelebrate and sing\ncelebrate and sing to the King\n(repeat)');
INSERT INTO page VALUES (13435,593,2,'And I will praise you, Lord\nYes I will praise you, Lord\nAnd I will sing of all that\n you have done.\nA joy that knows no limit\nA lightness in my spirit,\nHere in the grace of\n God I stand.');
INSERT INTO page VALUES (13453,389,3,'For me, to live is Christ\nand to die is gain.\nNo matter what price I pay\nI choose to give this life away');
INSERT INTO page VALUES (13437,595,1,'Higher and Higher\nFurther and Further\nDeeper and Deeper\n    into You');
INSERT INTO page VALUES (13438,595,2,'More than words\nI want a heart that beats\nMore than words\nI want a life that speaks\nMore than songs\nThough I sing them loud\n and play them long\nMore than all\nI want You');
INSERT INTO page VALUES (13441,596,1,'To God be the glory\nTo God be the glory\nTo God be the glory\nFor the things He has done\nWith His blood He has saved me\nWith His power He has raised me\nTo God be the glory\nFor the things He has done');
INSERT INTO page VALUES (13442,596,2,'With His blood He has saved me\nWith His power He has raised me\nTo God be the glory\nFor the things He has done');
INSERT INTO page VALUES (13444,597,2,'Great is Your faithfulness!\nGreat is Your faithfulness!\nMorning by morning\n new mercies I See;\nAll I have needed\n Your hand has provided;\nGreat is Your faithfulness,\n Lord, unto me!');
INSERT INTO page VALUES (13445,597,6,'Great is Your faithfulness!\nGreat is Your faithfulness!\nMorning by morning\n new mercies I See;\nAll I have needed\n Your hand has provided;\nGreat is Your faithfulness,\n Lord, unto me!');
INSERT INTO page VALUES (13446,597,4,'Great is Your faithfulness!\nGreat is Your faithfulness!\nMorning by morning\n new mercies I See;\nAll I have needed\n Your hand has provided;\nGreat is Your faithfulness,\n Lord, unto me!');
INSERT INTO page VALUES (13447,597,3,'Summer and winter,\n and springtime and harvest,\nSun, moon and stars\n in their courses above\nJoin with all nature\n in manifold witness\nTo Your great faithfulness,\n mercy, and love.');
INSERT INTO page VALUES (13448,597,5,'Pardon for sin and\n a peace that endures,\nYour own dear presence\n to cheer and to guide;\nStrength for today and\n bright hope for tomorrow,\nBlessings all mine,\n with ten thousand beside!');
INSERT INTO page VALUES (13450,598,3,'All blessing,\n all honour belongs to You\nAll power,\n all wisdom is Yours');
INSERT INTO page VALUES (13451,598,2,'Holy is Your name is all the Earth\nRighteous are Your ways so merciful\nEverythng You\'ve done is just and true\nHoly, Holy Lord are You\nHoly, Holy Lord are You');
INSERT INTO page VALUES (13454,599,1,'Jehovah Jireh, my provider\nHis grace is sufficient for me\nFor me, for me\nJehovah Jireh, my provider\nHis grace is sufficient for me');
INSERT INTO page VALUES (13455,599,2,'My God shall supply all my needs\nAccording to his riches in glory\nHe gives his angels charge over me\nJehovah Jireh cares for me\nFor me, for me\nJehovah Jireh cares for me');
INSERT INTO page VALUES (13456,600,4,'             3\nThe role of Christ\n');
INSERT INTO page VALUES (13457,600,1,'Ethics of Reconciliation\n                      vs.\n      The Ministry of Reconciliation');
INSERT INTO page VALUES (13458,600,3,'            2\n God\'s priorities\nfor reconciliation');
INSERT INTO page VALUES (13459,600,2,'                  1\nA worldly point of view\n(that paul was avoiding)');
INSERT INTO page VALUES (13461,601,1,'I will lift my voice in worship,\nI will lift my voice in praise;\nI will sing of my redeemer\nI will celebrate His name');
INSERT INTO page VALUES (13462,601,3,'Come on and celebrate\nHis gift of love, we will celebrate\nThe Son of God who loved us\nAnd gave us life.\nWe\'ll shout Your praise, O King\nYou give us joy nothing else can bring\nWe\'ll give to You our offering\nIn celebration praise');
INSERT INTO page VALUES (13463,601,2,'I will lift my heart in worship,\nI will lift my heart in praise;\nI will sing of my redeemer\nI will celebrate His name');
INSERT INTO page VALUES (13464,545,4,'And you bought me\nAnd you sought me\nYour blood poured out for me\nA new creation in \n Your image, Oh Lord\nYou rescued me\nYou rescued me');
INSERT INTO page VALUES (13466,603,7,'In his humiliation he was deprived\nof justice. Who can speak of his\ndescendants? For his life was taken\nfrom the earth.\'\nThe eunuch asked Philip, \'Tell me,\nplease, who is the prophet talking about, \nhimself or someone else?\'\nThen Philip began with that very\npassage of Scripture and told him the\ngood news about Jesus.');
INSERT INTO page VALUES (13467,603,5,'and on his way home was sitting\nin his chariot reading the book of Isaiah\nthe prophet.\nThe Spirit told Philip, \'Go to that\nchariot and stay near it.\'\nThen Philip ran up to the chariot\nand heard the man reading Isaiah the\nprophet. \'Do you understand what you are\nreading?\' Philip asked.');
INSERT INTO page VALUES (13468,603,1,'    Baptism\n\nSylvia Collinson');
INSERT INTO page VALUES (13469,603,4,'Now an angel of the Lord said to\nPhilip, \'Go south to the road --the desert\nroad --that goes down from\nJerusalem to Gaza.\'\nSo he started out, and on his way\nhe met an Ethiopian eunuch, an\nimportant official in charge of all the\ntreasury of Candace, queen of the\nEthiopians. This man had gone to\nJerusalem to worship,\n');
INSERT INTO page VALUES (13470,603,2,'What different beliefs do\nChristians have about baptism?');
INSERT INTO page VALUES (13471,603,3,'Acts 8:26-39');
INSERT INTO page VALUES (13472,603,6,'\'How can I,\' he said, \'unless\nsomeone explains it to me?\' So he\ninvited Philip to come up and sit with\nhim.\nThe eunuch was reading this\npassage of Scripture: \'He was led like a\nsheep to the slaughter, and as a lamb\nbefore the shearer is silent, so he did\nnot open his mouth.');
INSERT INTO page VALUES (13473,603,12,'Who got baptised in\nthe New Testament?');
INSERT INTO page VALUES (13474,603,13,'Why be baptised? ');
INSERT INTO page VALUES (13475,603,8,'As they traveled along the road,\nthey came to some water and the\neunuch said, \'Look, here is water. Why\nshouldn\'t I be baptized?\'\nAnd he gave orders to stop the\nchariot. Then both Philip and the eunuch\nwent down into the water and Philip\nbaptized him.');
INSERT INTO page VALUES (13476,603,10,'What does our reading \ntell us about baptism?');
INSERT INTO page VALUES (13477,603,9,'When they came up out of the\nwater, the Spirit of the Lord suddenly\ntook Philip away, and the eunuch did not\nsee him again, but went on his way\nrejoicing.');
INSERT INTO page VALUES (13478,603,11,'<UL>\n<LI>Different beliefs about baptism -\n<LI>Makes part of God\'s family\n<LI>Parents make promises concerning\n children\n<LI>Part of God\'s covenant community\n<LI>Children included in parents\'\n relationship with God\n<LI>For (adult) believers\n<LI>Not necessary \n<LI>Can be for the dead');
INSERT INTO page VALUES (13479,604,1,'Here I stand forgiven\nHere I stand holy and righteous\nYou paid the price\nYou laid down your life\nJesus I surrender all');
INSERT INTO page VALUES (13480,604,3,'Hallelujah, Hallelujah, Hallelujah\nHallelujah, Hallelujah,\nHere I stand forgiven');
INSERT INTO page VALUES (13481,604,2,'And I\'ll walk with you in my heart\nI\'ll walk with you in my heart\nFind me at the cross\nDown on my knees\nThankyou Lord for saving me');
INSERT INTO page VALUES (13484,605,1,'These are the days of Elijah,\nDeclaring the word of the Lord;\nAnd these are the days of\n your servant Moses,\nRighteousness being restored;\nAnd though these are\n days of great trials,\nOf famine and darkness and sword.\nStill we are the voice\n in the desert crying,\n\"Prepare ye the way of the Lord.\"\n');
INSERT INTO page VALUES (13485,605,3,'And these are the days of Ezekiel,\nThe dry bones becoming flesh;\nAnd these are the days of\n your servant David,\nRebuilding a temple of praise;\nAnd these are the\n days of the harvest,\nThe fields are as white in the world.\nAnd we are the labourers\n in your vineyard,\nDeclaring the Word of the Lord.\n');
INSERT INTO page VALUES (13486,605,2,'Behold He comes,\n riding on the clouds,\nShining like the sun,\n at the trumpet call;\nLift your voice,\n it\'s the year of Jubilee\nAnd out of Zion\'s hill\n salvation comes.\n');
INSERT INTO page VALUES (13487,606,6,'WOMEN:\nShout to the north and the south,\nSing to the east and the west.\nJesus is Saviour to all,\n Lord of heaven and earth.');
INSERT INTO page VALUES (13488,606,4,'Shout to the north and the south,\nSing to the east and the west.\nJesus is Saviour to all,\n Lord of heaven and earth.');
INSERT INTO page VALUES (13489,606,1,'Men of faith,\nrise up and sing of the\n great and glorious king.\nYou are strong when \n you feel weak,\nin your brokenness,\n complete.\n');
INSERT INTO page VALUES (13490,606,3,'Rise up,\n women of the truth,\nstand and sing to broken hearts.\nWho can know\n the healing pow\'r of\n our awesome King of love?\n');
INSERT INTO page VALUES (13491,606,2,'Shout to the north and the south,\nSing to the east and the west.\nJesus is Saviour to all,\n Lord of heaven and earth.\n');
INSERT INTO page VALUES (13492,606,5,'We\'ve been through fire,\nwe\'ve been through rain,\nwe\'ve been refined by\n the pow\'r of his name.\nWe\'ve fallen deeper\n in love with you,\nyou\'ve burned the\n truth on our lips.');
INSERT INTO page VALUES (13493,607,1,'Beautiful, beautiful,\n Jesus is beautiful,\nAnd Jesus makes beautiful\n things of my life.\n\nCarefully touching me,\n causing my eyes to see,\nJesus makes beautiful\n things of my life.');
INSERT INTO page VALUES (13494,606,7,'Shout to the north and the south,\nSing to the east and the west.\nJesus is Saviour to all,\n Lord of heaven and earth.');
INSERT INTO page VALUES (13496,608,4,'Let every race and\n every language tell\nOf Him who saved our\n souls from death and hell.\n\nLift high the cross,\n the love of Christ proclaim,\nTill all the world adores\n His sacred name.');
INSERT INTO page VALUES (13497,608,1,'Lift high the cross,\n the love of Christ proclaim,\nTill all the world adores\n His sacred name.');
INSERT INTO page VALUES (13498,608,2,'Come Christians,\n follow where the captain trod,\nThe King victorious,\n Christ the Son of God.\n\nLift high the cross,\n the love of Christ proclaim,\nTill all the world adores\n His sacred name.');
INSERT INTO page VALUES (13499,608,3,'From north and south,\n from east and west they raise,\nIn growing unison\n their songs of praise.\n\nLift high the cross,\n the love of Christ proclaim,\nTill all the world adores\n His sacred name.');
INSERT INTO page VALUES (13500,608,5,'O Lord, once lifted\n on the tree of pain,\nDraw all the world to\n seek you once again.\n\nLift high the cross,\n the love of Christ proclaim,\nTill all the world adores\n His sacred name.');
INSERT INTO page VALUES (13501,606,8,'Rise up,\nchurch with broken wings,\n fill this place\n with songs again\nof our God who\n reigns on high,\n by his grace again we\'ll fly.\n');
INSERT INTO page VALUES (13511,611,1,'<UL><LI>FATHER ABRAHAM\n_________________</LI>\n<LI>* The Tower of Babel - Gen 11</LI>\n<LI>* The Scattering - Gen 11:9</LI>\n<LI>* To Haran - Gen 11:31</LI>\n<LI>* The Call - Gen 12:1-5</LI>\n<LI>* Promise of protection - Gen 15:1-6</LI>\n<LI>* Promise of a son - Gen 18</LI>\n<LI>* The test - Gen 22</LI><UL>');
INSERT INTO page VALUES (13502,456,4,'Your name is like\n honey on my lips\nYour Spirit like\n water to my soul\nYour word is a\n lamp unto my feet\nJesus I love You,\n I love You.\n(repeat)');
INSERT INTO page VALUES (13503,609,4,'And the harvest is ready,\nSo, I\'m telling everybody\nCome and join with us,\n the greatest thing on earth.\n');
INSERT INTO page VALUES (13504,609,1,'There\'s no place I\'d rather be,\nNothing better than your presence,\nIt\'s so easy to believe\n\'Cause I feel the power of heaven.');
INSERT INTO page VALUES (13505,609,3,'So thanks be unto Jesus\n Who always causes us to triumph.\nHe\'s given us power and strength\n We know will never end.');
INSERT INTO page VALUES (13506,609,2,'Lord, I\'m pressing in today,\nFor the purpose of your kingdom,\nGot my heart set on your ways,\nI\'ll be faithful to the end.');
INSERT INTO page VALUES (13507,609,5,'This is the church,\nWe are the church,\nWe are the bride of Christ,\nThe people of God,\nThe light of the world,\nVessels of truth and life.\n(repeat)');
INSERT INTO page VALUES (13508,610,1,'I will sing unto the Lord,\nFor He has triumphed gloriously\nThe horse and rider\n thrown into the sea\n(repeat)');
INSERT INTO page VALUES (13509,610,3,'The Lord is God and\n I will praise Him\nMy father\'s God\n and I will exalt Him\n(repeat)');
INSERT INTO page VALUES (13510,610,2,'The Lord my God,\n my strength,\n my song\nIs now become\n my victory\n(repeat)');
INSERT INTO page VALUES (13512,611,2,'<UL><LI>ABRAHAM IN THE NT\n__________________</LI>\n<LI>* The Gospel in advance - GAL 3:8</LI>\n<LI>* See also\n ROMANS 3:21, 4:1-5, 13, 16, 18</LI>\n<LI>* Raised from the dead - HEB 11:19</LI></UL>\n             ');
INSERT INTO page VALUES (13513,612,1,'Holy holy are You Lord\nThe whole earth is filled\nWith Your Glory\nLet the nations rise to give\nHonour and praise to Your name');
INSERT INTO page VALUES (13514,612,2,'Let Your face\nShine on us\nAnd the world will\n know You live');
INSERT INTO page VALUES (13542,617,1,'Thou are worthy, thou are worthy,\nThou are worthy O Lord\nTo receive glory, glory and honour\nGlory and honour and power\nFor Thou has created\nHast all things created\nThou hast created all things\nAnd for thy pleasure they are created\nThou are worthy O Lord');
INSERT INTO page VALUES (13516,612,4,'Holy holy are You Lord\nThe whole earth is filled\nWith Your Glory\nLet the nations rise to give\nHonour and praise to Your name');
INSERT INTO page VALUES (13518,612,3,'All the Heavens shout Your praise\nBeautiful is our God\nThe universe will sing\nHallelujah to You our King');
INSERT INTO page VALUES (13519,612,6,'All the Heavens shout Your praise\nBeautiful is our God\nThe universe will sing\nHallelujah to You our King\n(repeat)\n\nHallelujah to You our King (x2)');
INSERT INTO page VALUES (13520,612,5,'Let Your face\nShine on us\nAnd the world will\n know You live');
INSERT INTO page VALUES (13529,615,5,'Kingdom of Christ, for your coming we pray,\nHasten O Father, the dawn of the day\nWhen this new song Your creation shall sing,\nSatan is vanquished and Jesus is King.');
INSERT INTO page VALUES (13530,615,3,'Souls shall be saved from the burden of sin,\nDoubt shall not darken His witness within,\nHell has no terrors, and death has no sting;\nLove is victorious when Jesus is King.');
INSERT INTO page VALUES (13531,615,6,'Come let us sing: Praise to our King,\nJesus our King, Jesus our King:\nThis is our song, who to Jesus belong:\nGlory to Jesus, to Jesus our King.');
INSERT INTO page VALUES (13532,615,4,'Come let us sing: Praise to our King,\nJesus our King, Jesus our King:\nThis is our song, who to Jesus belong:\nGlory to Jesus, to Jesus our King.');
INSERT INTO page VALUES (13533,615,2,'Come let us sing: Praise to our King,\nJesus our King, Jesus our King:\nThis is our song, who to Jesus belong:\nGlory to Jesus, to Jesus our King.');
INSERT INTO page VALUES (13534,615,1,'Sing we the King who is coming to reign,\nGlory to Jesus, the Lamb that was slain.\nLife and salvation His empire shall bring.\nJoy to the nations when Jesus is King.');
INSERT INTO page VALUES (13537,616,1,'If I can help somebody\n as I pass along,\nIf I can cheer somebody\n with a word or song,\nIf I can show somebody\n He is trav\'ling wrong,\nThen my living shall not be in vain.');
INSERT INTO page VALUES (13538,616,2,'Then my living shall not be in vain,\nThen my living shall not be in vain,\nIf I can help somebody\n as I pass along,\nThen my living shall not be in vain.');
INSERT INTO page VALUES (13543,618,1,'All over the world\nThe Spirit is moving\nAll over the world\nAs the prophet said t\'would be\nAll over the world\nThere\'s a mighty revelation\nOf the glory of the Lord\nAs the waters cover the sea');
INSERT INTO page VALUES (13544,618,3,'Deep down in my heart\nThe Spirit is moving\nDeep down in my heart\nAs the prophet said t\'would be\nDeep down in my heart\nThere\'s a mighty revelation\nOf the glory of the Lord\nAs the waters cover the sea');
INSERT INTO page VALUES (13545,618,2,'All over the church\nThe Spirit is moving\nAll over the church\nAs the prophet said t\'would be\nAll over the church\nThere\'s a mighty revelation\nOf the glory of the Lord\nAs the waters cover the sea');
INSERT INTO page VALUES (13546,619,1,'With my hands lifted up\nAnd my mouth filled with praise\nWith a heart of thanksgiving\nI will bless thee O Lord\nI will bless thee O Lord\nI will bless thee O Lord\nWith a heart of thanksgiving\nI will bless thee O Lord');
INSERT INTO page VALUES (13547,620,1,'Into Thy presence we come\nNot by the works we have done\nBut by Thy grace and Thy grace alone\nInto Thy presence we come');
INSERT INTO page VALUES (13548,621,1,'There\'s a river of life\n flowing out from me\nMakes the lame to walk\n and the blind to see\nOpens prison doors,\n sets the captives free\nThere\'s a river of life\n flowing out from me');
INSERT INTO page VALUES (13549,622,1,'We worship and adore Thee\nBowing down before Thee\nSongs of praises singing\nHallelujahs ringing\nHallelujah, hallelujah\nHallelujah, Amen');
INSERT INTO page VALUES (13550,623,1,'Jesus breaks every fetter (x3)\nAnd He sets me free\n\nI will sing hallelujah (x3)\nFor He sets me free\n\nWe will give Him the glory (x3)\nFor He sets us free');
INSERT INTO page VALUES (13551,624,1,'It\'s a lovely, lovely name\nThe name of Jesus\nIt\'s a lovely, lovely name\nFrom heaven above\nDispelling the clouds of doubt and fear\nFilling the saddened heart with cheer\nIt\'s a lovely, lovely name\nThe name I love');
INSERT INTO page VALUES (13552,625,1,'He has shown thee O man what is good\nAnd what does the Lord require of thee?\nBut to do justly and to love mercy\nAnd to walk humbly with thy God');
INSERT INTO page VALUES (13554,627,1,'* Assets\n* Achievements\n* Amusements\n* Alternative Spiritualities');
INSERT INTO page VALUES (13553,626,1,'Come bless the Lord\nAll ye servants of the Lord\nWho stand by night\nIn the house of the Lord\nLift up your hands\nIn the holy place\nAnd bless the Lord\nAnd bless the Lord');
INSERT INTO page VALUES (13555,628,3,'Suffering servant, scorned, ill-treated,\nvictim crucified!\ndeath is through the cross defeated,\nsinners justified:\n Yours the glory and the crown,\n the high renown, the eternal name.');
INSERT INTO page VALUES (13556,628,4,'Priestly king, enthroned for ever\nhigh in heaven above!\nsin and death and hell shall never\nstifle hymns of love:\n Yours the glory and the crown,\n the high renown, the eternal name.');
INSERT INTO page VALUES (13557,628,1,'Christ triumphant, ever reigning,\nSaviour, Master, King!\nLord of heaven, our lives sustaining,\nhear us as we sing:\n Yours the glory and the crown,\n the high renown, the eternal name.');
INSERT INTO page VALUES (13558,628,2,'Word incarnate, truth revealing,\nSon of Man on earth!\npower and majesty concealing\nby your humble birth:\n Yours the glory and the crown,\n the high renown, the eternal name.');
INSERT INTO page VALUES (13559,628,5,'So, our hearts and voices raising\nthrough the ages long,\nceaselessly upon you gazing,\nthis shall be our song:\n Yours the glory and the crown,\n the high renown, the eternal name.');
INSERT INTO page VALUES (13560,629,3,'Good Christian men, rejoice\nWith heart and soul and voice!\nNow ye need not fear the grave:\nJesus Christ was born to save;\nCalls you one, and calls you all,\nTo gain His everlasting hall.\nChrist was born to save,\nChrist was born to save!');
INSERT INTO page VALUES (13561,629,1,'Good Christian men, rejoice\nWith heart and soul and voice!\nGive ye heed to what we say:\nJesus Christ is born today.\nMen and beast before Him bow,\nAnd He is in the manger now:\nChrist is born today,\nChrist is born today!');
INSERT INTO page VALUES (13562,629,2,'Good Christian men, rejoice\nWith heart and soul and voice!\nNow ye hear of endless bliss:\nJesus Christ was born for this.\nHe hath opened heaven\'s door,\nAnd man is blessed for evermore.\nChrist was born for this,\nChrist was born for this!');
INSERT INTO page VALUES (13563,630,1,'Hark! The herald angels sing,\n\"Glory to new-born King;\nPeace on earth, and mercy;\nGod and sinners reconciled.\"\n\nJoyful, all ye nations, rise,\nJoin the triumph of the skies,\nWth angelic hosts proclaim,\n\"Christ is born in Bethlehem!\"\n\nHark the herald angles sing,\n\"Glory to the new-born King.\"');
INSERT INTO page VALUES (13564,630,3,'Come, let us worship the King;\nJesus, the Saviour, is born.\nFor the Lord is great\n and greatly to be praised\nThrough all the earth.\nLet us worship the King.');
INSERT INTO page VALUES (13565,630,4,'Jesus shall reign where\'er the sun\nDoes his succesive journey run;\nHis Kingdom spread\n from shore to shore,\nTill moons shall wax and wane no more.\n\nHark the herald angles sing,\n\"Glory to the new-born King.\"');
INSERT INTO page VALUES (13566,630,2,'Come, let us worship the King;\nJesus, the Saviour is born.\nFor the Lord will reign\n over all the earth.\n(repeat)');
INSERT INTO page VALUES (13567,631,1,'The North-wind is tossing the leaves,\nThe red-dust is over the town;\nThe sparrows are under the eaves\nand the grass in the paddock is brown;\nAs we lift up our voices and sing\nTo the Christ-Child Heavenly King.');
INSERT INTO page VALUES (13568,631,2,'The tree-ferns in green gullies sway;\nThe cool stream flows silently by:\nThe joy-bells are greeting the day,\nAnd the chimes are adrift in the sky,\nAs we lift up over voices and sing\nTo the Christ-Child, the Heavenly king.');
INSERT INTO page VALUES (13569,632,3,'Why Shepherds?\nWhy Bethlehem?\nWhy a Saviour?');
INSERT INTO page VALUES (13570,632,1,'Why Shepherds?');
INSERT INTO page VALUES (13571,632,2,'Why Shepherds?\nWhy Bethlehem?');
INSERT INTO page VALUES (13675,653,1,'Christ for the world we sing\nThe world to Christ we bring\nWith loving zeal\nThe poor and them that mourn\nThe faint and overborne\nSin sick and sorrow worn\nWhom Christ doth heal');
INSERT INTO page VALUES (13586,408,4,'Jesus we remember\n this your birthday.\n(repeat)');
INSERT INTO page VALUES (13596,638,3,'O come, O come Emmanuel\nAnd cheer us by\n your kingly presence now\nMake straight the\n way that leads on high\nAnd open wide our heavenly home.\n');
INSERT INTO page VALUES (13597,638,4,'Rejoice! Rejoice! Emmanuel\nHas come to you,\nOn this the first Noel\n');
INSERT INTO page VALUES (13598,638,2,'Rejoice! Rejoice! Emmanuel\nHas come to you,\nOn this the first Noel\n');
INSERT INTO page VALUES (13599,638,1,'O come, O come, Emmanuel\nAnd ransom captive \'Israel\'\nWho mourn in lonely exile here\nUntil the Son of God appear\n');
INSERT INTO page VALUES (13600,639,1,'Emmanuel, Emmanuel,\nHis name is called Emmanuel.\nGod with us\nrevealed to us\nHis name is called\nEmmanuel');
INSERT INTO page VALUES (13601,640,3,'The shepherds look on,\nCreation\'s amazed,\nGod as a man:\nIt\'s Christmas.\nThey fall on their knees,\nAll glory to Him,\nJesus has come,\nIt\'s Christmas.');
INSERT INTO page VALUES (13602,640,4,'All glory to God in the highest,\nAll glory to Jesus the King,\nJesus has come,\nMay His name be heard.\nAll glory to God,\nIt\'s Christmas.');
INSERT INTO page VALUES (13603,640,5,'From a baby so small,\nTo a man on a cross,\nSalvation has come:\nIt\'s Christmas.\nI bow down my knee,\nI burst into song,\nAll glory to God,\nIt\'s Christmas.');
INSERT INTO page VALUES (13604,640,2,'All glory to God in the highest,\nAll glory to Jesus the King,\nJesus has come,\nMay His name be heard.\nAll glory to God,\nIt\'s Christmas.');
INSERT INTO page VALUES (13605,640,6,'All glory to God in the highest,\nAll glory to Jesus the King,\nJesus has come,\nMay His name be heard.\nAll glory to God,\nIt\'s Christmas.');
INSERT INTO page VALUES (13606,640,1,'A baby is born\nA life is given,\nOur king has come:\nIt\'s Christmas.\nJoy to the world,\nThe angels proclaim,\nOur Saviour has come,\nIt\'s Christmas.');
INSERT INTO page VALUES (13607,322,5,'High King of heaven,\nmy victory won,\nMay I reach heaven\'s joys,\nO bright heavens Son,\nHeart of my own heart,\nwhatever befall,\nStill be my vision,\nO Ruler of all.');
INSERT INTO page VALUES (13608,575,3,'Change my heart O God,\n make it ever true.\nChange my heart O God,\n may I be like you.');
INSERT INTO page VALUES (13609,641,1,'\"The purpose of Gosford City\nBaptist Church is that from a\ncornerstone of worship in\nJesus Christ, we are committed\nto service, discipleship and\nevangelism, which incorporates\nmission.\"');
INSERT INTO page VALUES (13610,642,2,'Hallelujah,\nHallelujah,\nHallelujah,\nHallelu, Hallelujah');
INSERT INTO page VALUES (13611,642,6,'Hallelujah,\nHallelujah,\nHallelujah,\nHallelu, Hallelujah');
INSERT INTO page VALUES (13612,642,1,'Seek ye first the kingdom of God,\nAnd His righteousness,\nAnd all these things shall\n be added unto you\nHallelu, Hallelujah');
INSERT INTO page VALUES (13613,642,5,'Ask and it shall be given unto you,\nSeek and you shall find,\nKnock and it shall\n opened unto you\nHallelu, Hallelujah');
INSERT INTO page VALUES (13614,642,3,'You shall not live by bread alone,\nBut by every word\nThat proceeds from\n the mouth of God,\nHallelu, Hallelujah');
INSERT INTO page VALUES (13615,642,4,'Hallelujah,\nHallelujah,\nHallelujah,\nHallelu, Hallelujah');

--
-- Table structure for table `playlist`
--

CREATE TABLE playlist (
  playorder INTEGER NOT NULL default '0',
  playlist INTEGER NOT NULL default '1',
  data varchar(50) NOT NULL default '',
  type varchar(4) default 'song',
  transition INTEGER default '0',
  PRIMARY KEY  (playorder)
) TYPE=MyISAM;

--
-- Dumping data for table `playlist`
--


--
-- Table structure for table `playlists`
--

CREATE TABLE playlists (
  id INTEGER NOT NULL default '1',
  title varchar(50) NOT NULL default '',
  ref varchar(50) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `playlists`
--

INSERT INTO playlists VALUES (1,'Main Playlist','');

