//
//  Lynkeos
//  $Id: MyImageListWindow.h,v 1.15 2005/01/27 23:03:52 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Sat Jan 17 2004.
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYIMAGELISTWINDOW_H
#define __MYIMAGELISTWINDOW_H

#ifdef GNUSTEP
#else
#import <Cocoa/Cocoa.h>
#endif

#include "MyImageListItem.h"
#include "MyObjectImageList.h"
#include "MyImageView.h"

typedef enum
{
   ListMode,
   AlignMode, Aligning,
   AnalyzeMode, Analyzing,
   StackMode, Stacking,
   ProcessMode
} MyImageListWindowState;

typedef enum
{
   DarkFrameMode,
   FlatFieldMode,
   ImageMode
} MyImageListWindowMode;

/*!
 * @class MyImageListWindow
 * @abstract The document window controler
 * @discussion This class controls the document window.
 *   It is the first responder for every user action,
 *   which are propagated to MyDocument.
 *   It has a direct read access to MyImageList and MyObjectImageList
 *   for optimisation purpose (document is still called for write accesses).
 *
 *    Its behaviour is controlled by its state :
 *     <ul>
 *    <li>ListMode : The list tab is selected,
 *    <li>AlignMode : The align tab is selected and no alignment is in progress,
 *    <li>Aligning : The align tab is selected and an alignment is in progress,
 *    <li>AnalyzeMode : The analyze tab is selected and no analyze is in 
 *    progress,
 *    <li>Analyzing : The analyze tab is selected and an analyze is in progress,
 *    <li>StackMode : The stack tab is selected and no stacking is in progress,
 *    <li>Stacking : The stack tab is selected and stacking is in progress,
 *    <li>ProcessMode : The process tab is selected.
 *     </ul>
 * @ingroup Controlers
 */
@interface MyImageListWindow : NSWindowController <MyImageViewDelegate>
{
@private
   // Related user interface objects
   // Views
   IBOutlet NSOutlineView*    _textView;
   IBOutlet NSTabView*	      _tabPane;
   IBOutlet MyImageView*      _imageView;
   IBOutlet NSPopUpButton*    _listMenu;
   // List tab
   IBOutlet NSButton*	      _plusButton;
   IBOutlet NSButton*	      _minusButton;
   IBOutlet NSButton*	      _prevButton;
   IBOutlet NSButton*	      _nextButton;
   IBOutlet NSButton*	      _toggleButton;
   // Alignment tab
   IBOutlet NSTextField       *_searchFieldX, *_searchFieldY;
   IBOutlet NSPopUpButton*    _searchSideMenu;
   IBOutlet NSButton*	      _refCheckBox;
   IBOutlet NSButton*	      _alignButton;
   // Analyze tab
   IBOutlet NSTextField       *_analyzeFieldX, *_analyzeFieldY;
   IBOutlet NSPopUpButton*    _analyzeSideMenu;
   IBOutlet NSButton*	      _analyzeButton;
   IBOutlet NSPopUpButton*    _analyzeMethodMenu;
   IBOutlet NSSlider*	      _selectThresholdSlide;
   IBOutlet NSTextField       *_minQualityText, *_maxQualityText;
   // Stack tab
   IBOutlet NSTextField       *_cropX, *_cropY, *_cropW, *_cropH;
   IBOutlet NSButton	      *_doubleButton, *_monoStackButton;
   IBOutlet NSButton	      *_stackButton;
   // Process tab
   IBOutlet NSSlider	      *_deconvRadius, *_deconvThreshold;
   IBOutlet NSSlider	      *_unsharpRadius, *_unsharpGain;
   IBOutlet NSSlider	      *_blackLevel, *_whiteLevel;
   IBOutlet NSTextField       *_deconvTextRadius, *_deconvTextThreshold;
   IBOutlet NSTextField       *_unsharpTextRadius, *_unsharpTextGain;
   IBOutlet NSTextField       *_blackTextLevel, *_whiteTextLevel;
   
   // Window state
   MyImageListWindowMode      _windowMode;
   MyImageListWindowState     _windowState;
   MyImageListItem*	      _highlightedItem;
   u_short		      _sideMenuLimit;
   bool                       _processImageUpdate;
   bool                       _fillSideArmed;
   double                     _minQuality, _qualityScale;
   
   // document contents (optimisation to jump over a redirection for reads,
   //			 document is still called for writing)
   MyImageList*               _currentList;
}

/// \name Accessors
/// Read and write accessors to the class attributes
//@{
- (MyImageListWindowMode) windowMode ;
- (MyImageListWindowState) windowState ;
- (MyImageListItem*) highlightedItem ;

- (void) setWindowState :(MyImageListWindowState)state ;
//@}

/// \name Actions
///Actions comming from the document controller
//@{
- (void) refreshOutline ;
- (void) highlightItem :(MyImageListItem*)item ;

   // GUI updating
- (void) updateSidePopup ;
- (void) updateAlignControls ;

- (void) addFiles :(NSArray*)files ;
//@}

/// \name Outline
/// Outline view management
//@{
- (void) outlineViewSelectionDidChange :(NSNotification*)aNotification;

- (id) outlineView:(NSOutlineView *)outlineView child:(int)index 
            ofItem:(id)item;
- (BOOL) outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item;
- (int) outlineView:(NSOutlineView *)outlineView
        numberOfChildrenOfItem:(id)item;
- (id) outlineView:(NSOutlineView *)outlineView 
       objectValueForTableColumn:(NSTableColumn *)tableColumn
            byItem:(id)item;
- (void)outlineView:(NSOutlineView *)outlineView setObjectValue:(id)object
     forTableColumn:(NSTableColumn *)tableColumn byItem:(id)item;
//@}

/// \name TabView
/// Tab view management
//@{
- (void)tabView:(NSTabView *)tabView 
        didSelectTabViewItem:(NSTabViewItem *)tabViewItem;
//@}

/// \name GUIActions
/// Actions which are target of NIB objects
//@{
   // Control actions
- (void) searchSquareChange :(id)sender ;
- (void) analyzeSquareChange :(id)sender ;
- (void) analyzeMethodChange :(id)sender ;
- (void) cropRectangleChange :(id)sender ;

   // Buttons or menu actions
- (void) modeMenuAction :(id)sender ;
- (void) addAction :(id)sender ;
- (void) deleteAction :(id)sender ;
- (void) referenceAction :(id)sender ;
- (void) toggleEntrySelection :(id)sender ;
- (void) highlightNext :(id)sender ;
- (void) highlightPrevious :(id)sender ;
- (void) doubleButtonAction :(id)sender ;
- (void) monochromeButtonAction :(id)sender ;
- (void) alignAction :(id)sender ;
- (void) autoSelectAction :(id)sender ;
- (void) analyzeAction :(id)sender ;
- (void) stackAction :(id)sender ;
- (void) postProcessAction :(id)sender ;
- (void) changeLevelsAction : (id)sender ;
//@}

@end

#endif
