<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007 Finn-Arne Johansen <faj@bzz.no> BzzWare AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

require_once ("createlm.php"); 

function loadConfig () {
    global $domain, $base, $ldaphost, $homelocation, $useLisGroup, 
           $groupbase, $authbase, $hostbase, $netgroupbase,
           $automountbase, $variablesbase,
           $groupprefix, $authprefix, $hostprefix, $netgroupprefix,
           $automountprefix, $variablesprefix,
           $minPwLength, $minPwUpper, $minPwLower, $minPwNumber,
           $allowPwSet, $smarty_templ, $smarty_compile ; 

    @include_once ("/etc/lwat/config.php"); 

    if (empty ($domain))         $domain         = $_COOKIE ['domain'] ; 
    if (empty ($ldaphost))       $ldaphost       = $_COOKIE ['ldaphost'] ; 
    if (empty ($base))           $base           = $_COOKIE ['base'] ; 
    if (! isset ($useLisGroup))  $useLisGroup    = $_COOKIE ['useLisGroup'] ;
    if (empty ($groupprefix))    $groupprefix    = $_COOKIE ['groupprefix'] ;
    if (empty ($authprefix))     $authprefix     = $_COOKIE ['authprefix'] ;
    if (empty ($hostprefix))     $hostprefix     = $_COOKIE ['hostprefix'] ;
    if (empty ($netgroupprefix)) $netgroupprefix = $_COOKIE ['netgroupprefix'] ;
    if (empty ($variablesprefix)) $variablesprefix = $_COOKIE ['variablesprefix'] ;
    if (empty ($automountprefix)) $automountprefix = $_COOKIE ['automountprefix'] ;
    if (empty ($homelocation))   $homelocation   = $_COOKIE ['homelocation'] ;
    if (empty ($minPwLength))    $minPwLength    = $_COOKIE ['minPwLength'] ;
    if (empty ($minPwUpper))     $minPwUpper     = $_COOKIE ['minPwUpper'] ;
    if (empty ($minPwLower))     $minPwLower     = $_COOKIE ['minPwLower'] ;
    if (empty ($minPwNumber))    $minPwNumber    = $_COOKIE ['minPwNumber'] ;
    if (empty ($allowPwSet))     $allowPwSet     = $_COOKIE ['allowPwSet'] ;
    if (empty ($smarty_templ))   $smarty_templ   = $_COOKIE ['smarty_templ'] ;
    if (empty ($smarty_compile)) $smarty_compile = $_COOKIE ['smarty_compile'] ;

    if (empty ($domain)) {
	$domain = debconf_get("lwat/domain") ;
	if (empty ($domain)) 
	    $domain = debconf_get("slapd/domain") ; 
	if (empty ($domain)) 
	    $domain = debconf_get("postfix/mailname") ;
	if (empty ($domain)) 
	    $domain = debconf_get("shared/mailname") ; 
	if (empty ($domain))
	    $domain = exec ('hostname -d') ;
	if (empty ($domain))
	    $domain = 'example.net' ; 
	setcookie ('domain', $domain) ; 
    }

    if (empty ($ldaphost)) {
	$ldaphost = debconf_get("shared/ldapns/ldap-server") ; 
	if (empty ($ldaphost)) 
	    $ldaphost = "ldap";
	setcookie ('ldaphost', $ldaphost) ; 
    }

    if (empty ($base)) {
	$base = debconf_get("shared/ldapns/base-dn") ; 
	if (empty ($base)) 
	    $base = debconf_get("shared/organization") ; 
	if (empty ($base)) {
	    $base_array = split ('.', $domain) ; 
	    $base = 'dc=' . $base_array[0] ; 
	    for ($i = 1 ; $i < count($base_array) ; $i++) 
                $base .= ",dc=" . $base_array[$i] ; 
        }
        setcookie ('base', $base) ; 
    }

    if (empty ($groupprefix)) {
	$groupprefix = debconf_get("lwat/groupprefix") ; 
	if (empty ($groupprefix))
	    $groupprefix = "ou=Group" ;
        setcookie ('groupprefix', $groupprefix) ; 
    }
    
    if (! isset ($useLisGroup) && empty ($authprefix)) {
        $useLisGroup = debconf_get ("lwat/uselisgroup") ; 
	if (! isset ($useLisGroup)) {
	    $ldap=@ldap_connect ($ldaphost); 
	    ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
	    $bind = @ldap_bind ($ldap) ;
	    $filter = '(objectClass=lisAclGroup)' ; 
	    $want = array ("cn") ; 
	    $result = @ldap_search ($ldap, $base, $filter, $want) ; 
	    if (@ldap_count_entries ($ldap, $result))
		$useLisGroup = true ;
            else
		$useLisGroup = false ;
	}

        setcookie ('useLisGroup', $useLisGroup) ; 
    }

    if (! $useLisGroup) {
	if (empty ($authprefix)) {
	    $authprefix = debconf_get("lwat/authprefix") ;
	    if (empty ($authprefix)) 
		$authprefix = "ou=AuthGroup" ;
	    setcookie ('authprefix', $authprefix) ; 
	}
    }
    
    if (empty ($hostprefix)) {
        $hostprefix = debconf_get("lwat/hostprefix") ; 
	if (empty ($hostprefix))
	    $hostprefix = "ou=Hosts" ;
        setcookie ('hostprefix', $hostprefix) ; 
    }

    if (empty ($netgroupprefix)) {
        $netgroupprefix = debconf_get("lwat/netgroupprefix") ; 
	if (empty ($netgroupprefix))
	    $netgroupprefix = "ou=Netgroup" ;
        setcookie ('netgroupprefix', $netgroupprefix) ; 
    }
    
    if (empty ($variablesprefix)) {
        $variablesprefix = debconf_get("lwat/variablesprefix") ; 
	if (empty ($variablesprefix))
	    $variablesprefix = "ou=variables" ;
        setcookie ('variablesprefix', $variablesprefix) ; 
    }

    if (empty ($automountprefix)) {
        $automountprefix = debconf_get("lwat/automountprefix") ; 
	if (empty ($automountprefix))
	    $automountprefix = "ou=Automount" ;
        setcookie ('automountprefix', $automountprefix) ; 
    }

    if (empty ($homelocation)) {
        $homelocation = debconf_get ("lwat/homedirlocation") ; 
	if (empty ($homelocation))
	    $homelocation = "/home" ;
        setcookie ('homelocation', $homelocation) ; 
    }

    if (empty ($minPwLength)) {
        $minPwLength = debconf_get ("lwat/minPwLength") ; 
	if (empty ($minPwLength))
	    $minPwLength = 5 ;
        setcookie ('minPwLength', $minPwLength) ; 
    }
    
    if (empty ($minPwUpper)) {
        $minPwUpper = debconf_get ("lwat/minPwUpper") ; 
	if (empty ($minPwUpper))
	    $minPwUpper = 1 ;
        setcookie ('minPwUpper', $minPwUpper) ; 
    }

    if (empty ($minPwLower)) {
        $minPwLower = debconf_get ("lwat/minPwLower") ; 
	if (empty ($minPwLower))
	    $minPwLower = 1 ;
        setcookie ('minPwLower', $minPwLower) ; 
    }

    if (empty ($minPwNumber)) {
        $minPwNumber = debconf_get ("lwat/minPwNumber") ; 
	if (empty ($minPwNumber))
	    $minPwNumber = 1 ;
        setcookie ('minPwNumber', $minPwNumber) ; 
    }

    if (empty ($allowPwSet)) {
        $allowPwSet = debconf_get ("lwat/allowPwSet") ; 
	if (empty ($allowPwSet))
	    $allowPwSet = false ;
        setcookie ('allowPwSet', $allowPwSet) ; 
    }

    if (empty ($smarty_templ)) {
        $smarty_templ = debconf_get ("lwat/smarty_templ") ; 
	if (empty ($smarty_templ)) 
	    $smarty_templ = realpath ("../templates") ;
        setcookie ('smarty_templ', $smarty_templ) ; 
    }

    if (empty ($smarty_compile)) {
        $smarty_compile = debconf_get ("lwat/smarty_compile") ; 
	if (empty ($smarty_compile))
	    $smarty_compile = "/var/spool/lwat" ;
	if (! is_dir ($smarty_compile))
	    $smarty_compile = "/var/tmp" ; 
        setcookie ('smarty_compile', $smarty_compile) ; 
    }
    
    if (empty($groupprefix)) $groupbase = $base ; 
    else $groupbase = $groupprefix . "," . $base ; 
    if (empty($authprefix)) $authbase = $base ; 
    else $authbase = $authprefix . "," . $base ; 
    if (empty($hostprefix)) $hostbase = $base ; 
    else $hostbase = $hostprefix . "," . $base ; 
    if (empty($netgroupprefix)) $netgroupbase = $base ; 
    else $netgroupbase =  $netgroupprefix . "," . $base ; 
    if (empty($variablesprefix)) $variablesbase = $base ; 
    else $variablesbase = $variablesprefix . "," . $base ; 
    if (empty($automountprefix)) $automountbase = $base ; 
    else $automountbase = $automountprefix . "," . $base ; 
}

function debconf_get($lookup) {
    global $debconf ; 

    if (empty ($debconf)) {
	$debconffile = file ('/var/cache/debconf/config.dat') ; 
	$debconf = array () ; 
	$debconfentry = array () ; 
	for ($i = 0 ; $i < count($debconffile) ; $i++) {
	    $debconfline = trim($debconffile[$i]) ; 
	    if ($debconfline == '') {
		$debconf[$debconfentry["Name"]]["Value"] = $debconfentry["Value"] ; 
		$debconf[$debconfentry["Name"]]["Owners"] = $debconfentry["Owners"] ; 
		$debconfentry = array () ; 
	    } else {
		list ($key, $value) = split (':', $debconfline, 2) ; 
		$debconfentry[$key] = trim($value) ; 
	    }
	}
    }
    return ($debconf[$lookup]["Value"]) ; 
}

function loadLocale () {
    $found_locale = $_COOKIE['locale'] ;
    
    if ($found_locale == "" && $handle = @opendir ('../locales')) {
	$all_locales = array () ; 
	while (false !== ($file = readdir ($handle))) {
	    if (is_dir ('../locales/' . $file . '/LC_MESSAGES')) {
		$all_locales = array_merge ($all_locales, array ($file)) ; 
	    }
	}
	closedir ($handle) ; 
	$lang_accept = array () ; 
	$lang_accept = explode (",", $_SERVER['HTTP_ACCEPT_LANGUAGE']); 
	for ($i = 0 ; $i < count ($lang_accept) ; $i++ ) {
	    $lang_accept[$i] = split(";", $lang_accept[$i]) ; 
	    $lang_accept[$i] = $lang_accept[$i][0] ; 
	}
	if (!empty($lang_accept[0]))
	foreach ($lang_accept as $lang) {
	    if (!isset ($locale_exact)) {
		foreach ($all_locales as $locales) {
		    if ($locales == $lang)
			$locale_exact = $lang ; 
		    elseif (!isset ($locale_match)) {
			if (strpos ($locales, $lang) === 0)
			    $locale_match = $locales ; 
		    }
		}
	    }
	}
	if (isset ($locale_exact)) 
	    $found_locale=$locale_exact ; 
	elseif (isset ($locale_match))
	    $found_locale=$locale_match ; 
	if (isset ($found_locale))
	    setcookie ( 'locale', $found_locale) ;
	unset ($all_locales, $lang_accept, $locale_match, $locale_exact, $lang, $locales) ; 
    }
	
    if (isset ($found_locale)) {
        $locale = setlocale (LC_ALL, $found_locale) ; 
	if (empty($locale)) 
	    setlocale (LC_ALL, $found_locale . ".UTF8"); 
	bindtextdomain ("lwat", "../locales/"); 
	bind_textdomain_codeset ("lwat", "UTF-8");
	textdomain ("lwat"); 
    }
    header('Content-Type: text/html; charset=UTF-8') ;
}

function xorstring ($key, $xor) {
    $keylen=strlen ($key) ; 
    if (! $keylen) return "" ; 
    $newstr="" ; 
    $index=0 ; 
    $keyindex = $index ;
    while ($index < strlen ($xor)) {
        $newstr .= chr(ord($xor[$index]) ^ ord ($key[$keyindex])) ; 
        $index ++ ;
        $keyindex= $index % $keylen ;
    }
    if ($keyindex == 0) {
        $last=strpos ($newstr, chr(0)); 
        if ($last === false) { 
            return $newstr ;
        }
        return(substr ($newstr, 0, $last)) ; 
    }
    while ($keyindex != 0) {
        $newstr .= $key[$keyindex] ; 
        $index ++ ;
        $keyindex= $index % $keylen ;
    }
    return ($newstr) ;
}

function readKey ($key) {
    return htmlspecialchars(trim($_POST[$key])) ; 
}

function debug ($mixed) {
    echo "<pre>\n" ; 
    print_r ($mixed);
    echo "\n</pre>\n" ; 
}

function pwgen(){
    $pw = '';
    $c  = 'bcdfghjkmnprstvwzBCDFGHJKLMNPQRSTVW'; //consonants except hard to speak ones
    $v  = 'aeiouAEU';              //vowels
    $a  = $c.$v;                //both

    //use two syllables...
    for($i=0;$i < 2; $i++){
        $pw .= $c[rand(0, strlen($c)-1)];
        $pw .= $v[rand(0, strlen($v)-1)];
        $pw .= $a[rand(0, strlen($a)-1)];
    }
    //... and add a nice number
    $pw .= rand(10,99);

    return $pw;
}

function cryptgen($clear){
//prepare a salt
    $salt = md5(uniqid(rand(), true));

    $salt=substr($salt,0,4);
    return '{SSHA}'.base64_encode(pack("H*", sha1($clear.$salt)).$salt);
}

function getnextid ($connect) {
    global $variablesbase, $base ; 

    $looped = false ; 
    $want= array ("gidNumber", "uidNumber");
    $filter = "(&(gidNumber=*)(cn=nextID))" ;
    $result= @ldap_search ($connect, "ou=Variables," . $base, $filter, $want);
    $nextID=0 ;
    if ($result) {
        $entries = ldap_get_entries ($connect, $result) ;
        if ($entries["count"]) 
            $nextID=$entries[0]["gidnumber"][0]  ; 
    }
    do {
        if ($nextID < 10000) $nextID=10000 ;
        else if ($nextID > 59999) {
            if ($looped) {
                die ('Sorry, all user id\'s between 10000 and 59999 seems to have been taken') ;
            } else {
                $looped = true ;
                $nextID=10000 ; 
            }
        } 
	$filter = "(&(|(gidNumber=$nextID)(uidNumber=$nextID))(!(cn=nextID)))" ;
	$result= @ldap_search ($connect, $base, $filter, $want);
	$entries = @ldap_get_entries ($connect, $result) ;
	if ($entries["count"] > 0) $nextID++ ;
    } while  ($entries["count"]) ; 
    $info=array () ;
    $info["objectClass"] = array ("top", "posixGroup") ;
    $info["gidnumber"] = $nextID + 1 ;
    $info["cn"] = "newID" ;
    if (@ldap_add ($connect,"cn=newID," . $variablesbase,$info)) {
        @ldap_delete ($connect,"cn=nextID," . $variablesbase) ;
        @ldap_rename ($connect,"cn=newID," . $variablesbase, "cn=nextID", $variablesbase, true) ;
        return $nextID ;
    } 
    die ("ERROR: Unable update nextID") ;
}

function get_sn ($newname) {
    $sn="" ;
    $allnames = explode (" ", $newname) ;
    foreach ($allnames as $name) {
        $sn=$name ;
    }
    return $sn;
}

function chk_username ($connect, $username, $excludes)  {
    global $base ;

    $filter = "(|(uid=$username)(cn=$username))" ;
    $result= ldap_search ($connect, $base, $filter);
    $entries = ldap_get_entries ($connect, $result) ;

    if ($entries["count"])
	return "" ;

    if (is_array($excludes)) {
        $result = in_array ($username, $excludes) ;  
        if ($result)
	    return "" ;
    }
    return $username ;
}
function get_username ($connect, $newname, $excludes = NULL)  {
    global $base ;

    $charset = mb_detect_encoding ($newname, 'UTF-8, ISO-8859-1') ; 
    switch ($charset) {
        case 'ISO-8859-1':
            $basename = $newname ; 
            break ; 
        default:
            $basename = mb_convert_encoding ($newname, 'ISO-8859-1', $charset); 
            break ;
    }
    for ($i=0 ; $i < strlen($basename); $i++) {
        switch (ord($basename[$i])) {
            case 192: case 193: case 194: case 195: case 196: case 197:
                $basename[$i] = "A" ; 
                break ;
            case 199:
                $basename[$i] = "C" ; 
                break ;
            case 198: case 200: case 201: case 202: case 203:           
                $basename[$i] = "E" ; 
                break ;
            case 204: case 205: case 206: case 207:              
                $basename[$i] = "I" ;
                break ;
            case 209 :                          
                $basename[$i] = "N" ;
                break ;
            case 208: case 210: case 211: case 212: case 213: case 214: case 216 :  
                $basename[$i] = "O" ; 
                break ;
            case 217: case 218: case 219: case 220 :              
                $basename[$i] = "U" ; 
                break ;
            case 221 :                          
                $basename[$i] = "Y" ; 
                break ;
            case 222 :                          
		$basename[$i] = "P" ; 
		break ;
            case 223 :                          
		$basename[$i] = "I" ; 
		break ;
            case 224: case 225: case 226: case 227: case 228: case 229 :
		$basename[$i] = "a" ; 
		break ;
            case 231 : 
		$basename[$i] = "c" ; 
		break ;
            case 230: case 232: case 233: case 234: case 235 :
		$basename[$i] = "e" ; 
		break ;
            case 236: case 237: case 238: case 239 :
		$basename[$i] = "i" ; 
		break ;
            case 241 : 
		$basename[$i] = "n" ; 
		break ;
            case 240: case 242: case 243: case 244: case 245: case 246: case 248 :  
		$basename[$i] = "o" ; 
		break ;
            case 249: case 250: case 251: case 252 : 
		$basename[$i] = "u" ; 
		break ;
            case 253: case 255 : 
		$basename[$i] = "y" ; 
		break ;
            case 254 :   
		$basename[$i] = "p" ; 
		break ;
	}
    }
    $basename = strtolower ($basename) ;
    $allnames = preg_split ("/[\s,.-]+/", $basename) ;
    $firstname = $allnames[0] ;
    foreach ($allnames as $name) $lastname=$name ;
    $bigname = substr ($firstname, 0,3) . substr ($lastname, 0,3) ; 
    $username = chk_username ($connect, $bigname, $excludes);
    if (!empty($username)) 
	return $username ;
    $loop="aeiouy" ;
    while (ereg ("[aeiouy]", $loop)) {
        $restname="" ;
        for ($i=1 ; $i < (count($allnames)); $i++)
	    $restname .= $allnames[$i] . " " ; 
	while (ereg ("[aeiouy]", $loop)) {
	    for ($count=1 ; $count <= 6 ; $count++ ) {
		$addname="" ;
		foreach (explode (" ", $restname) as $name)
		    $addname .= substr ($name, 0, $count);
		while (strlen ($addname) > 6)
		    $addname=substr($addname, $count);
		$username= chk_username($connect, substr($firstname,0,8 - strlen($addname)) . $addname, $excludes) ; 
		if (!empty($username)) 
		    return $username ;
	    }
	    $length=strlen($restname);
	    $loop="" ;
	    while ($length--) {
		switch ($restname[$length]) {
		    case "a": case "e": case "i": case "o": case "u": case "y":
			$loop=$restname[$length] ;
			$restname=substr($restname, 0,$length) . substr($restname, $length + 1) ;
			$length = 0 ;
			break ;
		}
	    }
	    $length=strlen($firstname);
	    $loop="" ;
	    while ($length--) {
		switch ($firstname[$length]) {
		    case "a": case "e": case "i": case "o": case "u": case "y":
			$loop=$firstname[$length] ;
			$firstname=substr($firstname, 0,$length) . substr($firstname, $length + 1) ;
			$length = 0 ;
			break ;
		}
	    }
	}
    }
    for ($i=0 ; $i < 100 ; $i++) {
        $username = chk_username ($connect,
                                  sprintf ("%s%02d", $bigname, $i), 
                                  $excludes) ; 
        if (! empty($username)) return $username ; 
    }
    echo "Sorry, I'm unable to generate a unique username for $newname<BR>";
    return "" ;
}

function get_givenName ($newname) {
    $last="" ; 
    foreach (explode (" ", $newname) as $value) {
        $givenName .= $last ;
        $last = "$value" . " " ;
    }
    if (! $givenName) $givenName=$last ;
    return $givenName ;
}

function get_sambasid ($connect, $userid) {
    global $base ;
    $want= array ("sambasid");
    $filter = "(objectClass=sambaDomain)" ;
    $result= ldap_search ($connect, $base, $filter, $want);
    if (! $result) {
        echo "Failed to search for sambaSID<BR>" ;
        return "" ;
    }
    $entries = ldap_get_entries ($connect, $result) ;
    if ($entries["count"] <> 1) {
        echo "I'm confused. There is not one sambaDomain and one only in ldap<BR>" ;
        return "" ;
    }
    $sambaSID=$entries[0]["sambasid"][0] . sprintf("-%d", $userid * 2 + 1000)  ; 
    return $sambaSID ;
}

function ldapAddUser ($ldap, $cn, $template, $username, $userpw, $groups) {
    global $groupbase, $base, $domain, $useLisGroup ; 

    $templates = parse_ini_file ('/etc/lwat/admin.ini', true) ; 
    $template = $templates[$template] ;
    $sn = get_sn ($username) ;
    $userid = getnextid ($ldap) ;
    $userldif['uidNumber'] = $userid ;
    $userldif['gidNumber'] = $userid ;
    $userldif['uid'] = $username ;
    $userldif['cn'] = $cn ;
    $userldif['userPassword'] = cryptgen($userpw) ;
    if ($useLisGroup === true) {
	$groupldif["objectClass"] = array ("top", "posixGroup", 'lisGroup') ; 
	$groupldif["groupType"] = "private" ;
    } else
	$groupldif["objectClass"] = array ("top", "posixGroup") ; 
    $groupldif["cn"] = $username ; 
    $groupldif["gidNumber"] = $userid ;
    $groupldif["description"] = "$cn personal group" ;
    $replace=array("%username%", "%base%", "%domain%", "%sn%") ;
    $replacewith =array($username, $base, $domain, $sn) ;
    foreach ($template as $key => $value) {
        $value = str_replace ($replace, $replacewith, $value) ;
        switch ($key) {
             case "ou":
                 $ou=$value ;
                 break ;
             case "groups":
                 if (is_array ($groups)) 
		     $groups = array_merge ($groups, explode (" ", $value)) ;
		 else
		     $groups =  explode (" ", $value) ;
                 break ;
             case "objectClass":
                 $userldif['objectClass'] = explode (" ", $value); 
                 break ;
             default:
                 $userldif[$key] = $value ;
                 break ;
        }
    }
    if (in_array ('sambaSamAccount',$userldif['objectClass'])) 
        $userldif = (array_merge($userldif, sambaAddInfo ($ldap, $userldif, $userpw))) ;
    if (!ldap_add($ldap, "uid=" . $username . "," . $ou, $userldif)) {
        debug (array_merge(array ('dn' => "uid=" . $username . "," . $ou), $userldif)) ;
        return ; 
    }
    if ($useLisGroup) $ou=$groupbase ;
    if (!ldap_add($ldap, "cn=" . $username . "," . $ou, $groupldif)) {
        debug (array('dn' => "cn=" . $username . "," . $ou, 'groupldif' => $groupldif)) ;
        return ;
    }
    $nogroup = array () ; 
    foreach ($groups as $group) {
        $filter="(&(objectClass=posixGroup)(cn=" . $group . "))";
        $want = array ('gidNumber'); 
        $result = ldap_search($ldap, $groupbase, $filter, $want);
        $entries = ldap_get_entries ($ldap, $result);
        $gid= $entries[0]['gidnumber'][0] ;
        if (!userAddGroup ($ldap, $username, $gid)) 
            $nogroup[] = $group ; 
    }
    if (empty($nogroup)) return ; 
    foreach ($nogroup as $group) {
        $pos = in_array ($group, $groups) ; 
        if (isset ($pos)) 
           array_splice ($groups, $pos - 1  , 1) ; 
    }
}

function sambaAddInfo ($ldap, $userldif, $userpw) {
    $sambahash = new smbHash () ;
    $sambaldif = array ()  ;
    $sambaldif['sambaSID'] = get_sambasid ($ldap, $userldif['uidNumber']) ;
    $sambaldif["sambaAcctFlags"] = "[U          ]" ;
    $sambaldif["sambaLMPassword"] = $sambahash->lmhash($userpw) ; 
    $sambaldif["sambaNTPassword"] = $sambahash->nthash($userpw) ; 
    return $sambaldif ;
}

function userAddGroup ($ldap, $uid, $gid) {
    global $groupbase, $base ; 
    $filter="(&(objectClass=posixGroup)(gidNumber=" . $gid . "))";
    $want = array ('cn'); 
    $searchbase=$groupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $groupdn=$entries[0]["dn"] ; 
    $cn=$entries[0]["cn"][0] ; 
    $change = array (); 
    $change["memberUid"][] = $uid ; 
    if (!@ldap_mod_add($ldap, $groupdn, $change))
        return false ; 
    $filter="(&(member=*)(cn=" . $cn . "))";
    $result = ldap_search($ldap, $base, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $groupdn=$entries[0]["dn"] ; 
    $change = array (); 
    if ($entries[count]) {
        $want = array (); 
	$filter="(&(objectClass=posixAccount)(uid=" . $uid  ."))";
	$result = ldap_search($ldap, $base, $filter, $want);
	$entries = ldap_get_entries ($ldap, $result) ; 
	$change["member"][] = $entries[0]["dn"] ; 
	@ldap_mod_add($ldap, $groupdn, $change) ;
    }
    return true ; 
    
}


?>
