/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : weapon.h
 * Description : Weapon code
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef L_WEAPON_H
#define L_WEAPON_H

#include "SDL.h"
#include "vector.h"
#include "weapon.h"

typedef enum {Noproj,Decor,FireStarter,Handgun,Napalm,Cannon,Grenade,MegaBomb,
	Missile,MagMine,Mine,Claybomb,Plastique,
	Snowball,Landmine,Spear,GravityWell,
	Zap,Rocket,Energy,Boomerang,
	DividingMine,Tag,Mush,Waterjet,
	Ember,Acid,Mirv,MagWave} ProjectileType;

typedef enum {WCannon,WGrenade,WMegaBomb,WShotgun,
	WMissile,WCloak,WMagMine,
	WMine,WShield,WGhostShip,
	WAfterBurner,WWarp,
	WClaybomb,WPlastique,WSnowball,
	WDart,WLandmine,WRepair,
	WInfantry,WHelicopter,WSpeargun,
	WGravGun,WGravMine,WZapper,
	WRocket,WEnergy,WBoomerang,
	WRemote,WDivide,WTag,WMush,
	WWatergun,WEmber,WAcid,WMirv,
	WFlame,WEMP,WAntigrav} WeaponType;

#define WeaponCount 38

/* Define types for the standard weapons  */
typedef enum {SShot, S3ShotWide, S3ShotTight, SSweep,S4Way} SWeaponType;
#define SWeaponCount 5

typedef struct {
  int x;
  int y;
  Vector vector;
  Vector *gravity;
  char wind_affects;
  float angle;
  double maxspeed;
  Uint32 color;
  ProjectileType type;
  signed char owner;
  unsigned char primed;
  Uint16 var1;
  int life;
} Projectile;

/* Linked list containing all projectiles */
struct Projectile_list {
  Projectile *projectile;
  struct Projectile_list *next;
  struct Projectile_list *prev;
};

/* Initialization */
extern void init_weapons(void);
extern void deinit_weapons(char just_clear);
extern void set_hole_size(Uint8 size);

/* Handling */
extern Projectile *make_projectile(int x,int y,Vector v);
extern void add_projectile(Projectile *proj);
extern void spawn_clusters(int x,int y,int count,int owner,ProjectileType type);
extern void add_explosion(int x,int y,ProjectileType cluster);
extern char detonate_remote(char plr);

/* Animation */
extern void animate_weapons(void);
extern void draw_weapons(void);

/* Misc weapon utility functions */
extern int find_nearest_player(int myX,int myY,int not_this,double *dist);

#endif
