/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : game.h
 * Description : Game configuration and initialization
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef L_GAME_H
#define L_GAME_H

#include <SDL/SDL.h>

#include "lconf.h"

#define PLAYMODE_COUNT 4

typedef enum {Keyboard,Pad1,Pad2,Pad3,Pad4} ControllerType;
typedef enum {Forward,Backward,Left,Right,Weap1,Weap2} Keys;
typedef enum {Normal,OutsideShip,OutsideShip1,RndCritical} Playmode;

extern unsigned int Controllers;

typedef struct {
  char indstr_base;
  unsigned char jumpgates;
  unsigned char turrets;
  unsigned char critters;
  unsigned char cows,birds,fish,bats;
  char snowfall,stars;
  unsigned char soldiers,helicopters;	/* These are the maximium number of hostile critters each player can have */
} PerLevelSettings;

typedef struct {
  int rounds;
  char players_in[4];
  Playmode playmode;
  /* Controller options */
  ControllerType controller[4];
  SDLKey buttons[4][6]; /* Forward, Backward, Left,Right,Weap1,Weap2 */

  struct LevelFile *levels;
  struct LevelFile *first_level;
  struct LevelFile *last_level;
  int levelcount;
  /* General game settings */
  char ship_collisions;
  char coll_damage;
  char gravity_bullets;
  char wind_bullets;
  char jumplife;
  char enable_smoke;
  char endmode;
  char weapon_switch;
  char eject;
  char explosions;
  char holesize;
  char recall;
  char criticals;
  /* Level settings */
  PerLevelSettings ls;
  /* Audio settings */
  char sounds;
  char music;
  char playlist; /* Ordered, random */
  Uint8 music_vol; /* 0-128 */
  /* Temporary settings */
  char mbg_anim;
} GameInfo;

typedef struct {
  int wins[4];
  int lastwin;
  unsigned long lifetime[4];
  int total_rounds;
} GameStatus;

/* Initialization */
extern void init_game(void);
extern void reset_game(void);
extern void deinit_game(void);
extern void prematch_game(void);
extern void apply_per_level_settings(LevelSettings *settings);

/* Drawing */
extern void fill_unused_player_screens(void);

/* Game over statistics screen */
extern void game_statistics(void);

/* Ingame eventloop */
extern void game_eventloop(void);

/* Some globals */
extern GameInfo game_settings;
extern PerLevelSettings level_settings;
extern GameStatus game_status;
extern Uint8 game_loop;

/* Saving/loading configuration and level stuff */
extern void save_game_config(void);
extern void load_game_config(void);

#endif
