/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : console.h
 * Description : 
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef L_CONSOLE_H
#define L_CONSOLE_H

#include "SDL.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

/* The screen */
extern SDL_Surface *screen;

/* What is loaded (so we know if it is safe to deinitialize in the end) */
typedef enum {TL_SHIPS,TL_PARTICLES,TL_WEAPONS,TL_SPECIAL,TL_CRITTERS,
	TL_GAME,TL_INTRO,TL_HOTSEAT,TL_FONT,TL_AUDIO,TL_DEMOS,TL_PILOTS,
	TL_PLAYERS} Things;
extern char things_loaded[12];

/* Colours */
extern Uint32 col_black;
extern Uint32 col_gray,col_grenade;
extern Uint32 col_snow;
extern Uint32 col_clay,col_clay2; /* The secod clay colour is underwater clay */
extern Uint32 col_default;
extern Uint32 col_yellow;
extern Uint32 col_red;
extern Uint32 col_green;
extern Uint32 col_blue;
extern Uint32 col_white;
extern Uint32 col_transculent;
extern Uint32 col_rope;
extern Uint32 col_plrs[4];
extern Uint32 col_pause_backg;

/* Initialize SDL library */
extern void init_sdl(void);

/* Initialize screen */
extern void init_video(void);

/* Graphics */

#ifdef DONT_UPDATE_DEAD
extern void kill_plr_screen(unsigned char plr);
#endif

extern void draw_box(int x,int y,int w,int h,char width,Uint32 color);
extern void pixelcopy(Uint32 *srcpix, Uint32 *pixels,int w,int h,int srcpitch,int pitch);
extern SDL_Surface *flip_surface(SDL_Surface *original);
extern SDL_Surface *copy_surface(SDL_Surface *original);
extern SDL_Rect cliprect(int x1,int y1,int w1,int h1,int x2,int y2,int w2,int h2);
extern char clip_line(int *x1,int *y1,int *x2,int *y2,int left,int top,int right,int bottom);
extern void recolor(SDL_Surface *surface,float red,float green,float blue,float alpha);

#ifndef HAVE_LIBSDL_GFX
extern inline void putpixel(SDL_Surface *surface,int x,int y,Uint32 color);
extern void draw_line(SDL_Surface *screen, int x1,int y1,int x2,int y2,Uint32 pixel);
extern SDL_Surface *scale_surface(SDL_Surface *original,int sX,int sY,int smooth);
#else
#include <SDL_gfxPrimitives.h>
#define putpixel pixelColor
#define draw_line aalineColor
#define scale_surface zoomSurface
#endif

/* Translate joystick events to keyboard events */
extern void joystick_button(SDL_JoyButtonEvent *btn);
extern void joystick_motion(SDL_JoyAxisEvent *axis,char plrmode);

#endif
