# -*- coding: utf-8 -*-

from qt import *
import os

from base.gui.ImprovedServerDialogDesign import ImprovedServerDialogDesign
from base.backend.ServerObject import ServerObject
from base.backend.ServerList import ServerList
from base.backend.LumaConnection import LumaConnection
from base.utils.gui.LumaErrorDialog import LumaErrorDialog
from base.utils.backend.LogObject import LogObject
import environment


class ImprovedServerDialog(ImprovedServerDialogDesign):

    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        ImprovedServerDialogDesign.__init__(self,parent,name,modal,fl)
        
        self.SAVED = False
        
        # List of supported authentification methods
        self.authentificationMethods = [u"Simple", u"SASL Plain", u"SASL CRAM-MD5", 
        u"SASL DIGEST-MD5", u"SASL Login", u"SASL GSSAPI", u"SASL EXTERNAL"]

        self.installationPrefix = environment.lumaInstallationPrefix
        self.iconPath = os.path.join(self.installationPrefix, "share", "luma", "icons")
        self.networkPixmap = QPixmap(os.path.join(self.iconPath, "network32.png"))
        
        # Save lineedit background color for later use
        #self.originalBackGroundColor = self.certFileEdit.paletteBackgroundColor()
        
        # Intsall network filter for highlightning labels when mouseover
        self.networkLabel.installEventFilter(self)
        self.credentialLabel.installEventFilter(self)
        self.encryptionLabel.installEventFilter(self)
        self.authLabel.installEventFilter(self)
        self.ldapOptLabel.installEventFilter(self)
        
        self.saveButton.setEnabled(0)
        
        # Show blank widget first, no server selected
        self.configStack.raiseWidget(6)
        
        self.originalBackGroundColor = self.networkLabel.paletteBackgroundColor()
        
        self.serverListObject = ServerList()
        self.serverListObject.readServerList()
        
        # Server which is currently selected.
        self.currentServer = None
        
        # Needed for closing the children of the old server
        self.oldServerItem = None
        
        self.displayServerList()
        
###############################################################################

    def displayServerList(self):
        """ Initialize the listview with the serverlist.
        """
        
        self.serverListView.clear()
        
        if self.serverListObject.serverList == None:
            return
            
        for x in self.serverListObject.serverList:
            tmpItem = QListViewItem(self.serverListView, x.name)
            self.serverListView.insertItem(tmpItem)
            
###############################################################################

    def serverSelected(self, serverItem):
    
        # Nothing selected
        if serverItem == None:
            if not (self.oldServerItem == None):
                self.oldServerItem.setOpen(False)
            self.oldServerItem = None
            self.serverLabel.setText(self.trUtf8("<b>No server selected</b>"))
            self.configStack.raiseWidget(6)
            return
    
        # Server selected
        if serverItem.parent() == None:
            if not (self.oldServerItem == None):
                self.oldServerItem.setOpen(False)
                while self.oldServerItem.childCount() > 0:
                    child = self.oldServerItem.firstChild()
                    self.oldServerItem.takeItem(child)
                
            serverItem.setOpen(True)
            self.oldServerItem = serverItem
            
            self.serverLabel.setText(QString("<b>%1</b>").arg(serverItem.text(0)))
            self.configStack.raiseWidget(0)
            
            selectedServerString = unicode(serverItem.text(0))
            x = self.serverListObject.getServerObject(selectedServerString)
            self.currentServer = x
            
            self.initializeFields()
            self.buildCategories(serverItem)
            
        # Subcategory from server selected
            

###############################################################################
        
    def eventFilter(self, object, event):
        if (event.type() == QEvent.Enter):
            if object == self.networkLabel:
                tmpColor = self.networkLabel.colorGroup().highlightedText()
                self.networkLabel.setPaletteBackgroundColor(tmpColor)
                
            if object == self.credentialLabel:
                tmpColor = self.credentialLabel.colorGroup().highlightedText()
                self.credentialLabel.setPaletteBackgroundColor(tmpColor)
                
            if object == self.encryptionLabel:
                tmpColor = self.encryptionLabel.colorGroup().highlightedText()
                self.encryptionLabel.setPaletteBackgroundColor(tmpColor)
                
            if object == self.authLabel:
                tmpColor = self.authLabel.colorGroup().highlightedText()
                self.authLabel.setPaletteBackgroundColor(tmpColor)
                
            if object == self.ldapOptLabel:
                tmpColor = self.ldapOptLabel.colorGroup().highlightedText()
                self.ldapOptLabel.setPaletteBackgroundColor(tmpColor)
                
                
        if (event.type() == QEvent.Leave):
            if object == self.networkLabel:
                self.networkLabel.setPaletteBackgroundColor(self.originalBackGroundColor)
                
            if object == self.credentialLabel:
                self.credentialLabel.setPaletteBackgroundColor(self.originalBackGroundColor)
                
            if object == self.encryptionLabel:
                self.encryptionLabel.setPaletteBackgroundColor(self.originalBackGroundColor)
                
            if object == self.authLabel:
                self.authLabel.setPaletteBackgroundColor(self.originalBackGroundColor)
                
            if object == self.ldapOptLabel:
                self.ldapOptLabel.setPaletteBackgroundColor(self.originalBackGroundColor)
            
                
        return 0
        
###############################################################################

    def initializeFields(self):
        self.networkLabel.blockSignals(True)
        self.credentialLabel.blockSignals(True)
        self.encryptionLabel.blockSignals(True)
        self.authLabel.blockSignals(True)
        self.ldapOptLabel.blockSignals(True)
        self.hostnameEdit.blockSignals(True)
        self.portBox.blockSignals(True)
        self.anonBindBox.blockSignals(True)
        self.bindAsEdit.blockSignals(True)
        self.bindPasswordEdit.blockSignals(True)
        self.encryptionBox.blockSignals(True)
        self.authentificationBox.blockSignals(True)
        self.serverCertBox.blockSignals(True)
        self.clientCertBox.blockSignals(True)
        self.certFileEdit.blockSignals(True)
        self.certKeyFileEdit.blockSignals(True)
        self.aliasBox.blockSignals(True)
        self.baseBox.blockSignals(True)
        self.baseDNView.blockSignals(True)
        
        x = self.currentServer
        
        self.networkLabel.setText(x.host + ":" + str(x.port))
        
        if x.bindAnon:
            self.credentialLabel.setText(self.trUtf8("Anonymous"))
        else:
            self.credentialLabel.setText(x.bindDN)
            
        self.encryptionLabel.setText(x.encryptionMethod)
        self.authLabel.setText(x.authMethod)
        
        if x.autoBase:
            self.ldapOptLabel.setText(self.trUtf8("Automatic"))
        else:
            baseString = ""
            for tmpBase in x.baseDN:
                baseString += tmpBase + "\n"
            self.ldapOptLabel.setText(baseString)
        
        #self.hostnameEdit
        #self.portBox
        #self.anonBindBox
        #self.bindAsEdit
        #self.bindPasswordEdit
        #self.encryptionBox
        #self.authentificationBox
        #self.serverCertBox
        #self.clientCertBox
        #self.certFileEdit
        #self.certKeyFileEdit
        #self.aliasBox
        #self.baseBox
        #self.baseDNView
        
        
        self.networkLabel.blockSignals(False)
        self.credentialLabel.blockSignals(False)
        self.encryptionLabel.blockSignals(False)
        self.authLabel.blockSignals(False)
        self.ldapOptLabel.blockSignals(False)
        self.hostnameEdit.blockSignals(False)
        self.portBox.blockSignals(False)
        self.anonBindBox.blockSignals(False)
        self.bindAsEdit.blockSignals(False)
        self.bindPasswordEdit.blockSignals(False)
        self.encryptionBox.blockSignals(False)
        self.authentificationBox.blockSignals(False)
        self.serverCertBox.blockSignals(False)
        self.clientCertBox.blockSignals(False)
        self.certFileEdit.blockSignals(False)
        self.certKeyFileEdit.blockSignals(False)
        self.aliasBox.blockSignals(False)
        self.baseBox.blockSignals(False)
        self.baseDNView.blockSignals(False)
        
###############################################################################

    def buildCategories(self, serverItem):
        pass
        #subItem = QListViewItem(tmpItem, "Network options")
        #subItem.setPixmap(0, self.networkPixmap)
        
        
