<?php
/*
# Copyright 2006, Mille-XTERM., Martin Rioux
# Created on 2006-03-03
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.crim.ca/
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	global $CONFIG;
	require_once 'Node.php';
	require_once "util/".$CONFIG['auth_name'].".php";


	/*
	*  User/Group browser class
	*
	* This class read node data for user/group type node.
	*
	* Author: Nicolas Dufresne
	*/

	class EntityBrowser{

		var $node;
		var $errors;
		var $isError;				// Can also be used to avoid other Configuration modules to be executed
		var $nb_find;
		var $entity_id;
		var $type;
		var $message;
		var $allUsers;
		var $allGroups;
		var $permissions;

		/**
		* Constructor fro node browser
		*
		* Called with 0, it build the complete node and computer browser, called with 1
		* it build the node only browser.
		*
		* @access public
		* @param int Default 0
		*/

		function EntityBrowser($type = USER_TYPE, $message = NULL, $entity_id = "entity_id", $nb_find = "nb_find") {
		    $this->load($type, $message, $entity_id, $nb_find);
		}

		/**
		* Load the browser (keeping Errors)
		* @access public
		*/
		function load($type = USER_TYPE, $message = NULL, $entity_id = "entity_id", $nb_find = "nb_find") {
	    	$this->isError = false;
			$nodeOK = false;
			switch ($type) {
			    case USER_TYPE:
			    case GROUP_TYPE:
				break;
			    default:
				$this->errors[] = getMessage('invalide_nodes_browser_type').$type;
				$this->isError = true;
				return false;
			}
			if (isset($_GET[$entity_id]) && !$nodeOK) {
				if($_GET[$entity_id] == 0){
					$_GET[$entity_id] = $this->resetNode();
				}
				$nodeOK = $this->buildNode($_GET[$entity_id]);
				if ($nodeOK) {
				    //if (!$this->node->isNode() && $type == NODE_TYPE) $this->node = $this->node->getParent();
				    $_GET[$entity_id] = $this->node->getID();
				}
			}
			if (!$nodeOK) {
				$nodeOK = $this->buildNode($this->resetNode());
				$_GET[$entity_id] = $this->node->getID();
			}
			if (isset($_POST['addEntity'])) {
				$auth = new Auth("","");
				//Check if value is not empty
				if(strlen(trim($_POST['entityToAdd'])) > 0){
					if($auth->isValidEntity($_POST['entityToAdd'],$_POST['user_group'])){
						$result = $this->node->insertEntity(strtolower($_POST['entityToAdd']),$_POST['user_group']);
						//result is id or error message
						if($result>0){
							$nodeOK = $this->buildNode($_GET[$result]);
							if ($nodeOK) {
								unset($this->errors);
					    		$_GET[$entity_id] = $this->node->getID();
							}
						}else{
							$this->errors[] = $result;
						}
					}else{
						$this->errors[]="";
						$this->errors[] = getMessage('invalide_node_name').$_POST['entityToAdd'];
					}
				}else{
					$this->errors[] = getMessage('empty_node_name');
				}
				unset($_POST['addEntity']);
			}
			if (isset($_GET['deleteEntity'])) {
				$this->node->deleteEntity();
				unset($_GET['deleteEntity']);
				$newEntityId = $this->resetNode();
				if($newEntityId > 1){
					//reset node
					$nodeOK = $this->buildNode($newEntityId);
					if ($nodeOK) {
				    	$_GET[$entity_id] = $this->node->getID();
					}
				}

			}
			$this->entity_id = $entity_id;
			$this->nb_find = $nb_find;
			$this->type = $type;
			$this->message = $message;
			$this->allGroups = $this->getEntityNodes(GROUP_TYPE);
			$this->allUsers = $this->getEntityNodes(USER_TYPE);
			return true;
		}



		/**
		* Print errors
		*
		* @access public
		*/
		function printErrors() {
			if (isset($this->errors[0])) print "<p>\n";
			else return;
			foreach ($this->errors as $error) {
				print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
			}
			print "</p>\n";
		}

		function isError() {
			return $this->isError;
		}

		/**
		* Return selected node
		*
		* This function returns the selected node. It returns NULL if a
		* isFatalError is true.
		*
		* @access public
		* @return Node
		*/
		function getNode(){
			return $this->node;
		}

		/**
		* Build the node
		*
		* This function build a node and test for errors
		*
		* @access private
		* @param int/mac/ip Default 0
		* @return bool;
		*/
		function buildNode($id = "Default") {

			//JMD: remove spaces that got in there by copy-paste
			$id = trim($id);

			if ($id == "Default") {
			    $this->node = new Node();
			}
			else {
			    $this->node = new Node($id);
			}
			$this->permissions = new Permissions($this->node->getID());
			//Check for invalide_nodes_type
			switch ($this->node->nodetype) {
				case NODE_TYPE:
				case COMPUTER_TYPE:
				case HWGROUP_TYPE:
					break;
				default:
					break;
			}

			if ($this->node->isError())
				$this->errors[] = $this->node->lastError();
			return !$this->node->isError();
		}
		/**
		* Get all group/user nodes
		*
		* @access public
		* @return
		*/
		function getEntityNodes($nodetype){
			$entityNodes = select("SELECT id, reference FROM nodes WHERE nodetype=".$nodetype." ORDER BY reference");
			if (!is_null($entityNodes) && !is_array($entityNodes)) {
				$this->errors[] = getMessage('db_error').$entityNodes;
				$this->isError = true;
				return NULL;
			}
			if (is_array($entityNodes)) {
				foreach ($entityNodes as $entityNode) {
					$entitiesAssoc[$entityNode['id']] = $entityNode['reference'];
				}
			}
			return $entitiesAssoc;
		}
		/**
		* Reset node id
		*
		* @access public
		* @return
		*/
		function resetNode(){
			$nodes_id = singleResultSelect("SELECT MIN(id) as minid FROM nodes WHERE nodetype=".GROUP_TYPE." OR nodetype=".USER_TYPE );
			return $nodes_id["minid"];
		}
		/**
		* Print the browser HTML view
		*
		* @access public
		* @return stdout
		*/
		function printView() {
			global $termonly;
			if ($this->isError) {
			    $this->printErrors();
			}
			else {
			    include 'entityBrowserView.php';
			}
		}
		/**
		 * getter for permissions
		 */
		 function getPermissions(){
		 	return $this->permissions;
		 }
	}

?>
