'''
Defines a GTK dialog for buffering L{pyLinAcc} events.

@todo: add note about future design separating monitor view from model

@author: Peter Parente
@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import pyLinAcc
from GTKEventDialog import GTKEventDialog
from i18n import _

class RawEventMonitor(GTKEventDialog):
  '''
  Buffers text describing raw L{pyLinAcc} events.
  '''
  def getName(self):
    '''
    Gets the localized name of this monitor.
    
    @return: Monitor name
    @rtype: string
    '''
    return _('pyLinAcc event monitor')
  
  def getEventNames(self):
    '''
    Gets the event categories to be displayed in the View menu for filtering.
    
    @return: Event categories
    @rtype: list of string
    '''
    return pyLinAcc.getNames()
  
  def getEventDefaults(self):
    '''
    Gets the default event categories to check in the View menu.
    
    @return: Event categories
    @rtype: list of string
    '''
    return pyLinAcc.getDefaults()
  
  def getEventType(self):
    '''
    Gets the L{pyLinAcc.Event.Event} base class to indicate the type of events
    this monitor wants to buffer.
    
    @return: Base type of the event this monitor should buffer
    @rtype: L{pyLinAcc.Event.Event} class
    '''
    return pyLinAcc.Event.Event
  
  def _isShown(self, event_name):
    '''
    Gets if the given event name is in the L{shown} list and if L{logging} is
    enabled.
    
    @todo: PP: this could be done faster with hashing
    
    @param event_name: Name of the event
    @type event_name: string
    @return: Is the event to be shown?
    @rtype: boolean
    '''
    if not self.logging:
      return False
    for n in self.shown:
      if event_name.startswith(n):
        return True
    return False
    
  def show(self, event, **kwargs):
    '''
    Renders an event as text into the gtk.TextBuffer. The context has no effect
    on rendering in this monitor and so it defaults to None.

    @param event: Event to buffer
    @type event: L{pyLinAcc.Event.Event}
    '''
    if not self.isInitialized():
      raise IOError
    elif (self._isShown(event.type.name) and not 
          event.source.getApplication().name.lower().startswith('lsr')):
      self._queueText(str(event))