'''
Defines the abstract base class for all L{AEMonitor} subclasses that will
monitor input to LSR from L{AEInput} devices.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Base

class InputMonitor(Base.AEMonitor):
  '''  
  Abstract base class for L{InputMonitor}s that will buffer input. Defines
  methods that must be overriden to do the buffering of input data.
  ''' 
  def showGestureReceived(self, dev, gesture):
    '''
    Abstract method. Buffers the L{AEInput.Gesture} received from the device.
    
    @param dev: Device on which the gesture occurred.
    @type dev: L{AEInput.AEInput}
    @param gesture: Gesture received from the device
    @type gesture: L{AEInput.Gesture}
    @raise IOError: When the monitor is no longer accepting data to buffer 
    @raise NotImplementedError: When this method is not overidden in a subclass
    '''
    raise NotImplementedError