# -*- coding: utf-8 -*-

# Copyright (c) 2004 Lindows
#
# This is the install script for Lsongs. It is based on the
# build script found in the PyQt distribution. The original is 
# Copyright (c) 2002 Riverbank Computing Limited <info@riverbankcomputing.co.uk>

import sys
import os
import string
import re
import compileall
import glob
import shutil
import fnmatch
import distutils.sysconfig

# Define the globals.
progName = None
modDir = None
platBinDir = None
distDir = None

def usage(rcode = 2):
    """Display a usage message and exit.

    rcode is the return code passed back to the calling process.
    """
    global progName, platBinDir, modDir, distDir

    print "Usage:"
    print "    %s [-hx] [-b dir] [-d dir] [-i dir]" % (progName)
    print "where:"
    print "    -h             display this help message"
    print "    -b dir         where Lsongs will be installed [default %s]" % (platBinDir)
    print "    -d dir         where Lsongs python files will be installed [default %s]" % (modDir)
    if sys.platform <> "win32":
        print "    -i dir         temporary install prefix [default %s]" % (distDir)
    print "    -x             don't perform dependency checks (use on your own risk)"

    sys.exit(rcode)


def initGlobals():
    """Sets the values of globals that need more than a simple assignment.
    """
    global platBinDir, modDir

    if sys.platform == "win32":
        platBinDir = sys.exec_prefix
    else:
        platBinDir = "/usr/local/bin"

    modDir = distutils.sysconfig.get_python_lib()


def copyToFile(name,text):
    """Copy a string to a file.

    name is the name of the file.
    text is the contents to copy to the file.
    """
    f = open(name,"w")
    f.write(text)
    f.close()


def wrapperName(dname,wfile):
    """Create the platform specific name for the wrapper script.
    """
    if sys.platform == "win32":
        wname = dname + "\\" + wfile + ".bat"
    else:
        wname = dname + "/" + wfile

    return wname


def createPyWrapper(pydir,wfile):
    """Create an executable wrapper for a Python script.

    pydir is the name of the directory where the Python script will eventually
    be installed.
    wfile is the basename of the wrapper.

    Returns the platform specific name of the wrapper.
    """
    if sys.platform == "win32":
        wname = wfile + ".bat"
        wrapper = \
"""@%s\\pythonw %s\\%s.py %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9
""" % (platBinDir,pydir,wfile)
    else:
        wname = wfile
#        wrapper = \
#"""#!/bin/sh
#
#exec %s %s/%s.py $*
#""" % (sys.executable,pydir,wfile)
        wrapper = \
"""#!/bin/sh

exec %s/%s "$@"
""" % (pydir,wfile)

    copyToFile(wname,wrapper)
    os.chmod(wname,0755)
    #os.chmod('%s/%s.py' % (pydir,wfile),0755)
    return wname


def copyTree(src, dst):
    """Copy Python, translation, documentation, wizards configuration
    and designer template files of a directory tree.
    """
    names = os.listdir(src)
    if not os.path.isdir(dst):
        os.mkdir(dst)
    for name in names:
        srcname = os.path.join(src, name)
        dstname = os.path.join(dst, name)
        if fnmatch.fnmatch(srcname, '*.py') or \
            fnmatch.fnmatch(srcname, '*.pyo') or \
            fnmatch.fnmatch(srcname, '*.pyc') or \
            fnmatch.fnmatch(srcname, '*rip') or \
            fnmatch.fnmatch(srcname, '*burn') or \
            fnmatch.fnmatch(srcname, '*encode') or \
            fnmatch.fnmatch(srcname, '*transcode') or \
            fnmatch.fnmatch(srcname, '*lsongs') or \
	    fnmatch.fnmatch(srcname, '*.xml'):
            shutil.copy2(srcname, dstname)
        elif os.path.isdir(srcname):
            copyTree(srcname, dstname)


def installLsongs():
    """Create the python wrapper files for Lsongs
    and install all the necessary files comprising the package.
    """
    global modDir, platBinDir, distDir
    
    lsongsdir = os.path.join(modDir, "Lsongs")
    lsongsimagedir = os.path.join(lsongsdir, "images")
    
    # Create the platform specific wrappers.
    lname = createPyWrapper(lsongsdir,"lsongs")

    # set install prefix, if not None
    #
    # ToDo: This has to be reworked, if there is a need
    #       for distDir on "win32".
    #       Don't use os.path.join because absolute paths
    #       seem to be assumed, but not assured.
    #       At least for linux, double slashes make no problems.
    #
    if distDir:
        lsongsdir = distDir + os.sep + lsongsdir
        lsongsimagedir = distDir + os.sep + lsongsimagedir
        bindir  = distDir + os.sep +  platBinDir
        mdir = distDir + os.sep + modDir
    else:
        bindir = platBinDir
        mdir = modDir
    
    # Cleanup old stuff
    # Remove the wrapper scripts
    rem_lname = wrapperName(platBinDir,"Lsongs")
    if os.path.exists(rem_lname):
        os.remove(rem_lname)
   
    # Cleanup the install directory
    try:
        shutil.rmtree(lsongsdir, 1)
    except:
        pass

    # Install the files
    # make the install directory tree
    try: os.makedirs(lsongsimagedir)
    except: pass
    if not os.path.isdir(bindir):
        os.makedirs(bindir)
    copyTree('Lsongs', lsongsdir)
    
    # copy the pixmaps
    for fn in glob.glob('Lsongs%simages%s*.png' % (os.sep, os.sep)):
        shutil.copy(fn, lsongsimagedir)
    # copy the wrappers
    shutil.copy(lname, bindir)
    # copy the license file
    shutil.copy('LICENSE.GPL', lsongsdir)

def main(argv):
    """The main function of the script.

    argv is the list of command line arguments.
    """
    import getopt

    # Parse the command line.
    global progName, modDir
    progName = os.path.basename(argv[0])

    initGlobals()

    try:
        if sys.platform == "win32":
            optlist, args = getopt.getopt(argv[1:],"hxb:d:")
        else:
            optlist, args = getopt.getopt(argv[1:],"hxb:d:i:")
    except getopt.GetoptError:
        usage()

    global platBinDir
    
    depChecks = 1

    for opt, arg in optlist:
        if opt == "-h":
            usage(0)
        elif opt == "-b":
            platBinDir = arg
        elif opt == "-d":
            global modDir
            modDir = arg
        elif opt == "-i":
            global distDir
            distDir = os.path.normpath(arg)
        elif opt == "-x":
            depChecks = 0
    
    if depChecks:
        # perform dependency checks
        if sys.version_info < (2,3,0):
            print 'Sorry, you must have Python 2.3.0 or higher.'
            sys.exit(5)
            
        try:
            from qt import qVersion, PYQT_VERSION
        except:
            print 'Sorry, please install PyQt.'
            sys.exit(1)

        qtMajor = int(qVersion().split('.')[0])
        if qtMajor < 3:
            print 'Sorry, you must have Qt version 3.0.0 or higher.'
            sys.exit(2)

        #check version of PyQt
        try:
            from qt import PYQT_VERSION_STR
            pyqtVersion = PYQT_VERSION_STR
        except:
            pyqtVersion = PYQT_VERSION
        if pyqtVersion[:9] == "snapshot-":
            if long(pyqtVersion[9:]) < 20030418L:
                print 'Sorry, you must have PyQt snapshot-20030418 or higher.'
                sys.exit(3)
        else:
            while pyqtVersion.count('.') < 2:
                pyqtVersion += '.0'
            (maj, min, pat) = pyqtVersion.split('.')
            maj = int(maj)
            min = int(min)
            pat = int(pat)
            if maj < 3 or (maj == 3 and min < 6):
                print 'Sorry, you must have PyQt 3.6.0 or snapshot-20030418 or higher.'
                sys.exit(3)
            if maj == 3 and min == 9:
                print 'PyQt 3.9 contains a bug, which prevents Lsongs from functioning.'
                print 'Please get PyQt 3.8 or 3.10 or newer (or snapshot-20031226 or newer).'
                sys.exit(3)
            
    print "Compiling files."
    if distDir:
        compileall.compile_dir("Lsongs", ddir=os.path.join(distDir, modDir))
    else:
        compileall.compile_dir("Lsongs", ddir=modDir)
    print "\nInstalling Lsongs ..."
    installLsongs()
    print "\nInstallation complete."

if __name__ == "__main__":
    try:
        main(sys.argv)
    except SystemExit:
        raise
    except:
        print \
"""An internal error occured.  Please report all the output of the program,
including the following traceback, to support@lindows.com
"""
        raise

