from LsongsServer import *
from LServiceFinder import *
from LServiceAdvertiser import *
from LSettings import *
from LDAAPServer import *
import socket

class LsongsSharing(QObject):
	def __init__(self):
		QObject.__init__(self)
		self.lsongsServers = {}
		self.slimp3Servers = {}
		self.lsongsAdvertiser = None
		self.lsongsServer = None
		self.lsongsFinder = None
		#self.slimp3Finder = None
		self.daapServer = None
		self.currentLsongsName = ""
		self.settings = LSettings.settings()
		#self.fromSettings()
	
	def killTasks(self):
		self.stopShareWithLsongs()
		self.stopShareWithSliMP3()
		self.stopShareWithTwonky()
		self.stopShareWithDAAP()
		self.stopLookForLsongs()
		#self.stopLookForSliMP3()

	def startLookForLsongs(self):
		if self.lsongsFinder==None:
			self.lsongsFinder = LServiceFinder('_lsongs._tcp')
			QObject.connect(self.lsongsFinder,PYSIGNAL('addService'),self.addLsongsService)
			QObject.connect(self.lsongsFinder,PYSIGNAL('removeService'),self.removeLsongsService)
			self.lsongsFinder.startFinding()
	
	def stopLookForLsongs(self):
		if self.lsongsFinder:
			self.lsongsFinder.killTasks()
			self.lsongsFinder = None
			for lsongs in self.lsongsServers.values():
				self.removeLsongsService(lsongs['Name'],lsongs['Type'])
			self.lsongsServers = {}
	
##	def startLookForSliMP3(self):
##		if self.slimp3Finder==None:
##			self.slimp3Finder = LServiceFinder('_slimhttp._tcp')
##			QObject.connect(self.slimp3Finder,PYSIGNAL('addService'),self.addSlimp3Service)
##			QObject.connect(self.slimp3Finder,PYSIGNAL('removeService'),self.removeSlimp3Service)
##			self.slimp3Finder.startFinding()
	
##	def stopLookForSliMP3(self):
##		if self.slimp3Finder:
##			self.slimp3Finder.killTasks()
##			self.slimp3Finder = None
##			for slimp3 in self.slimp3Servers.values():
##				self.removeSlimp3Service(slimp3['Name'],slimp3['Type'])
##			self.slimp3Servers = {}

	def shareName(self):
		name = self.settings.get('Share Name','')
		if len(name)==0:
			name = socket.gethostname()
			if name==None or len(name)==0:
				name = "Lsongs"
		return name
	
	def startShareWithLsongs(self):
		if self.lsongsServer==None:
			self.lsongsServer = LsongsServer()
		if self.lsongsAdvertiser==None:
			self.currentLsongsName = self.shareName()
			self.lsongsAdvertiser = LServiceAdvertiser('_lsongs._tcp',self.currentLsongsName)
			self.lsongsAdvertiser.startAdvertising()

	def stopShareWithLsongs(self):
		if self.lsongsAdvertiser:
			self.lsongsAdvertiser.killTasks()
			self.lsongsAdvertiser = None
		if self.lsongsServer:
			self.lsongsServer.killTasks()
			self.lsongsServer = None
	
	def startShareWithDAAP(self):
		if self.daapServer==None:
			self.daapServer = LDAAPServer(self.shareName())
			
	def stopShareWithDAAP(self):
		if self.daapServer:
			self.daapServer.killTasks()
			self.daapServer = None
	
	def startShareWithSliMP3(self):
		#print "start share with SliMP3"
		pass
	
	def stopShareWithSliMP3(self):
		#print "stop share with SliMP3"
		pass
		
	def startShareWithTwonky(self):
		#print "start share with Twonky"
		pass
		
	def stopShareWithTwonky(self):
		#print "stop share with Twonky"
		pass
	
	def addLsongsService(self,name,type,address,port):
		#print "broadcasting add of lsongs",name
		if name==self.currentLsongsName:
			share = self.settings.get("Mount Local Shares",False)
		else:
			share = self.settings.get("Look For Lsongs",True)
		#print "Share",str(share)
		if share:
			self.lsongsServers[name] = {'Name':name,'Type':type,'Address':address,'Port':port}
			self.emit(PYSIGNAL("addLsongsService"),(name,type,address,port))
	
	def removeLsongsService(self,name,type):
		try: del self.lsongsServers[name]
		except: pass
		self.emit(PYSIGNAL("removeLsongsService"),(name,type))

##	def addSlimp3Service(self,name,type,address,port):
##		self.slimp3Servers[name] = {'Name':name,'Type':type,'Address':address,'Port':port}
##		self.emit(PYSIGNAL("addSlimp3Service"),(name,type,address,port))
##	
##	def removeSlimp3Service(self,name,type):
##		try: del self.slimp3Servers[name]
##		except: pass
##		self.emit(PYSIGNAL("removeSlimp3Service"),(name,type))
	
	def shares(self):
		return {'lsongs':self.lsongsServers}
		#return {'lsongs':self.lsongsServers,'slimp3':self.slimp3Servers}

	def fromSettings(self):
		if self.settings.get('Look For Lsongs',True): self.startLookForLsongs()
		else: self.stopLookForLsongs()
		if self.settings.get('Share With Lsongs',False): self.startShareWithLsongs()
		else: self.stopShareWithLsongs()
##		if self.settings.get('Look For SliMP3',False): self.startLookForSliMP3()
##		else: self.stopLookForSliMP3()
		if not self.settings.get('isMP3Beamer',False):
			if self.settings.get('Share With DAAP',False): self.startShareWithDAAP()
			else: self.stopShareWithDAAP()
			if self.settings.get('Share With SliMP3',False): self.startShareWithSliMP3()
			else: self.stopShareWithSliMP3()
			if self.settings.get('Share With Twonky',False): self.startShareWithTwonky()
			else: self.stopShareWithTwonky()

	def static_singleton():
		global _lsongsSharingSingleton
		if _lsongsSharingSingleton==None:
			_lsongsSharingSingleton = LsongsSharing()
		return _lsongsSharingSingleton

	singleton = staticmethod(static_singleton)

_lsongsSharingSingleton = None
