#
# "@(#) $Id: LVolumeWidget.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LMusicPlayer import *
from LsongsPaths import *
from LSettings import *

_offset_owner = None
_offset = 0

class LVolumeSlider(QSlider):
	def wheelEvent(self,e):
		global _offset_owner, _offset
		if ( e.orientation() != self.orientation() and  not self.rect().contains(e.pos()) ):
			return

		if (_offset_owner != self):
			_offset_owner = self
			_offset = 0
		_offset = _offset-e.delta()*max(self.pageStep(),self.lineStep())/120
		if (abs(_offset)<1):
			return
		self.setValue( self.value() - int(_offset) )
		_offset = _offset-int(_offset)
		e.accept()

class LVolumeWidget(QWidget):
	def __init__(self,container = None):
		QWidget.__init__(self,container)
		self.buildControls()
		volume = LSettings.settings().get('Volume',50)
		self.volumeSlider.setValue(volume)
	
	def buildControls(self):
		hbox = QHBoxLayout(self)
		hbox.setSpacing(4)
		hbox.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		label = QLabel("",self)
		label.setPixmap(QPixmap(art("labelvolumelow.png")))
		hbox.addWidget(label)
		self.volumeSlider = LVolumeSlider(Qt.Horizontal,self)
		self.volumeSlider.setFixedWidth(100)
		self.volumeSlider.setRange(0,100)
		QObject.connect(self.volumeSlider,SIGNAL("valueChanged(int)"),self.volumeChanged)
		hbox.addWidget(self.volumeSlider)
		label = QLabel("",self)
		label.setPixmap(QPixmap(art("labelvolumehigh.png")))
		hbox.addWidget(label)
		hbox.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		QObject.connect(LMusicPlayer.singleton(),PYSIGNAL("volumeChanged"),self.gotVolumeChange)

	def volumeChanged(self,volume):
		LMusicPlayer.singleton().setVolume(volume,self)
	
	def gotVolumeChange(self,volume,fromObject):
		if fromObject!=self:
			self.volumeSlider.blockSignals(True)
			self.volumeSlider.setValue(volume)
			self.volumeSlider.blockSignals(False)
	
