#
# "@(#) $Id: LStatusSeekableProgressBar.py,v 1.5 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LsongsPaths import *

class LSeekableStatusProgressBar(QWidget):
	def __init__(self,container):
		QWidget.__init__(self,container)
		self.totalTime = 100
		self.currentTime = 100
		self.setMaximumWidth(241)
		self.setMinimumWidth(101)
		self.setFixedHeight(15)
		self.lastPosition = -1
		self.newPosition = 0
		self.tick = QPixmap(art("labeltick.png"))
	
	def progress(self,status):
		state = status['Status']
		if state in ['Playing']:
			self.currentTime = status['currentTime']
			self.totalTime = status['totalTime']
		else:
			self.currentTime = 0
			self.totalTime = 0
		#print self.currentTime,self.totalTime
		r = self.rect()
		self.position = -1
		if self.totalTime>0:
			self.position = (r.width()-10)*self.currentTime/self.totalTime+1
		if self.position!=self.lastPosition:
			#self.update()
			self.repaint()
			self.lastPosition = self.position
	
	def paintEvent(self,ev):
		p = QPainter()
		p.begin(self)
		r = self.rect()
		# drop shadow
		r1 = QRect(r.left()+1,r.top()+1,r.width()-1,r.height()-1)
		p.setPen(QColor(132,151,198))
		p.drawRect(r1)
		# indicator
		if self.position>0:
			p.drawPixmap(QPoint(self.position,r.top()+1),self.tick)
		# bounding box
		r1 = QRect(r.left(),r.top(),r.width()-1,r.height()-1)
		p.setPen(QColor(21,21,19))
		p.drawRect(r1)
		p.end()

	def mousePressEvent(self,event):
		self.handleSeek(event.pos())
	
	def mouseMoveEvent(self,event):
		self.handleSeek(event.pos())
	
	def handleSeek(self,position):
		if self.totalTime>0:
			fraction = (position.x()-1.0)/(self.width()-3) # XXX DSM some work here!
			if fraction<0: fraction=0
			if fraction>1: fraction=1
			seekTime = long(fraction*self.totalTime)
			self.emit(PYSIGNAL("seeked"),(fraction,seekTime,self.totalTime))
