#
# LSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from kdecore import *
from kdeui import *
from Library import *
from LTrackDrag import *
from LDellPlaylistDrag import *
from LDellTrackDrag import *
from LPodPlaylistDrag import *
from LPodTrackDrag import *
from LPlaylistDrag import *
from LRemoteTrackDrag import *
from LEncoderTrackDrag import *
from LsongsPaths import *

	# To enforce sort, we precompute special keys
	# A is 'Library'
	# B is 'Stations'
	# C is 'Music Store'
	# D+name is Incoming Shared Playlists
	# E+name is Incoming SlimServers
	# F+name is Normal Playlists
	# G+name is Smart Playlists
	# H is 'Purchased Music'
	# I is CD/DVD devices
	# J+name is MP3 devices
	# K is Encoder queue
	# L is Trash

class LSourceViewItem(QListViewItem):
	def __init__(self,container,name):
		self.bgColor = None
		QListViewItem.__init__(self,container,name)
		self.container = container
		self.source = None
		self.name = name
		self.buildKey()
		self.wantsTrackDrags = False
		self.wantsDellPlaylistDrags = False
		self.wantsDellTrackDrags = False
		self.wantsPodPlaylistDrags = False
		self.wantsPodTrackDrags = False
		self.wantsExternalTrackDrags = False
		self.wantsRemoteTrackDrags = False
		self.wantsPlaylistDrags = False
		self.wantsEncoderDrags = False
		self.wantsFileDrags = False
		self.canBeRemoved = False
		self.hasContextMenu = True
		iconFileName = self.iconFileName()
		self.setDropEnabled(True)
		if iconFileName:
			iconPath = art(iconFileName)
			pixmap = QPixmap(iconPath)
			self.setPixmap(0,pixmap)
		self.canExport = False
		self.canBurn = False
		self.canEmpty = False
		self.library = Library.mainLibrary()
		self.libraryPlaylist = self.library.playlistWithName("Library")
		self.trash = self.library.playlistWithName("Trash")
		self.popup = None
	
	def buildKey(self):
		self.sortKey = QString(self.makeKey())

	def contextMenu(self,pos,column,mainWindow):
		if self.popup==None:
			self.buildPopup(mainWindow)
		if self.popup!=None:
			self.loadPopup()
			self.popup.exec_loop(pos)

	def buildPopup(self,mainWindow):
		pass

	def loadPopup(self):
		pass

	def setBackgroundColor(self,color):
		self.bgColor = color
	
	def paintCell(self,p,cg,column,width,alignment):
		if self.bgColor:
			_cg = QColorGroup(cg)
			_cg.setColor(QColorGroup.Background,self.bgColor)
			_cg.setColor(QColorGroup.Base,self.bgColor)
			QListViewItem.paintCell(self,p,_cg,column,width,alignment)
		else:
			QListViewItem.paintCell(self,p,cg,column,width,alignment)

	def iconFileName(self):
		return None

	def makeKey(self):
		return '0'

	def key(self,column,ascending):
		return self.sortKey
		
	def okRename(self,column):
		oldName = self.text(0)
		QListViewItem.okRename(self,column)
		newName = unikode(self.text(0))
		if oldName!=newName:
			newName = newName.strip()
			if len(newName)==0:
				KMessageBox.error(None,i18n("Playlist names must not be empty"),i18n("Bad Playlist name"))
				self.setText(0,oldName)
				self.startRename(0)
			elif self.library.playlistWithName(newName)!=None:
					KMessageBox.error(None,i18n("Playlist names must be unique"),i18n("Duplicate Playlist name"))
					self.setText(0,oldName)
					self.startRename(0)
			else:
				self.changeName(newName)

	def changeName(self,newName):
		pass

	def doSourceChangeName(self,newName):
		self.source.name = newName

	def printDragFormats(self,event):
		print("formats:")
		n = 0
		while True:
			format = event.format(n)
			if (format==None):
				break
			print("  "+str(format))
			n = n+1
	
	def acceptDrag(self,event):
		return (self.wantsTrackDrags and LTrackDrag.canDecode(event)) or \
			(self.wantsDellPlaylistDrags and LDellPlaylistDrag.canDecode(event)) or \
			(self.wantsDellTrackDrags and LDellTrackDrag.canDecode(event)) or \
			(self.wantsFileDrags and QUriDrag.canDecode(event)) or\
			(self.wantsEncoderDrags and LEncoderTrackDrag.canDecode(event)) or \
			(self.wantsPlaylistDrags and LPlaylistDrag.canDecode(event)) or \
			(self.wantsPodPlaylistDrags and LPodPlaylistDrag.canDecode(event)) or \
			(self.wantsPodTrackDrags and LPodTrackDrag.canDecode(event))
		# XXX DSM add external track drags

	def dropped(self,event):
		#print "dropped"
		#self.printDragFormats(event)
		trackIDs = LTrackDrag.decode(event)['TrackIDs']
		self.addTrackIDs(trackIDs)
		return True

	def addTrackIDs(self,trackIDs):
		pass
	
	def select(self,container):
		pass

	def doubleClick(self):
		#print "double clicked",self
		pass

	def createDrag(self,container):
		pass
