#
# LSlimServerSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LMusicPlayer import *
from LSourceViewItem import *
from LServiceInfoDialog import*

class LSlimp3Track(Track):
	def __init__(self,title,url):
		Track.__init__(self)
		self.title = title
		self.album = title
		self.artist = title
		self.location = url
		self.stream = url
		self.totalTime = 30*1000
		self.library = None
		self.remote = True
		self.isPreview = True
		self.isStream = True

	def play(self,playlist = None):
		print "going to play",self.stream
		LMusicPlayer.playTrack(self,None,None)
	
	def pause(self):
		LMusicPlayer.pause()
	
	def fetchStream(self):
		pass

#
# SlimServer
#
class LSlimServerSourceViewItem(LSourceViewItem):
	def __init__(self,container,name,type,address,port):
		LSourceViewItem.__init__(self,container,name)		
		self.hasContextMenu = True
		self.name = name
		self.type = type
		self.address = address
		self.port = port

	def makeKey(self):
		return 'E'+str(self.name)

	def iconFileName(self): return "sourceslim.png"

	def select(self,container):
		container.emit(PYSIGNAL("selectSlimp3"),(self.name,self.type,self.address,self.port))

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		id = self.popup.insertItem(i18n("Get Info"),self.getInfo)
		id = self.popup.insertItem(i18n("Stream"),self.stream)
	
	def getInfo(self):
		dialog = LServiceInfoDialog(self.name,self.type,self.address,self.port)
		dialog.exec_loop()
	
	def stream(self):
		url = "http://%s:%d/stream.mp3" % (self.address,self.port)
		LSlimp3Track(str(self.name),url).play()
		self.select(self.container)
