#
# "@(#) $Id: LSettings.py,v 1.7 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from PListParser import *
from LsongsPaths import *
import time

class LSettings:
	def __init__(self):
		self.data = {}
		if not self.readXMLFile():
			self.setDefaults()
	
	def filePath(self):
		return library("LsongsSettings.xml")

	def readXMLFile(self):
		filePath = self.filePath()
		if os.path.exists(filePath):
			try:
				#print "reading settings"
				reader = PListReader()
				self.data = reader.parse(filePath)[0]
				#print self.data
				return True
			except: pass
		return False
		
	def writeXMLFile(self):
		#print "writing settings"
		self.data['Modified'] = time.gmtime(time.time())
		writer = PListWriter()
		writer.unparse([self.data],self.filePath())

	def setDefaults(self):
		print "setting default settings"
		self.data['Version'] = '1.0'
		self.data['Managed'] = False
		self.data['Modify Tags'] = False
		self.data['Encoder'] = 'mp3'
		self.data['Encoder Bit Rate'] = 192000
		self.data['CD Insertion Action'] = 'show'
		self.data['CD Error Correction'] = False
		self.data['Volume'] = 50

	def static_singleton():
		global _settingsSingleton
		if _settingsSingleton==None:
			_settingsSingleton = LSettings()
		return _settingsSingleton
	singleton = staticmethod(static_singleton)
	
	def static_settings():
		return LSettings.singleton().data
	settings = staticmethod(static_settings)

_settingsSingleton = None
