from qt import *
from kdeemul import *
import socket,signal

class LServiceAdvertiser(KProcIO):
	def __init__(self,type = '_http._tcp.local.',name = None,port = 9001):
		self.type = type
		if name:
			self.name = name
		else:
			self.name = socket.gethostname()
		self.port = port
		KProcIO.__init__(self)
		self.setExecutable("nice")
		self.setArguments(["howlxml_publish",self.name,self.type,str(self.port)])
		QObject.connect(self,SIGNAL("processExited(KProcess *)"),self.endProcess)
		QObject.connect(self,SIGNAL("readReady(KProcIO *)"),self.gotOutput)
	
	def startAdvertising(self):
		print "starting advertiser for",self.name,self.type,self.port
		self.start(KProcess.NotifyOnExit,KProcess.AllOutput)
		print "started"
	
	def gotOutput(self,io):
		(count,line,more) = self.readln(False)
		line = str(line)
		#print line
		self.ackRead()

	def gotError(self,process,buffer,bufferlen):
		print "LServiceAdvertiser:error:",self.name,self.type,buffer

	def endProcess(self,process):
		print "LServiceAdvertiser:end",self.name,self.type

	def killTasks(self):
		print "killing advertiser for",self.name,self.type
		self.kill(signal.SIGINT)
		print "killed"
