#
# "RemotePlaylistView.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from Library import *
from LLibraryView import *
from LPlaylistView import *
from LRemotePlaylistViewItem import *
from LRemoteTrackDrag import *
from qt import *
from human import *

class LRemotePlaylistView(LPlaylistView):
	def __init__(self,container):
		LPlaylistView.__init__(self,container)
	
	def setCurrentPlaylist(self):
		pass

	def loadHeaders(self):
		headers = [" ","",i18n("Song Name"),i18n("Time"),i18n("Artist"),i18n("Album"),i18n("Genre"),i18n("My Rating"),i18n("Play Count"),i18n("Last Played")]
		widths = [40,20,220,40,120,180,80,80,70,130]
		for index in xrange(0,len(headers)):
			self.addColumn(headers[index],widths[index])
		self.setShowSortIndicator(True)
		self.setFullWidth(True)
		self.setColumnAlignment(8,Qt.AlignCenter)
		self.indexColumn = 1
		self.ratingColumn = 7
		sortColumn = self.settings.get('Remote Sort Column',1)
		sortAscending = self.settings.get('Remote Sort Ascending',True)
		self.setSorting(sortColumn,sortAscending)
		QObject.connect(self.header(),SIGNAL("indexChange(int,int,int)"),self.columnIndexChanged)
		QObject.connect(self.header(),SIGNAL("sizeChange(int,int,int)"),self.columnSizeChanged)
		self.loadHeaderSizes('Remote Header Widths')
		self.loadHeaderOrdering('Remote Header Map')
		self.setDropHighlighter(False)
		self.setDropVisualizer(True)

	def loadTracks(self):
		pass

	def setPlaylist(self,playlist):
		self.playlistName = playlist.name
		self.playlist = playlist
		self.library = playlist._library
		self.playlist.fetchTracks()
		self.playlist.connect(PYSIGNAL("addedTrack"),self.refresh)
		self.playlist.connect(PYSIGNAL("removedTracks"),self.refresh)
		self.loadPlaylistItems()

	def xloadPlaylistItems(self):
		self.clear()
		index = 1
		tracks = self.playlist._tracks.values()
		for track in tracks:
			self.loadTrackItemForIndex(track,index)
			index = index+1
		self.emitCurrentEnabledSortedTracks()

	def loadTrackItemForIndex(self,track,index):
		item = LRemotePlaylistViewItem(self,track,index)

	def canBurn(self):
		return False
	
	def canPlay(self):
		return True

	def canShowLocation(self):
		return False
	
	def canGetInfo(self):
		return False

	def refresh(self):
		self.loadPlaylistItems()

	def doSelectionChanged(self):
		LLibraryView.doSelectionChanged(self)
		self.emit(PYSIGNAL("selectionChanged"),(self,None))

	def setSorting(self,column,ascending):
		KListView.setSorting(self,column,ascending)
		self.settings['Remote Sort Column'] = column
		self.settings['Remote Sort Ascending'] = not not ascending

	def columnIndexChanged(self,section,fromIndex,toIndex):
		self.saveHeaderOrdering('Remote Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		self.saveHeaderSizes('Remote Header Widths')

	def removeSelectedItems(self):
		#trackIDs = self.selectedTrackIDs()
		#self.library.removeTrackIDsFromTrash(trackIDs)
		pass

	def xcontextMenu(self,item,pos,col):
		pass
	
	def contentsDragEnterEvent(self,event):
		pass
	
	def contentsDropEvent(self,event):
		pass

	def acceptDrag(self,event):
		return False

	def dragObject(self):
		#print "dragging remote tracks"
		selectedTrackIDs = self.selectedTrackIDs()
		#print "selected",selectedTrackIDs
		tracks = self.library.tracksWithTrackIDs(selectedTrackIDs)
		#print tracks
		if tracks and len(tracks)>0:
			drag = LRemoteTrackDrag(tracks,self.playlist,self)
			drag.dragCopy()

	def canSync(self):
		return True
	
	def sync(self):
		print "syncing"
		if self.library.allowWrites:
			self.library.syncWith(Library.mainLibrary())
