#
# "@(#) $Id: LRadioViewItem.py,v 1.8 2004/08/18 20:19:51 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *
from utils import *
from LMusicPlayer import *
from LRadioLibrary import *
from LsongsPaths import *
from LTrackViewItemObject import *

def _get(a,b):
	if a==None: return b
	return a

class LRadioGenreViewItem(KListViewItem):
	def __init__(self,container,genre):
		KListViewItem.__init__(self,container)
		self.genre = genre
		self.loadInfo()
		if genre=="Popular":
			self.sortKey = QString("A")
		else:
			self.sortKey = QString(u"B%s" % unikode(genre))
			
	def key(self,column,ascending):
		return self.sortKey
	
	def loadInfo(self):
		self.setText(0,self.genre)

	def contentsMouseDoubleClickEvent(self,event):
		pass
	
	def contextMenu(self,pos,col):
		pass

_normalStationIcon = None
_userStationIcon = None
_dyingStationIcon = None

def radioIconForTrack(track):
	global _normalStationIcon,_userStationIcon,_dyingStationIcon
	if _normalStationIcon==None:
		_normalStationIcon = QPixmap(art("labelstationnormal.png"))
		_userStationIcon = QPixmap(art("labelstationuser.png"))
		_dyingStationIcon = QPixmap(art("labelstationdying.png"))
	if track.user:
		return _userStationIcon
	return _normalStationIcon

class LRadioViewItem(KListViewItem):
	def __init__(self,container,track):
		KListViewItem.__init__(self,container,None)
		self._track = track
		self.trackItem = LTrackViewItemObject(self)
		self.loadTrackInfo()

	def track(self):
		return self._track

	def trackID(self):
		return 0

	def loadTrackInfo(self):
		try:
			self.setPixmap(0,radioIconForTrack(self._track))
			self.setText(0,str(self._track.title))
			self.setText(1,humanBitRate(self._track.bitRate,True)+" ")
			self.setText(2,"  "+self._track.description)
		except:
			pass

	def changedAttribute(self,attribute,oldValue,newValue):
		if newValue:
			self.loadTrackInfo()

	def contentsMouseDoubleClickEvent(self,event):
		self.play()

	def play(self):
		#print "attempting to play",self._track.location
		self._track.play()
	
	def pause(self):
		self._track.pause()

	def contextMenu(self,pos,col):
		menu = QPopupMenu()
		status = self._track.playStatus
		if status=='playing':
			menu.insertItem(i18n("Pause"),self.pause)
		else:
			menu.insertItem(i18n("Play"),self.play)
		menu.insertSeparator()
		menu.insertItem(i18n("Edit station..."),self.editStation)
		menu.insertItem(i18n("Remove station"),self.removeStation)
		item = menu.exec_loop(pos)
			
	def editStation(self):
		self._track.edit()
	
	def removeStation(self):
		LRadioLibrary.singleton().remove(self._track)
		
	def notImplemented(self,item):
		KMessageBox.error(self,"%s not implemented" % item,"Not Implemented")
