#
# " LPodTrackView.py"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LPodTrackDrag import *
from LPodTrackViewItem import *
from PodLibrary import *
from LDeviceTrackView import *
from LSettings import *

class LPodTrackView(LDeviceTrackView):
	def __init__(self,container):
		LDeviceTrackView.__init__(self,container)
	
	def loadSortInfo(self):
		sortColumn = self.settings.get('Pod Library Sort Column',3)
		sortAscending = self.settings.get('Pod Library Sort Ascending',True)
		self.setSorting(sortColumn,sortAscending)
	
	def loadHeaderInfo(self):
		self.loadHeaderSizes('Pod Library Header Widths')
		self.loadHeaderOrdering('Pod Library Header Map')

	def loadTrackItemForIndex(self,track,index):
		item = LPodTrackViewItem(self,track,index)

	def dragObject(self):
		selectedTrackIDs = self.selectedTrackIDs()
		if selectedTrackIDs and len(selectedTrackIDs)>0:
			tracks = self.library.tracksWithTrackIDs(selectedTrackIDs)
			locations = [track.nativeLocation() for track in tracks]
			drag = LMultipleDrag(self)
			self.tdrag = LPodTrackDrag(selectedTrackIDs,self.playlist,self)
			drag.addDragObject(self.tdrag)
			self.udrag = QUriDrag(locations)
			drag.addDragObject(self.udrag)
			drag.dragCopy()

	def xsync(self):
		print "syncing"
		if self.library.allowWrites:
			self.library.syncWith(Library.mainLibrary())

	def setSorting(self,column,ascending):
		KListView.setSorting(self,column,ascending)
		self.settings['Pod Library Sort Column'] = column
		self.settings['Pod Library Sort Ascending'] = not not ascending

	def columnIndexChanged(self,section,fromIndex,toIndex):
		self.saveHeaderOrdering('Pod Library Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		self.saveHeaderSizes('Pod Library Header Widths')
