#
# " LDellTrackView.py"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LDellTrackDrag import *
from LDellTrackViewItem import *
from DellLibrary import *
from LDeviceTrackView import *
from LSettings import *

class LDellTrackView(LDeviceTrackView):
	def __init__(self,container):
		LDeviceTrackView.__init__(self,container)
	
	def loadSortInfo(self):
		sortColumn = self.settings.get('DDJ Library Sort Column',3)
		sortAscending = self.settings.get('DDJ Library Sort Ascending',True)
		self.setSorting(sortColumn,sortAscending)

	def loadHeaderInfo(self):
		self.loadHeaderSizes('DDJ Library Header Widths')
		self.loadHeaderOrdering('DDJ Library Header Map')

	def loadTrackItemForIndex(self,track,index):
		item = LDellTrackViewItem(self,track,index)

	def dragObject(self):
		#print "dragging Dell tracks"
		selectedTrackIDs = self.selectedTrackIDs()
		if selectedTrackIDs and len(selectedTrackIDs)>0:
			drag = LDellTrackDrag(selectedTrackIDs,self.playlist,self)
			drag.dragCopy()

	def xsync(self):
		print "syncing"
		if self.library.allowWrites:
			self.library.syncWith(Library.mainLibrary())

	def setSorting(self,column,ascending):
		KListView.setSorting(self,column,ascending)
		self.settings['DDJ Library Sort Column'] = column
		self.settings['DDJ Library Sort Ascending'] = not not ascending

	def columnIndexChanged(self,section,fromIndex,toIndex):
		self.saveHeaderOrdering('DDJ Library Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		self.saveHeaderSizes('DDJ Library Header Widths')
