#
# LDellTrackDrag.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import QStoredDrag
from utils import *

_delltrackmimetype = 'application/x-ddjtrackids'

#
# this class encapsulates a drag from a Dell playlist track list - all that's transferred
# is a list of trackIDs
#
class LDellTrackDrag(QStoredDrag):
	def __init__(self,trackIDs,playlist,widget):
		#print "creating LDellTrackDrag"
		QStoredDrag.__init__(self,_delltrackmimetype,widget)
		packet = {'Playlist':unikode(playlist.name),'TrackIDs':trackIDs}
		self.setEncodedData(str(packet))
		#print "encoded drag",packet

	def trackIDs(self):
		packet = eval(self,encodedData(_delltrackmimetype))
		return packet['TrackIDs']
	
	def class_canDecode(cls,event):
		return event.provides(_delltrackmimetype)

	canDecode = classmethod(class_canDecode)

	def class_decode(cls,event):
		return eval(str(event.encodedData(_delltrackmimetype)))

	decode = classmethod(class_decode)
