#
# "@(#) $Id: DellNJB.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
import os, re
#from DellLibrary import *

#
# This class is mainly used to monitor the presence of a Dell Digital Jukebox
# It basically polls the contents of the file /tmp/.ddj, which should contain
# either '1' or '0'.  The file is believed if its modification date is *after*
# the last boot time of the machine, otherwise it could just be a legacy from
# the last session.  The /tmp/.ddj is expected to be maintained by something
# *outside* of this application - the most common method is to create a usb hotplug
# script that is called when a device matching the vendor/model codes of a DDJ
# is mounted or unmounted.  This script and how it is connected into the system
# will vary between distributions.
#
class DellNJB(QObject):
	def __init__(self):
		QObject.__init__(self)
		self._hasDDJ = False
		self._numTracks = 0
		self.pattern = r'1'
		self.bootTime = 0
		self.getBootTime()
		self.startScanning()
	
	def hasDDJ(self):
		return self._hasDDJ

	#
	# capture the time the machine was last booted - this helps
	# us figure out if the DDJ presence file is valid
	#
	def getBootTime(self):
		path = "/proc/stat"
		fd = open(path,"r")
		data = fd.read()
		fd.close()
		mo = re.search(r"^btime (\d*)$",data,re.MULTILINE)
		if mo!=None:
			self.bootTime = int(mo.group(1))
			#print "got bootTime",self.bootTime

	#
	# set up timer to check whether or not a DDJ has been (dis)connected
	#
	def startScanning(self):
		self.timer = QTimer()
		self.timer.start(4000)
		self.connect(self.timer,SIGNAL("timeout()"),self.checkStatus)

	#
	# check the status of the device - if the state changes, generate a signal
	#
	def checkStatus(self):
		from DellLibrary import DellLibrary
		path = "/tmp/.ddj"
		if os.path.exists(path):
			modTime = os.path.getmtime(path)
			#print "modTime is",modTime
			if modTime>self.bootTime:
				fd = open(path,"r")
				data = fd.read()
				fd.close()
				mo = re.search(self.pattern,data,re.MULTILINE)
				if mo!=None:
					if not self._hasDDJ:
						print "found DDJ"
						if True: #try:
							self._hasDDJ = True
							DellLibrary.mount()
						else: #except:
							print "DellNJB: Trouble mounting DDJ"
							pass
				else:
					if self._hasDDJ:
						print "lost DDJ"
						try:
							DellLibrary.unmount()
						except:
							print "DellNJB: Trouble unmounting DDJ"
						#self.emit(PYSIGNAL("dellEjected"),(self,None))
						self._hasDDJ = False
			else:
				#print "ddj presence file too old"
				pass
		else:
			#print "cannot find ddj presence file"
			pass

	#
	# return the singleton instance of the Dell player
	#
	def static_singleton():
		global _DellNJBSingleton
		return _DellNJBSingleton
	singleton = staticmethod(static_singleton)

_DellNJBSingleton = DellNJB()


