#
# "@(#) $Id: CDTrack.py,v 1.14 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from Track import *
from LMusicPlayer import *
from LsongsDevices import *
import pyid3lib
import time, re

_cdromStream = None

def trim(s):
	if s==None: return None
	return s.strip()

def cleanup(s):
	return re.sub(r"/",r"-",s)
	
class CDTrack(Track):
	def __init__(self,library = None):
		Track.__init__(self,library)
		self.kind = "CD Track"
		self.location = "cdda:/1"
		self.image = None
		self.isCD = True
		self.ripStatus = "idle"
		self.bitRate = 1500000
		self.sampleRate = 44100
		self.format = "PCM"
		self.channels = 2
		self.mode = "Stereo"

	def play(self,playlist = None):
		from LMusicPlayer import LMusicPlayer
		playlist = self._library.playlistWithName('CD')
		#print "CD playlist is",playlist
		LMusicPlayer.setCDPlayer(self.driver())
		LMusicPlayer.playTrack(self,self._library,playlist)

	def pause(self):
		LMusicPlayer.pause()

	def driver(self):
		return self._library.drive.driver
	
	def busDevice(self):
		return self._library.drive.busDevice

	def loadFromCD(self,trackNum):
		self.discID = self._library.disc_id
		self.trackNum = trackNum
		self.location = "cdda:/%d" % trackNum
		self.originalLocation = self.location
		info = self._library.info
		if info:
			playlists = info['Playlists']
			playlist = playlists[len(playlists)-1]
			track = playlist[trackNum-1]
			#print data
			self.trackCount = track['Track Count']
			self.title = track['Title']
			self.shortFileName = self.title
			self.totalTime = track['Total Time']
			try: self.album = track['Album']
			except: pass
			try: self.artist = track['Artist']
			except: pass
			try: self.genre = track['Genre']
			except: pass
			try: self.year = track['Year']
			except: pass
			try: self.compilation = track['Compilation']
			except: pass
		else:
			self.title = "Track %02d" % self.trackNum
			self.shortFileName = "Track-%08x-%02d" % (self.discID[0],self.trackNum)
			#print self.discID
			print self.shortFileName
			start = self.discID[1+trackNum]*1000/75
			self.trackCount = self.discID[1]
			if trackNum==self.trackCount:
				end = self.discID[2+trackNum]*1000
			else:
				end = self.discID[2+trackNum]*1000/75
			#print start,end
			self.totalTime = end-start
		self.size = self.totalTime*1500/8
		
	def copyTagsInto(self,filePath):
		dst = pyid3lib.tag(filePath)
		if self.title:
			dst.title = self.title.encode('latin-1')
		if self.artist:
			dst.artist = self.artist.encode('latin-1')
		if self.album:
			dst.album = self.album.encode('latin-1')
		if self.year:
			dst.year = self.year
		if self.contentType:
			dst.contenttype = self.contentType
		self.mediatype = "CD"
		#if self.compilation:
		#	dst.compilation = self.compilation
		dst.track = (self.trackNum,self.trackCount)
		dst.encodedby = "Lsongs 1.0"
		dst.date = time.strftime("%Y-%m-%dT%H:%M:%S",time.gmtime(time.time()))
		dst.update()

	def loadTagsFrom(self,tags):
		Track.loadTagsFrom(self,tags)
		try:
			self.shortFileName = tags['title']
			#print "setting file name to",self.shortFileName
		except: pass

	def setRipStatus(self,status):
		if status['Status'] in ['Begin','Ripping']:
			self.ripStatus = 'ripping'
		elif status['Status']=='EndTrack':
			if status.get('Interrupted',False):
				self.ripStatus = 'idle'
			elif status['Source']=='Ripper':
				self.ripStatus = 'ripped'
		self.emit(PYSIGNAL("ripStatus"),(self,status))
