/*
 * dslk.h -- AIX header file for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: dlslk.h,v 1.7 99/11/10 15:00:11 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(DLSLK_H_AIX)
#define	DLSLK_H_AIX	1

#include <setjmp.h>
#include <string.h>

#define	_KERNEL
#include <sys/flock.h>
#undef	_KERNEL

#include <procinfo.h>

#include <jfs/inode.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/utsname.h>
#include <sys/vmount.h>
#include <sys/vnode.h>


/*
 * Local definitions
 */

#define	COMP_P		const void	/* qsort() compare pointer type */
#define	KA_T		off_t		/* kernel address type for kread() */
#define	LMEMCPY_P	void		/* local memcpy() type */
#define	lmemcpy		memcpy		/* local memcpy() */
#define	MALLOC_P	char		/* malloc() pointer cast */
#define	MALLOC_S	unsigned	/* malloc() size cast */
#define	N_UNIX		"/unix"		/* name list path */
#define	QSORT_P		void		/* qsort() table pointer type */

/*
 * Knl and Nl indexes
 */

#define	X_HINODE	0		/* Knl[] "hinode" index */
#define	X_NFS_SYMS	1		/* Knl[] "nfs_syms" index */
#define	X_KNL_NUM	2		/* number of Knl[] entries */

#if	AIXV>3250
#define	X_NHINO		0		/* Nl[] "nhino" index */
#endif	/* AIXV>3250 */


/*
 * Local structure definitions
 */


/*
 * Local global variables
 */

extern int Kd;				/* /dev/kmem file descriptor */
extern struct nlist Knl[];		/* kernel name list entries */

#if	AIXV>3250
extern struct nlist Nl[];		/* N_UNIX name list entries */
#endif	/* AIXV>3250 */

# endif	/* defined(DLSLK_H_AIX) */
