//
//  Little cms Profiler
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

#include "monitorvalues.h"
#include "setgamma.h"
#include "lcmsprf.h"
#include "qtlcmswidgets.h"
#include "lprofmain.h"
#include <qlineedit.h>
#include <qpixmap.h>

static PROFILERDATA sys; 
QButtonGroup* RGB_button_group;

monVal mongamma;

static passSys a;

QString textvalue(double b)
{	
    static char Buffer[128];
    ::sprintf(Buffer, "%g", b);
    return (QString) Buffer;
}

SetGamma::SetGamma(QWidget *parent )
  : SetGammaBase(parent)
{      
   
    // Take a copy of gamma
    GammaPix = new QPixmap(*(GammaProof -> pixmap()));
    GammaPix -> setOptimization(QPixmap::BestOptim);
    GammaBitmap = *GammaPix;
    Screen      = *GammaPix;
    
    ChartPix = new QPixmap(*(BigChart -> pixmap()));
    ChartPix -> setOptimization(QPixmap::BestOptim);
    ChartBitmap = *ChartPix;
    ChartScreen      = *ChartPix;
    
     a.get(&sys);
     mongamma.get(&mongamma);
     
      
    RGB_button_group = new QButtonGroup(this);
    RGB_button_group->insert(AdjustR,0);
    RGB_button_group->insert(AdjustG,1);
    RGB_button_group->insert(AdjustB,2);
    RGB_button_group->setExclusive(TRUE);
    
    	 
    // Fill primaries combo

    if (mongamma.items.linked==1) 
    {
        CheckLinkGamma -> setChecked(true);
    }
    else	
    { 
        CheckLinkGamma -> setChecked(false);
    }
    GammaR -> setText(mongamma.items.rgamma);
    GammaG -> setText(mongamma.items.ggamma);
    GammaB-> setText(mongamma.items.bgamma);
    AdjustR->setChecked(mongamma.items.rchecked);
    AdjustG->setChecked(mongamma.items.gchecked);
    AdjustB->setChecked(mongamma.items.bchecked);
	
    slotChangeGamma();
    slotGammaRadio();
    slotGammaSlider();	
}

void SetGamma::slotChangeGamma()
{
    if (CheckLinkGamma -> isChecked()) 
    {
        AdjustR -> hide();
        AdjustG -> hide();
        AdjustB -> hide();
        GammaR -> setEnabled(TRUE);
        GammaG -> hide();
        GammaB -> hide();
    }
    else 
    {
        AdjustR -> show();
        AdjustG -> show();
        AdjustB -> show();
        GammaR -> show();
        GammaG -> show();
        GammaB -> show();
        
        GammaR -> setEnabled(AdjustR -> isChecked());
        GammaG -> setEnabled(AdjustG -> isChecked());
        GammaB -> setEnabled(AdjustB -> isChecked());
    }

    slotGammaRadio();
    slotGammaSlider();
}



void SetGamma::slotGammaRadio()
{
    double v;

    if (AdjustR -> isChecked())  v = GammaR -> text().toDouble();
    else 
        if (AdjustG -> isChecked()) v = GammaG -> text().toDouble();
        else
            v = GammaB -> text().toDouble();

    GammaSlider -> setValue((int)(v * 100));

    RenderGamma();
    ProofGamma();
}


void SetGamma::slotGammaSlider()
{
    double val = (double) GammaSlider -> value() / 100.0;

    if (CheckLinkGamma -> isChecked()) 
    {
        // set all three values
        GammaR -> setText(textvalue(val));
        GammaG-> setText(textvalue(val));
        GammaB -> setText(textvalue(val));
    }
    else 
    {
        if (AdjustR -> isChecked())
            GammaR -> setText(textvalue(val));
        else
            if (AdjustG -> isChecked())
                GammaG -> setText(textvalue(val));
        else
            // if (AdjustB -> isChecked())
                GammaB -> setText(textvalue(val));
    }
    
    RenderGamma();
    ProofGamma();
}

void SetGamma::RenderGamma()
{
    if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
    
    if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);
    
    if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);
    
    if (CheckLinkGamma -> isChecked()) 
    {
        double val = GammaR -> text().toDouble()-1.6; 
        // the -1.6 is an offset to make this work with the Norman Koren gamma chart
        // Don't know at this point if this should be a constant or not.  
        // Need to look into this more
        // also applies to the else section below
        
        sys.Prelinearization[0] = cmsBuildGamma(256, val);
        sys.Prelinearization[1] = cmsBuildGamma(256, val);
        sys.Prelinearization[2] = cmsBuildGamma(256, val);
    }
    else 
    {
        sys.Prelinearization[0] = cmsBuildGamma(256, GammaR -> text().toDouble()-1.6);
        sys.Prelinearization[1] = cmsBuildGamma(256, GammaG -> text().toDouble()-1.6);
        sys.Prelinearization[2] = cmsBuildGamma(256, GammaB -> text().toDouble()-1.6);
    } 

}


void SetGamma::ProofGamma()
{    
    LPGAMMATABLE Gamma;
    DWORD dwMask;
    char buff[128];
    // To help debug problems with gamma
    sprintf(buff, "size of DWORD = %i", sizeof(DWORD));
    qDebug(buff);
    sprintf(buff, " size of WORD = %i", sizeof(WORD));
    qDebug(buff);
    
    if (CheckLinkGamma -> isChecked()) 
    {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);
        dwMask = 0x00FFFFFF;
    }
    else
        if (AdjustR -> isChecked()) 
        {
            Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);
            dwMask = 0x00FF0000;
        }
    else
        if (AdjustG -> isChecked()) 
        {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[1]);
        dwMask = 0x0000FF00;
        }
    else 
    {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[2]);
        dwMask = 0x000000FF;
    }
    
    L16PARAMS Lut16;
    cmsCalcL16Params(Gamma -> nEntries, &Lut16);
    // BYTE, WORD and LPBYTE are from lcms.h and are defined as:
    /* 
             typedef unsigned char BYTE, *LPBYTE; 
             typedef unsigned short WORD, *LPWORD;
             typedef unsigned int DWORD, *LPDWORD;
    */
    int height = Screen.height();
    int width  = Screen.width();
    if (Screen.systemBitOrder() == QImage::BigEndian)
    { 
        Screen=Screen.convertBitOrder(QImage::LittleEndian);
        GammaBitmap=GammaBitmap.convertBitOrder(QImage::LittleEndian);
    }
    for (int i=0; i < height; i++) 
    {
        LPBYTE ptrSrc  = GammaBitmap.scanLine(i);
        LPBYTE ptrDest = Screen.scanLine(i);
        for (int j=0; j < width; j++) 
        {
            BYTE In = *ptrSrc;
            WORD InVal = (In << 8) | In;
            WORD OutVal = cmsLinearInterpLUT16(InVal , Gamma -> GammaTable, &Lut16);
            DWORD OutByte = (DWORD) (OutVal >> 8);
            DWORD Out = OutByte;
            OutByte <<= 8;
            Out |= OutByte;
            OutByte <<= 8;
            Out |= OutByte;
            Out &= dwMask;
            *((DWORD*) ptrDest) = Out;
            ptrSrc  += sizeof(DWORD);
            ptrDest += sizeof(DWORD);
        }
    }
    cmsFreeGamma(Gamma);
    if (Screen.systemBitOrder() == QImage::BigEndian)
    { 
        Screen=Screen.convertBitOrder(QImage::BigEndian);
        GammaBitmap=GammaBitmap.convertBitOrder(QImage::BigEndian);
    }
    ScreenPixmap.convertFromImage(Screen, QPixmap::ColorOnly | QPixmap::ThresholdDither | QPixmap::AvoidDither);
    GammaProof -> setPixmap(ScreenPixmap);
    ProofChart();
}


void SetGamma::ProofChart()
{    
    LPGAMMATABLE Gamma;
    DWORD dwMask;
    if (CheckLinkGamma -> isChecked()) 
    {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);
        dwMask = 0x00FFFFFF;
    }
    else
        if (AdjustR -> isChecked()) 
        {
            Gamma = cmsReverseGamma(256, sys.Prelinearization[0]);
            dwMask = 0x00FF0000;
        }
    else
        if (AdjustG -> isChecked()) 
        {
            Gamma = cmsReverseGamma(256, sys.Prelinearization[1]);
            dwMask = 0x0000FF00;
        }
    else 
    {
        Gamma = cmsReverseGamma(256, sys.Prelinearization[2]);
        dwMask = 0x000000FF;
    }
    L16PARAMS Lut16;
    cmsCalcL16Params(Gamma -> nEntries, &Lut16);
    
    int height = ChartScreen.height();
    int width  = ChartScreen.width();
    if (ChartScreen.systemBitOrder() == QImage::BigEndian)
    { 
        ChartScreen=ChartScreen.convertBitOrder(QImage::LittleEndian);
        ChartBitmap=ChartBitmap.convertBitOrder(QImage::LittleEndian);
    }
    for (int i=0; i < height; i++) 
    {
        LPBYTE ptrSrc  = ChartBitmap.scanLine(i);
        LPBYTE ptrDest = ChartScreen.scanLine(i);
        for (int j=0; j < width; j++) 
        {
            BYTE In = *ptrSrc;
            WORD InVal = (In << 8) | In;
            WORD OutVal = cmsLinearInterpLUT16(InVal , Gamma -> GammaTable, &Lut16);
            DWORD OutByte = (DWORD) (OutVal >> 8);
            DWORD Out = OutByte;
            OutByte <<= 8;
            Out |= OutByte;
            OutByte <<= 8;
            Out |= OutByte;
            Out &= dwMask;
            *((DWORD*) ptrDest) = Out;
            ptrSrc  += sizeof(DWORD);
            ptrDest += sizeof(DWORD);
        }
    }
    cmsFreeGamma(Gamma);
    if (ChartScreen.systemBitOrder() == QImage::BigEndian)
    { 
        ChartScreen=ChartScreen.convertBitOrder(QImage::BigEndian);
        ChartBitmap=ChartBitmap.convertBitOrder(QImage::BigEndian);
    }
    ChartScreenPixmap.convertFromImage(ChartScreen, QPixmap::ColorOnly | QPixmap::ThresholdDither | QPixmap::AvoidDither);
    BigChart -> setPixmap(ChartScreenPixmap);
}


void SetGamma::slotOK()
{
    // qDebug("In slot OK");
    
    if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
    
    if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);
    
    if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);
    
    if (CheckLinkGamma -> isChecked()) 
    {
        double val = GammaR -> text().toDouble(); 
              
        sys.Prelinearization[0] = cmsBuildGamma(256, val);
        sys.Prelinearization[1] = cmsBuildGamma(256, val);
        sys.Prelinearization[2] = cmsBuildGamma(256, val);
    }
    else 
    {
        sys.Prelinearization[0] = cmsBuildGamma(256, GammaR -> text().toDouble());
        sys.Prelinearization[1] = cmsBuildGamma(256, GammaG -> text().toDouble());
        sys.Prelinearization[2] = cmsBuildGamma(256, GammaB -> text().toDouble());
    } 
    a.put(sys);
    
    if (CheckLinkGamma -> isChecked()) 
    {
        mongamma.items.linked=1;
    }
    else 	
    {
        mongamma.items.linked=0;
    }
    
    mongamma.items.rgamma=GammaR -> text();
    mongamma.items.ggamma=GammaG -> text();
    mongamma.items.bgamma=GammaB-> text();
    mongamma.items.rchecked=AdjustR->isChecked();
    mongamma.items.gchecked=AdjustG->isChecked();
    mongamma.items.bchecked=AdjustB->isChecked();
    mongamma.put(mongamma);
}

static QAssistantClient *help;

QString gamma_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

void SetGamma::slotHelpButton()
{
     QString execpath = (QString) gamma_get_QTDIR() + (QString) "/bin";
     QStringList cmdLst;
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/gamma.html";
     help->openAssistant ();
     help->showPage(path);
}


