#include "profileid.h"
#include <lprofmain.h>
#include <qvariant.h>
#include <qdialog.h>
#include  <qwidget.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <string.h>
#include <lcmsprf.h>

static PROFILERDATA sys;
   	
ProfileID::ProfileID( QWidget *parent)
    : ProfileIDBase(parent)
{ 
   passSys a;
   
   a.get(&sys);
    ManufacturerEdit->setText(sys.hdr.Manufacturer);
    ModelEdit -> setText(sys.hdr.Model);
    CopyrightEdit -> setText(sys.hdr.Copyright);
    DescriptionEdit -> setText(sys.hdr.Description);
   // CommentsEdit->setText(sys.hdr.Comments);
}

ProfileID::~ProfileID()
{
  
}

void ProfileID::slotUpdateValues()
{
    passSys a;
    
      strcpy(sys.hdr.Manufacturer, ManufacturerEdit->text().local8Bit());
      strcpy(sys.hdr.Model, ModelEdit -> text().local8Bit());
      strcpy(sys.hdr.Copyright, CopyrightEdit -> text().local8Bit());
      strcpy(sys.hdr.Description, DescriptionEdit -> text().local8Bit());
      // strcpy(sys.hdr.Comments, CommentsEdit->text());
      a.put(sys);
  }

static QAssistantClient *help;

QString ID_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

void ProfileID::slotHelpButton()
{
     QString execpath = (QString) ID_get_QTDIR() + (QString) "/bin";
     help = new QAssistantClient(execpath, this);
     QStringList cmdLst;
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/profile-id.html";
     help->openAssistant ();
     help->showPage(path);
}

